<?php
/**************************************************************************
* This file is part of the WebIssues Server program
* Copyright (C) 2006 Michał Męciński
* Copyright (C) 2007-2009 WebIssues Team
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
**************************************************************************/

function wi_db_connect( $host, $database, $user, $password )
{
    global $db_link;

    try {
        $db_link = new COM( 'ADODB.Connection', null, CP_UTF8 );
    } catch ( com_exception $ex ) {
        trigger_error( 'Could not create the ADODB.Connection object', E_USER_WARNING );
        return false;
    }

    $string = "Provider=sqloledb; Data Source=$host; Initial Catalog=$database";
    if ( $user != '' )
        $string .= "; User ID=$user; Password=$password";
    else
        $string .= "; Trusted_Connection=yes";

    try {
        $db_link->Open( $string );
    } catch ( com_exception $ex ) {
        trigger_error( $db_link->Errors[ 0 ], E_USER_WARNING );
        return false;
    }

    return true;
}

function wi_db_escape_arg( $arg, $type, &$params )
{
    switch( $type ) {
        case 'd':
            return (int)$arg;
        case 's':
            return "N'" . str_replace( "'", "''", $arg ) . "'";
        case 'b':
            return '0x' . bin2hex( $arg );
    }
}

function wi_db_query( $query, $params )
{
    global $db_link;

    $log = wi_log_open( 'sql' );
    if ( $log )
        fwrite( $log, "> $query\n" );

    try {
        $rs = $db_link->Execute( $query );
    } catch ( com_exception $ex ) {
        $msg = $db_link->Errors[ 0 ];
        trigger_error( $msg, E_USER_WARNING );
        if ( $log )
            fwrite( $log, "ERROR: $msg\n" );
        return false;
    }

    if ( $log ) {
        if ( $rs->State == 0 )
            fwrite( $log, "(no result)\n");
        else if ( $rs->EOF )
            fwrite( $log, "(empty result)\n");
        else
            fwrite( $log, "(one or more rows returned)\n");
    }

    if ( $rs->State == 0 )
        return true;

    return $rs;
}

function wi_db_fetch_assoc( $rs )
{
    if( $rs->EOF )
        return false;

    $row = array();

    for( $i = 0; $i < $rs->Fields->Count; $i++ )
        $row[ $rs->Fields[ $i ]->Name ] = $rs->Fields[ $i ]->Value;

    $rs->MoveNext();

    return $row;
}

function wi_db_unescape_blob( $data )
{
    // NOTE: $data is a VARIANT of type VT_ARRAY | VT_UI1
    // casting it to a string will truncate it on the first \0 character
    // so the string must be built from individual characters

    $length = count( $data );
    $string = '';

    for ( $i = 0; $i < $length; $i++ )
        $string .= chr( $data[ $i ] );

    return $string;
}

function wi_db_insert_id( $table, $column )
{
    global $db_link;

    $query = "SELECT @@IDENTITY";
    $rs = $db_link->Execute( $query );
    return $rs->Fields[ 0 ]->Value;
}

function wi_db_table_exists( $table )
{
    global $db_link;

    $query = "SELECT OBJECT_ID('$table', 'U')";
    $rs = $db_link->Execute( $query );
    return $rs->Fields[ 0 ]->Value != null;
}
