# coding=utf-8
r"""
This code was generated by
\ / _    _  _|   _  _
 | (_)\/(_)(_|\/| |(/_  v1.0.0
      /       /
"""

from twilio.base import deserialize
from twilio.base import values
from twilio.base.instance_context import InstanceContext
from twilio.base.instance_resource import InstanceResource
from twilio.base.list_resource import ListResource
from twilio.base.page import Page


class BrandsInformationList(ListResource):
    """ PLEASE NOTE that this class contains preview products that are subject
    to change. Use them with caution. If you currently do not have developer
    preview access, please contact help@twilio.com. """

    def __init__(self, version):
        """
        Initialize the BrandsInformationList

        :param Version version: Version that contains the resource

        :returns: twilio.rest.preview.trusted_comms.brands_information.BrandsInformationList
        :rtype: twilio.rest.preview.trusted_comms.brands_information.BrandsInformationList
        """
        super(BrandsInformationList, self).__init__(version)

        # Path Solution
        self._solution = {}

    def get(self):
        """
        Constructs a BrandsInformationContext

        :returns: twilio.rest.preview.trusted_comms.brands_information.BrandsInformationContext
        :rtype: twilio.rest.preview.trusted_comms.brands_information.BrandsInformationContext
        """
        return BrandsInformationContext(self._version, )

    def __call__(self):
        """
        Constructs a BrandsInformationContext

        :returns: twilio.rest.preview.trusted_comms.brands_information.BrandsInformationContext
        :rtype: twilio.rest.preview.trusted_comms.brands_information.BrandsInformationContext
        """
        return BrandsInformationContext(self._version, )

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.Preview.TrustedComms.BrandsInformationList>'


class BrandsInformationPage(Page):
    """ PLEASE NOTE that this class contains preview products that are subject
    to change. Use them with caution. If you currently do not have developer
    preview access, please contact help@twilio.com. """

    def __init__(self, version, response, solution):
        """
        Initialize the BrandsInformationPage

        :param Version version: Version that contains the resource
        :param Response response: Response from the API

        :returns: twilio.rest.preview.trusted_comms.brands_information.BrandsInformationPage
        :rtype: twilio.rest.preview.trusted_comms.brands_information.BrandsInformationPage
        """
        super(BrandsInformationPage, self).__init__(version, response)

        # Path Solution
        self._solution = solution

    def get_instance(self, payload):
        """
        Build an instance of BrandsInformationInstance

        :param dict payload: Payload response from the API

        :returns: twilio.rest.preview.trusted_comms.brands_information.BrandsInformationInstance
        :rtype: twilio.rest.preview.trusted_comms.brands_information.BrandsInformationInstance
        """
        return BrandsInformationInstance(self._version, payload, )

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.Preview.TrustedComms.BrandsInformationPage>'


class BrandsInformationContext(InstanceContext):
    """ PLEASE NOTE that this class contains preview products that are subject
    to change. Use them with caution. If you currently do not have developer
    preview access, please contact help@twilio.com. """

    def __init__(self, version):
        """
        Initialize the BrandsInformationContext

        :param Version version: Version that contains the resource

        :returns: twilio.rest.preview.trusted_comms.brands_information.BrandsInformationContext
        :rtype: twilio.rest.preview.trusted_comms.brands_information.BrandsInformationContext
        """
        super(BrandsInformationContext, self).__init__(version)

        # Path Solution
        self._solution = {}
        self._uri = '/BrandsInformation'.format(**self._solution)

    def fetch(self, if_none_match=values.unset):
        """
        Fetch the BrandsInformationInstance

        :param unicode if_none_match: Standard `If-None-Match` HTTP header

        :returns: The fetched BrandsInformationInstance
        :rtype: twilio.rest.preview.trusted_comms.brands_information.BrandsInformationInstance
        """
        headers = values.of({'If-None-Match': if_none_match, })

        payload = self._version.fetch(method='GET', uri=self._uri, headers=headers, )

        return BrandsInformationInstance(self._version, payload, )

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        context = ' '.join('{}={}'.format(k, v) for k, v in self._solution.items())
        return '<Twilio.Preview.TrustedComms.BrandsInformationContext {}>'.format(context)


class BrandsInformationInstance(InstanceResource):
    """ PLEASE NOTE that this class contains preview products that are subject
    to change. Use them with caution. If you currently do not have developer
    preview access, please contact help@twilio.com. """

    def __init__(self, version, payload):
        """
        Initialize the BrandsInformationInstance

        :returns: twilio.rest.preview.trusted_comms.brands_information.BrandsInformationInstance
        :rtype: twilio.rest.preview.trusted_comms.brands_information.BrandsInformationInstance
        """
        super(BrandsInformationInstance, self).__init__(version)

        # Marshaled Properties
        self._properties = {
            'update_time': deserialize.iso8601_datetime(payload.get('update_time')),
            'file_link': payload.get('file_link'),
            'file_link_ttl_in_seconds': payload.get('file_link_ttl_in_seconds'),
            'url': payload.get('url'),
        }

        # Context
        self._context = None
        self._solution = {}

    @property
    def _proxy(self):
        """
        Generate an instance context for the instance, the context is capable of
        performing various actions.  All instance actions are proxied to the context

        :returns: BrandsInformationContext for this BrandsInformationInstance
        :rtype: twilio.rest.preview.trusted_comms.brands_information.BrandsInformationContext
        """
        if self._context is None:
            self._context = BrandsInformationContext(self._version, )
        return self._context

    @property
    def update_time(self):
        """
        :returns: Creation time of the information retrieved
        :rtype: datetime
        """
        return self._properties['update_time']

    @property
    def file_link(self):
        """
        :returns: The URL to the brands information
        :rtype: unicode
        """
        return self._properties['file_link']

    @property
    def file_link_ttl_in_seconds(self):
        """
        :returns: How long will be the `file_link` valid
        :rtype: unicode
        """
        return self._properties['file_link_ttl_in_seconds']

    @property
    def url(self):
        """
        :returns: The URL of this resource
        :rtype: unicode
        """
        return self._properties['url']

    def fetch(self, if_none_match=values.unset):
        """
        Fetch the BrandsInformationInstance

        :param unicode if_none_match: Standard `If-None-Match` HTTP header

        :returns: The fetched BrandsInformationInstance
        :rtype: twilio.rest.preview.trusted_comms.brands_information.BrandsInformationInstance
        """
        return self._proxy.fetch(if_none_match=if_none_match, )

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        context = ' '.join('{}={}'.format(k, v) for k, v in self._solution.items())
        return '<Twilio.Preview.TrustedComms.BrandsInformationInstance {}>'.format(context)
