/**
 * viewmanager.h
 *
 * Copyright (C)  2004  Zack Rusin <zack@kde.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
 * 02111-1307  USA
 */

#ifndef KCONFED_VIEWMANAGER_H
#define KCONFED_VIEWMANAGER_H

#include "treeitems.h"

#include <qlistview.h>
#include <qobject.h>
#include <qptrlist.h>

class KListView;
class QListViewItem;
namespace PropertyLib {
    class PropertyEditor;
    class PropertyList;
}
class QLabel;

namespace KConfigEditor
{
    class GroupItem;
    class Token;
    class ConfigurationView;
    class DescriptionWidget;

    class ViewManager : public QObject
    {
        Q_OBJECT
    public:
        ViewManager( ConfigurationView *view, PropertyLib::PropertyEditor *propertyView,
                     DescriptionWidget *docView, const char* name = 0 );
        ~ViewManager();

    protected slots:
        void slotSelectionChanged( QListViewItem* );
        void slotTokenRestored( Token* );
	void slotClicked( QListViewItem* it, const QPoint &p, int idx);
        void slotChangeDescription( QListViewItem* );

    private:
        ConfigurationView * m_configView;
        PropertyLib::PropertyEditor* m_propertyView;
        PropertyLib::PropertyList* m_currentList;
        QListViewItemIterator m_appItr;
        QListViewItemIterator m_entryItr;
        ConfItem::Type m_lastSearch;
        DescriptionWidget* m_docWidget;
        //QDict<ConfItem> m_itemsDict
    };
}

#endif
