/* ****************************************************************************
  This file is part of KBabel

  Copyright (C) 1999 by Matthias Kiefer
                            <matthias.kiefer@gmx.de>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

**************************************************************************** */
#include "kbabelpref.h"
#include "prefwidgets.h"

#include <qlayout.h>
#include <qwhatsthis.h>

#include <klocale.h>
#include <kiconloader.h>
#include <kapp.h>

KBabelPreferences::KBabelPreferences(SearchSettings searchOpts,EditorSettings editOpts
                   ,SaveSettings saveOpts, IdentitySettings idOpts,CatManSettings catManOpts)
    : KDialogBase(TreeList, i18n("Preferences"),
                  Help|Default|Ok|Apply|Cancel, Ok,0,0,false)
{
    QFrame *frame;
    frame = addPage(i18n("Identity"), i18n("Information about you and the translation team"));
    _identityPage = new IdentityPreferences(frame);
    _identityPage->setSettings(idOpts);

    frame = addPage(i18n("Editor"), i18n("Options for editing"));
    _editorPage = new EditorPreferences(frame);
    _editorPage->setSettings(editOpts);

    frame = addPage(i18n("Search"), i18n("Options for searching similiar translations"));
    _searchPage = new SearchPreferences(frame);
    _searchPage->setSettings(searchOpts);

    frame = addPage(i18n("Save"), i18n("Options for saving a file"));
    _savePage = new SavePreferences(frame);
    _savePage->setSettings(saveOpts);

    frame = addPage(i18n("Catalog Manager"),i18n("Options for the Catalog Manager"));
    _catManPage = new CatManPreferences(frame);
    _catManPage->setSettings(catManOpts);

    setMinimumSize(600,430);

    //adjustSize();

    _searchSettings = searchOpts;
    _editorSettings = editOpts;
    _saveSettings = saveOpts;
    _idSettings = idOpts;
    _catManSettings = catManOpts;
}


void KBabelPreferences::updateIdentitySettings(IdentitySettings settings)
{
    _identityPage->setSettings(settings);
    _idSettings=settings;
}

void KBabelPreferences::updateSaveSettings(SaveSettings settings)
{
    _savePage->setSettings(settings);
    _saveSettings=settings;
}

void KBabelPreferences::updateCatManSettings(CatManSettings settings)
{
    _catManPage->setSettings(settings);
    _catManSettings=settings;
}

void KBabelPreferences::updateSearchSettings(SearchSettings settings)
{
    _searchPage->setSettings(settings);
    _searchSettings = settings;
}


void KBabelPreferences::slotHelp()
{
   //TODO
   kapp->invokeHTMLHelp("Preferences","");
}

void KBabelPreferences::slotDefault()
{
   switch(activePageIndex())
   {
      case PAGE_IDENTITY:
         _identityPage->defaults();
         break;
      case PAGE_SAVE:
        _savePage->defaults();
        break;
      case PAGE_EDITOR:
        _editorPage->defaults();
        break;
      case PAGE_SEARCH:
         _searchPage->defaults();
         break;
      case PAGE_CATMAN:
         _catManPage->defaults();
         break;
      default:
        break;
   }
}

void KBabelPreferences::slotApply()
{
   switch(activePageIndex())
   {
      case PAGE_IDENTITY:
         _idSettings = _identityPage->settings();
         emit identityOptionsChanged(_idSettings);
         break;
      case PAGE_SAVE:
        _saveSettings=_savePage->settings();
        emit saveOptionsChanged(_saveSettings);
        break;
      case PAGE_EDITOR:
        _editorSettings = _editorPage->settings();
        emit editorOptionsChanged(_editorSettings);
        break;
      case PAGE_SEARCH:
         _searchSettings =  _searchPage->settings();
         emit searchOptionsChanged(_searchSettings);
         break;
      case PAGE_CATMAN:
         _catManSettings = _catManPage->settings();
         emit catManOptionsChanged(_catManSettings);
         break;
      default:
        break;
   }

}

void KBabelPreferences::slotOk()
{
   _idSettings = _identityPage->settings();
   _saveSettings=_savePage->settings();
   _editorSettings = _editorPage->settings();
   _searchSettings =  _searchPage->settings();
   _catManSettings = _catManPage->settings();

   emit identityOptionsChanged(_idSettings);
   emit saveOptionsChanged(_saveSettings);
   emit editorOptionsChanged(_editorSettings);
   emit searchOptionsChanged(_searchSettings);
   emit catManOptionsChanged(_catManSettings);

   QDialog::accept();
}

void KBabelPreferences::slotCancel()
{
    _identityPage->setSettings(_idSettings);
    _savePage->setSettings(_saveSettings);
    _editorPage->setSettings(_editorSettings);
    _searchPage->setSettings(_searchSettings);
    _catManPage->setSettings(_catManSettings);

    QDialog::reject();
}


