/***************************************************************************
                          proxyconf.cpp  -  description
                             -------------------
    begin                : Wed May 3 2000
    copyright            : (C) 2000 by Frank von Daak
    email                : frank.fun@kpage.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
/***************************************************************************
                          proxyconf.cpp  -  description
                             -------------------
    begin                : Tue Mar 14 2000
    copyright            : (C) 2000 by Frank von Daak
    email                : frank.fun@skydsl.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "proxyconf.h"

ProxyConf::ProxyConf(QWidget *parent, const char *name )
		 : QFrame(parent,name)
{
	QFont fnt (QFont("helvetica",12, QFont::Bold));

	httpProxyBox = new QCheckBox(i18n("Use HTTP-Proxy"), this);
	httpProxyBox->setGeometry(10,10,170,20);
	httpProxyBox->setFont(fnt);
	connect(httpProxyBox, SIGNAL(clicked()), this, SLOT(enableHttpProxy()));

	QLabel *httpProxyAdressLab = new QLabel(i18n("HTTP-Proxy :"), this);
	httpProxyAdressLab->setGeometry(20,35,90,20);

	httpProxyAdressLine = new QLineEdit(this);
	httpProxyAdressLine->setGeometry(110,35,180,20);
	httpProxyAdressLine->setEnabled(false);

	QLabel *httpProxyPortLab = new QLabel(i18n("Port:"), this);
	httpProxyPortLab->setGeometry(300,35,30,20);

	httpProxyPortLine = new QLineEdit(this);
	httpProxyPortLine->setGeometry(330,35,50,20);
	httpProxyPortLine->setEnabled(false);
	
// --- The FTP-Part ----

	ftpProxyBox = new QCheckBox(i18n("Use FTP-Proxy"), this);
	ftpProxyBox->setGeometry(10,80,170,20);
	ftpProxyBox->setFont(fnt);
	connect(ftpProxyBox, SIGNAL(clicked()), this, SLOT(enableFtpProxy()));

	QLabel *ftpProxyAdressLab = new QLabel(i18n("FTP-Proxy :"), this);
	ftpProxyAdressLab->setGeometry(20,110,90,20);

	ftpProxyAdressLine = new QLineEdit(this);
	ftpProxyAdressLine->setGeometry(110,110,170,20);
	ftpProxyAdressLine->setEnabled(false);

	QLabel *ftpProxyPortLab = new QLabel(i18n("Port:"), this);
	ftpProxyPortLab->setGeometry(300,110,30,20);

	ftpProxyPortLine = new QLineEdit(this);
	ftpProxyPortLine->setGeometry(330,110,50,20);
	ftpProxyPortLine->setEnabled(false);

	httpProxyloginBox = new QCheckBox(i18n("Proxy requires login:"), this);
	httpProxyloginBox->setGeometry(20,150,150,20);
	httpProxyloginBox->setEnabled(false);
	connect(httpProxyloginBox, SIGNAL(clicked()), this, SLOT(getHttpProxyLogin()));

	httpProxyusrLab = new QLabel(i18n("UserName :"), this);
	httpProxyusrLab->setGeometry(20,180,80,20);
	httpProxyusrLab->hide();

	httpProxypassLab = new QLabel(i18n("Password :"), this);
	httpProxypassLab->setGeometry(20,200,80,20);
	httpProxypassLab->hide();

	httpProxyusrLine = new QLineEdit(this);
	httpProxyusrLine->setGeometry(110,180,200,20);
	httpProxyusrLine->hide();

	httpProxypassLine = new QLineEdit(this);
	httpProxypassLine->setGeometry(110,200,200,20);
	httpProxypassLine->setEchoMode(QLineEdit::Password);
	httpProxypassLine->hide();
}

ProxyConf::~ProxyConf()
{
}

void ProxyConf::enableHttpProxy()
{
	if ( httpProxyBox->isChecked() ) {
		httpProxyAdressLine->setEnabled(true);
		httpProxyPortLine->setEnabled(true);
		httpProxyloginBox->setEnabled(true);
	} else {
		httpProxyAdressLine->setEnabled(false);
		httpProxyPortLine->setEnabled(false);
		httpProxyloginBox->setEnabled(false);
		httpProxyloginBox->setChecked(false);
		getHttpProxyLogin();
	}
}

void ProxyConf::getHttpProxyLogin()
{
	if ( httpProxyloginBox->isChecked() ) {
		httpProxyusrLine->show();
		httpProxypassLine->show();
		httpProxypassLab->show();
		httpProxyusrLab->show();
	} else {
		httpProxyusrLine->hide();
		httpProxypassLine->hide();
		httpProxypassLab->hide();
		httpProxyusrLab->hide();
	}
}

void ProxyConf::enableFtpProxy()
{
	if ( ftpProxyBox->isChecked() ) {
		ftpProxyAdressLine->setEnabled(true);
		ftpProxyPortLine->setEnabled(true);
	} else {
		ftpProxyAdressLine->setEnabled(false);
		ftpProxyPortLine->setEnabled(false);
	}
}