/***************************************************************************
                          mylineedit.cpp  -  description
                             -------------------
    begin                : Fri Feb 4 2000
    copyright            : (C) 2000 by Frank von Daak
    email                : frank.fun@skydsl.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "mylineedit.h"

MyLineEdit::MyLineEdit(QWidget *parent, const char *name )
		  : QLineEdit(parent,name)
{
    this->setAcceptDrops(true);
}

MyLineEdit::~MyLineEdit()
{
}

void MyLineEdit::focusInEvent(QFocusEvent *fe)
{
	if ( fe->gotFocus() )
		emit focusIn();
	QLineEdit::focusInEvent(fe);
}

void MyLineEdit::dropEvent(QDropEvent *de)
{
	QString text;
	QStrList urllist;

	int count=1;
	if (QUriDrag::decode(de, urllist)) {
		for (text=urllist.first(); text != 0; text=urllist.next()) {
			// Maybe I'll use this later :-)
			if ( count > 1 ) {
				emit multiUrl(urllist);
				return;
			}
			getProtocol(text);
			count++;
		}
	}
}

void MyLineEdit::getProtocol(QString &text)
{
	// This is used to check for the used protocol of the url
	QString tmp, tmp2;
	tmp = text;
	tmp2 = text;
	if ( tmp.left(7) == "http://" ) {
		text.remove(0,7);
		emit dropProt("http");
	}else if ( tmp.left(6) == "ftp://" ) {
		text.remove(0,6);
		emit dropProt("ftp");
	} else {
		QMessageBox::warning(this, i18n("Wrong Protocol"),
			i18n("Sorry, but this protocol\n"
				 "is not supported by KWebGet !"));
		return;
	}

	this->clear();
	this->setText(text);
}