/***************************************************************************
                          wizpage4.cpp  -  description
                             -------------------
    begin                : Wed Feb 9 2000
    copyright            : (C) 2000 by Frank von Daak
    email                : frank.fun@skydsl.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "wizpage4.h"

WizPage4::WizPage4(QWidget *parent, const char *name )
		: QFrame(parent,name)
{
	QLabel *lab = new QLabel(i18n("Set up the recursion depth and the amount of MBytes..."), this);
	lab->setGeometry(5,5,435,15);
	lab->setAlignment(AlignCenter);
	lab->setFont(QFont("helvetica", 14, QFont::Bold));

	QLabel *infoLab = new QLabel(i18n("Now, you can select, how many levels of links KWebGet "
			"should follow, to download the pages.\nYou can also set up a maximum "
			"amount of MBytes to download."), this);
	infoLab->setFont(QFont("helvetica", 10));
	infoLab->setGeometry(5,35,435,50);

	QLabel *cautLab = new QLabel(i18n("Attention: Many sites are very large, and filled with tons of files,\n"
				"which can fill your harddrive. It's better, to set up the number of levels here !"), this);
	cautLab->setFont(QFont("helvetica", 10));
	cautLab->setGeometry(5,85,435,30);

	levBut = new QCheckBox(i18n("Number of Levels :"),this);
	levBut->setGeometry(5,125,145,15);
	connect(levBut, SIGNAL(clicked()), this, SLOT(enableRecursive()));

	levBox = new QSpinBox(1, 9999, 1, this);
	levBox->setGeometry(165,125,60,20);
	levBox->setEnabled(false);

	quotaBut = new QCheckBox(i18n("Maximum amount of\nMBytes to get :"),this);	
	quotaBut->setGeometry(5,170,150,30);
	connect(quotaBut, SIGNAL(clicked()),this, SLOT(enableQuota()));

	quotaBox = new QSpinBox(1,9999,1,this);
	quotaBox->setGeometry(165,175,60,20);
	quotaBox->setEnabled(false);
}

WizPage4::~WizPage4()
{
}

void WizPage4::enableQuota()
{
	if ( quotaBut->isChecked() )
		quotaBox->setEnabled(true);
	else
		quotaBox->setEnabled(false);
}

void WizPage4::enableRecursive()
{
	if ( levBut->isChecked() )
		levBox->setEnabled(true);
	else
		levBox->setEnabled(false);
}