/***************************************************************************
                          kwgwizard.h  -  description
                             -------------------
    begin                : Mon Feb 7 2000
    copyright            : (C) 2000 by Frank von Daak
    email                : frank.fun@skydsl.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KWGWIZARD_H
#define KWGWIZARD_H

#include <kapp.h>

#include <qwidget.h>
#include <qframe.h>
#include <qdialog.h>
#include <qframe.h>
#include <qlabel.h>
#include <qpainter.h>
#include <qpixmap.h>
#include <qpushbutton.h>
#include <qmessagebox.h>
#include <qdir.h>

#include "../mypushbutton.h"
#include "wizpage1.h"
#include "wizpage2.h"
#include "wizpage3.h"
#include "wizpage4.h"
#include "wizpage5.h"
#include "wizpage6.h"

/**
  *@author Frank von Daak
  */

class KWGWizard : public QDialog  {
   Q_OBJECT
public: 
	KWGWizard(QWidget *parent=0, const char *name=0, bool modal=false, WFlags f=0);
	~KWGWizard();

	MyPushButton *cancelBut;
	WizPage1 *wizPage1;
	WizPage2 *wizPage2;
	WizPage3 *wizPage3;
	WizPage4 *wizPage4;
	WizPage5 *wizPage5;
	WizPage6 *wizPage6;

private:
	QFrame *wizFrame;
	MyPushButton *nextBut, *backBut, *finishBut;
	int comeFrom;

	void initWizard();
	void showWizPage1();
	void showWizPage2();
	void showWizPage3();
	void showWizPage4();
	void showWizPage5();
	void showWizPage6();
	void closeEvent( QCloseEvent *);
	bool checkFolder();

private slots:
	void getCaption(const char*);
	void getFolder(const char*);

	void nextPage();
	void goBack();
	void enableNext(const char *);
	void enableNext(int);
	void enableNext();
	void enableAgentLine(int);
	void finishWiz();

signals:
	void finished();
};

#endif