/* ============================================================
 * File  : kexifwidget.cpp
 * Author: Renchi Raju <renchi@pooh.tam.uiuc.edu>
 * Date  : 2004-12-14
 * Description : 
 * 
 * Copyright 2004 by Renchi Raju

 * This program is free software; you can redistribute it
 * and/or modify it under the terms of the GNU General
 * Public License as published by the Free Software Foundation;
 * either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * ============================================================ */

#include <qlayout.h>
#include <qmap.h>

#include <klocale.h>
#include <kglobal.h>
#include <kdebug.h>

#include <libexif/exif-tag.h>
#include <libexif/exif-entry.h>

#include "kexifdata.h"
#include "kexififd.h"
#include "kexifentry.h"
#include "kexiflistview.h"
#include "kexifwidget.h"

static int KExifHumanList[] =
{
     EXIF_TAG_MAKE ,
     EXIF_TAG_MODEL ,
     EXIF_TAG_DATE_TIME ,
     EXIF_TAG_SHUTTER_SPEED_VALUE ,
     EXIF_TAG_APERTURE_VALUE ,
     EXIF_TAG_EXPOSURE_PROGRAM ,
     EXIF_TAG_EXPOSURE_MODE ,
     EXIF_TAG_EXPOSURE_BIAS_VALUE ,
     EXIF_TAG_EXPOSURE_TIME ,
     EXIF_TAG_WHITE_BALANCE ,
     EXIF_TAG_ISO_SPEED_RATINGS ,
     EXIF_TAG_FOCAL_LENGTH ,
     EXIF_TAG_SUBJECT_DISTANCE ,
     EXIF_TAG_METERING_MODE ,
     EXIF_TAG_CONTRAST ,
     EXIF_TAG_SATURATION ,
     EXIF_TAG_SHARPNESS ,
     EXIF_TAG_LIGHT_SOURCE ,
     EXIF_TAG_FLASH ,
     EXIF_TAG_IMAGE_DESCRIPTION ,
     EXIF_TAG_COPYRIGHT ,
     -1 
};


KExifWidget::KExifWidget(QWidget* parent, const char* name)
    : QWidget(parent, name), m_mode(KExifWidget::SIMPLE)
{
    KGlobal::locale()->insertCatalogue("libkexif");

    m_data = new KExifData;

    QVBoxLayout* lay = new QVBoxLayout(this);
    m_view = new KExifListView(this);
    lay->addWidget(m_view);
}

KExifWidget::~KExifWidget()
{
    delete m_data;
}

bool KExifWidget::loadFile(const QString& filename)
{
    m_view->clear();
    if (!m_data->readFromFile(filename))
        return false;
    
    buildView();
    return true;
}

bool KExifWidget::loadData(char *data, int size)
{
    m_view->clear();
    if (!m_data->readFromData(data, size))
        return false;
    
    buildView();
    return true;
}

KExifData* KExifWidget::exifData() const
{
    return m_data;
}

void KExifWidget::setMode(KExifWidget::Mode mode)
{
    if (m_mode == mode)
        return;

    m_mode = mode;
    buildView();
}


QString KExifWidget::getCurrentItemName() const
{
    return m_view->getCurrentItemName();
}

void KExifWidget::setCurrentItem(const QString& itemName)
{
    m_view->setCurrentItem(itemName);    
}

void KExifWidget::buildView()
{
    m_view->clear();
    if (m_mode == SIMPLE)
    {

        QMap<int, KExifEntry*> humanMap;
        for (int i=0; KExifHumanList[i] != -1; i++)
        {
            humanMap.replace(KExifHumanList[i], 0);
        }
        
        QPtrList<KExifIfd> ifdList(m_data->ifdList());
        for (KExifIfd* ifd = ifdList.first(); ifd; ifd = ifdList.next())
        {
            QPtrList<KExifEntry> entryList = ifd->entryList();
            for (KExifEntry* entry = entryList.first(); entry; entry = entryList.next())
            {
                if (entry->exifEntry() &&
                    humanMap.contains(entry->exifEntry()->tag))
                {
                    humanMap.replace(entry->exifEntry()->tag, entry);
                }
            }
        }

        QPtrList<KExifEntry> entryList;
        for (int i=0; KExifHumanList[i] != -1; i++)
        {
            KExifEntry* entry = humanMap[KExifHumanList[i]];
            if (entry)
            {
                entryList.append(entry);
            }
        } 
       
        m_view->setEntryList(entryList);
    }
    else
    {
        m_view->setIfdList(m_data->ifdList());
    }
}

#include "kexifwidget.moc"
