/*
    Copyright 2006 Hamish Rodda <rodda@kde.org>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#ifndef KSELECTACTION_TEST_H
#define KSELECTACTION_TEST_H

#include <QMainWindow>

class KSelectAction;

class SelectActionTest : public QMainWindow
{
    Q_OBJECT

public:
    SelectActionTest(QWidget *parent = nullptr);

public Q_SLOTS:
    void triggered(QAction *action);
    void triggered(int index);
    void triggered(const QString &text);

    void slotActionTriggered(bool state);

    void addAction();
    void removeAction();

private:
    KSelectAction *m_comboSelect;
    KSelectAction *m_buttonSelect;
};

#endif
