/***************************************************************************
                          main.cpp  -  description
                             -------------------

    This file is a part of kpl - a program for graphical presentation of
    data sets and functions.

    begin                : Sat Apr 24 15:14:00 MEST 1999

    copyright            : (C) 2003 by Werner Stille
    email                : stille@uni-freiburg.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <dcopclient.h>
#include <kaboutdata.h>
#include <kapp.h>
#include <kcmdlineargs.h>
#include <klocale.h>
#include "kpl.h"

static const char* description =
  I18N_NOOP("An application for plotting of data sets and functions");

static KCmdLineOptions options[] = {
  {"+[File]", I18N_NOOP("File or URL to open"), 0},
  {0, 0, 0}
};

int main(int argc, char** argv)
{
  KAboutData aboutData("kpl", I18N_NOOP("Kpl"), VERSION, description,
                       KAboutData::License_GPL, "(c) 2003, Werner Stille",
                       0, 0, "stille@uni-freiburg.de");
  aboutData.addAuthor("Werner Stille", 0, "stille@uni-freiburg.de");
  KCmdLineArgs::init(argc, argv, &aboutData);
  KCmdLineArgs::addCmdLineOptions(options);
  KApplication app;
  app.dcopClient()->registerAs(app.name(), false);
  if (app.isRestored())
    RESTORE(KplApp)
  else {
    KCmdLineArgs* args = KCmdLineArgs::parsedArgs();
    KplApp* kpl = new KplApp;
    if (args->count()) {
      KURL::List list;
      for (int i = 0; i < args->count(); i++)
        list.append(args->url(i));
        kpl->openList(&list);
    }
    kpl->show();
    args->clear();
  }
  return app.exec();
}
