#ifndef MYTEXT_H
#define MYTEXT_H

#include <qwidget.h>
#include <qmultilinedit.h>
#include "mytext.h"
#include "filter.h"
#include "ktail_config.h"

class mybox : public QWidget
{
	Q_OBJECT
public:
	mybox(QWidget *parent=0, const char *name=0)
	: QWidget(parent, name) {};
	void resizeEvent (QResizeEvent *);
	QWidget *mychild;
	void setChild(QWidget *child);
	void removeChild();
};

class mytext : public QMultiLineEdit
{
	Q_OBJECT
public:
	mytext(QWidget *parent=0, const char *name=0);
	void mousePressEvent(QMouseEvent *);
	void setMaxLines(int);
	void setFilter(const char *, bool);
	const char *getFilter();
	void insertLineAtEnd(const char *);
	void editFilter();
	bool filterIsExcl() { return(excludePattern); };
private:
	void insertSingleLineAtEnd(const char *, bool);
	int maxLines;
	bool lastLineComplete;
	filter *filterw;
	QRegExp *re;
	bool excludePattern;
signals:
	void rightclicked();
	void altrightclicked();
	void middleclicked();
};

#endif
