export { MemoryCookieStore, MemoryCookieStoreIndex } from '../memstore';
export { pathMatch } from '../pathMatch';
export { permuteDomain } from '../permuteDomain';
export { getPublicSuffix, GetPublicSuffixOptions } from '../getPublicSuffix';
export { Store } from '../store';
export { ParameterError } from '../validators';
export { version } from '../version';
export { Callback, ErrorCallback, Nullable } from '../utils';
export { canonicalDomain } from './canonicalDomain';
export { PrefixSecurityEnum, SerializedCookie, SerializedCookieJar, } from './constants';
export { Cookie, CreateCookieOptions, ParseCookieOptions } from './cookie';
export { cookieCompare } from './cookieCompare';
export { CookieJar, CreateCookieJarOptions, GetCookiesOptions, SetCookieOptions, } from './cookieJar';
export { defaultPath } from './defaultPath';
export { domainMatch } from './domainMatch';
export { formatDate } from './formatDate';
export { parseDate } from './parseDate';
export { permutePath } from './permutePath';
import { Cookie, ParseCookieOptions } from './cookie';
/**
 * {@inheritDoc Cookie.parse}
 * @public
 */
export declare function parse(str: string, options?: ParseCookieOptions): Cookie | undefined;
/**
 * {@inheritDoc Cookie.fromJSON}
 * @public
 */
export declare function fromJSON(str: unknown): Cookie | undefined;
