import type { Experiment } from '@statsig/js-client';
import type { EvaluationDetails } from './types';
export type OnDefaultValueFallback = (config: DynamicConfig, parameter: string, defaultValueType: string, valueType: string) => void;
export declare class DynamicConfig {
    static fromExperiment(experiment: Experiment): DynamicConfig;
    value: Record<string, any>;
    readonly _name: string;
    readonly _ruleID: string;
    readonly _secondaryExposures: Record<string, string>[];
    readonly _allocatedExperimentName: string;
    readonly _evaluationDetails: EvaluationDetails;
    readonly _onDefaultValueFallback: OnDefaultValueFallback | null;
    private experiment?;
    constructor(configName: string, configValue: Record<string, any>, ruleID: string, evaluationDetails: EvaluationDetails, secondaryExposures?: Record<string, string>[], allocatedExperimentName?: string, onDefaultValueFallback?: OnDefaultValueFallback | null);
    get<T>(key: string, defaultValue: T, typeGuard?: (value: unknown) => value is T): T;
    getValue(key?: string, defaultValue?: any | null): boolean | number | string | object | Array<any> | null;
    private fireExposure;
}
