"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports._getEnvironmentFromDomain = _getEnvironmentFromDomain;
exports.configure = configure;
exports.getATLContextDomain = getATLContextDomain;
exports.getATLContextUrl = getATLContextUrl;
var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));
var _constants = require("../../common/constants");
var _domains = require("../../common/constants/domains");
var _types = require("../../common/types");
function configure(data) {
  if (!data || Object.keys(data).length < 1) {
    throw new Error('Data are not available');
  }

  // @ts-ignore - This is causing ts errors when this package is being enrolled into jira local consumption so temporarily ts ignoring this line for now
  globalThis.ATL_CONTEXT_DOMAIN = data;
}
function isValidDomainKey(domainKey) {
  if (!_types.AllowedDomains.includes(domainKey)) {
    return false;
  }
  return true;
}
function getATLContextDomain(domain, environment) {
  var _domainMap$perimeter$, _domainMap$perimeter, _subdomainOverride$do;
  // Validate this is a valid domain
  if (!isValidDomainKey(domain)) {
    throw new Error("Domain ".concat(domain, " is not supported.\n      Supported domains: ").concat(_types.AllowedDomains.join(', ')));
  }

  // First priority, always return the global context if the product has onboarded
  // @ts-ignore - This is causing ts errors when this package is being enrolled into jira local consumption so temporarily ts ignoring this line for now
  var data = globalThis.ATL_CONTEXT_DOMAIN;
  if (data) {
    return data[domain];
  }
  var _ref = environment !== null && environment !== void 0 ? environment : _getEnvironmentFromDomain(),
    _ref2 = (0, _slicedToArray2.default)(_ref, 2),
    env = _ref2[0],
    perimeter = _ref2[1];

  // Second priority, return if there is a full domain override
  var override = _domains.fullDomainOverride[domain];
  if (override) {
    var _override$perimeter$e, _override$perimeter;
    return (// Exact match preferred
      (_override$perimeter$e = (_override$perimeter = override[perimeter]) === null || _override$perimeter === void 0 ? void 0 : _override$perimeter[env]) !== null && _override$perimeter$e !== void 0 ? _override$perimeter$e :
      // Fallback to mandatory commercial production
      override[_constants.COMMERCIAL][_constants.PRODUCTION]
    );
  }

  // Third priority, join the subdomain
  var tld = (_domainMap$perimeter$ = (_domainMap$perimeter = _domains.domainMap[perimeter]) === null || _domainMap$perimeter === void 0 ? void 0 : _domainMap$perimeter[env]) !== null && _domainMap$perimeter$ !== void 0 ? _domainMap$perimeter$ : _domains.domainMap[_constants.COMMERCIAL][_constants.PRODUCTION];
  var subdomain = (_subdomainOverride$do = _domains.subdomainOverride[domain]) !== null && _subdomainOverride$do !== void 0 ? _subdomainOverride$do : domain;
  return "".concat(subdomain, ".").concat(tld);
}
function getATLContextUrl(domain) {
  return "".concat(globalThis.location.protocol, "//").concat(getATLContextDomain(domain));
}
function _getEnvironmentFromDomain() {
  var _globalThis$location;
  var hostname = (_globalThis$location = globalThis.location) === null || _globalThis$location === void 0 ? void 0 : _globalThis$location.hostname;
  if (!hostname) {
    // default if no location available
    return [_constants.PRODUCTION, _constants.COMMERCIAL];
  }

  // *.atlassian-fex.com
  if (hostname.match(/atlassian-fex\.com/)) {
    return [_constants.STAGING, _constants.FEDRAMP_FEDEX];
  }

  // *.stg.atlassian-us-gov-mod.com OR *.stg.atlassian-us-gov-mod.net
  if (hostname.match(/stg\.atlassian-us-gov-mod\.(com|net)/)) {
    return [_constants.STAGING, _constants.FEDRAMP_MODERATE];
  }

  // *.atlassian-stg-fedm.net
  if (hostname.match(/atlassian-stg-fedm\.net/)) {
    return [_constants.STAGING, _constants.FEDRAMP_MODERATE];
  }

  // *.atlassian-us-gov-mod.com OR *.atlassian-us-gov-mod.net
  if (hostname.match(/atlassian-us-gov-mod\.(com|net)/)) {
    return [_constants.PRODUCTION, _constants.FEDRAMP_MODERATE];
  }

  // *.stg.atlassian.com OR *.stg.internal.atlassian.com
  if (hostname.match(/stg(\.internal)?\.atlassian\.com/)) {
    return [_constants.STAGING, _constants.COMMERCIAL];
  }

  // *.jira-dev.com
  if (hostname.match(/jira-dev\.com/)) {
    return [_constants.STAGING, _constants.COMMERCIAL];
  }

  // default fallthrough
  return [_constants.PRODUCTION, _constants.COMMERCIAL];
}