/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.html.json.impl;

import java.io.Closeable;
import java.io.IOException;
import java.util.concurrent.Executor;
import org.netbeans.html.json.impl.ReactiveTech;
import org.netbeans.html.json.impl.ReactiveType;
import org.netbeans.html.json.spi.Proto;

public class Reactive
implements Closeable {
    private final Executor onChange;
    private final Runnable reaction;
    private final Proto proto;

    private Reactive(Runnable reaction, Executor onChange) {
        this.reaction = reaction;
        this.onChange = onChange;
        this.proto = ReactiveType.TYPE.createProto(this, ReactiveTech.CTX);
        this.proto.applyBindings();
    }

    private void reactionWithRecording() {
        this.reaction(true);
    }

    private void reaction(boolean run) {
        this.proto.acquireLock("reaction");
        if (run) {
            this.reaction.run();
        }
        this.proto.releaseLock();
    }

    Proto getProto() {
        return this.proto;
    }

    Runnable getReaction() {
        return this.reaction;
    }

    public static Closeable react(Runnable reaction, Executor onChange) {
        Reactive r = new Reactive(reaction, onChange);
        r.reactionWithRecording();
        return r;
    }

    void valueHasMutated(String propertyName) {
        this.onChange.execute(this::reactionWithRecording);
    }

    @Override
    public void close() throws IOException {
        this.reaction(false);
    }
}

