# Contributing to Glycin

## Running tests

```sh
$ meson setup -Dprofile=dev builddir
$ meson test -vC builddir
```

## Finding blocked syscalls

Auditd is enabled by default on Fedora. On Debian you need to

```sh
sudo apt install auditd
systemctl start auditd.service
```

After that you have to execute the failing operation again while running the program with `GLYCIN_SECCOMP_DEFAULT_ACTION=KILL_PROCESS`.

On Fedora the logs should be accessible via

```sh
journalctl -b | grep SECCOMP
```

On Debian via

```sh
sudo grep SECCOMP /var/log/audit/audit.log
```

## Using the locally built loaders

While `meson test` will ensure to run against the locally built loaders, for other commands, this is not the case. As a first step, you need to install the loaders into a local directory:

```sh
$ meson setup -Dprofile=dev --prefix=$(pwd)/install builddir
$ meson install -C builddir
```

You can set `GLYCIN_DATA_DIR=$(pwd)/install/share` to force glycin to use the locally built loaders.

Usually, the better option is to use `meson devenv` which will also set other relevant variables:

```sh
$ meson devenv -C builddir -w .
# Test if it works
$ ./tests/libglycin.py
```

## Useful Commands

Glycin comes with a few tools in `glycin-dev-tools/` that can be helpful for development.

```sh
$ meson devenv -C builddir -w .
$ cargo r --bin glycin-image-info image.png
```

Use ImageMagic to get Exif information.

```sh
$ identify -format '%[EXIF:*]' <image>
```

Increase memory usage (this can crash your PC)

```sh
$ sudo swapoff -a
$ stress-ng --vm-bytes 20G --vm-keep -m 1
```

## Test D-Bus API stability

The following test will ensure that the lastest API documented in `docs/` hasn't changed.

```
$ cargo test -p tests -- dbus_api_stability --include-ignored
```

## Resources

- [xdg/shared-mime-info](https://gitlab.freedesktop.org/xdg/shared-mime-info/-/blob/master/data/freedesktop.org.xml.in)

## Use of Generative AI

This project does not allow contributions generated by large languages models (LLMs) and chatbots. This ban includes, but is not limited to, tools like ChatGPT, Claude, Copilot, DeepSeek, and Devin AI. We are taking these steps as precaution due to the potential negative influence of AI generated content on quality, as well as likely copyright violations.

This ban of AI generated content applies to all parts of the projects, including, but not limited to, code, documentation, issues, and artworks. An exception applies for purely translating texts for issues and comments to English.

AI tools can be used to answer questions and find information. However, we encourage contributors to avoid them in favor of using [existing documentation](https://developer.gnome.org) and our [chats and forums](https://welcome.gnome.org). Since AI generated information is frequently misleading or false, we cannot supply support on anything referencing AI output.

## Regenerating libglycin-rebind

Bindings can be regenerated by copying the GIR files from the nightly runtime

```sh
flatpak run --filesystem=home --command=cp org.gnome.Sdk//master /usr/share/gir-1.0/{Gly,GlyGtk4}-2.gir .
```

Alternatively, they can be compiled:

```sh
$ meson setup builddir
$ meson compile -C buildir Gly-2.gir GlyGtk4-2.gir
$ cp builddir/libglycin/Gly{,Gtk4}-2.gir libglycin-rebind
```

Replace `GStrv` with `char**` in return types.

``` sh
$ sed -i s/'<array c:type="GStrv">'/'<array c:type="gchar**">'/ Gly-2.gir
```

then regenerate the bindings

``` sh
$ (cd libglycin-rebind && ./gir/generator.py --no-fmt)
$ cargo +nightly fmt
```
