/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.testing.worker;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.gradle.api.Action;
import org.gradle.api.internal.tasks.testing.TestClassProcessor;
import org.gradle.api.internal.tasks.testing.TestClassRunInfo;
import org.gradle.api.internal.tasks.testing.TestResultProcessor;
import org.gradle.api.internal.tasks.testing.WorkerTestClassProcessorFactory;
import org.gradle.api.internal.tasks.testing.worker.ForkedTestClasspath;
import org.gradle.api.internal.tasks.testing.worker.RemoteTestClassProcessor;
import org.gradle.api.internal.tasks.testing.worker.TestEventSerializer;
import org.gradle.api.internal.tasks.testing.worker.TestWorker;
import org.gradle.internal.exceptions.DefaultMultiCauseException;
import org.gradle.internal.nativeintegration.services.NativeServices;
import org.gradle.internal.remote.ObjectConnection;
import org.gradle.internal.work.WorkerLeaseRegistry;
import org.gradle.internal.work.WorkerThreadRegistry;
import org.gradle.process.JavaForkOptions;
import org.gradle.process.ProcessExecutionException;
import org.gradle.process.internal.worker.WorkerProcess;
import org.gradle.process.internal.worker.WorkerProcessBuilder;
import org.gradle.process.internal.worker.WorkerProcessFactory;

public class ForkingTestClassProcessor
implements TestClassProcessor {
    public static final String GRADLE_TEST_WORKER_NAME = "Gradle Test Executor";
    private final WorkerProcessFactory workerFactory;
    private final WorkerTestClassProcessorFactory processorFactory;
    private final JavaForkOptions options;
    private final ForkedTestClasspath classpath;
    private final Action<WorkerProcessBuilder> buildConfigAction;
    private final Lock lock = new ReentrantLock();
    private final WorkerThreadRegistry workerThreadRegistry;
    private RemoteTestClassProcessor remoteProcessor;
    private WorkerProcess workerProcess;
    private TestResultProcessor resultProcessor;
    private WorkerLeaseRegistry.WorkerLeaseCompletion completion;
    private boolean stoppedNow;
    private final Set<Throwable> unrecoverableExceptions = new HashSet<Throwable>();

    public ForkingTestClassProcessor(WorkerThreadRegistry workerThreadRegistry, WorkerProcessFactory workerFactory, WorkerTestClassProcessorFactory processorFactory, JavaForkOptions options, ForkedTestClasspath classpath, Action<WorkerProcessBuilder> buildConfigAction) {
        this.workerThreadRegistry = workerThreadRegistry;
        this.workerFactory = workerFactory;
        this.processorFactory = processorFactory;
        this.options = options;
        this.classpath = classpath;
        this.buildConfigAction = buildConfigAction;
    }

    public void startProcessing(TestResultProcessor resultProcessor) {
        this.resultProcessor = resultProcessor;
    }

    public void processTestClass(TestClassRunInfo testClass) {
        this.lock.lock();
        try {
            if (this.stoppedNow) {
                return;
            }
            if (this.remoteProcessor == null) {
                this.completion = this.workerThreadRegistry.startWorker();
                try {
                    this.remoteProcessor = this.forkProcess();
                }
                catch (RuntimeException e) {
                    this.completion.leaseFinish();
                    this.completion = null;
                    throw e;
                }
            }
            this.remoteProcessor.processTestClass(testClass);
        }
        finally {
            this.lock.unlock();
        }
    }

    RemoteTestClassProcessor forkProcess() {
        WorkerProcessBuilder builder = this.workerFactory.create((Action)new TestWorker(this.processorFactory));
        builder.setBaseName(GRADLE_TEST_WORKER_NAME);
        builder.setImplementationClasspath(this.classpath.getImplementationClasspath());
        builder.applicationClasspath(this.classpath.getApplicationClasspath());
        builder.applicationModulePath(this.classpath.getApplicationModulepath());
        builder.setNativeServicesMode(NativeServices.NativeServicesMode.DISABLED);
        builder.getJavaCommand().copyJavaForkOptions(this.options);
        this.buildConfigAction.execute((Object)builder);
        this.workerProcess = builder.build();
        this.workerProcess.start();
        ObjectConnection connection = this.workerProcess.getConnection();
        connection.useParameterSerializers(TestEventSerializer.create());
        connection.addUnrecoverableErrorHandler((Action)new Action<Throwable>(){

            public void execute(Throwable throwable) {
                ForkingTestClassProcessor.this.lock.lock();
                try {
                    if (!ForkingTestClassProcessor.this.stoppedNow) {
                        ForkingTestClassProcessor.this.unrecoverableExceptions.add(throwable);
                    }
                }
                finally {
                    ForkingTestClassProcessor.this.lock.unlock();
                }
            }
        });
        connection.addIncoming(TestResultProcessor.class, (Object)this.resultProcessor);
        RemoteTestClassProcessor remoteProcessor = (RemoteTestClassProcessor)connection.addOutgoing(RemoteTestClassProcessor.class);
        connection.connect();
        remoteProcessor.startProcessing();
        return remoteProcessor;
    }

    public void stop() {
        block11: {
            try {
                if (this.remoteProcessor == null) break block11;
                this.lock.lock();
                try {
                    if (!this.stoppedNow) {
                        this.remoteProcessor.stop();
                    }
                }
                finally {
                    this.lock.unlock();
                }
                this.workerProcess.waitForStop();
            }
            catch (ProcessExecutionException e) {
                if (!this.stoppedNow) {
                    throw e;
                }
            }
            finally {
                if (this.completion != null) {
                    this.completion.leaseFinish();
                }
            }
        }
        this.maybeRethrowUnrecoverableExceptions();
    }

    public void stopNow() {
        this.lock.lock();
        try {
            this.stoppedNow = true;
            if (this.remoteProcessor != null) {
                this.workerProcess.stopNow();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    private void maybeRethrowUnrecoverableExceptions() {
        if (!this.unrecoverableExceptions.isEmpty()) {
            throw new DefaultMultiCauseException("Unexpected errors were encountered while processing test results that may result in some results being incorrect or incomplete.", this.unrecoverableExceptions);
        }
    }
}

