"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = require("react");
var _index = require("../index");
/**
 * __useRouterLink()__
 *
 * Hook: Returns app-configured router link component.
 *
 * A generic can be passed to define advanced link configuration:
 * ```
 * type MyRouterLinkConfig = {
 *  to: string;
 *  replace?: boolean;
 * }
 *
 * const RouterLink = useRouterLink<MyRouterLinkConfig>();
 * ```
 */
var useRouterLink = function useRouterLink() {
  var _useContext = (0, _react.useContext)(_index.RouterLinkProviderContext),
    routerLinkComponent = _useContext.routerLinkComponent;
  if (routerLinkComponent) {
    return routerLinkComponent;
  }
};
var _default = exports.default = useRouterLink;