#!/bin/sh
# create a new rpm package for MoleInvasion

VERSION="0.4"
MOLE_DIR=moleinvasion-$VERSION
OUTDIR=/tmp/$$/$MOLE_DIR

if [ "$(basename $PWD)" != "rpm" ]
then
	echo "You're not in the rpm directory ..."
	exit 1
fi

echo "Copying for building in $OUTDIR ..."
mkdir -p $OUTDIR || exit 2
# copy base dir to build dir
cd ..
cp -rfp rpm/ debian/ font/ gfx/ lin/ lvl/ snd/ src/ txt/ music/ $OUTDIR || exit 2
#mkdir -p $OUTDIR/music/
cd $OUTDIR || exit 2

#clean
find . -type d -name ".svn" -exec rm -rf {} \; 2>/dev/null

#creating tarball
cd ..
tar cvfz ~/RPM/SOURCES/moleinvasion.tgz $MOLE_DIR/ || exit 2

#build
rpmbuild -ba $MOLE_DIR/rpm/moleinvasion.spec
if [ $? -ne 0 ]
then
	echo "Error in creating package ..."
	exit 1
fi

# verif
cd ~/RPM/RPMS/
pwd
ls -Rl */*
