/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.initialization;

import com.google.common.collect.ImmutableList;
import javax.annotation.Nullable;
import org.gradle.api.Action;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.Plugin;
import org.gradle.api.file.ProjectLayout;
import org.gradle.api.initialization.SharedModelDefaults;
import org.gradle.api.initialization.internal.SharedModelDefaultsInternal;
import org.gradle.api.internal.initialization.ActionBasedDefault;
import org.gradle.api.internal.initialization.ClassLoaderScope;
import org.gradle.api.internal.plugins.DslObject;
import org.gradle.api.internal.plugins.software.SoftwareType;
import org.gradle.api.internal.tasks.properties.InspectionScheme;
import org.gradle.api.problems.internal.InternalProblems;
import org.gradle.internal.Cast;
import org.gradle.internal.exceptions.DefaultMultiCauseException;
import org.gradle.internal.properties.PropertyValue;
import org.gradle.internal.properties.PropertyVisitor;
import org.gradle.internal.reflect.DefaultTypeValidationContext;
import org.gradle.internal.reflect.validation.TypeValidationContext;
import org.gradle.internal.reflect.validation.TypeValidationProblemRenderer;
import org.gradle.model.internal.type.ModelType;
import org.gradle.plugin.software.internal.ModelDefault;
import org.gradle.plugin.software.internal.ModelDefaultsHandler;
import org.gradle.plugin.software.internal.SoftwareTypeImplementation;
import org.gradle.plugin.software.internal.SoftwareTypeRegistry;

public class ActionBasedModelDefaultsHandler
implements ModelDefaultsHandler {
    private final SharedModelDefaultsInternal sharedModelDefaults;
    private final ProjectLayout projectLayout;
    private final SoftwareTypeRegistry softwareTypeRegistry;
    private final InspectionScheme inspectionScheme;
    private final InternalProblems problems;

    public ActionBasedModelDefaultsHandler(SharedModelDefaults sharedModelDefaults, ProjectLayout projectLayout, SoftwareTypeRegistry softwareTypeRegistry, InspectionScheme inspectionScheme, InternalProblems problems) {
        this.sharedModelDefaults = (SharedModelDefaultsInternal)sharedModelDefaults;
        this.projectLayout = projectLayout;
        this.softwareTypeRegistry = softwareTypeRegistry;
        this.inspectionScheme = inspectionScheme;
        this.problems = problems;
    }

    @Override
    public <T> void apply(T target, ClassLoaderScope classLoaderScope, String softwareTypeName, Plugin<?> plugin) {
        final SoftwareTypeImplementation<?> softwareTypeImplementation = this.softwareTypeRegistry.getSoftwareTypeImplementations().get(softwareTypeName);
        DefaultTypeValidationContext typeValidationContext = DefaultTypeValidationContext.withRootType(plugin.getClass(), (boolean)false, (InternalProblems)this.problems);
        this.inspectionScheme.getPropertyWalker().visitProperties(plugin, (TypeValidationContext)typeValidationContext, new PropertyVisitor(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void visitSoftwareTypeProperty(String propertyName, PropertyValue value, Class<?> declaredPropertyType, SoftwareType softwareType) {
                try {
                    ActionBasedModelDefaultsHandler.this.sharedModelDefaults.setProjectLayout(ActionBasedModelDefaultsHandler.this.projectLayout);
                    softwareTypeImplementation.visitModelDefaults((Class)Cast.uncheckedCast(ActionBasedDefault.class), ActionBasedModelDefaultsHandler.executeActionVisitor(softwareTypeImplementation, value.call()));
                }
                finally {
                    ActionBasedModelDefaultsHandler.this.sharedModelDefaults.clearProjectLayout();
                }
            }
        });
        if (!typeValidationContext.getProblems().isEmpty()) {
            throw new DefaultMultiCauseException(String.format(typeValidationContext.getProblems().size() == 1 ? "A problem was found with the %s plugin." : "Some problems were found with the %s plugin.", ActionBasedModelDefaultsHandler.getPluginObjectDisplayName(plugin)), (Iterable)typeValidationContext.getProblems().stream().map(TypeValidationProblemRenderer::renderMinimalInformationAbout).sorted().map(InvalidUserDataException::new).collect(ImmutableList.toImmutableList()));
        }
    }

    private static <T> ModelDefault.Visitor<Action<? super T>> executeActionVisitor(SoftwareTypeImplementation<T> softwareTypeImplementation, @Nullable Object modelObject) {
        if (modelObject == null) {
            throw new IllegalStateException("The model object for " + softwareTypeImplementation.getSoftwareType() + " declared in " + softwareTypeImplementation.getPluginClass().getName() + " is null.");
        }
        return action -> action.execute(Cast.uncheckedNonnullCast((Object)modelObject));
    }

    private static String getPluginObjectDisplayName(Object parameterObject) {
        return ModelType.of((Class)new DslObject(parameterObject).getDeclaredType()).getDisplayName();
    }
}

