/* Generated by wayland-scanner 1.24.0 */

#ifndef WLR_FOREIGN_TOPLEVEL_MANAGEMENT_UNSTABLE_V1_SERVER_PROTOCOL_H
#define WLR_FOREIGN_TOPLEVEL_MANAGEMENT_UNSTABLE_V1_SERVER_PROTOCOL_H

#include <stdint.h>
#include <stddef.h>
#include "wayland-server.h"

#ifdef  __cplusplus
extern "C" {
#endif

struct wl_client;
struct wl_resource;

/**
 * @page page_wlr_foreign_toplevel_management_unstable_v1 The wlr_foreign_toplevel_management_unstable_v1 protocol
 * @section page_ifaces_wlr_foreign_toplevel_management_unstable_v1 Interfaces
 * - @subpage page_iface_zwlr_foreign_toplevel_manager_v1 - list and control opened apps
 * - @subpage page_iface_zwlr_foreign_toplevel_handle_v1 - an opened toplevel
 * @section page_copyright_wlr_foreign_toplevel_management_unstable_v1 Copyright
 * <pre>
 *
 * Copyright © 2018 Ilia Bozhinov
 *
 * Permission to use, copy, modify, distribute, and sell this
 * software and its documentation for any purpose is hereby granted
 * without fee, provided that the above copyright notice appear in
 * all copies and that both that copyright notice and this permission
 * notice appear in supporting documentation, and that the name of
 * the copyright holders not be used in advertising or publicity
 * pertaining to distribution of the software without specific,
 * written prior permission.  The copyright holders make no
 * representations about the suitability of this software for any
 * purpose.  It is provided "as is" without express or implied
 * warranty.
 *
 * THE COPYRIGHT HOLDERS DISCLAIM ALL WARRANTIES WITH REGARD TO THIS
 * SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS, IN NO EVENT SHALL THE COPYRIGHT HOLDERS BE LIABLE FOR ANY
 * SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN
 * AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF
 * THIS SOFTWARE.
 * </pre>
 */
struct wl_output;
struct wl_seat;
struct wl_surface;
struct zwlr_foreign_toplevel_handle_v1;
struct zwlr_foreign_toplevel_manager_v1;

#ifndef ZWLR_FOREIGN_TOPLEVEL_MANAGER_V1_INTERFACE
#define ZWLR_FOREIGN_TOPLEVEL_MANAGER_V1_INTERFACE
/**
 * @page page_iface_zwlr_foreign_toplevel_manager_v1 zwlr_foreign_toplevel_manager_v1
 * @section page_iface_zwlr_foreign_toplevel_manager_v1_desc Description
 *
 * The purpose of this protocol is to enable the creation of taskbars
 * and docks by providing them with a list of opened applications and
 * letting them request certain actions on them, like maximizing, etc.
 *
 * After a client binds the zwlr_foreign_toplevel_manager_v1, each opened
 * toplevel window will be sent via the toplevel event
 * @section page_iface_zwlr_foreign_toplevel_manager_v1_api API
 * See @ref iface_zwlr_foreign_toplevel_manager_v1.
 */
/**
 * @defgroup iface_zwlr_foreign_toplevel_manager_v1 The zwlr_foreign_toplevel_manager_v1 interface
 *
 * The purpose of this protocol is to enable the creation of taskbars
 * and docks by providing them with a list of opened applications and
 * letting them request certain actions on them, like maximizing, etc.
 *
 * After a client binds the zwlr_foreign_toplevel_manager_v1, each opened
 * toplevel window will be sent via the toplevel event
 */
extern const struct wl_interface zwlr_foreign_toplevel_manager_v1_interface;
#endif
#ifndef ZWLR_FOREIGN_TOPLEVEL_HANDLE_V1_INTERFACE
#define ZWLR_FOREIGN_TOPLEVEL_HANDLE_V1_INTERFACE
/**
 * @page page_iface_zwlr_foreign_toplevel_handle_v1 zwlr_foreign_toplevel_handle_v1
 * @section page_iface_zwlr_foreign_toplevel_handle_v1_desc Description
 *
 * A zwlr_foreign_toplevel_handle_v1 object represents an opened toplevel
 * window. Each app may have multiple opened toplevels.
 *
 * Each toplevel has a list of outputs it is visible on, conveyed to the
 * client with the output_enter and output_leave events.
 * @section page_iface_zwlr_foreign_toplevel_handle_v1_api API
 * See @ref iface_zwlr_foreign_toplevel_handle_v1.
 */
/**
 * @defgroup iface_zwlr_foreign_toplevel_handle_v1 The zwlr_foreign_toplevel_handle_v1 interface
 *
 * A zwlr_foreign_toplevel_handle_v1 object represents an opened toplevel
 * window. Each app may have multiple opened toplevels.
 *
 * Each toplevel has a list of outputs it is visible on, conveyed to the
 * client with the output_enter and output_leave events.
 */
extern const struct wl_interface zwlr_foreign_toplevel_handle_v1_interface;
#endif

/**
 * @ingroup iface_zwlr_foreign_toplevel_manager_v1
 * @struct zwlr_foreign_toplevel_manager_v1_interface
 */
struct zwlr_foreign_toplevel_manager_v1_interface {
	/**
	 * stop sending events
	 *
	 * Indicates the client no longer wishes to receive events for
	 * new toplevels. However the compositor may emit further
	 * toplevel_created events, until the finished event is emitted.
	 *
	 * The client must not send any more requests after this one.
	 */
	void (*stop)(struct wl_client *client,
		     struct wl_resource *resource);
};

#define ZWLR_FOREIGN_TOPLEVEL_MANAGER_V1_TOPLEVEL 0
#define ZWLR_FOREIGN_TOPLEVEL_MANAGER_V1_FINISHED 1

/**
 * @ingroup iface_zwlr_foreign_toplevel_manager_v1
 */
#define ZWLR_FOREIGN_TOPLEVEL_MANAGER_V1_TOPLEVEL_SINCE_VERSION 1
/**
 * @ingroup iface_zwlr_foreign_toplevel_manager_v1
 */
#define ZWLR_FOREIGN_TOPLEVEL_MANAGER_V1_FINISHED_SINCE_VERSION 1

/**
 * @ingroup iface_zwlr_foreign_toplevel_manager_v1
 */
#define ZWLR_FOREIGN_TOPLEVEL_MANAGER_V1_STOP_SINCE_VERSION 1

/**
 * @ingroup iface_zwlr_foreign_toplevel_manager_v1
 * Sends an toplevel event to the client owning the resource.
 * @param resource_ The client's resource
 */
static inline void
zwlr_foreign_toplevel_manager_v1_send_toplevel(struct wl_resource *resource_, struct wl_resource *toplevel)
{
	wl_resource_post_event(resource_, ZWLR_FOREIGN_TOPLEVEL_MANAGER_V1_TOPLEVEL, toplevel);
}

/**
 * @ingroup iface_zwlr_foreign_toplevel_manager_v1
 * Sends an finished event to the client owning the resource.
 * @param resource_ The client's resource
 */
static inline void
zwlr_foreign_toplevel_manager_v1_send_finished(struct wl_resource *resource_)
{
	wl_resource_post_event(resource_, ZWLR_FOREIGN_TOPLEVEL_MANAGER_V1_FINISHED);
}

#ifndef ZWLR_FOREIGN_TOPLEVEL_HANDLE_V1_STATE_ENUM
#define ZWLR_FOREIGN_TOPLEVEL_HANDLE_V1_STATE_ENUM
/**
 * @ingroup iface_zwlr_foreign_toplevel_handle_v1
 * types of states on the toplevel
 *
 * The different states that a toplevel can have. These have the same meaning
 * as the states with the same names defined in xdg-toplevel
 */
enum zwlr_foreign_toplevel_handle_v1_state {
	/**
	 * the toplevel is maximized
	 */
	ZWLR_FOREIGN_TOPLEVEL_HANDLE_V1_STATE_MAXIMIZED = 0,
	/**
	 * the toplevel is minimized
	 */
	ZWLR_FOREIGN_TOPLEVEL_HANDLE_V1_STATE_MINIMIZED = 1,
	/**
	 * the toplevel is active
	 */
	ZWLR_FOREIGN_TOPLEVEL_HANDLE_V1_STATE_ACTIVATED = 2,
	/**
	 * the toplevel is fullscreen
	 * @since 2
	 */
	ZWLR_FOREIGN_TOPLEVEL_HANDLE_V1_STATE_FULLSCREEN = 3,
};
/**
 * @ingroup iface_zwlr_foreign_toplevel_handle_v1
 */
#define ZWLR_FOREIGN_TOPLEVEL_HANDLE_V1_STATE_FULLSCREEN_SINCE_VERSION 2
#endif /* ZWLR_FOREIGN_TOPLEVEL_HANDLE_V1_STATE_ENUM */

#ifndef ZWLR_FOREIGN_TOPLEVEL_HANDLE_V1_STATE_ENUM_IS_VALID
#define ZWLR_FOREIGN_TOPLEVEL_HANDLE_V1_STATE_ENUM_IS_VALID
/**
 * @ingroup iface_zwlr_foreign_toplevel_handle_v1
 * Validate a zwlr_foreign_toplevel_handle_v1 state value.
 *
 * @return true on success, false on error.
 * @ref zwlr_foreign_toplevel_handle_v1_state
 */
static inline bool
zwlr_foreign_toplevel_handle_v1_state_is_valid(uint32_t value, uint32_t version) {
	switch (value) {
	case ZWLR_FOREIGN_TOPLEVEL_HANDLE_V1_STATE_MAXIMIZED:
		return version >= 1;
	case ZWLR_FOREIGN_TOPLEVEL_HANDLE_V1_STATE_MINIMIZED:
		return version >= 1;
	case ZWLR_FOREIGN_TOPLEVEL_HANDLE_V1_STATE_ACTIVATED:
		return version >= 1;
	case ZWLR_FOREIGN_TOPLEVEL_HANDLE_V1_STATE_FULLSCREEN:
		return version >= 2;
	default:
		return false;
	}
}
#endif /* ZWLR_FOREIGN_TOPLEVEL_HANDLE_V1_STATE_ENUM_IS_VALID */

#ifndef ZWLR_FOREIGN_TOPLEVEL_HANDLE_V1_ERROR_ENUM
#define ZWLR_FOREIGN_TOPLEVEL_HANDLE_V1_ERROR_ENUM
enum zwlr_foreign_toplevel_handle_v1_error {
	/**
	 * the provided rectangle is invalid
	 */
	ZWLR_FOREIGN_TOPLEVEL_HANDLE_V1_ERROR_INVALID_RECTANGLE = 0,
};
#endif /* ZWLR_FOREIGN_TOPLEVEL_HANDLE_V1_ERROR_ENUM */

#ifndef ZWLR_FOREIGN_TOPLEVEL_HANDLE_V1_ERROR_ENUM_IS_VALID
#define ZWLR_FOREIGN_TOPLEVEL_HANDLE_V1_ERROR_ENUM_IS_VALID
/**
 * @ingroup iface_zwlr_foreign_toplevel_handle_v1
 * Validate a zwlr_foreign_toplevel_handle_v1 error value.
 *
 * @return true on success, false on error.
 * @ref zwlr_foreign_toplevel_handle_v1_error
 */
static inline bool
zwlr_foreign_toplevel_handle_v1_error_is_valid(uint32_t value, uint32_t version) {
	switch (value) {
	case ZWLR_FOREIGN_TOPLEVEL_HANDLE_V1_ERROR_INVALID_RECTANGLE:
		return version >= 1;
	default:
		return false;
	}
}
#endif /* ZWLR_FOREIGN_TOPLEVEL_HANDLE_V1_ERROR_ENUM_IS_VALID */

/**
 * @ingroup iface_zwlr_foreign_toplevel_handle_v1
 * @struct zwlr_foreign_toplevel_handle_v1_interface
 */
struct zwlr_foreign_toplevel_handle_v1_interface {
	/**
	 * requests that the toplevel be maximized
	 *
	 * Requests that the toplevel be maximized. If the maximized
	 * state actually changes, this will be indicated by the state
	 * event.
	 */
	void (*set_maximized)(struct wl_client *client,
			      struct wl_resource *resource);
	/**
	 * requests that the toplevel be unmaximized
	 *
	 * Requests that the toplevel be unmaximized. If the maximized
	 * state actually changes, this will be indicated by the state
	 * event.
	 */
	void (*unset_maximized)(struct wl_client *client,
				struct wl_resource *resource);
	/**
	 * requests that the toplevel be minimized
	 *
	 * Requests that the toplevel be minimized. If the minimized
	 * state actually changes, this will be indicated by the state
	 * event.
	 */
	void (*set_minimized)(struct wl_client *client,
			      struct wl_resource *resource);
	/**
	 * requests that the toplevel be unminimized
	 *
	 * Requests that the toplevel be unminimized. If the minimized
	 * state actually changes, this will be indicated by the state
	 * event.
	 */
	void (*unset_minimized)(struct wl_client *client,
				struct wl_resource *resource);
	/**
	 * activate the toplevel
	 *
	 * Request that this toplevel be activated on the given seat.
	 * There is no guarantee the toplevel will be actually activated.
	 */
	void (*activate)(struct wl_client *client,
			 struct wl_resource *resource,
			 struct wl_resource *seat);
	/**
	 * request that the toplevel be closed
	 *
	 * Send a request to the toplevel to close itself. The compositor
	 * would typically use a shell-specific method to carry out this
	 * request, for example by sending the xdg_toplevel.close event.
	 * However, this gives no guarantees the toplevel will actually be
	 * destroyed. If and when this happens, the
	 * zwlr_foreign_toplevel_handle_v1.closed event will be emitted.
	 */
	void (*close)(struct wl_client *client,
		      struct wl_resource *resource);
	/**
	 * the rectangle which represents the toplevel
	 *
	 * The rectangle of the surface specified in this request
	 * corresponds to the place where the app using this protocol
	 * represents the given toplevel. It can be used by the compositor
	 * as a hint for some operations, e.g minimizing. The client is
	 * however not required to set this, in which case the compositor
	 * is free to decide some default value.
	 *
	 * If the client specifies more than one rectangle, only the last
	 * one is considered.
	 *
	 * The dimensions are given in surface-local coordinates. Setting
	 * width=height=0 removes the already-set rectangle.
	 */
	void (*set_rectangle)(struct wl_client *client,
			      struct wl_resource *resource,
			      struct wl_resource *surface,
			      int32_t x,
			      int32_t y,
			      int32_t width,
			      int32_t height);
	/**
	 * destroy the zwlr_foreign_toplevel_handle_v1 object
	 *
	 * Destroys the zwlr_foreign_toplevel_handle_v1 object.
	 *
	 * This request should be called either when the client does not
	 * want to use the toplevel anymore or after the closed event to
	 * finalize the destruction of the object.
	 */
	void (*destroy)(struct wl_client *client,
			struct wl_resource *resource);
	/**
	 * request that the toplevel be fullscreened
	 *
	 * Requests that the toplevel be fullscreened on the given
	 * output. If the fullscreen state and/or the outputs the toplevel
	 * is visible on actually change, this will be indicated by the
	 * state and output_enter/leave events.
	 *
	 * The output parameter is only a hint to the compositor. Also, if
	 * output is NULL, the compositor should decide which output the
	 * toplevel will be fullscreened on, if at all.
	 * @since 2
	 */
	void (*set_fullscreen)(struct wl_client *client,
			       struct wl_resource *resource,
			       struct wl_resource *output);
	/**
	 * request that the toplevel be unfullscreened
	 *
	 * Requests that the toplevel be unfullscreened. If the
	 * fullscreen state actually changes, this will be indicated by the
	 * state event.
	 * @since 2
	 */
	void (*unset_fullscreen)(struct wl_client *client,
				 struct wl_resource *resource);
};

#define ZWLR_FOREIGN_TOPLEVEL_HANDLE_V1_TITLE 0
#define ZWLR_FOREIGN_TOPLEVEL_HANDLE_V1_APP_ID 1
#define ZWLR_FOREIGN_TOPLEVEL_HANDLE_V1_OUTPUT_ENTER 2
#define ZWLR_FOREIGN_TOPLEVEL_HANDLE_V1_OUTPUT_LEAVE 3
#define ZWLR_FOREIGN_TOPLEVEL_HANDLE_V1_STATE 4
#define ZWLR_FOREIGN_TOPLEVEL_HANDLE_V1_DONE 5
#define ZWLR_FOREIGN_TOPLEVEL_HANDLE_V1_CLOSED 6
#define ZWLR_FOREIGN_TOPLEVEL_HANDLE_V1_PARENT 7

/**
 * @ingroup iface_zwlr_foreign_toplevel_handle_v1
 */
#define ZWLR_FOREIGN_TOPLEVEL_HANDLE_V1_TITLE_SINCE_VERSION 1
/**
 * @ingroup iface_zwlr_foreign_toplevel_handle_v1
 */
#define ZWLR_FOREIGN_TOPLEVEL_HANDLE_V1_APP_ID_SINCE_VERSION 1
/**
 * @ingroup iface_zwlr_foreign_toplevel_handle_v1
 */
#define ZWLR_FOREIGN_TOPLEVEL_HANDLE_V1_OUTPUT_ENTER_SINCE_VERSION 1
/**
 * @ingroup iface_zwlr_foreign_toplevel_handle_v1
 */
#define ZWLR_FOREIGN_TOPLEVEL_HANDLE_V1_OUTPUT_LEAVE_SINCE_VERSION 1
/**
 * @ingroup iface_zwlr_foreign_toplevel_handle_v1
 */
#define ZWLR_FOREIGN_TOPLEVEL_HANDLE_V1_STATE_SINCE_VERSION 1
/**
 * @ingroup iface_zwlr_foreign_toplevel_handle_v1
 */
#define ZWLR_FOREIGN_TOPLEVEL_HANDLE_V1_DONE_SINCE_VERSION 1
/**
 * @ingroup iface_zwlr_foreign_toplevel_handle_v1
 */
#define ZWLR_FOREIGN_TOPLEVEL_HANDLE_V1_CLOSED_SINCE_VERSION 1
/**
 * @ingroup iface_zwlr_foreign_toplevel_handle_v1
 */
#define ZWLR_FOREIGN_TOPLEVEL_HANDLE_V1_PARENT_SINCE_VERSION 3

/**
 * @ingroup iface_zwlr_foreign_toplevel_handle_v1
 */
#define ZWLR_FOREIGN_TOPLEVEL_HANDLE_V1_SET_MAXIMIZED_SINCE_VERSION 1
/**
 * @ingroup iface_zwlr_foreign_toplevel_handle_v1
 */
#define ZWLR_FOREIGN_TOPLEVEL_HANDLE_V1_UNSET_MAXIMIZED_SINCE_VERSION 1
/**
 * @ingroup iface_zwlr_foreign_toplevel_handle_v1
 */
#define ZWLR_FOREIGN_TOPLEVEL_HANDLE_V1_SET_MINIMIZED_SINCE_VERSION 1
/**
 * @ingroup iface_zwlr_foreign_toplevel_handle_v1
 */
#define ZWLR_FOREIGN_TOPLEVEL_HANDLE_V1_UNSET_MINIMIZED_SINCE_VERSION 1
/**
 * @ingroup iface_zwlr_foreign_toplevel_handle_v1
 */
#define ZWLR_FOREIGN_TOPLEVEL_HANDLE_V1_ACTIVATE_SINCE_VERSION 1
/**
 * @ingroup iface_zwlr_foreign_toplevel_handle_v1
 */
#define ZWLR_FOREIGN_TOPLEVEL_HANDLE_V1_CLOSE_SINCE_VERSION 1
/**
 * @ingroup iface_zwlr_foreign_toplevel_handle_v1
 */
#define ZWLR_FOREIGN_TOPLEVEL_HANDLE_V1_SET_RECTANGLE_SINCE_VERSION 1
/**
 * @ingroup iface_zwlr_foreign_toplevel_handle_v1
 */
#define ZWLR_FOREIGN_TOPLEVEL_HANDLE_V1_DESTROY_SINCE_VERSION 1
/**
 * @ingroup iface_zwlr_foreign_toplevel_handle_v1
 */
#define ZWLR_FOREIGN_TOPLEVEL_HANDLE_V1_SET_FULLSCREEN_SINCE_VERSION 2
/**
 * @ingroup iface_zwlr_foreign_toplevel_handle_v1
 */
#define ZWLR_FOREIGN_TOPLEVEL_HANDLE_V1_UNSET_FULLSCREEN_SINCE_VERSION 2

/**
 * @ingroup iface_zwlr_foreign_toplevel_handle_v1
 * Sends an title event to the client owning the resource.
 * @param resource_ The client's resource
 */
static inline void
zwlr_foreign_toplevel_handle_v1_send_title(struct wl_resource *resource_, const char *title)
{
	wl_resource_post_event(resource_, ZWLR_FOREIGN_TOPLEVEL_HANDLE_V1_TITLE, title);
}

/**
 * @ingroup iface_zwlr_foreign_toplevel_handle_v1
 * Sends an app_id event to the client owning the resource.
 * @param resource_ The client's resource
 */
static inline void
zwlr_foreign_toplevel_handle_v1_send_app_id(struct wl_resource *resource_, const char *app_id)
{
	wl_resource_post_event(resource_, ZWLR_FOREIGN_TOPLEVEL_HANDLE_V1_APP_ID, app_id);
}

/**
 * @ingroup iface_zwlr_foreign_toplevel_handle_v1
 * Sends an output_enter event to the client owning the resource.
 * @param resource_ The client's resource
 */
static inline void
zwlr_foreign_toplevel_handle_v1_send_output_enter(struct wl_resource *resource_, struct wl_resource *output)
{
	wl_resource_post_event(resource_, ZWLR_FOREIGN_TOPLEVEL_HANDLE_V1_OUTPUT_ENTER, output);
}

/**
 * @ingroup iface_zwlr_foreign_toplevel_handle_v1
 * Sends an output_leave event to the client owning the resource.
 * @param resource_ The client's resource
 */
static inline void
zwlr_foreign_toplevel_handle_v1_send_output_leave(struct wl_resource *resource_, struct wl_resource *output)
{
	wl_resource_post_event(resource_, ZWLR_FOREIGN_TOPLEVEL_HANDLE_V1_OUTPUT_LEAVE, output);
}

/**
 * @ingroup iface_zwlr_foreign_toplevel_handle_v1
 * Sends an state event to the client owning the resource.
 * @param resource_ The client's resource
 */
static inline void
zwlr_foreign_toplevel_handle_v1_send_state(struct wl_resource *resource_, struct wl_array *state)
{
	wl_resource_post_event(resource_, ZWLR_FOREIGN_TOPLEVEL_HANDLE_V1_STATE, state);
}

/**
 * @ingroup iface_zwlr_foreign_toplevel_handle_v1
 * Sends an done event to the client owning the resource.
 * @param resource_ The client's resource
 */
static inline void
zwlr_foreign_toplevel_handle_v1_send_done(struct wl_resource *resource_)
{
	wl_resource_post_event(resource_, ZWLR_FOREIGN_TOPLEVEL_HANDLE_V1_DONE);
}

/**
 * @ingroup iface_zwlr_foreign_toplevel_handle_v1
 * Sends an closed event to the client owning the resource.
 * @param resource_ The client's resource
 */
static inline void
zwlr_foreign_toplevel_handle_v1_send_closed(struct wl_resource *resource_)
{
	wl_resource_post_event(resource_, ZWLR_FOREIGN_TOPLEVEL_HANDLE_V1_CLOSED);
}

/**
 * @ingroup iface_zwlr_foreign_toplevel_handle_v1
 * Sends an parent event to the client owning the resource.
 * @param resource_ The client's resource
 */
static inline void
zwlr_foreign_toplevel_handle_v1_send_parent(struct wl_resource *resource_, struct wl_resource *parent)
{
	wl_resource_post_event(resource_, ZWLR_FOREIGN_TOPLEVEL_HANDLE_V1_PARENT, parent);
}

#ifdef  __cplusplus
}
#endif

#endif
