// SPDX-License-Identifier: LGPL-2.1-only OR LGPL-3.0-only OR LicenseRef-KDE-Accepted-LGPL
// SPDX-FileCopyrightText: 2024 Arjen Hiemstra <ahiemstra@heimr.nl>
//
// This file is automatically generated from qml_group.cpp.j2.
// To regenerate, run `tools/propertygenerator/generate_properties.py`.

#include "ShadowPropertyGroup.h"

#include <QQmlEngine>

#include "QuickStyle.h"

using namespace Union::Properties;
using namespace Qt::StringLiterals;

ShadowPropertyGroup::ShadowPropertyGroup(QuickStyle *style)
    : QObject()
    , m_style(style)
{
    m_offset = std::make_unique<OffsetPropertyGroup>(m_style);
    m_left = std::make_unique<LinePropertyGroup>(m_style);
    m_right = std::make_unique<LinePropertyGroup>(m_style);
    m_top = std::make_unique<LinePropertyGroup>(m_style);
    m_bottom = std::make_unique<LinePropertyGroup>(m_style);
    m_topLeft = std::make_unique<CornerPropertyGroup>(m_style);
    m_topRight = std::make_unique<CornerPropertyGroup>(m_style);
    m_bottomLeft = std::make_unique<CornerPropertyGroup>(m_style);
    m_bottomRight = std::make_unique<CornerPropertyGroup>(m_style);
}

void ShadowPropertyGroup::update(ShadowProperty *newState)
{
    if (newState == m_state) {
        return;
    }

    m_state = newState;

    if (!newState) {
        m_offset->update(nullptr);
        m_left->update(nullptr);
        m_right->update(nullptr);
        m_top->update(nullptr);
        m_bottom->update(nullptr);
        m_topLeft->update(nullptr);
        m_topRight->update(nullptr);
        m_bottomLeft->update(nullptr);
        m_bottomRight->update(nullptr);
    } else {
        m_offset->update(newState->offset());
        m_left->update(newState->left());
        m_right->update(newState->right());
        m_top->update(newState->top());
        m_bottom->update(newState->bottom());
        m_topLeft->update(newState->topLeft());
        m_topRight->update(newState->topRight());
        m_bottomLeft->update(newState->bottomLeft());
        m_bottomRight->update(newState->bottomRight());
    }

    Q_EMIT colorChanged();
    Q_EMIT sizeChanged();
    Q_EMIT blurChanged();
    Q_EMIT updated();
}

void ShadowPropertyGroup::refreshColors()
{
    m_offset->refreshColors();
    Q_EMIT colorChanged();
    m_left->refreshColors();
    m_right->refreshColors();
    m_top->refreshColors();
    m_bottom->refreshColors();
    m_topLeft->refreshColors();
    m_topRight->refreshColors();
    m_bottomLeft->refreshColors();
    m_bottomRight->refreshColors();
}

OffsetPropertyGroup *ShadowPropertyGroup::offset() const
{
    return m_offset.get();
}

QJSValue ShadowPropertyGroup::color() const
{
    if (!m_state) {
        return QJSValue(QJSValue::UndefinedValue);
    }

    auto value = m_state->color();
    if (value) {
        return m_style->engine()->toScriptValue(value.value().toQColor());
    }

    return QJSValue(QJSValue::UndefinedValue);
}

QJSValue ShadowPropertyGroup::size() const
{
    if (!m_state) {
        return QJSValue(QJSValue::UndefinedValue);
    }

    auto value = m_state->size();
    if (value) {
        return m_style->engine()->toScriptValue(value.value());
    }

    return QJSValue(QJSValue::UndefinedValue);
}

QJSValue ShadowPropertyGroup::blur() const
{
    if (!m_state) {
        return QJSValue(QJSValue::UndefinedValue);
    }

    auto value = m_state->blur();
    if (value) {
        return m_style->engine()->toScriptValue(value.value());
    }

    return QJSValue(QJSValue::UndefinedValue);
}

LinePropertyGroup *ShadowPropertyGroup::left() const
{
    return m_left.get();
}

LinePropertyGroup *ShadowPropertyGroup::right() const
{
    return m_right.get();
}

LinePropertyGroup *ShadowPropertyGroup::top() const
{
    return m_top.get();
}

LinePropertyGroup *ShadowPropertyGroup::bottom() const
{
    return m_bottom.get();
}

CornerPropertyGroup *ShadowPropertyGroup::topLeft() const
{
    return m_topLeft.get();
}

CornerPropertyGroup *ShadowPropertyGroup::topRight() const
{
    return m_topRight.get();
}

CornerPropertyGroup *ShadowPropertyGroup::bottomLeft() const
{
    return m_bottomLeft.get();
}

CornerPropertyGroup *ShadowPropertyGroup::bottomRight() const
{
    return m_bottomRight.get();
}

#include "moc_ShadowPropertyGroup.cpp"