// This Source Code Form is subject to the terms of the Mozilla Public
// License, v. 2.0. If a copy of the MPL was not distributed with this
// file, You can obtain one at http://mozilla.org/MPL/2.0/.

// Code generated by "deep-copy -type RegistryAuthConfigV1Alpha1 -type RegistryMirrorConfigV1Alpha1 -type RegistryTLSConfigV1Alpha1 -pointer-receiver -header-file ../../../../../hack/boilerplate.txt -o deep_copy.generated.go ."; DO NOT EDIT.

package cri

import (
	"net/url"

	"github.com/siderolabs/talos/pkg/machinery/config/types/meta"
)

// DeepCopy generates a deep copy of *RegistryAuthConfigV1Alpha1.
func (o *RegistryAuthConfigV1Alpha1) DeepCopy() *RegistryAuthConfigV1Alpha1 {
	var cp RegistryAuthConfigV1Alpha1 = *o
	return &cp
}

// DeepCopy generates a deep copy of *RegistryMirrorConfigV1Alpha1.
func (o *RegistryMirrorConfigV1Alpha1) DeepCopy() *RegistryMirrorConfigV1Alpha1 {
	var cp RegistryMirrorConfigV1Alpha1 = *o
	if o.RegistryEndpoints != nil {
		cp.RegistryEndpoints = make([]RegistryEndpoint, len(o.RegistryEndpoints))
		copy(cp.RegistryEndpoints, o.RegistryEndpoints)
		for i2 := range o.RegistryEndpoints {
			if o.RegistryEndpoints[i2].EndpointURL.URL != nil {
				cp.RegistryEndpoints[i2].EndpointURL.URL = new(url.URL)
				*cp.RegistryEndpoints[i2].EndpointURL.URL = *o.RegistryEndpoints[i2].EndpointURL.URL
				if o.RegistryEndpoints[i2].EndpointURL.URL.User != nil {
					cp.RegistryEndpoints[i2].EndpointURL.URL.User = new(url.Userinfo)
					*cp.RegistryEndpoints[i2].EndpointURL.URL.User = *o.RegistryEndpoints[i2].EndpointURL.URL.User
				}
			}
			if o.RegistryEndpoints[i2].EndpointOverridePath != nil {
				cp.RegistryEndpoints[i2].EndpointOverridePath = new(bool)
				*cp.RegistryEndpoints[i2].EndpointOverridePath = *o.RegistryEndpoints[i2].EndpointOverridePath
			}
		}
	}
	if o.RegistrySkipFallback != nil {
		cp.RegistrySkipFallback = new(bool)
		*cp.RegistrySkipFallback = *o.RegistrySkipFallback
	}
	return &cp
}

// DeepCopy generates a deep copy of *RegistryTLSConfigV1Alpha1.
func (o *RegistryTLSConfigV1Alpha1) DeepCopy() *RegistryTLSConfigV1Alpha1 {
	var cp RegistryTLSConfigV1Alpha1 = *o
	if o.TLSClientIdentity != nil {
		cp.TLSClientIdentity = new(meta.CertificateAndKey)
		*cp.TLSClientIdentity = *o.TLSClientIdentity
	}
	if o.TLSInsecureSkipVerify != nil {
		cp.TLSInsecureSkipVerify = new(bool)
		*cp.TLSInsecureSkipVerify = *o.TLSInsecureSkipVerify
	}
	return &cp
}
