/* rygel-playspeed-response.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from rygel-playspeed-response.vala, do not modify */

/*
 * Copyright (C) 2013  Cable Television Laboratories, Inc.
 *
 * Author: Craig Pratt <craig@ecaspia.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include "rygel-server.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib-object.h>
#include <libsoup/soup.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	RYGEL_PLAY_SPEED_RESPONSE_0_PROPERTY,
	RYGEL_PLAY_SPEED_RESPONSE_NUM_PROPERTIES
};
static GParamSpec* rygel_play_speed_response_properties[RYGEL_PLAY_SPEED_RESPONSE_NUM_PROPERTIES];
#define _rygel_play_speed_unref0(var) ((var == NULL) ? NULL : (var = (rygel_play_speed_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _soup_message_headers_unref0(var) ((var == NULL) ? NULL : (var = (soup_message_headers_unref (var), NULL)))

struct _RygelPlaySpeedResponsePrivate {
	RygelPlaySpeed* speed;
};

static gint RygelPlaySpeedResponse_private_offset;
static gpointer rygel_play_speed_response_parent_class = NULL;

static void rygel_play_speed_response_real_add_response_headers (RygelHTTPResponseElement* base,
                                                          RygelHTTPRequest* request);
static gchar* rygel_play_speed_response_real_to_string (RygelHTTPResponseElement* base);
static void rygel_play_speed_response_finalize (GObject * obj);
static GType rygel_play_speed_response_get_type_once (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
rygel_play_speed_response_get_instance_private (RygelPlaySpeedResponse* self)
{
	return G_STRUCT_MEMBER_P (self, RygelPlaySpeedResponse_private_offset);
}

RygelPlaySpeedResponse*
rygel_play_speed_response_construct (GType object_type,
                                     gint numerator,
                                     guint denominator,
                                     gint framerate)
{
	RygelPlaySpeedResponse * self = NULL;
	RygelPlaySpeed* _tmp0_;
	self = (RygelPlaySpeedResponse*) rygel_http_response_element_construct (object_type);
	_tmp0_ = rygel_play_speed_new (numerator, denominator);
	_rygel_play_speed_unref0 (self->priv->speed);
	self->priv->speed = _tmp0_;
	self->framerate = framerate;
	return self;
}

RygelPlaySpeedResponse*
rygel_play_speed_response_new (gint numerator,
                               guint denominator,
                               gint framerate)
{
	return rygel_play_speed_response_construct (RYGEL_TYPE_PLAY_SPEED_RESPONSE, numerator, denominator, framerate);
}

static gpointer
_rygel_play_speed_ref0 (gpointer self)
{
	return self ? rygel_play_speed_ref (self) : NULL;
}

RygelPlaySpeedResponse*
rygel_play_speed_response_construct_from_speed (GType object_type,
                                                RygelPlaySpeed* speed,
                                                gint framerate,
                                                GError** error)
{
	RygelPlaySpeedResponse * self = NULL;
	RygelPlaySpeed* _tmp0_;
	g_return_val_if_fail (speed != NULL, NULL);
	self = (RygelPlaySpeedResponse*) rygel_http_response_element_construct (object_type);
	_tmp0_ = _rygel_play_speed_ref0 (speed);
	_rygel_play_speed_unref0 (self->priv->speed);
	self->priv->speed = _tmp0_;
	self->framerate = framerate;
	return self;
}

RygelPlaySpeedResponse*
rygel_play_speed_response_new_from_speed (RygelPlaySpeed* speed,
                                          gint framerate,
                                          GError** error)
{
	return rygel_play_speed_response_construct_from_speed (RYGEL_TYPE_PLAY_SPEED_RESPONSE, speed, framerate, error);
}

RygelPlaySpeedResponse*
rygel_play_speed_response_construct_from_string (GType object_type,
                                                 const gchar* speed,
                                                 gint framerate,
                                                 GError** error)
{
	RygelPlaySpeedResponse * self = NULL;
	RygelPlaySpeed* _tmp0_ = NULL;
	RygelPlaySpeed* _tmp1_;
	RygelPlaySpeed* _tmp2_;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (speed != NULL, NULL);
	self = (RygelPlaySpeedResponse*) rygel_http_response_element_construct (object_type);
	_tmp1_ = rygel_play_speed_new_from_string (speed, &_inner_error0_);
	_tmp0_ = _tmp1_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == RYGEL_PLAY_SPEED_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (self);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp2_ = _tmp0_;
	_tmp0_ = NULL;
	_rygel_play_speed_unref0 (self->priv->speed);
	self->priv->speed = _tmp2_;
	self->framerate = framerate;
	_rygel_play_speed_unref0 (_tmp0_);
	return self;
}

RygelPlaySpeedResponse*
rygel_play_speed_response_new_from_string (const gchar* speed,
                                           gint framerate,
                                           GError** error)
{
	return rygel_play_speed_response_construct_from_string (RYGEL_TYPE_PLAY_SPEED_RESPONSE, speed, framerate, error);
}

gboolean
rygel_play_speed_response_equals (RygelPlaySpeedResponse* self,
                                  RygelPlaySpeedRequest* that)
{
	RygelPlaySpeed* _tmp0_;
	RygelPlaySpeed* _tmp1_;
	RygelPlaySpeed* _tmp2_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (that != NULL, FALSE);
	if (that == NULL) {
		result = FALSE;
		return result;
	}
	_tmp0_ = self->priv->speed;
	_tmp1_ = rygel_play_speed_request_get_speed (that);
	_tmp2_ = _tmp1_;
	result = rygel_play_speed_equals (_tmp0_, _tmp2_);
	return result;
}

static gpointer
_soup_message_headers_ref0 (gpointer self)
{
	return self ? soup_message_headers_ref (self) : NULL;
}

static void
rygel_play_speed_response_real_add_response_headers (RygelHTTPResponseElement* base,
                                                     RygelHTTPRequest* request)
{
	RygelPlaySpeedResponse * self;
	RygelPlaySpeed* _tmp0_;
	self = (RygelPlaySpeedResponse*) base;
	g_return_if_fail (request != NULL);
	_tmp0_ = self->priv->speed;
	if (!rygel_play_speed_is_normal_rate (_tmp0_)) {
		SoupMessageHeaders* headers = NULL;
		SoupServerMessage* _tmp1_;
		SoupMessageHeaders* _tmp2_;
		SoupMessageHeaders* _tmp3_;
		SoupMessageHeaders* _tmp4_;
		RygelPlaySpeed* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		SoupServerMessage* _tmp13_;
		_tmp1_ = request->msg;
		_tmp2_ = soup_server_message_get_response_headers (_tmp1_);
		_tmp3_ = _soup_message_headers_ref0 (_tmp2_);
		headers = _tmp3_;
		_tmp4_ = headers;
		_tmp5_ = self->priv->speed;
		_tmp6_ = rygel_play_speed_to_string (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = g_strconcat ("speed=", _tmp7_, NULL);
		_tmp9_ = _tmp8_;
		soup_message_headers_append (_tmp4_, RYGEL_PLAY_SPEED_REQUEST_PLAYSPEED_HEADER, _tmp9_);
		_g_free0 (_tmp9_);
		_g_free0 (_tmp7_);
		if (self->framerate > 0) {
			gchar* framerate_val = NULL;
			gchar* _tmp10_;
			SoupMessageHeaders* _tmp11_;
			const gchar* _tmp12_;
			_tmp10_ = g_strdup_printf ("rate=%02d", self->framerate);
			framerate_val = _tmp10_;
			_tmp11_ = headers;
			_tmp12_ = framerate_val;
			soup_message_headers_append (_tmp11_, RYGEL_PLAY_SPEED_RESPONSE_FRAMERATE_HEADER, _tmp12_);
			_g_free0 (framerate_val);
		}
		_tmp13_ = request->msg;
		if (soup_server_message_get_http_version (_tmp13_) == SOUP_HTTP_1_0) {
			SoupMessageHeaders* _tmp14_;
			_tmp14_ = headers;
			soup_message_headers_replace (_tmp14_, "Pragma", "no-cache");
		}
		_soup_message_headers_unref0 (headers);
	}
}

static gchar*
rygel_play_speed_response_real_to_string (RygelHTTPResponseElement* base)
{
	RygelPlaySpeedResponse * self;
	RygelPlaySpeed* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* result;
	self = (RygelPlaySpeedResponse*) base;
	_tmp0_ = self->priv->speed;
	_tmp1_ = rygel_play_speed_to_string (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strdup_printf ("PlaySpeedResponse(speed=%s, framerate=%d)", _tmp2_, self->framerate);
	_tmp4_ = _tmp3_;
	_g_free0 (_tmp2_);
	result = _tmp4_;
	return result;
}

static void
rygel_play_speed_response_class_init (RygelPlaySpeedResponseClass * klass,
                                      gpointer klass_data)
{
	rygel_play_speed_response_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &RygelPlaySpeedResponse_private_offset);
	((RygelHTTPResponseElementClass *) klass)->add_response_headers = (void (*) (RygelHTTPResponseElement*, RygelHTTPRequest*)) rygel_play_speed_response_real_add_response_headers;
	((RygelHTTPResponseElementClass *) klass)->to_string = (gchar* (*) (RygelHTTPResponseElement*)) rygel_play_speed_response_real_to_string;
	G_OBJECT_CLASS (klass)->finalize = rygel_play_speed_response_finalize;
}

static void
rygel_play_speed_response_instance_init (RygelPlaySpeedResponse * self,
                                         gpointer klass)
{
	self->priv = rygel_play_speed_response_get_instance_private (self);
}

static void
rygel_play_speed_response_finalize (GObject * obj)
{
	RygelPlaySpeedResponse * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_PLAY_SPEED_RESPONSE, RygelPlaySpeedResponse);
	_rygel_play_speed_unref0 (self->priv->speed);
	G_OBJECT_CLASS (rygel_play_speed_response_parent_class)->finalize (obj);
}

/**
 * This class represents a DLNA PlaySpeed response (PlaySpeed.dlna.org)
 */
 G_GNUC_NO_INLINE static GType
rygel_play_speed_response_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (RygelPlaySpeedResponseClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_play_speed_response_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelPlaySpeedResponse), 0, (GInstanceInitFunc) rygel_play_speed_response_instance_init, NULL };
	GType rygel_play_speed_response_type_id;
	rygel_play_speed_response_type_id = g_type_register_static (RYGEL_TYPE_HTTP_RESPONSE_ELEMENT, "RygelPlaySpeedResponse", &g_define_type_info, 0);
	RygelPlaySpeedResponse_private_offset = g_type_add_instance_private (rygel_play_speed_response_type_id, sizeof (RygelPlaySpeedResponsePrivate));
	return rygel_play_speed_response_type_id;
}

GType
rygel_play_speed_response_get_type (void)
{
	static volatile gsize rygel_play_speed_response_type_id__once = 0;
	if (g_once_init_enter (&rygel_play_speed_response_type_id__once)) {
		GType rygel_play_speed_response_type_id;
		rygel_play_speed_response_type_id = rygel_play_speed_response_get_type_once ();
		g_once_init_leave (&rygel_play_speed_response_type_id__once, rygel_play_speed_response_type_id);
	}
	return rygel_play_speed_response_type_id__once;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

