/* DataCollection.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from DataCollection.vala, do not modify */

/*
* Copyright (c) 2009-2013 Yorba Foundation
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU Lesser General Public
* License as published by the Free Software Foundation; either
* version 2.1 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*/

#include "io.elementary.photos.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gee.h>
#include <glib-object.h>
#include <gobject/gvaluecollector.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define _g_free0(var) (var = (g_free (var), NULL))
#define _data_set_unref0(var) ((var == NULL) ? NULL : (var = (data_set_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _data_collection_unref0(var) ((var == NULL) ? NULL : (var = (data_collection_unref (var), NULL)))

#define DATA_COLLECTION_TYPE_MARKER_IMPL (data_collection_marker_impl_get_type ())
#define DATA_COLLECTION_MARKER_IMPL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DATA_COLLECTION_TYPE_MARKER_IMPL, DataCollectionMarkerImpl))
#define DATA_COLLECTION_MARKER_IMPL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DATA_COLLECTION_TYPE_MARKER_IMPL, DataCollectionMarkerImplClass))
#define DATA_COLLECTION_IS_MARKER_IMPL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DATA_COLLECTION_TYPE_MARKER_IMPL))
#define DATA_COLLECTION_IS_MARKER_IMPL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DATA_COLLECTION_TYPE_MARKER_IMPL))
#define DATA_COLLECTION_MARKER_IMPL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DATA_COLLECTION_TYPE_MARKER_IMPL, DataCollectionMarkerImplClass))

typedef struct _DataCollectionMarkerImpl DataCollectionMarkerImpl;
typedef struct _DataCollectionMarkerImplClass DataCollectionMarkerImplClass;
typedef struct _DataCollectionMarkerImplPrivate DataCollectionMarkerImplPrivate;
#define _alteration_unref0(var) ((var == NULL) ? NULL : (var = (alteration_unref (var), NULL)))
#define __vala_GValue_free0(var) ((var == NULL) ? NULL : (var = (_vala_GValue_free (var), NULL)))
enum  {
	DATA_COLLECTION_MARKER_IMPL_0_PROPERTY,
	DATA_COLLECTION_MARKER_IMPL_NUM_PROPERTIES
};
static GParamSpec* data_collection_marker_impl_properties[DATA_COLLECTION_MARKER_IMPL_NUM_PROPERTIES];
typedef struct _ParamSpecDataCollection ParamSpecDataCollection;
enum  {
	DATA_COLLECTION_ITEMS_ADDED_SIGNAL,
	DATA_COLLECTION_ITEMS_REMOVED_SIGNAL,
	DATA_COLLECTION_CONTENTS_ALTERED_SIGNAL,
	DATA_COLLECTION_ITEMS_ALTERED_SIGNAL,
	DATA_COLLECTION_ORDERING_CHANGED_SIGNAL,
	DATA_COLLECTION_PROPERTY_SET_SIGNAL,
	DATA_COLLECTION_PROPERTY_CLEARED_SIGNAL,
	DATA_COLLECTION_FROZEN_SIGNAL,
	DATA_COLLECTION_THAWED_SIGNAL,
	DATA_COLLECTION_NUM_SIGNALS
};
static guint data_collection_signals[DATA_COLLECTION_NUM_SIGNALS] = {0};
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _DataCollectionPrivate {
	gchar* name;
	DataSet* dataset;
	GeeHashMap* properties;
	gint64 object_ordinal_generator;
	gint notifies_frozen;
	GeeHashMap* frozen_items_altered;
	gboolean fire_ordering_changed;
};

struct _DataCollectionMarkerImpl {
	GObject parent_instance;
	DataCollectionMarkerImplPrivate * priv;
	DataCollection* owner;
	GeeHashSet* marked;
	gint freeze_count;
};

struct _DataCollectionMarkerImplClass {
	GObjectClass parent_class;
};

struct _ParamSpecDataCollection {
	GParamSpec parent_instance;
};

static gint DataCollection_private_offset;
static gpointer data_collection_parent_class = NULL;
static gpointer data_collection_marker_impl_parent_class = NULL;
static MarkerIface * data_collection_marker_impl_marker_parent_iface = NULL;

static GValue* _g_value_dup (GValue* self);
static void _vala_GValue_free (GValue* self);
static gchar* data_collection_real_to_string (DataCollection* self);
static void data_collection_real_notify_items_added (DataCollection* self,
                                              GeeIterable* added);
static void data_collection_real_notify_items_removed (DataCollection* self,
                                                GeeIterable* removed);
static void data_collection_real_notify_contents_altered (DataCollection* self,
                                                   GeeIterable* added,
                                                   GeeIterable* removed);
static void data_collection_real_notify_items_altered (DataCollection* self,
                                                GeeMap* items);
static void data_collection_real_notify_ordering_changed (DataCollection* self);
static void data_collection_real_notify_property_set (DataCollection* self,
                                               const gchar* name,
                                               GValue* old,
                                               GValue* val);
static void data_collection_real_notify_property_cleared (DataCollection* self,
                                                   const gchar* name);
static gboolean data_collection_real_valid_type (DataCollection* self,
                                          DataObject* object);
static void data_collection_real_set_comparator (DataCollection* self,
                                          Comparator comparator,
                                          gpointer comparator_target,
                                          ComparatorPredicate predicate,
                                          gpointer predicate_target);
static void data_collection_real_reset_comparator (DataCollection* self);
static GeeCollection* data_collection_real_get_all (DataCollection* self);
static gint data_collection_real_get_count (DataCollection* self);
static DataObject* data_collection_real_get_at (DataCollection* self,
                                         gint index);
static gint data_collection_real_index_of (DataCollection* self,
                                    DataObject* object);
static gboolean data_collection_real_contains (DataCollection* self,
                                        DataObject* object);
static gboolean data_collection_internal_contains (DataCollection* self,
                                            DataObject* object);
static void data_collection_internal_add (DataCollection* self,
                                   DataObject* object);
static void data_collection_internal_add_many (DataCollection* self,
                                        GeeList* objects,
                                        ProgressMonitor monitor,
                                        gpointer monitor_target);
static void data_collection_internal_remove (DataCollection* self,
                                      DataObject* object);
static gboolean data_collection_real_add (DataCollection* self,
                                   DataObject* object);
static GeeCollection* data_collection_real_add_many (DataCollection* self,
                                              GeeCollection* objects,
                                              ProgressMonitor monitor,
                                              gpointer monitor_target);
static DataCollectionMarkerImpl* data_collection_marker_impl_new (DataCollection* owner);
static DataCollectionMarkerImpl* data_collection_marker_impl_construct (GType object_type,
                                                                 DataCollection* owner);
static GType data_collection_marker_impl_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static gboolean data_collection_marker_impl_is_valid (DataCollectionMarkerImpl* self,
                                               DataCollection* collection);
static void data_collection_marker_impl_freeze (DataCollectionMarkerImpl* self);
static void data_collection_marker_impl_finished (DataCollectionMarkerImpl* self);
static void data_collection_real_remove_marked (DataCollection* self,
                                         Marker* m);
static void data_collection_real_clear (DataCollection* self);
static void data_collection_real_close (DataCollection* self);
static gboolean _bool_value_equals_value_equal_func (GValue* a,
                                              GValue* b,
                                              gpointer self);
static gboolean _int_value_equals_value_equal_func (GValue* a,
                                             GValue* b,
                                             gpointer self);
static void data_collection_real_notify_frozen (DataCollection* self);
static void data_collection_real_notify_thawed (DataCollection* self);
static void data_collection_real_items_added (DataCollection* self,
                                       GeeIterable* added);
static void data_collection_real_items_removed (DataCollection* self,
                                         GeeIterable* removed);
static void data_collection_real_contents_altered (DataCollection* self,
                                            GeeIterable* added,
                                            GeeIterable* removed);
static void g_cclosure_user_marshal_VOID__OBJECT_OBJECT (GClosure * closure,
                                                  GValue * return_value,
                                                  guint n_param_values,
                                                  const GValue * param_values,
                                                  gpointer invocation_hint,
                                                  gpointer marshal_data);
static void data_collection_real_items_altered (DataCollection* self,
                                         GeeMap* items);
static void data_collection_real_ordering_changed (DataCollection* self);
static void data_collection_real_property_set (DataCollection* self,
                                        const gchar* name,
                                        GValue* old,
                                        GValue* val);
static void g_cclosure_user_marshal_VOID__STRING_POINTER_BOXED (GClosure * closure,
                                                         GValue * return_value,
                                                         guint n_param_values,
                                                         const GValue * param_values,
                                                         gpointer invocation_hint,
                                                         gpointer marshal_data);
static void data_collection_real_property_cleared (DataCollection* self,
                                            const gchar* name);
static void data_collection_real_frozen (DataCollection* self);
static void data_collection_real_thawed (DataCollection* self);
static void data_collection_marker_impl_on_items_removed (DataCollectionMarkerImpl* self,
                                                   GeeIterable* removed);
static void _data_collection_marker_impl_on_items_removed_data_collection_items_removed (DataCollection* _sender,
                                                                                  GeeIterable* removed,
                                                                                  gpointer self);
static void data_collection_marker_impl_real_mark (Marker* base,
                                            DataObject* object);
static void data_collection_marker_impl_real_unmark (Marker* base,
                                              DataObject* object);
static gboolean data_collection_marker_impl_real_toggle (Marker* base,
                                                  DataObject* object);
static void data_collection_marker_impl_real_mark_many (Marker* base,
                                                 GeeCollection* list);
static void data_collection_marker_impl_real_unmark_many (Marker* base,
                                                   GeeCollection* list);
static void data_collection_marker_impl_real_mark_all (Marker* base);
static gint data_collection_marker_impl_real_get_count (Marker* base);
static GeeCollection* data_collection_marker_impl_real_get_all (Marker* base);
static void data_collection_marker_impl_finalize (GObject * obj);
static GType data_collection_marker_impl_get_type_once (void);
static void data_collection_finalize (DataCollection * obj);
static GType data_collection_get_type_once (void);

static inline gpointer
data_collection_get_instance_private (DataCollection* self)
{
	return G_STRUCT_MEMBER_P (self, DataCollection_private_offset);
}

static GValue*
_g_value_dup (GValue* self)
{
	return g_boxed_copy (G_TYPE_VALUE, self);
}

static void
_vala_GValue_free (GValue* self)
{
	g_boxed_free (G_TYPE_VALUE, self);
}

DataCollection*
data_collection_construct (GType object_type,
                           const gchar* name)
{
	DataCollection* self = NULL;
	gchar* _tmp0_;
	g_return_val_if_fail (name != NULL, NULL);
	self = (DataCollection*) g_type_create_instance (object_type);
	_tmp0_ = g_strdup (name);
	_g_free0 (self->priv->name);
	self->priv->name = _tmp0_;
	return self;
}

DataCollection*
data_collection_new (const gchar* name)
{
	return data_collection_construct (TYPE_DATA_COLLECTION, name);
}

static gchar*
data_collection_real_to_string (DataCollection* self)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
	_tmp0_ = self->priv->name;
	_tmp1_ = g_strdup_printf ("%s (%d)", _tmp0_, data_collection_get_count (self));
	result = _tmp1_;
	return result;
}

gchar*
data_collection_to_string (DataCollection* self)
{
	DataCollectionClass* _klass_;
	g_return_val_if_fail (self != NULL, NULL);
	_klass_ = DATA_COLLECTION_GET_CLASS (self);
	if (_klass_->to_string) {
		return _klass_->to_string (self);
	}
	return NULL;
}

static void
data_collection_real_notify_items_added (DataCollection* self,
                                         GeeIterable* added)
{
	g_return_if_fail (added != NULL);
	g_signal_emit (self, data_collection_signals[DATA_COLLECTION_ITEMS_ADDED_SIGNAL], 0, added);
}

void
data_collection_notify_items_added (DataCollection* self,
                                    GeeIterable* added)
{
	DataCollectionClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = DATA_COLLECTION_GET_CLASS (self);
	if (_klass_->notify_items_added) {
		_klass_->notify_items_added (self, added);
	}
}

static void
data_collection_real_notify_items_removed (DataCollection* self,
                                           GeeIterable* removed)
{
	g_return_if_fail (removed != NULL);
	g_signal_emit (self, data_collection_signals[DATA_COLLECTION_ITEMS_REMOVED_SIGNAL], 0, removed);
}

void
data_collection_notify_items_removed (DataCollection* self,
                                      GeeIterable* removed)
{
	DataCollectionClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = DATA_COLLECTION_GET_CLASS (self);
	if (_klass_->notify_items_removed) {
		_klass_->notify_items_removed (self, removed);
	}
}

static void
data_collection_real_notify_contents_altered (DataCollection* self,
                                              GeeIterable* added,
                                              GeeIterable* removed)
{
	g_signal_emit (self, data_collection_signals[DATA_COLLECTION_CONTENTS_ALTERED_SIGNAL], 0, added, removed);
}

void
data_collection_notify_contents_altered (DataCollection* self,
                                         GeeIterable* added,
                                         GeeIterable* removed)
{
	DataCollectionClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = DATA_COLLECTION_GET_CLASS (self);
	if (_klass_->notify_contents_altered) {
		_klass_->notify_contents_altered (self, added, removed);
	}
}

static void
data_collection_real_notify_items_altered (DataCollection* self,
                                           GeeMap* items)
{
	g_return_if_fail (items != NULL);
	g_signal_emit (self, data_collection_signals[DATA_COLLECTION_ITEMS_ALTERED_SIGNAL], 0, items);
}

void
data_collection_notify_items_altered (DataCollection* self,
                                      GeeMap* items)
{
	DataCollectionClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = DATA_COLLECTION_GET_CLASS (self);
	if (_klass_->notify_items_altered) {
		_klass_->notify_items_altered (self, items);
	}
}

static void
data_collection_real_notify_ordering_changed (DataCollection* self)
{
	g_signal_emit (self, data_collection_signals[DATA_COLLECTION_ORDERING_CHANGED_SIGNAL], 0);
}

void
data_collection_notify_ordering_changed (DataCollection* self)
{
	DataCollectionClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = DATA_COLLECTION_GET_CLASS (self);
	if (_klass_->notify_ordering_changed) {
		_klass_->notify_ordering_changed (self);
	}
}

static void
data_collection_real_notify_property_set (DataCollection* self,
                                          const gchar* name,
                                          GValue* old,
                                          GValue* val)
{
	GValue _tmp0_;
	g_return_if_fail (name != NULL);
	g_return_if_fail (val != NULL);
	_tmp0_ = *val;
	g_signal_emit (self, data_collection_signals[DATA_COLLECTION_PROPERTY_SET_SIGNAL], 0, name, old, &_tmp0_);
}

void
data_collection_notify_property_set (DataCollection* self,
                                     const gchar* name,
                                     GValue* old,
                                     GValue* val)
{
	DataCollectionClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = DATA_COLLECTION_GET_CLASS (self);
	if (_klass_->notify_property_set) {
		_klass_->notify_property_set (self, name, old, val);
	}
}

static void
data_collection_real_notify_property_cleared (DataCollection* self,
                                              const gchar* name)
{
	g_return_if_fail (name != NULL);
	g_signal_emit (self, data_collection_signals[DATA_COLLECTION_PROPERTY_CLEARED_SIGNAL], 0, name);
}

void
data_collection_notify_property_cleared (DataCollection* self,
                                         const gchar* name)
{
	DataCollectionClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = DATA_COLLECTION_GET_CLASS (self);
	if (_klass_->notify_property_cleared) {
		_klass_->notify_property_cleared (self, name);
	}
}

GeeCollection*
data_collection_get_singleton (DataObject* object)
{
	SingletonCollection* _tmp0_;
	GeeCollection* result;
	g_return_val_if_fail (object != NULL, NULL);
	_tmp0_ = singleton_collection_new (TYPE_DATA_OBJECT, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, object);
	result = (GeeCollection*) _tmp0_;
	return result;
}

GeeMap*
data_collection_get_alteration_singleton (DataObject* object,
                                          Alteration* alteration)
{
	GeeMap* map = NULL;
	GeeHashMap* _tmp0_;
	GeeMap* result;
	g_return_val_if_fail (object != NULL, NULL);
	g_return_val_if_fail (alteration != NULL, NULL);
	_tmp0_ = gee_hash_map_new (TYPE_DATA_OBJECT, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, TYPE_ALTERATION, (GBoxedCopyFunc) alteration_ref, (GDestroyNotify) alteration_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	map = (GeeMap*) _tmp0_;
	gee_map_set (map, object, alteration);
	result = map;
	return result;
}

static gboolean
data_collection_real_valid_type (DataCollection* self,
                                 DataObject* object)
{
	gboolean result;
	g_return_val_if_fail (object != NULL, FALSE);
	result = TRUE;
	return result;
}

gboolean
data_collection_valid_type (DataCollection* self,
                            DataObject* object)
{
	DataCollectionClass* _klass_;
	g_return_val_if_fail (self != NULL, FALSE);
	_klass_ = DATA_COLLECTION_GET_CLASS (self);
	if (_klass_->valid_type) {
		return _klass_->valid_type (self, object);
	}
	return FALSE;
}

Comparator
data_collection_get_comparator (DataCollection* self,
                                gpointer* result_target)
{
	DataSet* _tmp0_;
	gpointer _tmp1_ = NULL;
	Comparator _tmp2_;
	Comparator _tmp3_;
	gpointer _tmp3__target;
	Comparator result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->dataset;
	_tmp2_ = data_set_get_comparator (_tmp0_, &_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp3__target = _tmp1_;
	*result_target = _tmp3__target;
	result = _tmp3_;
	return result;
}

ComparatorPredicate
data_collection_get_comparator_predicate (DataCollection* self,
                                          gpointer* result_target)
{
	DataSet* _tmp0_;
	gpointer _tmp1_ = NULL;
	ComparatorPredicate _tmp2_;
	ComparatorPredicate _tmp3_;
	gpointer _tmp3__target;
	ComparatorPredicate result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->dataset;
	_tmp2_ = data_set_get_comparator_predicate (_tmp0_, &_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp3__target = _tmp1_;
	*result_target = _tmp3__target;
	result = _tmp3_;
	return result;
}

static void
data_collection_real_set_comparator (DataCollection* self,
                                     Comparator comparator,
                                     gpointer comparator_target,
                                     ComparatorPredicate predicate,
                                     gpointer predicate_target)
{
	DataSet* _tmp0_;
	_tmp0_ = self->priv->dataset;
	data_set_set_comparator (_tmp0_, comparator, comparator_target, predicate, predicate_target);
	data_collection_notify_ordering_changed (self);
}

void
data_collection_set_comparator (DataCollection* self,
                                Comparator comparator,
                                gpointer comparator_target,
                                ComparatorPredicate predicate,
                                gpointer predicate_target)
{
	DataCollectionClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = DATA_COLLECTION_GET_CLASS (self);
	if (_klass_->set_comparator) {
		_klass_->set_comparator (self, comparator, comparator_target, predicate, predicate_target);
	}
}

static void
data_collection_real_reset_comparator (DataCollection* self)
{
	DataSet* _tmp0_;
	_tmp0_ = self->priv->dataset;
	data_set_reset_comparator (_tmp0_);
	data_collection_notify_ordering_changed (self);
}

void
data_collection_reset_comparator (DataCollection* self)
{
	DataCollectionClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = DATA_COLLECTION_GET_CLASS (self);
	if (_klass_->reset_comparator) {
		_klass_->reset_comparator (self);
	}
}

static GeeCollection*
data_collection_real_get_all (DataCollection* self)
{
	DataSet* _tmp0_;
	GeeList* _tmp1_;
	GeeCollection* result;
	_tmp0_ = self->priv->dataset;
	_tmp1_ = data_set_get_all (_tmp0_);
	result = (GeeCollection*) _tmp1_;
	return result;
}

GeeCollection*
data_collection_get_all (DataCollection* self)
{
	DataCollectionClass* _klass_;
	g_return_val_if_fail (self != NULL, NULL);
	_klass_ = DATA_COLLECTION_GET_CLASS (self);
	if (_klass_->get_all) {
		return _klass_->get_all (self);
	}
	return NULL;
}

DataSet*
data_collection_get_dataset_copy (DataCollection* self)
{
	DataSet* _tmp0_;
	DataSet* _tmp1_;
	DataSet* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->dataset;
	_tmp1_ = data_set_copy (_tmp0_);
	result = _tmp1_;
	return result;
}

static gint
data_collection_real_get_count (DataCollection* self)
{
	DataSet* _tmp0_;
	gint result;
	_tmp0_ = self->priv->dataset;
	result = data_set_get_count (_tmp0_);
	return result;
}

gint
data_collection_get_count (DataCollection* self)
{
	DataCollectionClass* _klass_;
	g_return_val_if_fail (self != NULL, 0);
	_klass_ = DATA_COLLECTION_GET_CLASS (self);
	if (_klass_->get_count) {
		return _klass_->get_count (self);
	}
	return -1;
}

static DataObject*
data_collection_real_get_at (DataCollection* self,
                             gint index)
{
	DataSet* _tmp0_;
	DataObject* _tmp1_;
	DataObject* result;
	_tmp0_ = self->priv->dataset;
	_tmp1_ = data_set_get_at (_tmp0_, index);
	result = _tmp1_;
	return result;
}

DataObject*
data_collection_get_at (DataCollection* self,
                        gint index)
{
	DataCollectionClass* _klass_;
	g_return_val_if_fail (self != NULL, NULL);
	_klass_ = DATA_COLLECTION_GET_CLASS (self);
	if (_klass_->get_at) {
		return _klass_->get_at (self, index);
	}
	return NULL;
}

static gint
data_collection_real_index_of (DataCollection* self,
                               DataObject* object)
{
	DataSet* _tmp0_;
	gint result;
	g_return_val_if_fail (object != NULL, 0);
	_tmp0_ = self->priv->dataset;
	result = data_set_index_of (_tmp0_, object);
	return result;
}

gint
data_collection_index_of (DataCollection* self,
                          DataObject* object)
{
	DataCollectionClass* _klass_;
	g_return_val_if_fail (self != NULL, 0);
	_klass_ = DATA_COLLECTION_GET_CLASS (self);
	if (_klass_->index_of) {
		return _klass_->index_of (self, object);
	}
	return -1;
}

static gboolean
data_collection_real_contains (DataCollection* self,
                               DataObject* object)
{
	gboolean result;
	g_return_val_if_fail (object != NULL, FALSE);
	result = data_collection_internal_contains (self, object);
	return result;
}

gboolean
data_collection_contains (DataCollection* self,
                          DataObject* object)
{
	DataCollectionClass* _klass_;
	g_return_val_if_fail (self != NULL, FALSE);
	_klass_ = DATA_COLLECTION_GET_CLASS (self);
	if (_klass_->contains) {
		return _klass_->contains (self, object);
	}
	return FALSE;
}

static gboolean
data_collection_internal_contains (DataCollection* self,
                                   DataObject* object)
{
	DataSet* _tmp0_;
	DataCollection* _tmp1_;
	DataCollection* _tmp2_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (object != NULL, FALSE);
	_tmp0_ = self->priv->dataset;
	if (!data_set_contains (_tmp0_, object)) {
		result = FALSE;
		return result;
	}
	_tmp1_ = data_object_get_membership (object);
	_tmp2_ = _tmp1_;
	_vala_assert (_tmp2_ == self, "object.get_membership () == this");
	_data_collection_unref0 (_tmp2_);
	result = TRUE;
	return result;
}

static void
data_collection_internal_add (DataCollection* self,
                              DataObject* object)
{
	DataCollection* _tmp0_;
	gint64 _tmp1_;
	gboolean added = FALSE;
	DataSet* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (object != NULL);
	_vala_assert (data_collection_valid_type (self, object), "valid_type (object)");
	_tmp0_ = self;
	_tmp1_ = self->priv->object_ordinal_generator;
	self->priv->object_ordinal_generator = _tmp1_ + 1;
	data_object_internal_set_membership (object, _tmp0_, _tmp1_);
	_tmp2_ = self->priv->dataset;
	added = data_set_add (_tmp2_, object);
	_vala_assert (added, "added");
}

static void
data_collection_internal_add_many (DataCollection* self,
                                   GeeList* objects,
                                   ProgressMonitor monitor,
                                   gpointer monitor_target)
{
	gint count = 0;
	gint _tmp0_;
	gint _tmp1_;
	gboolean added = FALSE;
	DataSet* _tmp9_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (objects != NULL);
	_tmp0_ = gee_collection_get_size ((GeeCollection*) objects);
	_tmp1_ = _tmp0_;
	count = _tmp1_;
	{
		gint ctr = 0;
		ctr = 0;
		{
			gboolean _tmp2_ = FALSE;
			_tmp2_ = TRUE;
			while (TRUE) {
				DataObject* object = NULL;
				gpointer _tmp4_;
				DataObject* _tmp5_;
				DataObject* _tmp6_;
				DataCollection* _tmp7_;
				gint64 _tmp8_;
				if (!_tmp2_) {
					gint _tmp3_;
					_tmp3_ = ctr;
					ctr = _tmp3_ + 1;
				}
				_tmp2_ = FALSE;
				if (!(ctr < count)) {
					break;
				}
				_tmp4_ = gee_list_get (objects, ctr);
				object = (DataObject*) _tmp4_;
				_tmp5_ = object;
				_vala_assert (data_collection_valid_type (self, _tmp5_), "valid_type (object)");
				_tmp6_ = object;
				_tmp7_ = self;
				_tmp8_ = self->priv->object_ordinal_generator;
				self->priv->object_ordinal_generator = _tmp8_ + 1;
				data_object_internal_set_membership (_tmp6_, _tmp7_, _tmp8_);
				if (monitor != NULL) {
					monitor ((guint64) ctr, (guint64) count, TRUE, monitor_target);
				}
				_g_object_unref0 (object);
			}
		}
	}
	_tmp9_ = self->priv->dataset;
	added = data_set_add_many (_tmp9_, (GeeCollection*) objects);
	_vala_assert (added, "added");
}

static void
data_collection_internal_remove (DataCollection* self,
                                 DataObject* object)
{
	gboolean removed = FALSE;
	DataSet* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (object != NULL);
	_tmp0_ = self->priv->dataset;
	removed = data_set_remove (_tmp0_, object);
	_vala_assert (removed, "removed");
	data_object_internal_clear_membership (object);
}

static gboolean
data_collection_real_add (DataCollection* self,
                          DataObject* object)
{
	GeeCollection* added = NULL;
	GeeCollection* _tmp4_;
	GeeCollection* _tmp5_;
	GeeCollection* _tmp6_;
	gboolean result;
	g_return_val_if_fail (object != NULL, FALSE);
	if (data_collection_internal_contains (self, object)) {
		gchar* _tmp0_;
		gchar* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		_tmp0_ = data_collection_to_string (self);
		_tmp1_ = _tmp0_;
		_tmp2_ = data_object_to_string (object);
		_tmp3_ = _tmp2_;
		g_debug ("DataCollection.vala:324: %s cannot add %s: already present", _tmp1_, _tmp3_);
		_g_free0 (_tmp3_);
		_g_free0 (_tmp1_);
		result = FALSE;
		return result;
	}
	data_collection_internal_add (self, object);
	_tmp4_ = data_collection_get_singleton (object);
	added = _tmp4_;
	_tmp5_ = added;
	data_collection_notify_items_added (self, (GeeIterable*) _tmp5_);
	_tmp6_ = added;
	data_collection_notify_contents_altered (self, (GeeIterable*) _tmp6_, NULL);
	data_object_notify_membership_changed (object, self);
	result = TRUE;
	_g_object_unref0 (added);
	return result;
}

gboolean
data_collection_add (DataCollection* self,
                     DataObject* object)
{
	DataCollectionClass* _klass_;
	g_return_val_if_fail (self != NULL, FALSE);
	_klass_ = DATA_COLLECTION_GET_CLASS (self);
	if (_klass_->add) {
		return _klass_->add (self, object);
	}
	return FALSE;
}

static GeeCollection*
data_collection_real_add_many (DataCollection* self,
                               GeeCollection* objects,
                               ProgressMonitor monitor,
                               gpointer monitor_target)
{
	GeeArrayList* added = NULL;
	GeeArrayList* _tmp0_;
	gint count = 0;
	GeeArrayList* _tmp13_;
	gint _tmp14_;
	gint _tmp15_;
	GeeArrayList* _tmp16_;
	GeeArrayList* _tmp17_;
	GeeArrayList* _tmp18_;
	GeeCollection* result;
	g_return_val_if_fail (objects != NULL, NULL);
	_tmp0_ = gee_array_list_new (TYPE_DATA_OBJECT, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	added = _tmp0_;
	{
		GeeIterator* _object_it = NULL;
		GeeIterator* _tmp1_;
		_tmp1_ = gee_iterable_iterator ((GeeIterable*) objects);
		_object_it = _tmp1_;
		while (TRUE) {
			GeeIterator* _tmp2_;
			DataObject* object = NULL;
			GeeIterator* _tmp3_;
			gpointer _tmp4_;
			DataObject* _tmp5_;
			GeeArrayList* _tmp11_;
			DataObject* _tmp12_;
			_tmp2_ = _object_it;
			if (!gee_iterator_next (_tmp2_)) {
				break;
			}
			_tmp3_ = _object_it;
			_tmp4_ = gee_iterator_get (_tmp3_);
			object = (DataObject*) _tmp4_;
			_tmp5_ = object;
			if (data_collection_internal_contains (self, _tmp5_)) {
				gchar* _tmp6_;
				gchar* _tmp7_;
				DataObject* _tmp8_;
				gchar* _tmp9_;
				gchar* _tmp10_;
				_tmp6_ = data_collection_to_string (self);
				_tmp7_ = _tmp6_;
				_tmp8_ = object;
				_tmp9_ = data_object_to_string (_tmp8_);
				_tmp10_ = _tmp9_;
				g_debug ("DataCollection.vala:348: %s cannot add %s: already present", _tmp7_, _tmp10_);
				_g_free0 (_tmp10_);
				_g_free0 (_tmp7_);
				_g_object_unref0 (object);
				continue;
			}
			_tmp11_ = added;
			_tmp12_ = object;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp11_, _tmp12_);
			_g_object_unref0 (object);
		}
		_g_object_unref0 (_object_it);
	}
	_tmp13_ = added;
	_tmp14_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp13_);
	_tmp15_ = _tmp14_;
	count = _tmp15_;
	if (count == 0) {
		result = (GeeCollection*) added;
		return result;
	}
	_tmp16_ = added;
	data_collection_internal_add_many (self, (GeeList*) _tmp16_, monitor, monitor_target);
	_tmp17_ = added;
	data_collection_notify_items_added (self, (GeeIterable*) _tmp17_);
	_tmp18_ = added;
	data_collection_notify_contents_altered (self, (GeeIterable*) _tmp18_, NULL);
	{
		gint ctr = 0;
		ctr = 0;
		{
			gboolean _tmp19_ = FALSE;
			_tmp19_ = TRUE;
			while (TRUE) {
				GeeArrayList* _tmp21_;
				gpointer _tmp22_;
				DataObject* _tmp23_;
				if (!_tmp19_) {
					gint _tmp20_;
					_tmp20_ = ctr;
					ctr = _tmp20_ + 1;
				}
				_tmp19_ = FALSE;
				if (!(ctr < count)) {
					break;
				}
				_tmp21_ = added;
				_tmp22_ = gee_abstract_list_get ((GeeAbstractList*) _tmp21_, ctr);
				_tmp23_ = (DataObject*) _tmp22_;
				data_object_notify_membership_changed (_tmp23_, self);
				_g_object_unref0 (_tmp23_);
			}
		}
	}
	result = (GeeCollection*) added;
	return result;
}

GeeCollection*
data_collection_add_many (DataCollection* self,
                          GeeCollection* objects,
                          ProgressMonitor monitor,
                          gpointer monitor_target)
{
	DataCollectionClass* _klass_;
	g_return_val_if_fail (self != NULL, NULL);
	_klass_ = DATA_COLLECTION_GET_CLASS (self);
	if (_klass_->add_many) {
		return _klass_->add_many (self, objects, monitor, monitor_target);
	}
	return NULL;
}

Marker*
data_collection_start_marking (DataCollection* self)
{
	DataCollectionMarkerImpl* _tmp0_;
	Marker* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = data_collection_marker_impl_new (self);
	result = (Marker*) _tmp0_;
	return result;
}

Marker*
data_collection_mark (DataCollection* self,
                      DataObject* object)
{
	Marker* marker = NULL;
	DataCollectionMarkerImpl* _tmp0_;
	Marker* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (object != NULL, NULL);
	_tmp0_ = data_collection_marker_impl_new (self);
	marker = (Marker*) _tmp0_;
	marker_mark (marker, object);
	result = marker;
	return result;
}

Marker*
data_collection_mark_many (DataCollection* self,
                           GeeCollection* objects)
{
	Marker* marker = NULL;
	DataCollectionMarkerImpl* _tmp0_;
	Marker* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (objects != NULL, NULL);
	_tmp0_ = data_collection_marker_impl_new (self);
	marker = (Marker*) _tmp0_;
	marker_mark_many (marker, objects);
	result = marker;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
data_collection_act_on_marked (DataCollection* self,
                               Marker* m,
                               MarkedAction action,
                               gpointer action_target,
                               ProgressMonitor monitor,
                               gpointer monitor_target,
                               GObject* user)
{
	DataCollectionMarkerImpl* marker = NULL;
	DataCollectionMarkerImpl* _tmp0_;
	DataCollectionMarkerImpl* _tmp1_;
	DataCollectionMarkerImpl* _tmp2_;
	guint64 count = 0ULL;
	guint64 total = 0ULL;
	DataCollectionMarkerImpl* _tmp3_;
	GeeHashSet* _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	DataCollectionMarkerImpl* _tmp21_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (m != NULL);
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (m, DATA_COLLECTION_TYPE_MARKER_IMPL, DataCollectionMarkerImpl));
	marker = _tmp0_;
	_tmp1_ = marker;
	_vala_assert (data_collection_marker_impl_is_valid (_tmp1_, self), "marker.is_valid (this)");
	_tmp2_ = marker;
	data_collection_marker_impl_freeze (_tmp2_);
	count = (guint64) 0;
	_tmp3_ = marker;
	_tmp4_ = _tmp3_->marked;
	_tmp5_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp4_);
	_tmp6_ = _tmp5_;
	total = (guint64) _tmp6_;
	{
		GeeIterator* _object_it = NULL;
		DataCollectionMarkerImpl* _tmp7_;
		GeeHashSet* _tmp8_;
		GeeIterator* _tmp9_;
		_tmp7_ = marker;
		_tmp8_ = _tmp7_->marked;
		_tmp9_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) _tmp8_);
		_object_it = _tmp9_;
		while (TRUE) {
			GeeIterator* _tmp10_;
			DataObject* object = NULL;
			GeeIterator* _tmp11_;
			gpointer _tmp12_;
			DataObject* _tmp13_;
			DataObject* _tmp17_;
			_tmp10_ = _object_it;
			if (!gee_iterator_next (_tmp10_)) {
				break;
			}
			_tmp11_ = _object_it;
			_tmp12_ = gee_iterator_get (_tmp11_);
			object = (DataObject*) _tmp12_;
			_tmp13_ = object;
			if (!data_collection_internal_contains (self, _tmp13_)) {
				DataObject* _tmp14_;
				gchar* _tmp15_;
				gchar* _tmp16_;
				_tmp14_ = object;
				_tmp15_ = data_object_to_string (_tmp14_);
				_tmp16_ = _tmp15_;
				g_warning ("DataCollection.vala:412: act_on_marked: marker holding ref to unknown " \
"%s", _tmp16_);
				_g_free0 (_tmp16_);
				_g_object_unref0 (object);
				continue;
			}
			_tmp17_ = object;
			if (!action (_tmp17_, user, action_target)) {
				_g_object_unref0 (object);
				break;
			}
			if (monitor != NULL) {
				ProgressMonitor _tmp18_;
				gpointer _tmp18__target;
				guint64 _tmp19_;
				guint64 _tmp20_;
				_tmp18_ = monitor;
				_tmp18__target = monitor_target;
				count = count + 1;
				_tmp19_ = count;
				_tmp20_ = total;
				if (!_tmp18_ (_tmp19_, _tmp20_, TRUE, _tmp18__target)) {
					_g_object_unref0 (object);
					break;
				}
			}
			_g_object_unref0 (object);
		}
		_g_object_unref0 (_object_it);
	}
	_tmp21_ = marker;
	data_collection_marker_impl_finished (_tmp21_);
	_g_object_unref0 (marker);
}

static void
data_collection_real_remove_marked (DataCollection* self,
                                    Marker* m)
{
	DataCollectionMarkerImpl* marker = NULL;
	DataCollectionMarkerImpl* _tmp0_;
	DataCollectionMarkerImpl* _tmp1_;
	DataCollectionMarkerImpl* _tmp2_;
	GeeArrayList* skipped = NULL;
	GeeArrayList* _tmp18_;
	DataCollectionMarkerImpl* _tmp22_;
	GeeHashSet* _tmp23_;
	gint _tmp24_;
	gint _tmp25_;
	DataCollectionMarkerImpl* _tmp37_;
	g_return_if_fail (m != NULL);
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (m, DATA_COLLECTION_TYPE_MARKER_IMPL, DataCollectionMarkerImpl));
	marker = _tmp0_;
	_tmp1_ = marker;
	_vala_assert (data_collection_marker_impl_is_valid (_tmp1_, self), "marker.is_valid (this)");
	_tmp2_ = marker;
	data_collection_marker_impl_freeze (_tmp2_);
	skipped = NULL;
	{
		GeeIterator* _object_it = NULL;
		DataCollectionMarkerImpl* _tmp3_;
		GeeHashSet* _tmp4_;
		GeeIterator* _tmp5_;
		_tmp3_ = marker;
		_tmp4_ = _tmp3_->marked;
		_tmp5_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) _tmp4_);
		_object_it = _tmp5_;
		while (TRUE) {
			GeeIterator* _tmp6_;
			DataObject* object = NULL;
			GeeIterator* _tmp7_;
			gpointer _tmp8_;
			DataObject* _tmp9_;
			DataObject* _tmp17_;
			_tmp6_ = _object_it;
			if (!gee_iterator_next (_tmp6_)) {
				break;
			}
			_tmp7_ = _object_it;
			_tmp8_ = gee_iterator_get (_tmp7_);
			object = (DataObject*) _tmp8_;
			_tmp9_ = object;
			if (!data_collection_internal_contains (self, _tmp9_)) {
				DataObject* _tmp10_;
				gchar* _tmp11_;
				gchar* _tmp12_;
				GeeArrayList* _tmp13_;
				GeeArrayList* _tmp15_;
				DataObject* _tmp16_;
				_tmp10_ = object;
				_tmp11_ = data_object_to_string (_tmp10_);
				_tmp12_ = _tmp11_;
				g_warning ("DataCollection.vala:445: remove_marked: marker holding ref to unknown " \
"%s", _tmp12_);
				_g_free0 (_tmp12_);
				_tmp13_ = skipped;
				if (_tmp13_ == NULL) {
					GeeArrayList* _tmp14_;
					_tmp14_ = gee_array_list_new (TYPE_DATA_OBJECT, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
					_g_object_unref0 (skipped);
					skipped = _tmp14_;
				}
				_tmp15_ = skipped;
				_tmp16_ = object;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp15_, _tmp16_);
				_g_object_unref0 (object);
				continue;
			}
			_tmp17_ = object;
			data_collection_internal_remove (self, _tmp17_);
			_g_object_unref0 (object);
		}
		_g_object_unref0 (_object_it);
	}
	_tmp18_ = skipped;
	if (_tmp18_ != NULL) {
		DataCollectionMarkerImpl* _tmp19_;
		GeeHashSet* _tmp20_;
		GeeArrayList* _tmp21_;
		_tmp19_ = marker;
		_tmp20_ = _tmp19_->marked;
		_tmp21_ = skipped;
		gee_collection_remove_all ((GeeCollection*) _tmp20_, (GeeCollection*) _tmp21_);
	}
	_tmp22_ = marker;
	_tmp23_ = _tmp22_->marked;
	_tmp24_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp23_);
	_tmp25_ = _tmp24_;
	if (_tmp25_ > 0) {
		DataCollectionMarkerImpl* _tmp26_;
		GeeHashSet* _tmp27_;
		DataCollectionMarkerImpl* _tmp28_;
		GeeHashSet* _tmp29_;
		_tmp26_ = marker;
		_tmp27_ = _tmp26_->marked;
		data_collection_notify_items_removed (self, (GeeIterable*) _tmp27_);
		_tmp28_ = marker;
		_tmp29_ = _tmp28_->marked;
		data_collection_notify_contents_altered (self, NULL, (GeeIterable*) _tmp29_);
		{
			GeeIterator* _object_it = NULL;
			DataCollectionMarkerImpl* _tmp30_;
			GeeHashSet* _tmp31_;
			GeeIterator* _tmp32_;
			_tmp30_ = marker;
			_tmp31_ = _tmp30_->marked;
			_tmp32_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) _tmp31_);
			_object_it = _tmp32_;
			while (TRUE) {
				GeeIterator* _tmp33_;
				DataObject* object = NULL;
				GeeIterator* _tmp34_;
				gpointer _tmp35_;
				DataObject* _tmp36_;
				_tmp33_ = _object_it;
				if (!gee_iterator_next (_tmp33_)) {
					break;
				}
				_tmp34_ = _object_it;
				_tmp35_ = gee_iterator_get (_tmp34_);
				object = (DataObject*) _tmp35_;
				_tmp36_ = object;
				data_object_notify_membership_changed (_tmp36_, NULL);
				_g_object_unref0 (object);
			}
			_g_object_unref0 (_object_it);
		}
	}
	_tmp37_ = marker;
	data_collection_marker_impl_finished (_tmp37_);
	_g_object_unref0 (skipped);
	_g_object_unref0 (marker);
}

void
data_collection_remove_marked (DataCollection* self,
                               Marker* m)
{
	DataCollectionClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = DATA_COLLECTION_GET_CLASS (self);
	if (_klass_->remove_marked) {
		_klass_->remove_marked (self, m);
	}
}

static void
data_collection_real_clear (DataCollection* self)
{
	DataSet* _tmp0_;
	GeeArrayList* removed = NULL;
	GeeArrayList* _tmp1_;
	GeeArrayList* _tmp10_;
	GeeArrayList* _tmp11_;
	_tmp0_ = self->priv->dataset;
	if (data_set_get_count (_tmp0_) == 0) {
		return;
	}
	_tmp1_ = gee_array_list_new (TYPE_DATA_OBJECT, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	removed = _tmp1_;
	{
		gboolean _tmp2_ = FALSE;
		_tmp2_ = TRUE;
		while (TRUE) {
			DataObject* object = NULL;
			DataSet* _tmp4_;
			DataObject* _tmp5_;
			DataObject* _tmp6_;
			GeeArrayList* _tmp7_;
			DataObject* _tmp8_;
			DataObject* _tmp9_;
			if (!_tmp2_) {
				DataSet* _tmp3_;
				_tmp3_ = self->priv->dataset;
				if (!(data_set_get_count (_tmp3_) > 0)) {
					break;
				}
			}
			_tmp2_ = FALSE;
			_tmp4_ = self->priv->dataset;
			_tmp5_ = data_set_get_at (_tmp4_, 0);
			object = _tmp5_;
			_tmp6_ = object;
			_vala_assert (_tmp6_ != NULL, "object != null");
			_tmp7_ = removed;
			_tmp8_ = object;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp7_, _tmp8_);
			_tmp9_ = object;
			data_collection_internal_remove (self, _tmp9_);
			_g_object_unref0 (object);
		}
	}
	_tmp10_ = removed;
	data_collection_notify_items_removed (self, (GeeIterable*) _tmp10_);
	_tmp11_ = removed;
	data_collection_notify_contents_altered (self, NULL, (GeeIterable*) _tmp11_);
	{
		GeeArrayList* _object_list = NULL;
		GeeArrayList* _tmp12_;
		gint _object_size = 0;
		GeeArrayList* _tmp13_;
		gint _tmp14_;
		gint _tmp15_;
		gint _object_index = 0;
		_tmp12_ = removed;
		_object_list = _tmp12_;
		_tmp13_ = _object_list;
		_tmp14_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp13_);
		_tmp15_ = _tmp14_;
		_object_size = _tmp15_;
		_object_index = -1;
		while (TRUE) {
			gint _tmp16_;
			gint _tmp17_;
			DataObject* object = NULL;
			GeeArrayList* _tmp18_;
			gpointer _tmp19_;
			DataObject* _tmp20_;
			_object_index = _object_index + 1;
			_tmp16_ = _object_index;
			_tmp17_ = _object_size;
			if (!(_tmp16_ < _tmp17_)) {
				break;
			}
			_tmp18_ = _object_list;
			_tmp19_ = gee_abstract_list_get ((GeeAbstractList*) _tmp18_, _object_index);
			object = (DataObject*) _tmp19_;
			_tmp20_ = object;
			data_object_notify_membership_changed (_tmp20_, NULL);
			_g_object_unref0 (object);
		}
	}
	_g_object_unref0 (removed);
}

void
data_collection_clear (DataCollection* self)
{
	DataCollectionClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = DATA_COLLECTION_GET_CLASS (self);
	if (_klass_->clear) {
		_klass_->clear (self);
	}
}

static void
data_collection_real_close (DataCollection* self)
{
	data_collection_clear (self);
}

void
data_collection_close (DataCollection* self)
{
	DataCollectionClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = DATA_COLLECTION_GET_CLASS (self);
	if (_klass_->close) {
		_klass_->close (self);
	}
}

static gpointer
_alteration_ref0 (gpointer self)
{
	return self ? alteration_ref (self) : NULL;
}

void
data_collection_internal_notify_altered (DataCollection* self,
                                         DataObject* object,
                                         Alteration* alteration)
{
	gboolean resort_occurred = FALSE;
	DataSet* _tmp0_;
	GeeMap* _tmp12_;
	GeeMap* _tmp13_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (object != NULL);
	g_return_if_fail (alteration != NULL);
	_vala_assert (data_collection_internal_contains (self, object), "internal_contains (object)");
	_tmp0_ = self->priv->dataset;
	resort_occurred = data_set_resort_object (_tmp0_, object, alteration);
	if (data_collection_are_notifications_frozen (self)) {
		GeeHashMap* _tmp1_;
		Alteration* current = NULL;
		GeeHashMap* _tmp3_;
		gpointer _tmp4_;
		Alteration* _tmp5_;
		GeeHashMap* _tmp9_;
		Alteration* _tmp10_;
		gboolean _tmp11_ = FALSE;
		_tmp1_ = self->priv->frozen_items_altered;
		if (_tmp1_ == NULL) {
			GeeHashMap* _tmp2_;
			_tmp2_ = gee_hash_map_new (TYPE_DATA_OBJECT, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, TYPE_ALTERATION, (GBoxedCopyFunc) alteration_ref, (GDestroyNotify) alteration_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
			_g_object_unref0 (self->priv->frozen_items_altered);
			self->priv->frozen_items_altered = _tmp2_;
		}
		_tmp3_ = self->priv->frozen_items_altered;
		_tmp4_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp3_, object);
		current = (Alteration*) _tmp4_;
		_tmp5_ = current;
		if (_tmp5_ != NULL) {
			Alteration* _tmp6_;
			Alteration* _tmp7_;
			_tmp6_ = current;
			_tmp7_ = alteration_compress (_tmp6_, alteration);
			_alteration_unref0 (current);
			current = _tmp7_;
		} else {
			Alteration* _tmp8_;
			_tmp8_ = _alteration_ref0 (alteration);
			_alteration_unref0 (current);
			current = _tmp8_;
		}
		_tmp9_ = self->priv->frozen_items_altered;
		_tmp10_ = current;
		gee_abstract_map_set ((GeeAbstractMap*) _tmp9_, object, _tmp10_);
		if (self->priv->fire_ordering_changed) {
			_tmp11_ = TRUE;
		} else {
			_tmp11_ = resort_occurred;
		}
		self->priv->fire_ordering_changed = _tmp11_;
		_alteration_unref0 (current);
		return;
	}
	if (resort_occurred) {
		data_collection_notify_ordering_changed (self);
	}
	_tmp12_ = data_collection_get_alteration_singleton (object, alteration);
	_tmp13_ = _tmp12_;
	data_collection_notify_items_altered (self, _tmp13_);
	_g_object_unref0 (_tmp13_);
}

GValue*
data_collection_get_property (DataCollection* self,
                              const gchar* name)
{
	GeeHashMap* _tmp0_;
	gpointer _tmp1_;
	GValue* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = self->priv->properties;
	_tmp1_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp0_, name);
	result = (GValue*) _tmp1_;
	return result;
}

static gboolean
_bool_value_equals_value_equal_func (GValue* a,
                                     GValue* b,
                                     gpointer self)
{
	gboolean result;
	result = bool_value_equals (a, b);
	return result;
}

static gboolean
_int_value_equals_value_equal_func (GValue* a,
                                    GValue* b,
                                    gpointer self)
{
	gboolean result;
	result = int_value_equals (a, b);
	return result;
}

void
data_collection_set_property (DataCollection* self,
                              const gchar* name,
                              GValue* val,
                              ValueEqualFunc value_equals,
                              gpointer value_equals_target)
{
	GValue* old = NULL;
	GeeHashMap* _tmp0_;
	gpointer _tmp1_;
	GValue* _tmp2_;
	GeeHashMap* _tmp6_;
	GValue _tmp7_;
	GValue* _tmp8_;
	GValue _tmp9_;
	gint count = 0;
	DataSet* _tmp10_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (name != NULL);
	g_return_if_fail (val != NULL);
	if (value_equals == NULL) {
		if (G_VALUE_HOLDS (val, G_TYPE_BOOLEAN)) {
			value_equals = _bool_value_equals_value_equal_func;
			value_equals_target = NULL;
		} else {
			if (G_VALUE_HOLDS (val, G_TYPE_INT)) {
				value_equals = _int_value_equals_value_equal_func;
				value_equals_target = NULL;
			} else {
				g_error ("DataCollection.vala:552: value_equals must be specified for this type");
			}
		}
	}
	_tmp0_ = self->priv->properties;
	_tmp1_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp0_, name);
	old = (GValue*) _tmp1_;
	_tmp2_ = old;
	if (((gpointer) _tmp2_) != NULL) {
		GValue* _tmp3_;
		GValue _tmp4_;
		GValue _tmp5_;
		_tmp3_ = old;
		_tmp4_ = *val;
		_tmp5_ = *_tmp3_;
		if (value_equals (&_tmp5_, &_tmp4_, value_equals_target)) {
			__vala_GValue_free0 (old);
			return;
		}
	}
	_tmp6_ = self->priv->properties;
	_tmp7_ = *val;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp6_, name, &_tmp7_);
	_tmp8_ = old;
	_tmp9_ = *val;
	data_collection_notify_property_set (self, name, _tmp8_, &_tmp9_);
	_tmp10_ = self->priv->dataset;
	count = data_set_get_count (_tmp10_);
	{
		gint ctr = 0;
		ctr = 0;
		{
			gboolean _tmp11_ = FALSE;
			_tmp11_ = TRUE;
			while (TRUE) {
				DataSet* _tmp13_;
				DataObject* _tmp14_;
				DataObject* _tmp15_;
				GValue* _tmp16_;
				GValue _tmp17_;
				if (!_tmp11_) {
					gint _tmp12_;
					_tmp12_ = ctr;
					ctr = _tmp12_ + 1;
				}
				_tmp11_ = FALSE;
				if (!(ctr < count)) {
					break;
				}
				_tmp13_ = self->priv->dataset;
				_tmp14_ = data_set_get_at (_tmp13_, ctr);
				_tmp15_ = _tmp14_;
				_tmp16_ = old;
				_tmp17_ = *val;
				data_object_notify_collection_property_set (_tmp15_, name, _tmp16_, &_tmp17_);
				_g_object_unref0 (_tmp15_);
			}
		}
	}
	__vala_GValue_free0 (old);
}

void
data_collection_clear_property (DataCollection* self,
                                const gchar* name)
{
	GeeHashMap* _tmp0_;
	gint count = 0;
	DataSet* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (name != NULL);
	_tmp0_ = self->priv->properties;
	if (!gee_abstract_map_unset ((GeeAbstractMap*) _tmp0_, name, NULL)) {
		return;
	}
	data_collection_notify_property_cleared (self, name);
	_tmp1_ = self->priv->dataset;
	count = data_set_get_count (_tmp1_);
	{
		gint ctr = 0;
		ctr = 0;
		{
			gboolean _tmp2_ = FALSE;
			_tmp2_ = TRUE;
			while (TRUE) {
				DataSet* _tmp4_;
				DataObject* _tmp5_;
				DataObject* _tmp6_;
				if (!_tmp2_) {
					gint _tmp3_;
					_tmp3_ = ctr;
					ctr = _tmp3_ + 1;
				}
				_tmp2_ = FALSE;
				if (!(ctr < count)) {
					break;
				}
				_tmp4_ = self->priv->dataset;
				_tmp5_ = data_set_get_at (_tmp4_, ctr);
				_tmp6_ = _tmp5_;
				data_object_notify_collection_property_cleared (_tmp6_, name);
				_g_object_unref0 (_tmp6_);
			}
		}
	}
}

void
data_collection_freeze_notifications (DataCollection* self)
{
	gint _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->notifies_frozen;
	self->priv->notifies_frozen = _tmp0_ + 1;
	if (_tmp0_ == 0) {
		data_collection_notify_frozen (self);
	}
}

void
data_collection_thaw_notifications (DataCollection* self)
{
	gint _tmp0_;
	g_return_if_fail (self != NULL);
	if (self->priv->notifies_frozen == 0) {
		return;
	}
	self->priv->notifies_frozen = self->priv->notifies_frozen - 1;
	_tmp0_ = self->priv->notifies_frozen;
	if (_tmp0_ == 0) {
		data_collection_notify_thawed (self);
	}
}

gboolean
data_collection_are_notifications_frozen (DataCollection* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->notifies_frozen > 0;
	return result;
}

static void
data_collection_real_notify_frozen (DataCollection* self)
{
	g_signal_emit (self, data_collection_signals[DATA_COLLECTION_FROZEN_SIGNAL], 0);
}

void
data_collection_notify_frozen (DataCollection* self)
{
	DataCollectionClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = DATA_COLLECTION_GET_CLASS (self);
	if (_klass_->notify_frozen) {
		_klass_->notify_frozen (self);
	}
}

static void
data_collection_real_notify_thawed (DataCollection* self)
{
	GeeHashMap* _tmp0_;
	_tmp0_ = self->priv->frozen_items_altered;
	if (_tmp0_ != NULL) {
		GeeMap* copy = NULL;
		GeeHashMap* _tmp1_;
		GeeMap* _tmp2_;
		GeeMap* _tmp3_;
		_tmp1_ = self->priv->frozen_items_altered;
		_tmp2_ = _g_object_ref0 ((GeeMap*) _tmp1_);
		copy = _tmp2_;
		_g_object_unref0 (self->priv->frozen_items_altered);
		self->priv->frozen_items_altered = NULL;
		_tmp3_ = copy;
		data_collection_notify_items_altered (self, _tmp3_);
		_g_object_unref0 (copy);
	}
	if (self->priv->fire_ordering_changed) {
		self->priv->fire_ordering_changed = FALSE;
		data_collection_notify_ordering_changed (self);
	}
	g_signal_emit (self, data_collection_signals[DATA_COLLECTION_THAWED_SIGNAL], 0);
}

void
data_collection_notify_thawed (DataCollection* self)
{
	DataCollectionClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = DATA_COLLECTION_GET_CLASS (self);
	if (_klass_->notify_thawed) {
		_klass_->notify_thawed (self);
	}
}

static void
data_collection_real_items_added (DataCollection* self,
                                  GeeIterable* added)
{
	g_return_if_fail (added != NULL);
}

static void
data_collection_real_items_removed (DataCollection* self,
                                    GeeIterable* removed)
{
	g_return_if_fail (removed != NULL);
}

static void
data_collection_real_contents_altered (DataCollection* self,
                                       GeeIterable* added,
                                       GeeIterable* removed)
{
}

static void
g_cclosure_user_marshal_VOID__OBJECT_OBJECT (GClosure * closure,
                                             GValue * return_value,
                                             guint n_param_values,
                                             const GValue * param_values,
                                             gpointer invocation_hint,
                                             gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__OBJECT_OBJECT) (gpointer data1, gpointer arg_1, gpointer arg_2, gpointer data2);
	register GMarshalFunc_VOID__OBJECT_OBJECT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__OBJECT_OBJECT) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_object (param_values + 1), g_value_get_object (param_values + 2), data2);
}

static void
data_collection_real_items_altered (DataCollection* self,
                                    GeeMap* items)
{
	g_return_if_fail (items != NULL);
}

static void
data_collection_real_ordering_changed (DataCollection* self)
{
}

static void
data_collection_real_property_set (DataCollection* self,
                                   const gchar* name,
                                   GValue* old,
                                   GValue* val)
{
	g_return_if_fail (name != NULL);
	g_return_if_fail (val != NULL);
}

static void
g_cclosure_user_marshal_VOID__STRING_POINTER_BOXED (GClosure * closure,
                                                    GValue * return_value,
                                                    guint n_param_values,
                                                    const GValue * param_values,
                                                    gpointer invocation_hint,
                                                    gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__STRING_POINTER_BOXED) (gpointer data1, const char* arg_1, gpointer arg_2, gpointer arg_3, gpointer data2);
	register GMarshalFunc_VOID__STRING_POINTER_BOXED callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 4);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__STRING_POINTER_BOXED) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_string (param_values + 1), g_value_get_pointer (param_values + 2), g_value_get_boxed (param_values + 3), data2);
}

static void
data_collection_real_property_cleared (DataCollection* self,
                                       const gchar* name)
{
	g_return_if_fail (name != NULL);
}

static void
data_collection_real_frozen (DataCollection* self)
{
}

static void
data_collection_real_thawed (DataCollection* self)
{
}

static void
_data_collection_marker_impl_on_items_removed_data_collection_items_removed (DataCollection* _sender,
                                                                             GeeIterable* removed,
                                                                             gpointer self)
{
	data_collection_marker_impl_on_items_removed ((DataCollectionMarkerImpl*) self, removed);
}

static gpointer
_data_collection_ref0 (gpointer self)
{
	return self ? data_collection_ref (self) : NULL;
}

static DataCollectionMarkerImpl*
data_collection_marker_impl_construct (GType object_type,
                                       DataCollection* owner)
{
	DataCollectionMarkerImpl * self = NULL;
	DataCollection* _tmp0_;
	g_return_val_if_fail (owner != NULL, NULL);
	self = (DataCollectionMarkerImpl*) g_object_new (object_type, NULL);
	_tmp0_ = _data_collection_ref0 (owner);
	_data_collection_unref0 (self->owner);
	self->owner = _tmp0_;
	g_signal_connect_object (owner, "items-removed", (GCallback) _data_collection_marker_impl_on_items_removed_data_collection_items_removed, self, 0);
	return self;
}

static DataCollectionMarkerImpl*
data_collection_marker_impl_new (DataCollection* owner)
{
	return data_collection_marker_impl_construct (DATA_COLLECTION_TYPE_MARKER_IMPL, owner);
}

static void
data_collection_marker_impl_real_mark (Marker* base,
                                       DataObject* object)
{
	DataCollectionMarkerImpl * self;
	DataCollection* _tmp0_;
	GeeHashSet* _tmp1_;
	self = (DataCollectionMarkerImpl*) base;
	g_return_if_fail (object != NULL);
	_tmp0_ = self->owner;
	_vala_assert (data_collection_internal_contains (_tmp0_, object), "owner.internal_contains (object)");
	_tmp1_ = self->marked;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp1_, object);
}

static void
data_collection_marker_impl_real_unmark (Marker* base,
                                         DataObject* object)
{
	DataCollectionMarkerImpl * self;
	DataCollection* _tmp0_;
	GeeHashSet* _tmp1_;
	self = (DataCollectionMarkerImpl*) base;
	g_return_if_fail (object != NULL);
	_tmp0_ = self->owner;
	_vala_assert (data_collection_internal_contains (_tmp0_, object), "owner.internal_contains (object)");
	_tmp1_ = self->marked;
	gee_abstract_collection_remove ((GeeAbstractCollection*) _tmp1_, object);
}

static gboolean
data_collection_marker_impl_real_toggle (Marker* base,
                                         DataObject* object)
{
	DataCollectionMarkerImpl * self;
	DataCollection* _tmp0_;
	GeeHashSet* _tmp1_;
	GeeHashSet* _tmp4_;
	gboolean result;
	self = (DataCollectionMarkerImpl*) base;
	g_return_val_if_fail (object != NULL, FALSE);
	_tmp0_ = self->owner;
	_vala_assert (data_collection_internal_contains (_tmp0_, object), "owner.internal_contains (object)");
	_tmp1_ = self->marked;
	if (gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp1_, object)) {
		GeeHashSet* _tmp2_;
		_tmp2_ = self->marked;
		gee_abstract_collection_remove ((GeeAbstractCollection*) _tmp2_, object);
	} else {
		GeeHashSet* _tmp3_;
		_tmp3_ = self->marked;
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp3_, object);
	}
	_tmp4_ = self->marked;
	result = gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp4_, object);
	return result;
}

static void
data_collection_marker_impl_real_mark_many (Marker* base,
                                            GeeCollection* list)
{
	DataCollectionMarkerImpl * self;
	self = (DataCollectionMarkerImpl*) base;
	g_return_if_fail (list != NULL);
	{
		GeeIterator* _object_it = NULL;
		GeeIterator* _tmp0_;
		_tmp0_ = gee_iterable_iterator ((GeeIterable*) list);
		_object_it = _tmp0_;
		while (TRUE) {
			GeeIterator* _tmp1_;
			DataObject* object = NULL;
			GeeIterator* _tmp2_;
			gpointer _tmp3_;
			DataCollection* _tmp4_;
			DataObject* _tmp5_;
			GeeHashSet* _tmp6_;
			DataObject* _tmp7_;
			_tmp1_ = _object_it;
			if (!gee_iterator_next (_tmp1_)) {
				break;
			}
			_tmp2_ = _object_it;
			_tmp3_ = gee_iterator_get (_tmp2_);
			object = (DataObject*) _tmp3_;
			_tmp4_ = self->owner;
			_tmp5_ = object;
			_vala_assert (data_collection_internal_contains (_tmp4_, _tmp5_), "owner.internal_contains (object)");
			_tmp6_ = self->marked;
			_tmp7_ = object;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp6_, _tmp7_);
			_g_object_unref0 (object);
		}
		_g_object_unref0 (_object_it);
	}
}

static void
data_collection_marker_impl_real_unmark_many (Marker* base,
                                              GeeCollection* list)
{
	DataCollectionMarkerImpl * self;
	self = (DataCollectionMarkerImpl*) base;
	g_return_if_fail (list != NULL);
	{
		GeeIterator* _object_it = NULL;
		GeeIterator* _tmp0_;
		_tmp0_ = gee_iterable_iterator ((GeeIterable*) list);
		_object_it = _tmp0_;
		while (TRUE) {
			GeeIterator* _tmp1_;
			DataObject* object = NULL;
			GeeIterator* _tmp2_;
			gpointer _tmp3_;
			DataCollection* _tmp4_;
			DataObject* _tmp5_;
			GeeHashSet* _tmp6_;
			DataObject* _tmp7_;
			_tmp1_ = _object_it;
			if (!gee_iterator_next (_tmp1_)) {
				break;
			}
			_tmp2_ = _object_it;
			_tmp3_ = gee_iterator_get (_tmp2_);
			object = (DataObject*) _tmp3_;
			_tmp4_ = self->owner;
			_tmp5_ = object;
			_vala_assert (data_collection_internal_contains (_tmp4_, _tmp5_), "owner.internal_contains (object)");
			_tmp6_ = self->marked;
			_tmp7_ = object;
			gee_abstract_collection_remove ((GeeAbstractCollection*) _tmp6_, _tmp7_);
			_g_object_unref0 (object);
		}
		_g_object_unref0 (_object_it);
	}
}

static void
data_collection_marker_impl_real_mark_all (Marker* base)
{
	DataCollectionMarkerImpl * self;
	self = (DataCollectionMarkerImpl*) base;
	{
		GeeIterator* _object_it = NULL;
		DataCollection* _tmp0_;
		GeeCollection* _tmp1_;
		GeeCollection* _tmp2_;
		GeeIterator* _tmp3_;
		GeeIterator* _tmp4_;
		_tmp0_ = self->owner;
		_tmp1_ = data_collection_get_all (_tmp0_);
		_tmp2_ = _tmp1_;
		_tmp3_ = gee_iterable_iterator ((GeeIterable*) _tmp2_);
		_tmp4_ = _tmp3_;
		_g_object_unref0 (_tmp2_);
		_object_it = _tmp4_;
		while (TRUE) {
			GeeIterator* _tmp5_;
			DataObject* object = NULL;
			GeeIterator* _tmp6_;
			gpointer _tmp7_;
			GeeHashSet* _tmp8_;
			DataObject* _tmp9_;
			_tmp5_ = _object_it;
			if (!gee_iterator_next (_tmp5_)) {
				break;
			}
			_tmp6_ = _object_it;
			_tmp7_ = gee_iterator_get (_tmp6_);
			object = (DataObject*) _tmp7_;
			_tmp8_ = self->marked;
			_tmp9_ = object;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp8_, _tmp9_);
			_g_object_unref0 (object);
		}
		_g_object_unref0 (_object_it);
	}
}

static gint
data_collection_marker_impl_real_get_count (Marker* base)
{
	DataCollectionMarkerImpl * self;
	gint _tmp0_ = 0;
	GeeHashSet* _tmp1_;
	gint result;
	self = (DataCollectionMarkerImpl*) base;
	_tmp1_ = self->marked;
	if (_tmp1_ != NULL) {
		GeeHashSet* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		_tmp2_ = self->marked;
		_tmp3_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_tmp0_ = _tmp4_;
	} else {
		_tmp0_ = self->freeze_count;
	}
	result = _tmp0_;
	return result;
}

static GeeCollection*
data_collection_marker_impl_real_get_all (Marker* base)
{
	DataCollectionMarkerImpl * self;
	GeeArrayList* copy = NULL;
	GeeArrayList* _tmp0_;
	GeeHashSet* _tmp1_;
	GeeCollection* result;
	self = (DataCollectionMarkerImpl*) base;
	_tmp0_ = gee_array_list_new (TYPE_DATA_OBJECT, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	copy = _tmp0_;
	_tmp1_ = self->marked;
	gee_array_list_add_all (copy, (GeeCollection*) _tmp1_);
	result = (GeeCollection*) copy;
	return result;
}

static void
data_collection_marker_impl_on_items_removed (DataCollectionMarkerImpl* self,
                                              GeeIterable* removed)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (removed != NULL);
	{
		GeeIterator* _object_it = NULL;
		GeeIterator* _tmp0_;
		_tmp0_ = gee_iterable_iterator (removed);
		_object_it = _tmp0_;
		while (TRUE) {
			GeeIterator* _tmp1_;
			DataObject* object = NULL;
			GeeIterator* _tmp2_;
			gpointer _tmp3_;
			GeeHashSet* _tmp4_;
			DataObject* _tmp5_;
			_tmp1_ = _object_it;
			if (!gee_iterator_next (_tmp1_)) {
				break;
			}
			_tmp2_ = _object_it;
			_tmp3_ = gee_iterator_get (_tmp2_);
			object = (DataObject*) _tmp3_;
			_tmp4_ = self->marked;
			_tmp5_ = object;
			gee_abstract_collection_remove ((GeeAbstractCollection*) _tmp4_, _tmp5_);
			_g_object_unref0 (object);
		}
		_g_object_unref0 (_object_it);
	}
}

static void
data_collection_marker_impl_freeze (DataCollectionMarkerImpl* self)
{
	DataCollection* _tmp0_;
	guint _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->owner;
	g_signal_parse_name ("items-removed", TYPE_DATA_COLLECTION, &_tmp1_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp0_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, 0, NULL, (GCallback) _data_collection_marker_impl_on_items_removed_data_collection_items_removed, self);
}

static void
data_collection_marker_impl_finished (DataCollectionMarkerImpl* self)
{
	GeeHashSet* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->marked;
	if (_tmp0_ != NULL) {
		GeeHashSet* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		_tmp1_ = self->marked;
		_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		self->freeze_count = _tmp3_;
	}
	_g_object_unref0 (self->marked);
	self->marked = NULL;
}

static gboolean
data_collection_marker_impl_is_valid (DataCollectionMarkerImpl* self,
                                      DataCollection* collection)
{
	gboolean _tmp0_ = FALSE;
	DataCollection* _tmp1_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (collection != NULL, FALSE);
	_tmp1_ = self->owner;
	if (collection == _tmp1_) {
		GeeHashSet* _tmp2_;
		_tmp2_ = self->marked;
		_tmp0_ = _tmp2_ != NULL;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

static void
data_collection_marker_impl_class_init (DataCollectionMarkerImplClass * klass,
                                        gpointer klass_data)
{
	data_collection_marker_impl_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = data_collection_marker_impl_finalize;
}

static void
data_collection_marker_impl_marker_interface_init (MarkerIface * iface,
                                                   gpointer iface_data)
{
	data_collection_marker_impl_marker_parent_iface = g_type_interface_peek_parent (iface);
	iface->mark = (void (*) (Marker*, DataObject*)) data_collection_marker_impl_real_mark;
	iface->unmark = (void (*) (Marker*, DataObject*)) data_collection_marker_impl_real_unmark;
	iface->toggle = (gboolean (*) (Marker*, DataObject*)) data_collection_marker_impl_real_toggle;
	iface->mark_many = (void (*) (Marker*, GeeCollection*)) data_collection_marker_impl_real_mark_many;
	iface->unmark_many = (void (*) (Marker*, GeeCollection*)) data_collection_marker_impl_real_unmark_many;
	iface->mark_all = (void (*) (Marker*)) data_collection_marker_impl_real_mark_all;
	iface->get_count = (gint (*) (Marker*)) data_collection_marker_impl_real_get_count;
	iface->get_all = (GeeCollection* (*) (Marker*)) data_collection_marker_impl_real_get_all;
}

static void
data_collection_marker_impl_instance_init (DataCollectionMarkerImpl * self,
                                           gpointer klass)
{
	GeeHashSet* _tmp0_;
	_tmp0_ = gee_hash_set_new (TYPE_DATA_OBJECT, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL);
	self->marked = _tmp0_;
	self->freeze_count = 0;
}

static void
data_collection_marker_impl_finalize (GObject * obj)
{
	DataCollectionMarkerImpl * self;
	DataCollection* _tmp0_;
	guint _tmp1_;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, DATA_COLLECTION_TYPE_MARKER_IMPL, DataCollectionMarkerImpl);
	_tmp0_ = self->owner;
	g_signal_parse_name ("items-removed", TYPE_DATA_COLLECTION, &_tmp1_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp0_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, 0, NULL, (GCallback) _data_collection_marker_impl_on_items_removed_data_collection_items_removed, self);
	_data_collection_unref0 (self->owner);
	_g_object_unref0 (self->marked);
	G_OBJECT_CLASS (data_collection_marker_impl_parent_class)->finalize (obj);
}

static GType
data_collection_marker_impl_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (DataCollectionMarkerImplClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) data_collection_marker_impl_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DataCollectionMarkerImpl), 0, (GInstanceInitFunc) data_collection_marker_impl_instance_init, NULL };
	static const GInterfaceInfo marker_info = { (GInterfaceInitFunc) data_collection_marker_impl_marker_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType data_collection_marker_impl_type_id;
	data_collection_marker_impl_type_id = g_type_register_static (G_TYPE_OBJECT, "DataCollectionMarkerImpl", &g_define_type_info, 0);
	g_type_add_interface_static (data_collection_marker_impl_type_id, TYPE_MARKER, &marker_info);
	return data_collection_marker_impl_type_id;
}

static GType
data_collection_marker_impl_get_type (void)
{
	static volatile gsize data_collection_marker_impl_type_id__once = 0;
	if (g_once_init_enter (&data_collection_marker_impl_type_id__once)) {
		GType data_collection_marker_impl_type_id;
		data_collection_marker_impl_type_id = data_collection_marker_impl_get_type_once ();
		g_once_init_leave (&data_collection_marker_impl_type_id__once, data_collection_marker_impl_type_id);
	}
	return data_collection_marker_impl_type_id__once;
}

static void
value_data_collection_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
value_data_collection_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		data_collection_unref (value->data[0].v_pointer);
	}
}

static void
value_data_collection_copy_value (const GValue* src_value,
                                  GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = data_collection_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
value_data_collection_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
value_data_collection_collect_value (GValue* value,
                                     guint n_collect_values,
                                     GTypeCValue* collect_values,
                                     guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		DataCollection * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = data_collection_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
value_data_collection_lcopy_value (const GValue* value,
                                   guint n_collect_values,
                                   GTypeCValue* collect_values,
                                   guint collect_flags)
{
	DataCollection ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = data_collection_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
param_spec_data_collection (const gchar* name,
                            const gchar* nick,
                            const gchar* blurb,
                            GType object_type,
                            GParamFlags flags)
{
	ParamSpecDataCollection* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_DATA_COLLECTION), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
value_get_data_collection (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_DATA_COLLECTION), NULL);
	return value->data[0].v_pointer;
}

void
value_set_data_collection (GValue* value,
                           gpointer v_object)
{
	DataCollection * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_DATA_COLLECTION));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_DATA_COLLECTION));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		data_collection_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		data_collection_unref (old);
	}
}

void
value_take_data_collection (GValue* value,
                            gpointer v_object)
{
	DataCollection * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_DATA_COLLECTION));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_DATA_COLLECTION));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		data_collection_unref (old);
	}
}

static void
data_collection_class_init (DataCollectionClass * klass,
                            gpointer klass_data)
{
	data_collection_parent_class = g_type_class_peek_parent (klass);
	((DataCollectionClass *) klass)->finalize = data_collection_finalize;
	g_type_class_adjust_private_offset (klass, &DataCollection_private_offset);
	((DataCollectionClass *) klass)->to_string = (gchar* (*) (DataCollection*)) data_collection_real_to_string;
	((DataCollectionClass *) klass)->notify_items_added = (void (*) (DataCollection*, GeeIterable*)) data_collection_real_notify_items_added;
	((DataCollectionClass *) klass)->notify_items_removed = (void (*) (DataCollection*, GeeIterable*)) data_collection_real_notify_items_removed;
	((DataCollectionClass *) klass)->notify_contents_altered = (void (*) (DataCollection*, GeeIterable*, GeeIterable*)) data_collection_real_notify_contents_altered;
	((DataCollectionClass *) klass)->notify_items_altered = (void (*) (DataCollection*, GeeMap*)) data_collection_real_notify_items_altered;
	((DataCollectionClass *) klass)->notify_ordering_changed = (void (*) (DataCollection*)) data_collection_real_notify_ordering_changed;
	((DataCollectionClass *) klass)->notify_property_set = (void (*) (DataCollection*, const gchar*, GValue*, GValue*)) data_collection_real_notify_property_set;
	((DataCollectionClass *) klass)->notify_property_cleared = (void (*) (DataCollection*, const gchar*)) data_collection_real_notify_property_cleared;
	((DataCollectionClass *) klass)->valid_type = (gboolean (*) (DataCollection*, DataObject*)) data_collection_real_valid_type;
	((DataCollectionClass *) klass)->set_comparator = (void (*) (DataCollection*, Comparator, gpointer, ComparatorPredicate, gpointer)) data_collection_real_set_comparator;
	((DataCollectionClass *) klass)->reset_comparator = (void (*) (DataCollection*)) data_collection_real_reset_comparator;
	((DataCollectionClass *) klass)->get_all = (GeeCollection* (*) (DataCollection*)) data_collection_real_get_all;
	((DataCollectionClass *) klass)->get_count = (gint (*) (DataCollection*)) data_collection_real_get_count;
	((DataCollectionClass *) klass)->get_at = (DataObject* (*) (DataCollection*, gint)) data_collection_real_get_at;
	((DataCollectionClass *) klass)->index_of = (gint (*) (DataCollection*, DataObject*)) data_collection_real_index_of;
	((DataCollectionClass *) klass)->contains = (gboolean (*) (DataCollection*, DataObject*)) data_collection_real_contains;
	((DataCollectionClass *) klass)->add = (gboolean (*) (DataCollection*, DataObject*)) data_collection_real_add;
	((DataCollectionClass *) klass)->add_many = (GeeCollection* (*) (DataCollection*, GeeCollection*, ProgressMonitor, gpointer)) data_collection_real_add_many;
	((DataCollectionClass *) klass)->remove_marked = (void (*) (DataCollection*, Marker*)) data_collection_real_remove_marked;
	((DataCollectionClass *) klass)->clear = (void (*) (DataCollection*)) data_collection_real_clear;
	((DataCollectionClass *) klass)->close = (void (*) (DataCollection*)) data_collection_real_close;
	((DataCollectionClass *) klass)->notify_frozen = (void (*) (DataCollection*)) data_collection_real_notify_frozen;
	((DataCollectionClass *) klass)->notify_thawed = (void (*) (DataCollection*)) data_collection_real_notify_thawed;
	((DataCollectionClass *) klass)->items_added = data_collection_real_items_added;
	((DataCollectionClass *) klass)->items_removed = data_collection_real_items_removed;
	((DataCollectionClass *) klass)->contents_altered = data_collection_real_contents_altered;
	((DataCollectionClass *) klass)->items_altered = data_collection_real_items_altered;
	((DataCollectionClass *) klass)->ordering_changed = data_collection_real_ordering_changed;
	((DataCollectionClass *) klass)->property_set = data_collection_real_property_set;
	((DataCollectionClass *) klass)->property_cleared = data_collection_real_property_cleared;
	((DataCollectionClass *) klass)->frozen = data_collection_real_frozen;
	((DataCollectionClass *) klass)->thawed = data_collection_real_thawed;
	data_collection_signals[DATA_COLLECTION_ITEMS_ADDED_SIGNAL] = g_signal_new ("items-added", TYPE_DATA_COLLECTION, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (DataCollectionClass, items_added), NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, GEE_TYPE_ITERABLE);
	data_collection_signals[DATA_COLLECTION_ITEMS_REMOVED_SIGNAL] = g_signal_new ("items-removed", TYPE_DATA_COLLECTION, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (DataCollectionClass, items_removed), NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, GEE_TYPE_ITERABLE);
	data_collection_signals[DATA_COLLECTION_CONTENTS_ALTERED_SIGNAL] = g_signal_new ("contents-altered", TYPE_DATA_COLLECTION, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (DataCollectionClass, contents_altered), NULL, NULL, g_cclosure_user_marshal_VOID__OBJECT_OBJECT, G_TYPE_NONE, 2, GEE_TYPE_ITERABLE, GEE_TYPE_ITERABLE);
	data_collection_signals[DATA_COLLECTION_ITEMS_ALTERED_SIGNAL] = g_signal_new ("items-altered", TYPE_DATA_COLLECTION, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (DataCollectionClass, items_altered), NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, GEE_TYPE_MAP);
	data_collection_signals[DATA_COLLECTION_ORDERING_CHANGED_SIGNAL] = g_signal_new ("ordering-changed", TYPE_DATA_COLLECTION, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (DataCollectionClass, ordering_changed), NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	data_collection_signals[DATA_COLLECTION_PROPERTY_SET_SIGNAL] = g_signal_new ("property-set", TYPE_DATA_COLLECTION, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (DataCollectionClass, property_set), NULL, NULL, g_cclosure_user_marshal_VOID__STRING_POINTER_BOXED, G_TYPE_NONE, 3, G_TYPE_STRING, G_TYPE_POINTER, G_TYPE_VALUE);
	data_collection_signals[DATA_COLLECTION_PROPERTY_CLEARED_SIGNAL] = g_signal_new ("property-cleared", TYPE_DATA_COLLECTION, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (DataCollectionClass, property_cleared), NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
	data_collection_signals[DATA_COLLECTION_FROZEN_SIGNAL] = g_signal_new ("frozen", TYPE_DATA_COLLECTION, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (DataCollectionClass, frozen), NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	data_collection_signals[DATA_COLLECTION_THAWED_SIGNAL] = g_signal_new ("thawed", TYPE_DATA_COLLECTION, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (DataCollectionClass, thawed), NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
data_collection_instance_init (DataCollection * self,
                               gpointer klass)
{
	DataSet* _tmp0_;
	GeeHashMap* _tmp1_;
	self->priv = data_collection_get_instance_private (self);
	_tmp0_ = data_set_new ();
	self->priv->dataset = _tmp0_;
	_tmp1_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, G_TYPE_VALUE, (GBoxedCopyFunc) _g_value_dup, (GDestroyNotify) _vala_GValue_free, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	self->priv->properties = _tmp1_;
	self->priv->object_ordinal_generator = (gint64) 0;
	self->priv->notifies_frozen = 0;
	self->priv->frozen_items_altered = NULL;
	self->priv->fire_ordering_changed = FALSE;
	self->ref_count = 1;
}

static void
data_collection_finalize (DataCollection * obj)
{
	DataCollection * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_DATA_COLLECTION, DataCollection);
	g_signal_handlers_destroy (self);
	_g_free0 (self->priv->name);
	_data_set_unref0 (self->priv->dataset);
	_g_object_unref0 (self->priv->properties);
	_g_object_unref0 (self->priv->frozen_items_altered);
}

static GType
data_collection_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { value_data_collection_init, value_data_collection_free_value, value_data_collection_copy_value, value_data_collection_peek_pointer, "p", value_data_collection_collect_value, "p", value_data_collection_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (DataCollectionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) data_collection_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DataCollection), 0, (GInstanceInitFunc) data_collection_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType data_collection_type_id;
	data_collection_type_id = g_type_register_fundamental (g_type_fundamental_next (), "DataCollection", &g_define_type_info, &g_define_type_fundamental_info, 0);
	DataCollection_private_offset = g_type_add_instance_private (data_collection_type_id, sizeof (DataCollectionPrivate));
	return data_collection_type_id;
}

GType
data_collection_get_type (void)
{
	static volatile gsize data_collection_type_id__once = 0;
	if (g_once_init_enter (&data_collection_type_id__once)) {
		GType data_collection_type_id;
		data_collection_type_id = data_collection_get_type_once ();
		g_once_init_leave (&data_collection_type_id__once, data_collection_type_id);
	}
	return data_collection_type_id__once;
}

gpointer
data_collection_ref (gpointer instance)
{
	DataCollection * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
data_collection_unref (gpointer instance)
{
	DataCollection * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		DATA_COLLECTION_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

