{-# LANGUAGE ImplicitParams, RankNTypes, TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- An event controller to receive Drag-and-Drop operations, asynchronously.
-- 
-- It is the more complete but also more complex method of handling drop
-- operations compared to t'GI.Gtk.Objects.DropTarget.DropTarget', and you should only use
-- it if @GtkDropTarget@ doesn\'t provide all the features you need.
-- 
-- To use a @GtkDropTargetAsync@ to receive drops on a widget, you create
-- a @GtkDropTargetAsync@ object, configure which data formats and actions
-- you support, connect to its signals, and then attach it to the widget
-- with 'GI.Gtk.Objects.Widget.widgetAddController'.
-- 
-- During a drag operation, the first signal that a @GtkDropTargetAsync@
-- emits is [DropTargetAsync::accept]("GI.Gtk.Objects.DropTargetAsync#g:signal:accept"), which is meant to determine
-- whether the target is a possible drop site for the ongoing drop. The
-- default handler for the [accept](#g:signal:accept) signal accepts the drop if it finds
-- a compatible data format and an action that is supported on both sides.
-- 
-- If it is, and the widget becomes a target, you will receive a
-- [DropTargetAsync::dragEnter]("GI.Gtk.Objects.DropTargetAsync#g:signal:dragEnter") signal, followed by
-- [DropTargetAsync::dragMotion]("GI.Gtk.Objects.DropTargetAsync#g:signal:dragMotion") signals as the pointer moves,
-- optionally a [DropTargetAsync::drop]("GI.Gtk.Objects.DropTargetAsync#g:signal:drop") signal when a drop happens,
-- and finally a [DropTargetAsync::dragLeave]("GI.Gtk.Objects.DropTargetAsync#g:signal:dragLeave") signal when the
-- pointer moves off the widget.
-- 
-- The [dragEnter](#g:signal:dragEnter) and [dragMotion](#g:signal:dragMotion) handler return a @GdkDragAction@
-- to update the status of the ongoing operation. The [drop](#g:signal:drop) handler
-- should decide if it ultimately accepts the drop and if it does, it
-- should initiate the data transfer and finish the operation by calling
-- 'GI.Gdk.Objects.Drop.dropFinish'.
-- 
-- Between the [dragEnter](#g:signal:dragEnter) and [dragLeave](#g:signal:dragLeave) signals the widget is a
-- current drop target, and will receive the 'GI.Gtk.Flags.StateFlagsDropActive'
-- state, which can be used by themes to style the widget as a drop target.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gtk.Objects.DropTargetAsync
    ( 

-- * Exported types
    DropTargetAsync(..)                     ,
    IsDropTargetAsync                       ,
    toDropTargetAsync                       ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [rejectDrop]("GI.Gtk.Objects.DropTargetAsync#g:method:rejectDrop"), [reset]("GI.Gtk.Objects.EventController#g:method:reset"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getActions]("GI.Gtk.Objects.DropTargetAsync#g:method:getActions"), [getCurrentEvent]("GI.Gtk.Objects.EventController#g:method:getCurrentEvent"), [getCurrentEventDevice]("GI.Gtk.Objects.EventController#g:method:getCurrentEventDevice"), [getCurrentEventState]("GI.Gtk.Objects.EventController#g:method:getCurrentEventState"), [getCurrentEventTime]("GI.Gtk.Objects.EventController#g:method:getCurrentEventTime"), [getData]("GI.GObject.Objects.Object#g:method:getData"), [getFormats]("GI.Gtk.Objects.DropTargetAsync#g:method:getFormats"), [getName]("GI.Gtk.Objects.EventController#g:method:getName"), [getPropagationLimit]("GI.Gtk.Objects.EventController#g:method:getPropagationLimit"), [getPropagationPhase]("GI.Gtk.Objects.EventController#g:method:getPropagationPhase"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata"), [getWidget]("GI.Gtk.Objects.EventController#g:method:getWidget").
-- 
-- ==== Setters
-- [setActions]("GI.Gtk.Objects.DropTargetAsync#g:method:setActions"), [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setFormats]("GI.Gtk.Objects.DropTargetAsync#g:method:setFormats"), [setName]("GI.Gtk.Objects.EventController#g:method:setName"), [setPropagationLimit]("GI.Gtk.Objects.EventController#g:method:setPropagationLimit"), [setPropagationPhase]("GI.Gtk.Objects.EventController#g:method:setPropagationPhase"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty"), [setStaticName]("GI.Gtk.Objects.EventController#g:method:setStaticName").

#if defined(ENABLE_OVERLOADING)
    ResolveDropTargetAsyncMethod            ,
#endif

-- ** getActions #method:getActions#

#if defined(ENABLE_OVERLOADING)
    DropTargetAsyncGetActionsMethodInfo     ,
#endif
    dropTargetAsyncGetActions               ,


-- ** getFormats #method:getFormats#

#if defined(ENABLE_OVERLOADING)
    DropTargetAsyncGetFormatsMethodInfo     ,
#endif
    dropTargetAsyncGetFormats               ,


-- ** new #method:new#

    dropTargetAsyncNew                      ,


-- ** rejectDrop #method:rejectDrop#

#if defined(ENABLE_OVERLOADING)
    DropTargetAsyncRejectDropMethodInfo     ,
#endif
    dropTargetAsyncRejectDrop               ,


-- ** setActions #method:setActions#

#if defined(ENABLE_OVERLOADING)
    DropTargetAsyncSetActionsMethodInfo     ,
#endif
    dropTargetAsyncSetActions               ,


-- ** setFormats #method:setFormats#

#if defined(ENABLE_OVERLOADING)
    DropTargetAsyncSetFormatsMethodInfo     ,
#endif
    dropTargetAsyncSetFormats               ,




 -- * Properties


-- ** actions #attr:actions#
-- | The @GdkDragActions@ that this drop target supports.

#if defined(ENABLE_OVERLOADING)
    DropTargetAsyncActionsPropertyInfo      ,
#endif
    constructDropTargetAsyncActions         ,
#if defined(ENABLE_OVERLOADING)
    dropTargetAsyncActions                  ,
#endif
    getDropTargetAsyncActions               ,
    setDropTargetAsyncActions               ,


-- ** formats #attr:formats#
-- | The @GdkContentFormats@ that determines the supported data formats.

#if defined(ENABLE_OVERLOADING)
    DropTargetAsyncFormatsPropertyInfo      ,
#endif
    clearDropTargetAsyncFormats             ,
    constructDropTargetAsyncFormats         ,
#if defined(ENABLE_OVERLOADING)
    dropTargetAsyncFormats                  ,
#endif
    getDropTargetAsyncFormats               ,
    setDropTargetAsyncFormats               ,




 -- * Signals


-- ** accept #signal:accept#

    DropTargetAsyncAcceptCallback           ,
#if defined(ENABLE_OVERLOADING)
    DropTargetAsyncAcceptSignalInfo         ,
#endif
    afterDropTargetAsyncAccept              ,
    onDropTargetAsyncAccept                 ,


-- ** dragEnter #signal:dragEnter#

    DropTargetAsyncDragEnterCallback        ,
#if defined(ENABLE_OVERLOADING)
    DropTargetAsyncDragEnterSignalInfo      ,
#endif
    afterDropTargetAsyncDragEnter           ,
    onDropTargetAsyncDragEnter              ,


-- ** dragLeave #signal:dragLeave#

    DropTargetAsyncDragLeaveCallback        ,
#if defined(ENABLE_OVERLOADING)
    DropTargetAsyncDragLeaveSignalInfo      ,
#endif
    afterDropTargetAsyncDragLeave           ,
    onDropTargetAsyncDragLeave              ,


-- ** dragMotion #signal:dragMotion#

    DropTargetAsyncDragMotionCallback       ,
#if defined(ENABLE_OVERLOADING)
    DropTargetAsyncDragMotionSignalInfo     ,
#endif
    afterDropTargetAsyncDragMotion          ,
    onDropTargetAsyncDragMotion             ,


-- ** drop #signal:drop#

    DropTargetAsyncDropCallback             ,
#if defined(ENABLE_OVERLOADING)
    DropTargetAsyncDropSignalInfo           ,
#endif
    afterDropTargetAsyncDrop                ,
    onDropTargetAsyncDrop                   ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.Cairo.Structs.Context as Cairo.Context
import qualified GI.Cairo.Structs.FontOptions as Cairo.FontOptions
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GLib.Structs.Bytes as GLib.Bytes
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gdk.Flags as Gdk.Flags
import qualified GI.Gdk.Interfaces.Paintable as Gdk.Paintable
import qualified GI.Gdk.Objects.Clipboard as Gdk.Clipboard
import qualified GI.Gdk.Objects.Cursor as Gdk.Cursor
import qualified GI.Gdk.Objects.Device as Gdk.Device
import qualified GI.Gdk.Objects.Display as Gdk.Display
import qualified GI.Gdk.Objects.Drop as Gdk.Drop
import qualified GI.Gdk.Objects.Event as Gdk.Event
import qualified GI.Gdk.Objects.FrameClock as Gdk.FrameClock
import qualified GI.Gdk.Objects.Snapshot as Gdk.Snapshot
import qualified GI.Gdk.Objects.Surface as Gdk.Surface
import qualified GI.Gdk.Objects.Texture as Gdk.Texture
import qualified GI.Gdk.Structs.ContentFormats as Gdk.ContentFormats
import qualified GI.Gdk.Structs.RGBA as Gdk.RGBA
import qualified GI.Gdk.Structs.Rectangle as Gdk.Rectangle
import qualified GI.Gio.Interfaces.ActionGroup as Gio.ActionGroup
import qualified GI.Gio.Interfaces.Icon as Gio.Icon
import qualified GI.Gio.Interfaces.ListModel as Gio.ListModel
import qualified GI.Graphene.Structs.Matrix as Graphene.Matrix
import qualified GI.Graphene.Structs.Point as Graphene.Point
import qualified GI.Graphene.Structs.Point3D as Graphene.Point3D
import qualified GI.Graphene.Structs.Rect as Graphene.Rect
import qualified GI.Graphene.Structs.Size as Graphene.Size
import qualified GI.Graphene.Structs.Vec3 as Graphene.Vec3
import qualified GI.Graphene.Structs.Vec4 as Graphene.Vec4
import qualified GI.Gsk.Enums as Gsk.Enums
import qualified GI.Gsk.Objects.GLShader as Gsk.GLShader
import qualified GI.Gsk.Objects.RenderNode as Gsk.RenderNode
import qualified GI.Gsk.Objects.Renderer as Gsk.Renderer
import qualified GI.Gsk.Structs.ColorStop as Gsk.ColorStop
import qualified GI.Gsk.Structs.ComponentTransfer as Gsk.ComponentTransfer
import qualified GI.Gsk.Structs.Path as Gsk.Path
import qualified GI.Gsk.Structs.RoundedRect as Gsk.RoundedRect
import qualified GI.Gsk.Structs.Shadow as Gsk.Shadow
import qualified GI.Gsk.Structs.Stroke as Gsk.Stroke
import qualified GI.Gsk.Structs.Transform as Gsk.Transform
import qualified GI.Gtk.Callbacks as Gtk.Callbacks
import {-# SOURCE #-} qualified GI.Gtk.Enums as Gtk.Enums
import {-# SOURCE #-} qualified GI.Gtk.Flags as Gtk.Flags
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Accessible as Gtk.Accessible
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Buildable as Gtk.Buildable
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.ConstraintTarget as Gtk.ConstraintTarget
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Native as Gtk.Native
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Root as Gtk.Root
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.StyleProvider as Gtk.StyleProvider
import {-# SOURCE #-} qualified GI.Gtk.Objects.ATContext as Gtk.ATContext
import {-# SOURCE #-} qualified GI.Gtk.Objects.EventController as Gtk.EventController
import {-# SOURCE #-} qualified GI.Gtk.Objects.LayoutChild as Gtk.LayoutChild
import {-# SOURCE #-} qualified GI.Gtk.Objects.LayoutManager as Gtk.LayoutManager
import {-# SOURCE #-} qualified GI.Gtk.Objects.Settings as Gtk.Settings
import {-# SOURCE #-} qualified GI.Gtk.Objects.Snapshot as Gtk.Snapshot
import {-# SOURCE #-} qualified GI.Gtk.Objects.StyleContext as Gtk.StyleContext
import {-# SOURCE #-} qualified GI.Gtk.Objects.Tooltip as Gtk.Tooltip
import {-# SOURCE #-} qualified GI.Gtk.Objects.Widget as Gtk.Widget
import {-# SOURCE #-} qualified GI.Gtk.Structs.Border as Gtk.Border
import {-# SOURCE #-} qualified GI.Gtk.Structs.Requisition as Gtk.Requisition
import qualified GI.Pango.Enums as Pango.Enums
import qualified GI.Pango.Objects.Context as Pango.Context
import qualified GI.Pango.Objects.FontMap as Pango.FontMap
import qualified GI.Pango.Objects.Layout as Pango.Layout

#else
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gdk.Flags as Gdk.Flags
import qualified GI.Gdk.Objects.Drop as Gdk.Drop
import qualified GI.Gdk.Structs.ContentFormats as Gdk.ContentFormats
import {-# SOURCE #-} qualified GI.Gtk.Objects.EventController as Gtk.EventController

#endif

-- | Memory-managed wrapper type.
newtype DropTargetAsync = DropTargetAsync (SP.ManagedPtr DropTargetAsync)
    deriving (Eq)

instance SP.ManagedPtrNewtype DropTargetAsync where
    toManagedPtr (DropTargetAsync p) = p

foreign import ccall "gtk_drop_target_async_get_type"
    c_gtk_drop_target_async_get_type :: IO B.Types.GType

instance B.Types.TypedObject DropTargetAsync where
    glibType = c_gtk_drop_target_async_get_type

instance B.Types.GObject DropTargetAsync

-- | Type class for types which can be safely cast to t'DropTargetAsync', for instance with `toDropTargetAsync`.
class (SP.GObject o, O.IsDescendantOf DropTargetAsync o) => IsDropTargetAsync o
instance (SP.GObject o, O.IsDescendantOf DropTargetAsync o) => IsDropTargetAsync o

instance O.HasParentTypes DropTargetAsync
type instance O.ParentTypes DropTargetAsync = '[Gtk.EventController.EventController, GObject.Object.Object]

-- | Cast to t'DropTargetAsync', for types for which this is known to be safe. For general casts, use 'Data.GI.Base.ManagedPtr.castTo'.
toDropTargetAsync :: (MIO.MonadIO m, IsDropTargetAsync o) => o -> m DropTargetAsync
toDropTargetAsync = MIO.liftIO . B.ManagedPtr.unsafeCastTo DropTargetAsync

-- | Convert t'DropTargetAsync' to and from t'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe DropTargetAsync) where
    gvalueGType_ = c_gtk_drop_target_async_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr DropTargetAsync)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr DropTargetAsync)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject DropTargetAsync ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolveDropTargetAsyncMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveDropTargetAsyncMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveDropTargetAsyncMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveDropTargetAsyncMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveDropTargetAsyncMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveDropTargetAsyncMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveDropTargetAsyncMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveDropTargetAsyncMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveDropTargetAsyncMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveDropTargetAsyncMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveDropTargetAsyncMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveDropTargetAsyncMethod "rejectDrop" o = DropTargetAsyncRejectDropMethodInfo
    ResolveDropTargetAsyncMethod "reset" o = Gtk.EventController.EventControllerResetMethodInfo
    ResolveDropTargetAsyncMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveDropTargetAsyncMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveDropTargetAsyncMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveDropTargetAsyncMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveDropTargetAsyncMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveDropTargetAsyncMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveDropTargetAsyncMethod "getActions" o = DropTargetAsyncGetActionsMethodInfo
    ResolveDropTargetAsyncMethod "getCurrentEvent" o = Gtk.EventController.EventControllerGetCurrentEventMethodInfo
    ResolveDropTargetAsyncMethod "getCurrentEventDevice" o = Gtk.EventController.EventControllerGetCurrentEventDeviceMethodInfo
    ResolveDropTargetAsyncMethod "getCurrentEventState" o = Gtk.EventController.EventControllerGetCurrentEventStateMethodInfo
    ResolveDropTargetAsyncMethod "getCurrentEventTime" o = Gtk.EventController.EventControllerGetCurrentEventTimeMethodInfo
    ResolveDropTargetAsyncMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveDropTargetAsyncMethod "getFormats" o = DropTargetAsyncGetFormatsMethodInfo
    ResolveDropTargetAsyncMethod "getName" o = Gtk.EventController.EventControllerGetNameMethodInfo
    ResolveDropTargetAsyncMethod "getPropagationLimit" o = Gtk.EventController.EventControllerGetPropagationLimitMethodInfo
    ResolveDropTargetAsyncMethod "getPropagationPhase" o = Gtk.EventController.EventControllerGetPropagationPhaseMethodInfo
    ResolveDropTargetAsyncMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveDropTargetAsyncMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveDropTargetAsyncMethod "getWidget" o = Gtk.EventController.EventControllerGetWidgetMethodInfo
    ResolveDropTargetAsyncMethod "setActions" o = DropTargetAsyncSetActionsMethodInfo
    ResolveDropTargetAsyncMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveDropTargetAsyncMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveDropTargetAsyncMethod "setFormats" o = DropTargetAsyncSetFormatsMethodInfo
    ResolveDropTargetAsyncMethod "setName" o = Gtk.EventController.EventControllerSetNameMethodInfo
    ResolveDropTargetAsyncMethod "setPropagationLimit" o = Gtk.EventController.EventControllerSetPropagationLimitMethodInfo
    ResolveDropTargetAsyncMethod "setPropagationPhase" o = Gtk.EventController.EventControllerSetPropagationPhaseMethodInfo
    ResolveDropTargetAsyncMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveDropTargetAsyncMethod "setStaticName" o = Gtk.EventController.EventControllerSetStaticNameMethodInfo
    ResolveDropTargetAsyncMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveDropTargetAsyncMethod t DropTargetAsync, O.OverloadedMethod info DropTargetAsync p) => OL.IsLabel t (DropTargetAsync -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveDropTargetAsyncMethod t DropTargetAsync, O.OverloadedMethod info DropTargetAsync p, R.HasField t DropTargetAsync p) => R.HasField t DropTargetAsync p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveDropTargetAsyncMethod t DropTargetAsync, O.OverloadedMethodInfo info DropTargetAsync) => OL.IsLabel t (O.MethodProxy info DropTargetAsync) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- signal DropTargetAsync::accept
-- | Emitted on the drop site when a drop operation is about to begin.
-- 
-- If the drop is not accepted, 'P.False' will be returned and the drop target
-- will ignore the drop. If 'P.True' is returned, the drop is accepted for now
-- but may be rejected later via a call to 'GI.Gtk.Objects.DropTargetAsync.dropTargetAsyncRejectDrop'
-- or ultimately by returning 'P.False' from a [DropTargetAsync::drop]("GI.Gtk.Objects.DropTargetAsync#g:signal:drop")
-- handler.
-- 
-- The default handler for this signal decides whether to accept the drop
-- based on the formats provided by the /@drop@/.
-- 
-- If the decision whether the drop will be accepted or rejected needs
-- further processing, such as inspecting the data, this function should
-- return 'P.True' and proceed as is /@drop@/ was accepted and if it decides to
-- reject the drop later, it should call 'GI.Gtk.Objects.DropTargetAsync.dropTargetAsyncRejectDrop'.
type DropTargetAsyncAcceptCallback =
    Gdk.Drop.Drop
    -- ^ /@drop@/: the @GdkDrop@
    -> IO Bool
    -- ^ __Returns:__ 'P.True' if /@drop@/ is accepted

type C_DropTargetAsyncAcceptCallback =
    Ptr DropTargetAsync ->                  -- object
    Ptr Gdk.Drop.Drop ->
    Ptr () ->                               -- user_data
    IO CInt

-- | Generate a function pointer callable from C code, from a `C_DropTargetAsyncAcceptCallback`.
foreign import ccall "wrapper"
    mk_DropTargetAsyncAcceptCallback :: C_DropTargetAsyncAcceptCallback -> IO (FunPtr C_DropTargetAsyncAcceptCallback)

wrap_DropTargetAsyncAcceptCallback :: 
    GObject a => (a -> DropTargetAsyncAcceptCallback) ->
    C_DropTargetAsyncAcceptCallback
wrap_DropTargetAsyncAcceptCallback gi'cb gi'selfPtr drop _ = do
    drop' <- (newObject Gdk.Drop.Drop) drop
    result <- B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self)  drop'
    let result' = (P.fromIntegral . P.fromEnum) result
    return result'


-- | Connect a signal handler for the [accept](#signal:accept) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' dropTargetAsync #accept callback
-- @
-- 
-- 
onDropTargetAsyncAccept :: (IsDropTargetAsync a, MonadIO m) => a -> ((?self :: a) => DropTargetAsyncAcceptCallback) -> m SignalHandlerId
onDropTargetAsyncAccept obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_DropTargetAsyncAcceptCallback wrapped
    wrapped'' <- mk_DropTargetAsyncAcceptCallback wrapped'
    connectSignalFunPtr obj "accept" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [accept](#signal:accept) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' dropTargetAsync #accept callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterDropTargetAsyncAccept :: (IsDropTargetAsync a, MonadIO m) => a -> ((?self :: a) => DropTargetAsyncAcceptCallback) -> m SignalHandlerId
afterDropTargetAsyncAccept obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_DropTargetAsyncAcceptCallback wrapped
    wrapped'' <- mk_DropTargetAsyncAcceptCallback wrapped'
    connectSignalFunPtr obj "accept" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data DropTargetAsyncAcceptSignalInfo
instance SignalInfo DropTargetAsyncAcceptSignalInfo where
    type HaskellCallbackType DropTargetAsyncAcceptSignalInfo = DropTargetAsyncAcceptCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_DropTargetAsyncAcceptCallback cb
        cb'' <- mk_DropTargetAsyncAcceptCallback cb'
        connectSignalFunPtr obj "accept" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.DropTargetAsync::accept"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-DropTargetAsync.html#g:signal:accept"})

#endif

-- signal DropTargetAsync::drag-enter
-- | Emitted on the drop site when the pointer enters the widget.
-- 
-- It can be used to set up custom highlighting.
type DropTargetAsyncDragEnterCallback =
    Gdk.Drop.Drop
    -- ^ /@drop@/: the @GdkDrop@
    -> Double
    -- ^ /@x@/: the x coordinate of the current pointer position
    -> Double
    -- ^ /@y@/: the y coordinate of the current pointer position
    -> IO [Gdk.Flags.DragAction]
    -- ^ __Returns:__ Preferred action for this drag operation.

type C_DropTargetAsyncDragEnterCallback =
    Ptr DropTargetAsync ->                  -- object
    Ptr Gdk.Drop.Drop ->
    CDouble ->
    CDouble ->
    Ptr () ->                               -- user_data
    IO CUInt

-- | Generate a function pointer callable from C code, from a `C_DropTargetAsyncDragEnterCallback`.
foreign import ccall "wrapper"
    mk_DropTargetAsyncDragEnterCallback :: C_DropTargetAsyncDragEnterCallback -> IO (FunPtr C_DropTargetAsyncDragEnterCallback)

wrap_DropTargetAsyncDragEnterCallback :: 
    GObject a => (a -> DropTargetAsyncDragEnterCallback) ->
    C_DropTargetAsyncDragEnterCallback
wrap_DropTargetAsyncDragEnterCallback gi'cb gi'selfPtr drop x y _ = do
    drop' <- (newObject Gdk.Drop.Drop) drop
    let x' = realToFrac x
    let y' = realToFrac y
    result <- B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self)  drop' x' y'
    let result' = gflagsToWord result
    return result'


-- | Connect a signal handler for the [dragEnter](#signal:dragEnter) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' dropTargetAsync #dragEnter callback
-- @
-- 
-- 
onDropTargetAsyncDragEnter :: (IsDropTargetAsync a, MonadIO m) => a -> ((?self :: a) => DropTargetAsyncDragEnterCallback) -> m SignalHandlerId
onDropTargetAsyncDragEnter obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_DropTargetAsyncDragEnterCallback wrapped
    wrapped'' <- mk_DropTargetAsyncDragEnterCallback wrapped'
    connectSignalFunPtr obj "drag-enter" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [dragEnter](#signal:dragEnter) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' dropTargetAsync #dragEnter callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterDropTargetAsyncDragEnter :: (IsDropTargetAsync a, MonadIO m) => a -> ((?self :: a) => DropTargetAsyncDragEnterCallback) -> m SignalHandlerId
afterDropTargetAsyncDragEnter obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_DropTargetAsyncDragEnterCallback wrapped
    wrapped'' <- mk_DropTargetAsyncDragEnterCallback wrapped'
    connectSignalFunPtr obj "drag-enter" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data DropTargetAsyncDragEnterSignalInfo
instance SignalInfo DropTargetAsyncDragEnterSignalInfo where
    type HaskellCallbackType DropTargetAsyncDragEnterSignalInfo = DropTargetAsyncDragEnterCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_DropTargetAsyncDragEnterCallback cb
        cb'' <- mk_DropTargetAsyncDragEnterCallback cb'
        connectSignalFunPtr obj "drag-enter" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.DropTargetAsync::drag-enter"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-DropTargetAsync.html#g:signal:dragEnter"})

#endif

-- signal DropTargetAsync::drag-leave
-- | Emitted on the drop site when the pointer leaves the widget.
-- 
-- Its main purpose it to undo things done in
-- @GtkDropTargetAsync@[dragEnter](#g:signal:dragEnter).
type DropTargetAsyncDragLeaveCallback =
    Gdk.Drop.Drop
    -- ^ /@drop@/: the @GdkDrop@
    -> IO ()

type C_DropTargetAsyncDragLeaveCallback =
    Ptr DropTargetAsync ->                  -- object
    Ptr Gdk.Drop.Drop ->
    Ptr () ->                               -- user_data
    IO ()

-- | Generate a function pointer callable from C code, from a `C_DropTargetAsyncDragLeaveCallback`.
foreign import ccall "wrapper"
    mk_DropTargetAsyncDragLeaveCallback :: C_DropTargetAsyncDragLeaveCallback -> IO (FunPtr C_DropTargetAsyncDragLeaveCallback)

wrap_DropTargetAsyncDragLeaveCallback :: 
    GObject a => (a -> DropTargetAsyncDragLeaveCallback) ->
    C_DropTargetAsyncDragLeaveCallback
wrap_DropTargetAsyncDragLeaveCallback gi'cb gi'selfPtr drop _ = do
    drop' <- (newObject Gdk.Drop.Drop) drop
    B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self)  drop'


-- | Connect a signal handler for the [dragLeave](#signal:dragLeave) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' dropTargetAsync #dragLeave callback
-- @
-- 
-- 
onDropTargetAsyncDragLeave :: (IsDropTargetAsync a, MonadIO m) => a -> ((?self :: a) => DropTargetAsyncDragLeaveCallback) -> m SignalHandlerId
onDropTargetAsyncDragLeave obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_DropTargetAsyncDragLeaveCallback wrapped
    wrapped'' <- mk_DropTargetAsyncDragLeaveCallback wrapped'
    connectSignalFunPtr obj "drag-leave" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [dragLeave](#signal:dragLeave) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' dropTargetAsync #dragLeave callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterDropTargetAsyncDragLeave :: (IsDropTargetAsync a, MonadIO m) => a -> ((?self :: a) => DropTargetAsyncDragLeaveCallback) -> m SignalHandlerId
afterDropTargetAsyncDragLeave obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_DropTargetAsyncDragLeaveCallback wrapped
    wrapped'' <- mk_DropTargetAsyncDragLeaveCallback wrapped'
    connectSignalFunPtr obj "drag-leave" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data DropTargetAsyncDragLeaveSignalInfo
instance SignalInfo DropTargetAsyncDragLeaveSignalInfo where
    type HaskellCallbackType DropTargetAsyncDragLeaveSignalInfo = DropTargetAsyncDragLeaveCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_DropTargetAsyncDragLeaveCallback cb
        cb'' <- mk_DropTargetAsyncDragLeaveCallback cb'
        connectSignalFunPtr obj "drag-leave" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.DropTargetAsync::drag-leave"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-DropTargetAsync.html#g:signal:dragLeave"})

#endif

-- signal DropTargetAsync::drag-motion
-- | Emitted while the pointer is moving over the drop target.
type DropTargetAsyncDragMotionCallback =
    Gdk.Drop.Drop
    -- ^ /@drop@/: the @GdkDrop@
    -> Double
    -- ^ /@x@/: the x coordinate of the current pointer position
    -> Double
    -- ^ /@y@/: the y coordinate of the current pointer position
    -> IO [Gdk.Flags.DragAction]
    -- ^ __Returns:__ Preferred action for this drag operation.

type C_DropTargetAsyncDragMotionCallback =
    Ptr DropTargetAsync ->                  -- object
    Ptr Gdk.Drop.Drop ->
    CDouble ->
    CDouble ->
    Ptr () ->                               -- user_data
    IO CUInt

-- | Generate a function pointer callable from C code, from a `C_DropTargetAsyncDragMotionCallback`.
foreign import ccall "wrapper"
    mk_DropTargetAsyncDragMotionCallback :: C_DropTargetAsyncDragMotionCallback -> IO (FunPtr C_DropTargetAsyncDragMotionCallback)

wrap_DropTargetAsyncDragMotionCallback :: 
    GObject a => (a -> DropTargetAsyncDragMotionCallback) ->
    C_DropTargetAsyncDragMotionCallback
wrap_DropTargetAsyncDragMotionCallback gi'cb gi'selfPtr drop x y _ = do
    drop' <- (newObject Gdk.Drop.Drop) drop
    let x' = realToFrac x
    let y' = realToFrac y
    result <- B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self)  drop' x' y'
    let result' = gflagsToWord result
    return result'


-- | Connect a signal handler for the [dragMotion](#signal:dragMotion) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' dropTargetAsync #dragMotion callback
-- @
-- 
-- 
onDropTargetAsyncDragMotion :: (IsDropTargetAsync a, MonadIO m) => a -> ((?self :: a) => DropTargetAsyncDragMotionCallback) -> m SignalHandlerId
onDropTargetAsyncDragMotion obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_DropTargetAsyncDragMotionCallback wrapped
    wrapped'' <- mk_DropTargetAsyncDragMotionCallback wrapped'
    connectSignalFunPtr obj "drag-motion" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [dragMotion](#signal:dragMotion) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' dropTargetAsync #dragMotion callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterDropTargetAsyncDragMotion :: (IsDropTargetAsync a, MonadIO m) => a -> ((?self :: a) => DropTargetAsyncDragMotionCallback) -> m SignalHandlerId
afterDropTargetAsyncDragMotion obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_DropTargetAsyncDragMotionCallback wrapped
    wrapped'' <- mk_DropTargetAsyncDragMotionCallback wrapped'
    connectSignalFunPtr obj "drag-motion" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data DropTargetAsyncDragMotionSignalInfo
instance SignalInfo DropTargetAsyncDragMotionSignalInfo where
    type HaskellCallbackType DropTargetAsyncDragMotionSignalInfo = DropTargetAsyncDragMotionCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_DropTargetAsyncDragMotionCallback cb
        cb'' <- mk_DropTargetAsyncDragMotionCallback cb'
        connectSignalFunPtr obj "drag-motion" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.DropTargetAsync::drag-motion"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-DropTargetAsync.html#g:signal:dragMotion"})

#endif

-- signal DropTargetAsync::drop
-- | Emitted on the drop site when the user drops the data onto the widget.
-- 
-- The signal handler must determine whether the pointer position is in a
-- drop zone or not. If it is not in a drop zone, it returns 'P.False' and no
-- further processing is necessary.
-- 
-- Otherwise, the handler returns 'P.True'. In this case, this handler will
-- accept the drop. The handler must ensure that 'GI.Gdk.Objects.Drop.dropFinish'
-- is called to let the source know that the drop is done. The call to
-- 'GI.Gdk.Objects.Drop.dropFinish' must only be done when all data has been received.
-- 
-- To receive the data, use one of the read functions provided by
-- t'GI.Gdk.Objects.Drop.Drop' such as 'GI.Gdk.Objects.Drop.dropReadAsync' or
-- 'GI.Gdk.Objects.Drop.dropReadValueAsync'.
type DropTargetAsyncDropCallback =
    Gdk.Drop.Drop
    -- ^ /@drop@/: the @GdkDrop@
    -> Double
    -- ^ /@x@/: the x coordinate of the current pointer position
    -> Double
    -- ^ /@y@/: the y coordinate of the current pointer position
    -> IO Bool
    -- ^ __Returns:__ whether the drop is accepted at the given pointer position

type C_DropTargetAsyncDropCallback =
    Ptr DropTargetAsync ->                  -- object
    Ptr Gdk.Drop.Drop ->
    CDouble ->
    CDouble ->
    Ptr () ->                               -- user_data
    IO CInt

-- | Generate a function pointer callable from C code, from a `C_DropTargetAsyncDropCallback`.
foreign import ccall "wrapper"
    mk_DropTargetAsyncDropCallback :: C_DropTargetAsyncDropCallback -> IO (FunPtr C_DropTargetAsyncDropCallback)

wrap_DropTargetAsyncDropCallback :: 
    GObject a => (a -> DropTargetAsyncDropCallback) ->
    C_DropTargetAsyncDropCallback
wrap_DropTargetAsyncDropCallback gi'cb gi'selfPtr drop x y _ = do
    drop' <- (newObject Gdk.Drop.Drop) drop
    let x' = realToFrac x
    let y' = realToFrac y
    result <- B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self)  drop' x' y'
    let result' = (P.fromIntegral . P.fromEnum) result
    return result'


-- | Connect a signal handler for the [drop](#signal:drop) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' dropTargetAsync #drop callback
-- @
-- 
-- 
onDropTargetAsyncDrop :: (IsDropTargetAsync a, MonadIO m) => a -> ((?self :: a) => DropTargetAsyncDropCallback) -> m SignalHandlerId
onDropTargetAsyncDrop obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_DropTargetAsyncDropCallback wrapped
    wrapped'' <- mk_DropTargetAsyncDropCallback wrapped'
    connectSignalFunPtr obj "drop" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [drop](#signal:drop) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' dropTargetAsync #drop callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterDropTargetAsyncDrop :: (IsDropTargetAsync a, MonadIO m) => a -> ((?self :: a) => DropTargetAsyncDropCallback) -> m SignalHandlerId
afterDropTargetAsyncDrop obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_DropTargetAsyncDropCallback wrapped
    wrapped'' <- mk_DropTargetAsyncDropCallback wrapped'
    connectSignalFunPtr obj "drop" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data DropTargetAsyncDropSignalInfo
instance SignalInfo DropTargetAsyncDropSignalInfo where
    type HaskellCallbackType DropTargetAsyncDropSignalInfo = DropTargetAsyncDropCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_DropTargetAsyncDropCallback cb
        cb'' <- mk_DropTargetAsyncDropCallback cb'
        connectSignalFunPtr obj "drop" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.DropTargetAsync::drop"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-DropTargetAsync.html#g:signal:drop"})

#endif

-- VVV Prop "actions"
   -- Type: TInterface (Name {namespace = "Gdk", name = "DragAction"})
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@actions@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' dropTargetAsync #actions
-- @
getDropTargetAsyncActions :: (MonadIO m, IsDropTargetAsync o) => o -> m [Gdk.Flags.DragAction]
getDropTargetAsyncActions obj = MIO.liftIO $ B.Properties.getObjectPropertyFlags obj "actions"

-- | Set the value of the “@actions@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' dropTargetAsync [ #actions 'Data.GI.Base.Attributes.:=' value ]
-- @
setDropTargetAsyncActions :: (MonadIO m, IsDropTargetAsync o) => o -> [Gdk.Flags.DragAction] -> m ()
setDropTargetAsyncActions obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyFlags obj "actions" val

-- | Construct a t'GValueConstruct' with valid value for the “@actions@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructDropTargetAsyncActions :: (IsDropTargetAsync o, MIO.MonadIO m) => [Gdk.Flags.DragAction] -> m (GValueConstruct o)
constructDropTargetAsyncActions val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyFlags "actions" val

#if defined(ENABLE_OVERLOADING)
data DropTargetAsyncActionsPropertyInfo
instance AttrInfo DropTargetAsyncActionsPropertyInfo where
    type AttrAllowedOps DropTargetAsyncActionsPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrPut]
    type AttrBaseTypeConstraint DropTargetAsyncActionsPropertyInfo = IsDropTargetAsync
    type AttrSetTypeConstraint DropTargetAsyncActionsPropertyInfo = (~) [Gdk.Flags.DragAction]
    type AttrTransferTypeConstraint DropTargetAsyncActionsPropertyInfo = (~) [Gdk.Flags.DragAction]
    type AttrTransferType DropTargetAsyncActionsPropertyInfo = [Gdk.Flags.DragAction]
    type AttrGetType DropTargetAsyncActionsPropertyInfo = [Gdk.Flags.DragAction]
    type AttrLabel DropTargetAsyncActionsPropertyInfo = "actions"
    type AttrOrigin DropTargetAsyncActionsPropertyInfo = DropTargetAsync
    attrGet = getDropTargetAsyncActions
    attrSet = setDropTargetAsyncActions
    attrPut = setDropTargetAsyncActions
    attrTransfer _ v = do
        return v
    attrConstruct = constructDropTargetAsyncActions
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.DropTargetAsync.actions"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-DropTargetAsync.html#g:attr:actions"
        })
#endif

-- VVV Prop "formats"
   -- Type: TInterface (Name {namespace = "Gdk", name = "ContentFormats"})
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Nothing,Just True)

-- | Get the value of the “@formats@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' dropTargetAsync #formats
-- @
getDropTargetAsyncFormats :: (MonadIO m, IsDropTargetAsync o) => o -> m (Maybe Gdk.ContentFormats.ContentFormats)
getDropTargetAsyncFormats obj = MIO.liftIO $ B.Properties.getObjectPropertyBoxed obj "formats" Gdk.ContentFormats.ContentFormats

-- | Set the value of the “@formats@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' dropTargetAsync [ #formats 'Data.GI.Base.Attributes.:=' value ]
-- @
setDropTargetAsyncFormats :: (MonadIO m, IsDropTargetAsync o) => o -> Gdk.ContentFormats.ContentFormats -> m ()
setDropTargetAsyncFormats obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyBoxed obj "formats" (Just val)

-- | Construct a t'GValueConstruct' with valid value for the “@formats@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructDropTargetAsyncFormats :: (IsDropTargetAsync o, MIO.MonadIO m) => Gdk.ContentFormats.ContentFormats -> m (GValueConstruct o)
constructDropTargetAsyncFormats val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyBoxed "formats" (P.Just val)

-- | Set the value of the “@formats@” property to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #formats
-- @
clearDropTargetAsyncFormats :: (MonadIO m, IsDropTargetAsync o) => o -> m ()
clearDropTargetAsyncFormats obj = liftIO $ B.Properties.setObjectPropertyBoxed obj "formats" (Nothing :: Maybe Gdk.ContentFormats.ContentFormats)

#if defined(ENABLE_OVERLOADING)
data DropTargetAsyncFormatsPropertyInfo
instance AttrInfo DropTargetAsyncFormatsPropertyInfo where
    type AttrAllowedOps DropTargetAsyncFormatsPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint DropTargetAsyncFormatsPropertyInfo = IsDropTargetAsync
    type AttrSetTypeConstraint DropTargetAsyncFormatsPropertyInfo = (~) Gdk.ContentFormats.ContentFormats
    type AttrTransferTypeConstraint DropTargetAsyncFormatsPropertyInfo = (~) Gdk.ContentFormats.ContentFormats
    type AttrTransferType DropTargetAsyncFormatsPropertyInfo = Gdk.ContentFormats.ContentFormats
    type AttrGetType DropTargetAsyncFormatsPropertyInfo = (Maybe Gdk.ContentFormats.ContentFormats)
    type AttrLabel DropTargetAsyncFormatsPropertyInfo = "formats"
    type AttrOrigin DropTargetAsyncFormatsPropertyInfo = DropTargetAsync
    attrGet = getDropTargetAsyncFormats
    attrSet = setDropTargetAsyncFormats
    attrPut = undefined
    attrTransfer _ v = do
        return v
    attrConstruct = constructDropTargetAsyncFormats
    attrClear = clearDropTargetAsyncFormats
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.DropTargetAsync.formats"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-DropTargetAsync.html#g:attr:formats"
        })
#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList DropTargetAsync
type instance O.AttributeList DropTargetAsync = DropTargetAsyncAttributeList
type DropTargetAsyncAttributeList = ('[ '("actions", DropTargetAsyncActionsPropertyInfo), '("formats", DropTargetAsyncFormatsPropertyInfo), '("name", Gtk.EventController.EventControllerNamePropertyInfo), '("propagationLimit", Gtk.EventController.EventControllerPropagationLimitPropertyInfo), '("propagationPhase", Gtk.EventController.EventControllerPropagationPhasePropertyInfo), '("widget", Gtk.EventController.EventControllerWidgetPropertyInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
dropTargetAsyncActions :: AttrLabelProxy "actions"
dropTargetAsyncActions = AttrLabelProxy

dropTargetAsyncFormats :: AttrLabelProxy "formats"
dropTargetAsyncFormats = AttrLabelProxy

#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList DropTargetAsync = DropTargetAsyncSignalList
type DropTargetAsyncSignalList = ('[ '("accept", DropTargetAsyncAcceptSignalInfo), '("dragEnter", DropTargetAsyncDragEnterSignalInfo), '("dragLeave", DropTargetAsyncDragLeaveSignalInfo), '("dragMotion", DropTargetAsyncDragMotionSignalInfo), '("drop", DropTargetAsyncDropSignalInfo), '("notify", GObject.Object.ObjectNotifySignalInfo)] :: [(Symbol, DK.Type)])

#endif

-- method DropTargetAsync::new
-- method type : Constructor
-- Args: [ Arg
--           { argCName = "formats"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "ContentFormats" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the supported data formats"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       , Arg
--           { argCName = "actions"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "DragAction" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the supported actions"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Gtk" , name = "DropTargetAsync" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_drop_target_async_new" gtk_drop_target_async_new :: 
    Ptr Gdk.ContentFormats.ContentFormats -> -- formats : TInterface (Name {namespace = "Gdk", name = "ContentFormats"})
    CUInt ->                                -- actions : TInterface (Name {namespace = "Gdk", name = "DragAction"})
    IO (Ptr DropTargetAsync)

-- | Creates a new @GtkDropTargetAsync@ object.
dropTargetAsyncNew ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Maybe (Gdk.ContentFormats.ContentFormats)
    -- ^ /@formats@/: the supported data formats
    -> [Gdk.Flags.DragAction]
    -- ^ /@actions@/: the supported actions
    -> m DropTargetAsync
    -- ^ __Returns:__ the new @GtkDropTargetAsync@
dropTargetAsyncNew formats actions = liftIO $ do
    maybeFormats <- case formats of
        Nothing -> return FP.nullPtr
        Just jFormats -> do
            jFormats' <- B.ManagedPtr.disownBoxed jFormats
            return jFormats'
    let actions' = gflagsToWord actions
    result <- gtk_drop_target_async_new maybeFormats actions'
    checkUnexpectedReturnNULL "dropTargetAsyncNew" result
    result' <- (wrapObject DropTargetAsync) result
    whenJust formats touchManagedPtr
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method DropTargetAsync::get_actions
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "DropTargetAsync" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkDropTargetAsync`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gdk" , name = "DragAction" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_drop_target_async_get_actions" gtk_drop_target_async_get_actions :: 
    Ptr DropTargetAsync ->                  -- self : TInterface (Name {namespace = "Gtk", name = "DropTargetAsync"})
    IO CUInt

-- | Gets the actions that this drop target supports.
dropTargetAsyncGetActions ::
    (B.CallStack.HasCallStack, MonadIO m, IsDropTargetAsync a) =>
    a
    -- ^ /@self@/: a @GtkDropTargetAsync@
    -> m [Gdk.Flags.DragAction]
    -- ^ __Returns:__ the actions that this drop target supports
dropTargetAsyncGetActions self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    result <- gtk_drop_target_async_get_actions self'
    let result' = wordToGFlags result
    touchManagedPtr self
    return result'

#if defined(ENABLE_OVERLOADING)
data DropTargetAsyncGetActionsMethodInfo
instance (signature ~ (m [Gdk.Flags.DragAction]), MonadIO m, IsDropTargetAsync a) => O.OverloadedMethod DropTargetAsyncGetActionsMethodInfo a signature where
    overloadedMethod = dropTargetAsyncGetActions

instance O.OverloadedMethodInfo DropTargetAsyncGetActionsMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.DropTargetAsync.dropTargetAsyncGetActions",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-DropTargetAsync.html#v:dropTargetAsyncGetActions"
        })


#endif

-- method DropTargetAsync::get_formats
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "DropTargetAsync" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkDropTargetAsync`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Gdk" , name = "ContentFormats" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_drop_target_async_get_formats" gtk_drop_target_async_get_formats :: 
    Ptr DropTargetAsync ->                  -- self : TInterface (Name {namespace = "Gtk", name = "DropTargetAsync"})
    IO (Ptr Gdk.ContentFormats.ContentFormats)

-- | Gets the data formats that this drop target accepts.
-- 
-- If the result is 'P.Nothing', all formats are expected to be supported.
dropTargetAsyncGetFormats ::
    (B.CallStack.HasCallStack, MonadIO m, IsDropTargetAsync a) =>
    a
    -- ^ /@self@/: a @GtkDropTargetAsync@
    -> m (Maybe Gdk.ContentFormats.ContentFormats)
    -- ^ __Returns:__ the supported data formats
dropTargetAsyncGetFormats self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    result <- gtk_drop_target_async_get_formats self'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (wrapBoxed Gdk.ContentFormats.ContentFormats) result'
        return result''
    touchManagedPtr self
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data DropTargetAsyncGetFormatsMethodInfo
instance (signature ~ (m (Maybe Gdk.ContentFormats.ContentFormats)), MonadIO m, IsDropTargetAsync a) => O.OverloadedMethod DropTargetAsyncGetFormatsMethodInfo a signature where
    overloadedMethod = dropTargetAsyncGetFormats

instance O.OverloadedMethodInfo DropTargetAsyncGetFormatsMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.DropTargetAsync.dropTargetAsyncGetFormats",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-DropTargetAsync.html#v:dropTargetAsyncGetFormats"
        })


#endif

-- method DropTargetAsync::reject_drop
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "DropTargetAsync" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkDropTargetAsync`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "drop"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Drop" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the `GdkDrop` of an ongoing drag operation"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_drop_target_async_reject_drop" gtk_drop_target_async_reject_drop :: 
    Ptr DropTargetAsync ->                  -- self : TInterface (Name {namespace = "Gtk", name = "DropTargetAsync"})
    Ptr Gdk.Drop.Drop ->                    -- drop : TInterface (Name {namespace = "Gdk", name = "Drop"})
    IO ()

-- | Sets the /@drop@/ as not accepted on this drag site.
-- 
-- This function should be used when delaying the decision
-- on whether to accept a drag or not until after reading
-- the data.
dropTargetAsyncRejectDrop ::
    (B.CallStack.HasCallStack, MonadIO m, IsDropTargetAsync a, Gdk.Drop.IsDrop b) =>
    a
    -- ^ /@self@/: a @GtkDropTargetAsync@
    -> b
    -- ^ /@drop@/: the @GdkDrop@ of an ongoing drag operation
    -> m ()
dropTargetAsyncRejectDrop self drop = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    drop' <- unsafeManagedPtrCastPtr drop
    gtk_drop_target_async_reject_drop self' drop'
    touchManagedPtr self
    touchManagedPtr drop
    return ()

#if defined(ENABLE_OVERLOADING)
data DropTargetAsyncRejectDropMethodInfo
instance (signature ~ (b -> m ()), MonadIO m, IsDropTargetAsync a, Gdk.Drop.IsDrop b) => O.OverloadedMethod DropTargetAsyncRejectDropMethodInfo a signature where
    overloadedMethod = dropTargetAsyncRejectDrop

instance O.OverloadedMethodInfo DropTargetAsyncRejectDropMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.DropTargetAsync.dropTargetAsyncRejectDrop",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-DropTargetAsync.html#v:dropTargetAsyncRejectDrop"
        })


#endif

-- method DropTargetAsync::set_actions
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "DropTargetAsync" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkDropTargetAsync`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "actions"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "DragAction" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the supported actions"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_drop_target_async_set_actions" gtk_drop_target_async_set_actions :: 
    Ptr DropTargetAsync ->                  -- self : TInterface (Name {namespace = "Gtk", name = "DropTargetAsync"})
    CUInt ->                                -- actions : TInterface (Name {namespace = "Gdk", name = "DragAction"})
    IO ()

-- | Sets the actions that this drop target supports.
dropTargetAsyncSetActions ::
    (B.CallStack.HasCallStack, MonadIO m, IsDropTargetAsync a) =>
    a
    -- ^ /@self@/: a @GtkDropTargetAsync@
    -> [Gdk.Flags.DragAction]
    -- ^ /@actions@/: the supported actions
    -> m ()
dropTargetAsyncSetActions self actions = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    let actions' = gflagsToWord actions
    gtk_drop_target_async_set_actions self' actions'
    touchManagedPtr self
    return ()

#if defined(ENABLE_OVERLOADING)
data DropTargetAsyncSetActionsMethodInfo
instance (signature ~ ([Gdk.Flags.DragAction] -> m ()), MonadIO m, IsDropTargetAsync a) => O.OverloadedMethod DropTargetAsyncSetActionsMethodInfo a signature where
    overloadedMethod = dropTargetAsyncSetActions

instance O.OverloadedMethodInfo DropTargetAsyncSetActionsMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.DropTargetAsync.dropTargetAsyncSetActions",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-DropTargetAsync.html#v:dropTargetAsyncSetActions"
        })


#endif

-- method DropTargetAsync::set_formats
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "DropTargetAsync" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkDropTargetAsync`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "formats"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "ContentFormats" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "the supported data formats or %NULL for any format"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_drop_target_async_set_formats" gtk_drop_target_async_set_formats :: 
    Ptr DropTargetAsync ->                  -- self : TInterface (Name {namespace = "Gtk", name = "DropTargetAsync"})
    Ptr Gdk.ContentFormats.ContentFormats -> -- formats : TInterface (Name {namespace = "Gdk", name = "ContentFormats"})
    IO ()

-- | Sets the data formats that this drop target will accept.
dropTargetAsyncSetFormats ::
    (B.CallStack.HasCallStack, MonadIO m, IsDropTargetAsync a) =>
    a
    -- ^ /@self@/: a @GtkDropTargetAsync@
    -> Maybe (Gdk.ContentFormats.ContentFormats)
    -- ^ /@formats@/: the supported data formats or 'P.Nothing' for any format
    -> m ()
dropTargetAsyncSetFormats self formats = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    maybeFormats <- case formats of
        Nothing -> return FP.nullPtr
        Just jFormats -> do
            jFormats' <- unsafeManagedPtrGetPtr jFormats
            return jFormats'
    gtk_drop_target_async_set_formats self' maybeFormats
    touchManagedPtr self
    whenJust formats touchManagedPtr
    return ()

#if defined(ENABLE_OVERLOADING)
data DropTargetAsyncSetFormatsMethodInfo
instance (signature ~ (Maybe (Gdk.ContentFormats.ContentFormats) -> m ()), MonadIO m, IsDropTargetAsync a) => O.OverloadedMethod DropTargetAsyncSetFormatsMethodInfo a signature where
    overloadedMethod = dropTargetAsyncSetFormats

instance O.OverloadedMethodInfo DropTargetAsyncSetFormatsMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.DropTargetAsync.dropTargetAsyncSetFormats",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-DropTargetAsync.html#v:dropTargetAsyncSetFormats"
        })


#endif


