{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- Represents the platform-specific draw context.
-- 
-- @GdkCairoContext@s are created for a surface using
-- 'GI.Gdk.Objects.Surface.surfaceCreateCairoContext', and the context
-- can then be used to draw on that surface.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gdk.Objects.CairoContext
    ( 

-- * Exported types
    CairoContext(..)                        ,
    IsCairoContext                          ,
    toCairoContext                          ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [beginFrame]("GI.Gdk.Objects.DrawContext#g:method:beginFrame"), [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [cairoCreate]("GI.Gdk.Objects.CairoContext#g:method:cairoCreate"), [endFrame]("GI.Gdk.Objects.DrawContext#g:method:endFrame"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [isInFrame]("GI.Gdk.Objects.DrawContext#g:method:isInFrame"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getData]("GI.GObject.Objects.Object#g:method:getData"), [getDisplay]("GI.Gdk.Objects.DrawContext#g:method:getDisplay"), [getFrameRegion]("GI.Gdk.Objects.DrawContext#g:method:getFrameRegion"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata"), [getSurface]("GI.Gdk.Objects.DrawContext#g:method:getSurface").
-- 
-- ==== Setters
-- [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty").

#if defined(ENABLE_OVERLOADING)
    ResolveCairoContextMethod               ,
#endif

-- ** cairoCreate #method:cairoCreate#

#if defined(ENABLE_OVERLOADING)
    CairoContextCairoCreateMethodInfo       ,
#endif
    cairoContextCairoCreate                 ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.Cairo.Enums as Cairo.Enums
import qualified GI.Cairo.Structs.Context as Cairo.Context
import qualified GI.Cairo.Structs.Region as Cairo.Region
import qualified GI.Cairo.Structs.Surface as Cairo.Surface
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GLib.Structs.Bytes as GLib.Bytes
import qualified GI.GLib.Structs.String as GLib.String
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gdk.Callbacks as Gdk.Callbacks
import {-# SOURCE #-} qualified GI.Gdk.Enums as Gdk.Enums
import {-# SOURCE #-} qualified GI.Gdk.Flags as Gdk.Flags
import {-# SOURCE #-} qualified GI.Gdk.Interfaces.Paintable as Gdk.Paintable
import {-# SOURCE #-} qualified GI.Gdk.Objects.AppLaunchContext as Gdk.AppLaunchContext
import {-# SOURCE #-} qualified GI.Gdk.Objects.CicpParams as Gdk.CicpParams
import {-# SOURCE #-} qualified GI.Gdk.Objects.Clipboard as Gdk.Clipboard
import {-# SOURCE #-} qualified GI.Gdk.Objects.ContentProvider as Gdk.ContentProvider
import {-# SOURCE #-} qualified GI.Gdk.Objects.Cursor as Gdk.Cursor
import {-# SOURCE #-} qualified GI.Gdk.Objects.Device as Gdk.Device
import {-# SOURCE #-} qualified GI.Gdk.Objects.DeviceTool as Gdk.DeviceTool
import {-# SOURCE #-} qualified GI.Gdk.Objects.Display as Gdk.Display
import {-# SOURCE #-} qualified GI.Gdk.Objects.DrawContext as Gdk.DrawContext
import {-# SOURCE #-} qualified GI.Gdk.Objects.Event as Gdk.Event
import {-# SOURCE #-} qualified GI.Gdk.Objects.FrameClock as Gdk.FrameClock
import {-# SOURCE #-} qualified GI.Gdk.Objects.GLContext as Gdk.GLContext
import {-# SOURCE #-} qualified GI.Gdk.Objects.Monitor as Gdk.Monitor
import {-# SOURCE #-} qualified GI.Gdk.Objects.Seat as Gdk.Seat
import {-# SOURCE #-} qualified GI.Gdk.Objects.Snapshot as Gdk.Snapshot
import {-# SOURCE #-} qualified GI.Gdk.Objects.Surface as Gdk.Surface
import {-# SOURCE #-} qualified GI.Gdk.Objects.Texture as Gdk.Texture
import {-# SOURCE #-} qualified GI.Gdk.Objects.VulkanContext as Gdk.VulkanContext
import {-# SOURCE #-} qualified GI.Gdk.Structs.ColorState as Gdk.ColorState
import {-# SOURCE #-} qualified GI.Gdk.Structs.ContentFormats as Gdk.ContentFormats
import {-# SOURCE #-} qualified GI.Gdk.Structs.DmabufFormats as Gdk.DmabufFormats
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventSequence as Gdk.EventSequence
import {-# SOURCE #-} qualified GI.Gdk.Structs.FrameTimings as Gdk.FrameTimings
import {-# SOURCE #-} qualified GI.Gdk.Structs.KeymapKey as Gdk.KeymapKey
import {-# SOURCE #-} qualified GI.Gdk.Structs.Rectangle as Gdk.Rectangle
import {-# SOURCE #-} qualified GI.Gdk.Structs.TimeCoord as Gdk.TimeCoord
import qualified GI.GdkPixbuf.Objects.Pixbuf as GdkPixbuf.Pixbuf
import qualified GI.Gio.Callbacks as Gio.Callbacks
import qualified GI.Gio.Interfaces.AsyncResult as Gio.AsyncResult
import qualified GI.Gio.Interfaces.File as Gio.File
import qualified GI.Gio.Interfaces.Icon as Gio.Icon
import qualified GI.Gio.Interfaces.ListModel as Gio.ListModel
import qualified GI.Gio.Interfaces.LoadableIcon as Gio.LoadableIcon
import qualified GI.Gio.Objects.AppLaunchContext as Gio.AppLaunchContext
import qualified GI.Gio.Objects.Cancellable as Gio.Cancellable
import qualified GI.Gio.Objects.InputStream as Gio.InputStream
import qualified GI.Gio.Objects.OutputStream as Gio.OutputStream
import qualified GI.Pango.Enums as Pango.Enums

#else
import qualified GI.Cairo.Structs.Context as Cairo.Context
import qualified GI.GObject.Objects.Object as GObject.Object
import {-# SOURCE #-} qualified GI.Gdk.Objects.DrawContext as Gdk.DrawContext

#endif

-- | Memory-managed wrapper type.
newtype CairoContext = CairoContext (SP.ManagedPtr CairoContext)
    deriving (Eq)

instance SP.ManagedPtrNewtype CairoContext where
    toManagedPtr (CairoContext p) = p

foreign import ccall "gdk_cairo_context_get_type"
    c_gdk_cairo_context_get_type :: IO B.Types.GType

instance B.Types.TypedObject CairoContext where
    glibType = c_gdk_cairo_context_get_type

instance B.Types.GObject CairoContext

-- | Type class for types which can be safely cast to t'CairoContext', for instance with `toCairoContext`.
class (SP.GObject o, O.IsDescendantOf CairoContext o) => IsCairoContext o
instance (SP.GObject o, O.IsDescendantOf CairoContext o) => IsCairoContext o

instance O.HasParentTypes CairoContext
type instance O.ParentTypes CairoContext = '[Gdk.DrawContext.DrawContext, GObject.Object.Object]

-- | Cast to t'CairoContext', for types for which this is known to be safe. For general casts, use 'Data.GI.Base.ManagedPtr.castTo'.
toCairoContext :: (MIO.MonadIO m, IsCairoContext o) => o -> m CairoContext
toCairoContext = MIO.liftIO . B.ManagedPtr.unsafeCastTo CairoContext

-- | Convert t'CairoContext' to and from t'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe CairoContext) where
    gvalueGType_ = c_gdk_cairo_context_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr CairoContext)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr CairoContext)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject CairoContext ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolveCairoContextMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveCairoContextMethod "beginFrame" o = Gdk.DrawContext.DrawContextBeginFrameMethodInfo
    ResolveCairoContextMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveCairoContextMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveCairoContextMethod "cairoCreate" o = CairoContextCairoCreateMethodInfo
    ResolveCairoContextMethod "endFrame" o = Gdk.DrawContext.DrawContextEndFrameMethodInfo
    ResolveCairoContextMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveCairoContextMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveCairoContextMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveCairoContextMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveCairoContextMethod "isInFrame" o = Gdk.DrawContext.DrawContextIsInFrameMethodInfo
    ResolveCairoContextMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveCairoContextMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveCairoContextMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveCairoContextMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveCairoContextMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveCairoContextMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveCairoContextMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveCairoContextMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveCairoContextMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveCairoContextMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveCairoContextMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveCairoContextMethod "getDisplay" o = Gdk.DrawContext.DrawContextGetDisplayMethodInfo
    ResolveCairoContextMethod "getFrameRegion" o = Gdk.DrawContext.DrawContextGetFrameRegionMethodInfo
    ResolveCairoContextMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveCairoContextMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveCairoContextMethod "getSurface" o = Gdk.DrawContext.DrawContextGetSurfaceMethodInfo
    ResolveCairoContextMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveCairoContextMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveCairoContextMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveCairoContextMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveCairoContextMethod t CairoContext, O.OverloadedMethod info CairoContext p) => OL.IsLabel t (CairoContext -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveCairoContextMethod t CairoContext, O.OverloadedMethod info CairoContext p, R.HasField t CairoContext p) => R.HasField t CairoContext p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveCairoContextMethod t CairoContext, O.OverloadedMethodInfo info CairoContext) => OL.IsLabel t (O.MethodProxy info CairoContext) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList CairoContext
type instance O.AttributeList CairoContext = CairoContextAttributeList
type CairoContextAttributeList = ('[ '("display", Gdk.DrawContext.DrawContextDisplayPropertyInfo), '("surface", Gdk.DrawContext.DrawContextSurfacePropertyInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList CairoContext = CairoContextSignalList
type CairoContextSignalList = ('[ '("notify", GObject.Object.ObjectNotifySignalInfo)] :: [(Symbol, DK.Type)])

#endif

-- method CairoContext::cairo_create
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "CairoContext" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GdkCairoContext` that is currently drawing"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "cairo" , name = "Context" })
-- throws : False
-- Skip return : False

foreign import ccall "gdk_cairo_context_cairo_create" gdk_cairo_context_cairo_create :: 
    Ptr CairoContext ->                     -- self : TInterface (Name {namespace = "Gdk", name = "CairoContext"})
    IO (Ptr Cairo.Context.Context)

{-# DEPRECATED cairoContextCairoCreate ["(Since version 4.18)","Drawing content with Cairo should be done via","  Cairo rendernodes, not by using renderers."] #-}
-- | Retrieves a Cairo context to be used to draw on the @GdkSurface@
-- of /@context@/.
-- 
-- A call to 'GI.Gdk.Objects.DrawContext.drawContextBeginFrame' with this
-- /@context@/ must have been done or this function will return 'P.Nothing'.
-- 
-- The returned context is guaranteed to be valid until
-- 'GI.Gdk.Objects.DrawContext.drawContextEndFrame' is called.
cairoContextCairoCreate ::
    (B.CallStack.HasCallStack, MonadIO m, IsCairoContext a) =>
    a
    -- ^ /@self@/: a @GdkCairoContext@ that is currently drawing
    -> m (Maybe Cairo.Context.Context)
    -- ^ __Returns:__ a Cairo context
    --   to draw on \`GdkSurface
cairoContextCairoCreate self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    result <- gdk_cairo_context_cairo_create self'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (wrapBoxed Cairo.Context.Context) result'
        return result''
    touchManagedPtr self
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data CairoContextCairoCreateMethodInfo
instance (signature ~ (m (Maybe Cairo.Context.Context)), MonadIO m, IsCairoContext a) => O.OverloadedMethod CairoContextCairoCreateMethodInfo a signature where
    overloadedMethod = cairoContextCairoCreate

instance O.OverloadedMethodInfo CairoContextCairoCreateMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.CairoContext.cairoContextCairoCreate",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Objects-CairoContext.html#v:cairoContextCairoCreate"
        })


#endif


