{-# LANGUAGE PatternSynonyms, ScopedTypeVariables, ViewPatterns #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Dbusmenu.Constants
    ( 
    pattern SERVER_SIGNAL_LAYOUT_UPDATED    ,
    pattern SERVER_SIGNAL_ITEM_ACTIVATION   ,
    pattern SERVER_SIGNAL_ID_UPDATE         ,
    pattern SERVER_SIGNAL_ID_PROP_UPDATE    ,
    pattern SERVER_PROP_VERSION             ,
    pattern SERVER_PROP_TEXT_DIRECTION      ,
    pattern SERVER_PROP_STATUS              ,
    pattern SERVER_PROP_ROOT_NODE           ,
    pattern SERVER_PROP_DBUS_OBJECT         ,
    pattern MENUITEM_TOGGLE_STATE_UNKNOWN   ,
    pattern MENUITEM_TOGGLE_STATE_UNCHECKED ,
    pattern MENUITEM_TOGGLE_STATE_CHECKED   ,
    pattern MENUITEM_TOGGLE_RADIO           ,
    pattern MENUITEM_TOGGLE_CHECK           ,
    pattern MENUITEM_SIGNAL_SHOW_TO_USER    ,
    pattern MENUITEM_SIGNAL_REALIZED        ,
    pattern MENUITEM_SIGNAL_PROPERTY_CHANGED,
    pattern MENUITEM_SIGNAL_ITEM_ACTIVATED  ,
    pattern MENUITEM_SIGNAL_EVENT           ,
    pattern MENUITEM_SIGNAL_CHILD_REMOVED   ,
    pattern MENUITEM_SIGNAL_CHILD_MOVED     ,
    pattern MENUITEM_SIGNAL_CHILD_ADDED     ,
    pattern MENUITEM_SIGNAL_ABOUT_TO_SHOW   ,
    pattern MENUITEM_SHORTCUT_SUPER         ,
    pattern MENUITEM_SHORTCUT_SHIFT         ,
    pattern MENUITEM_SHORTCUT_CONTROL       ,
    pattern MENUITEM_SHORTCUT_ALT           ,
    pattern MENUITEM_PROP_VISIBLE           ,
    pattern MENUITEM_PROP_TYPE              ,
    pattern MENUITEM_PROP_TOGGLE_TYPE       ,
    pattern MENUITEM_PROP_TOGGLE_STATE      ,
    pattern MENUITEM_PROP_SHORTCUT          ,
    pattern MENUITEM_PROP_LABEL             ,
    pattern MENUITEM_PROP_ICON_NAME         ,
    pattern MENUITEM_PROP_ICON_DATA         ,
    pattern MENUITEM_PROP_ENABLED           ,
    pattern MENUITEM_PROP_DISPOSITION       ,
    pattern MENUITEM_PROP_CHILD_DISPLAY     ,
    pattern MENUITEM_PROP_ACCESSIBLE_DESC   ,
    pattern MENUITEM_ICON_NAME_BLANK        ,
    pattern MENUITEM_EVENT_OPENED           ,
    pattern MENUITEM_EVENT_CLOSED           ,
    pattern MENUITEM_EVENT_ACTIVATED        ,
    pattern MENUITEM_DISPOSITION_WARNING    ,
    pattern MENUITEM_DISPOSITION_NORMAL     ,
    pattern MENUITEM_DISPOSITION_INFORMATIVE,
    pattern MENUITEM_DISPOSITION_ALERT      ,
    pattern MENUITEM_CHILD_DISPLAY_SUBMENU  ,
    pattern CLIENT_TYPES_SEPARATOR          ,
    pattern CLIENT_TYPES_IMAGE              ,
    pattern CLIENT_TYPES_DEFAULT            ,
    pattern CLIENT_SIGNAL_ROOT_CHANGED      ,
    pattern CLIENT_SIGNAL_NEW_MENUITEM      ,
    pattern CLIENT_SIGNAL_LAYOUT_UPDATED    ,
    pattern CLIENT_SIGNAL_ITEM_ACTIVATE     ,
    pattern CLIENT_SIGNAL_ICON_THEME_DIRS_CHANGED,
    pattern CLIENT_SIGNAL_EVENT_RESULT      ,
    pattern CLIENT_PROP_TEXT_DIRECTION      ,
    pattern CLIENT_PROP_STATUS              ,
    pattern CLIENT_PROP_GROUP_EVENTS        ,
    pattern CLIENT_PROP_DBUS_OBJECT         ,
    pattern CLIENT_PROP_DBUS_NAME           ,

    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)

#else

#endif

-- | String to attach to signal [Server::layoutUpdated]("GI.Dbusmenu.Objects.Server#g:signal:layoutUpdated")
pattern SERVER_SIGNAL_LAYOUT_UPDATED = "layout-updated" :: T.Text

-- | String to attach to signal [Server::itemActivationRequested]("GI.Dbusmenu.Objects.Server#g:signal:itemActivationRequested")
pattern SERVER_SIGNAL_ITEM_ACTIVATION = "item-activation-requested" :: T.Text

-- | String to attach to signal [Server::itemUpdated]("GI.Dbusmenu.Objects.Server#g:signal:itemUpdated")
pattern SERVER_SIGNAL_ID_UPDATE = "item-updated" :: T.Text

-- | String to attach to signal [Server::itemPropertyUpdated]("GI.Dbusmenu.Objects.Server#g:signal:itemPropertyUpdated")
pattern SERVER_SIGNAL_ID_PROP_UPDATE = "item-property-updated" :: T.Text

-- | String to access property [Server:version]("GI.Dbusmenu.Objects.Server#g:attr:version")
pattern SERVER_PROP_VERSION = "version" :: T.Text

-- | String to access property t'GI.Dbusmenu.Objects.Server.Server':@/text-direction/@
pattern SERVER_PROP_TEXT_DIRECTION = "text-direction" :: T.Text

-- | String to access property t'GI.Dbusmenu.Objects.Server.Server':@/status/@
pattern SERVER_PROP_STATUS = "status" :: T.Text

-- | String to access property [Server:rootNode]("GI.Dbusmenu.Objects.Server#g:attr:rootNode")
pattern SERVER_PROP_ROOT_NODE = "root-node" :: T.Text

-- | String to access property [Server:dbusObject]("GI.Dbusmenu.Objects.Server#g:attr:dbusObject")
pattern SERVER_PROP_DBUS_OBJECT = "dbus-object" :: T.Text

-- | Used to set 'GI.Dbusmenu.Constants.MENUITEM_PROP_TOGGLE_STATE' so that the menu\'s
-- toggle item is undecided.
pattern MENUITEM_TOGGLE_STATE_UNKNOWN = -1 :: Int32

-- | Used to set 'GI.Dbusmenu.Constants.MENUITEM_PROP_TOGGLE_STATE' so that the menu\'s
-- toggle item is empty.
pattern MENUITEM_TOGGLE_STATE_UNCHECKED = 0 :: Int32

-- | Used to set 'GI.Dbusmenu.Constants.MENUITEM_PROP_TOGGLE_STATE' so that the menu\'s
-- toggle item is filled.
pattern MENUITEM_TOGGLE_STATE_CHECKED = 1 :: Int32

-- | Used to set 'GI.Dbusmenu.Constants.MENUITEM_PROP_TOGGLE_TYPE' to be a standard
-- radio item.
pattern MENUITEM_TOGGLE_RADIO = "radio" :: T.Text

-- | Used to set 'GI.Dbusmenu.Constants.MENUITEM_PROP_TOGGLE_TYPE' to be a standard
-- check mark item.
pattern MENUITEM_TOGGLE_CHECK = "checkmark" :: T.Text

-- | String to attach to signal t'GI.Dbusmenu.Objects.Server.Server'::@/show-to-user/@
pattern MENUITEM_SIGNAL_SHOW_TO_USER = "show-to-user" :: T.Text

-- | String to attach to signal t'GI.Dbusmenu.Objects.Server.Server'::@/realized/@
pattern MENUITEM_SIGNAL_REALIZED = "realized" :: T.Text

-- | String to attach to signal t'GI.Dbusmenu.Objects.Server.Server'::@/property-changed/@
pattern MENUITEM_SIGNAL_PROPERTY_CHANGED = "property-changed" :: T.Text

-- | String to attach to signal t'GI.Dbusmenu.Objects.Server.Server'::@/item-activated/@
pattern MENUITEM_SIGNAL_ITEM_ACTIVATED = "item-activated" :: T.Text

-- | String to attach to signal t'GI.Dbusmenu.Objects.Server.Server'::@/event/@
pattern MENUITEM_SIGNAL_EVENT = "event" :: T.Text

-- | String to attach to signal t'GI.Dbusmenu.Objects.Server.Server'::@/child-removed/@
pattern MENUITEM_SIGNAL_CHILD_REMOVED = "child-removed" :: T.Text

-- | String to attach to signal t'GI.Dbusmenu.Objects.Server.Server'::@/child-moved/@
pattern MENUITEM_SIGNAL_CHILD_MOVED = "child-moved" :: T.Text

-- | String to attach to signal t'GI.Dbusmenu.Objects.Server.Server'::@/child-added/@
pattern MENUITEM_SIGNAL_CHILD_ADDED = "child-added" :: T.Text

-- | String to attach to signal t'GI.Dbusmenu.Objects.Server.Server'::@/about-to-show/@
pattern MENUITEM_SIGNAL_ABOUT_TO_SHOW = "about-to-show" :: T.Text

-- | Used in 'GI.Dbusmenu.Constants.MENUITEM_PROP_SHORTCUT' to represent the
-- super key.
pattern MENUITEM_SHORTCUT_SUPER = "Super" :: T.Text

-- | Used in 'GI.Dbusmenu.Constants.MENUITEM_PROP_SHORTCUT' to represent the
-- shift key.
pattern MENUITEM_SHORTCUT_SHIFT = "Shift" :: T.Text

-- | Used in 'GI.Dbusmenu.Constants.MENUITEM_PROP_SHORTCUT' to represent the
-- control key.
pattern MENUITEM_SHORTCUT_CONTROL = "Control" :: T.Text

-- | Used in 'GI.Dbusmenu.Constants.MENUITEM_PROP_SHORTCUT' to represent the
-- alternate key.
pattern MENUITEM_SHORTCUT_ALT = "Alt" :: T.Text

-- | t'GI.Dbusmenu.Objects.Menuitem.Menuitem' property used to represent whether the menuitem
-- should be shown or not.  Type: @/G_VARIANT_TYPE_BOOLEAN/@.
pattern MENUITEM_PROP_VISIBLE = "visible" :: T.Text

-- | t'GI.Dbusmenu.Objects.Menuitem.Menuitem' property used to represent what type of menuitem
-- this object represents.  Type: @/G_VARIANT_TYPE_STRING/@.
pattern MENUITEM_PROP_TYPE = "type" :: T.Text

-- | t'GI.Dbusmenu.Objects.Menuitem.Menuitem' property that says what type of toggle entry should
-- be shown in the menu.  Should be either 'GI.Dbusmenu.Constants.MENUITEM_TOGGLE_CHECK'
-- or 'GI.Dbusmenu.Constants.MENUITEM_TOGGLE_RADIO'.  Type: @/G_VARIANT_TYPE_STRING/@
pattern MENUITEM_PROP_TOGGLE_TYPE = "toggle-type" :: T.Text

-- | t'GI.Dbusmenu.Objects.Menuitem.Menuitem' property that says what state a toggle entry should
-- be shown as the menu.  Should be either 'GI.Dbusmenu.Constants.MENUITEM_TOGGLE_STATE_UNCHECKED'
-- 'GI.Dbusmenu.Constants.MENUITEM_TOGGLE_STATE_CHECKED' or @/DBUSMENU_MENUITEM_TOGGLE_STATUE_UNKNOWN/@.
pattern MENUITEM_PROP_TOGGLE_STATE = "toggle-state" :: T.Text

-- | t'GI.Dbusmenu.Objects.Menuitem.Menuitem' property that is the entries that represent a shortcut
-- to activate the menuitem.  It is an array of arrays of strings.
-- 
-- It is recommended that this is not set directly but instead the
-- libdbusmenu-gtk library is used with the function @/dbusmenu_menuitem_property_set_shortcut()/@
pattern MENUITEM_PROP_SHORTCUT = "shortcut" :: T.Text

-- | t'GI.Dbusmenu.Objects.Menuitem.Menuitem' property used for the text on the menu item.
pattern MENUITEM_PROP_LABEL = "label" :: T.Text

-- | t'GI.Dbusmenu.Objects.Menuitem.Menuitem' property that is the name of the icon under the
-- Freedesktop.org icon naming spec.  Type: @/G_VARIANT_TYPE_STRING/@
pattern MENUITEM_PROP_ICON_NAME = "icon-name" :: T.Text

-- | t'GI.Dbusmenu.Objects.Menuitem.Menuitem' property that is the raw data of a custom icon
-- used in the application.  Type: @/G_VARIANT_TYPE_VARIANT/@
-- 
-- It is recommended that this is not set directly but instead the
-- libdbusmenu-gtk library is used with the function @/dbusmenu_menuitem_property_set_image()/@
pattern MENUITEM_PROP_ICON_DATA = "icon-data" :: T.Text

-- | t'GI.Dbusmenu.Objects.Menuitem.Menuitem' property used to represent whether the menuitem
-- is clickable or not.  Type: @/G_VARIANT_TYPE_BOOLEAN/@.
pattern MENUITEM_PROP_ENABLED = "enabled" :: T.Text

-- | t'GI.Dbusmenu.Objects.Menuitem.Menuitem' property to tell what type of information that the
-- menu item is displaying to the user.  Type: @/G_VARIANT_TYPE_STRING/@
pattern MENUITEM_PROP_DISPOSITION = "disposition" :: T.Text

-- | t'GI.Dbusmenu.Objects.Menuitem.Menuitem' property that tells how the children of this menuitem
-- should be displayed.  Most likely this will be unset or of the value
-- 'GI.Dbusmenu.Constants.MENUITEM_CHILD_DISPLAY_SUBMENU'.  Type: @/G_VARIANT_TYPE_STRING/@
pattern MENUITEM_PROP_CHILD_DISPLAY = "children-display" :: T.Text

-- | t'GI.Dbusmenu.Objects.Menuitem.Menuitem' property used to provide a textual description of any
-- information that the icon may convey. The contents of this property are
-- passed through to assistive technologies such as the Orca screen reader.
-- The contents of this property will not be visible in the menu item. If
-- this property is set, Orca will use this property instead of the label
-- property.
pattern MENUITEM_PROP_ACCESSIBLE_DESC = "accessible-desc" :: T.Text

-- | Used to set 'GI.Dbusmenu.Constants.MENUITEM_PROP_TOGGLE_STATE' so that the menu\'s
-- toggle item is undecided.
pattern MENUITEM_ICON_NAME_BLANK = "blank-icon" :: T.Text

-- | String for the event identifier when a menu is opened and
-- displayed to the user.  Only valid for items that contain
-- submenus.
pattern MENUITEM_EVENT_OPENED = "opened" :: T.Text

-- | String for the event identifier when a menu is closed and
-- displayed to the user.  Only valid for items that contain
-- submenus.
pattern MENUITEM_EVENT_CLOSED = "closed" :: T.Text

-- | String for the event identifier when a menu item is clicked
-- on by the user.
pattern MENUITEM_EVENT_ACTIVATED = "clicked" :: T.Text

-- | Used in 'GI.Dbusmenu.Constants.MENUITEM_PROP_DISPOSITION' to have a menu
-- item displayed in a way that conveys it\'s giving a warning
-- to the user.
pattern MENUITEM_DISPOSITION_WARNING = "warning" :: T.Text

-- | Used in 'GI.Dbusmenu.Constants.MENUITEM_PROP_DISPOSITION' to have a menu
-- item displayed in the normal manner.  Default value.
pattern MENUITEM_DISPOSITION_NORMAL = "normal" :: T.Text

-- | Used in 'GI.Dbusmenu.Constants.MENUITEM_PROP_DISPOSITION' to have a menu
-- item displayed in a way that conveys it\'s giving additional
-- information to the user.
pattern MENUITEM_DISPOSITION_INFORMATIVE = "informative" :: T.Text

-- | Used in 'GI.Dbusmenu.Constants.MENUITEM_PROP_DISPOSITION' to have a menu
-- item displayed in a way that conveys it\'s giving an alert
-- to the user.
pattern MENUITEM_DISPOSITION_ALERT = "alert" :: T.Text

-- | Used in 'GI.Dbusmenu.Constants.MENUITEM_PROP_CHILD_DISPLAY' to have the
-- subitems displayed as a submenu.
pattern MENUITEM_CHILD_DISPLAY_SUBMENU = "submenu" :: T.Text

-- | Used to set the \'type\' property on a menu item to create
-- a separator menu item.
pattern CLIENT_TYPES_SEPARATOR = "separator" :: T.Text

-- | Used to set the \'type\' property on a menu item to create
-- an image menu item.  Deprecated as standard menu items now
-- support images as well.
pattern CLIENT_TYPES_IMAGE = "standard" :: T.Text

-- | Used to set the \'type\' property on a menu item to create
-- a standard menu item.
pattern CLIENT_TYPES_DEFAULT = "standard" :: T.Text

-- | String to attach to signal [Client::rootChanged]("GI.Dbusmenu.Objects.Client#g:signal:rootChanged")
pattern CLIENT_SIGNAL_ROOT_CHANGED = "root-changed" :: T.Text

-- | String to attach to signal [Client::newMenuitem]("GI.Dbusmenu.Objects.Client#g:signal:newMenuitem")
pattern CLIENT_SIGNAL_NEW_MENUITEM = "new-menuitem" :: T.Text

-- | String to attach to signal [Client::layoutUpdated]("GI.Dbusmenu.Objects.Client#g:signal:layoutUpdated")
pattern CLIENT_SIGNAL_LAYOUT_UPDATED = "layout-updated" :: T.Text

-- | String to attach to signal [Client::itemActivate]("GI.Dbusmenu.Objects.Client#g:signal:itemActivate")
pattern CLIENT_SIGNAL_ITEM_ACTIVATE = "item-activate" :: T.Text

-- | String to attach to signal [Client::iconThemeDirsChanged]("GI.Dbusmenu.Objects.Client#g:signal:iconThemeDirsChanged")
pattern CLIENT_SIGNAL_ICON_THEME_DIRS_CHANGED = "icon-theme-dirs-changed" :: T.Text

-- | String to attach to signal [Client::eventResult]("GI.Dbusmenu.Objects.Client#g:signal:eventResult")
pattern CLIENT_SIGNAL_EVENT_RESULT = "event-result" :: T.Text

-- | String to access property t'GI.Dbusmenu.Objects.Client.Client':@/text-direction/@
pattern CLIENT_PROP_TEXT_DIRECTION = "text-direction" :: T.Text

-- | String to access property t'GI.Dbusmenu.Objects.Client.Client':@/status/@
pattern CLIENT_PROP_STATUS = "status" :: T.Text

-- | String to access property [Client:groupEvents]("GI.Dbusmenu.Objects.Client#g:attr:groupEvents")
pattern CLIENT_PROP_GROUP_EVENTS = "group-events" :: T.Text

-- | String to access property [Client:dbusObject]("GI.Dbusmenu.Objects.Client#g:attr:dbusObject")
pattern CLIENT_PROP_DBUS_OBJECT = "dbus-object" :: T.Text

-- | String to access property [Client:dbusName]("GI.Dbusmenu.Objects.Client#g:attr:dbusName")
pattern CLIENT_PROP_DBUS_NAME = "dbus-name" :: T.Text


