// Code generated by github.com/jmattheis/goverter, DO NOT EDIT.
//go:build !goverter

package hcloud

import (
	schema "github.com/hetznercloud/hcloud-go/v2/hcloud/schema"
	"net"
	"time"
)

type converterImpl struct{}

func (c *converterImpl) ActionFromSchema(source schema.Action) *Action {
	var hcloudAction Action
	hcloudAction.ID = source.ID
	hcloudAction.Status = ActionStatus(source.Status)
	hcloudAction.Command = source.Command
	hcloudAction.Progress = source.Progress
	hcloudAction.Started = source.Started
	hcloudAction.Finished = c.pTimeTimeToTimeTime(source.Finished)
	var pString *string
	if source.Error != nil {
		pString = &source.Error.Code
	}
	if pString != nil {
		hcloudAction.ErrorCode = *pString
	}
	var pString2 *string
	if source.Error != nil {
		pString2 = &source.Error.Message
	}
	if pString2 != nil {
		hcloudAction.ErrorMessage = *pString2
	}
	if source.Resources != nil {
		hcloudAction.Resources = make([]*ActionResource, len(source.Resources))
		for i := 0; i < len(source.Resources); i++ {
			hcloudAction.Resources[i] = c.schemaActionResourceReferenceToPHcloudActionResource(source.Resources[i])
		}
	}
	return &hcloudAction
}
func (c *converterImpl) ActionsFromSchema(source []schema.Action) []*Action {
	var pHcloudActionList []*Action
	if source != nil {
		pHcloudActionList = make([]*Action, len(source))
		for i := 0; i < len(source); i++ {
			pHcloudActionList[i] = c.ActionFromSchema(source[i])
		}
	}
	return pHcloudActionList
}
func (c *converterImpl) CertificateFromSchema(source schema.Certificate) *Certificate {
	var hcloudCertificate Certificate
	hcloudCertificate.ID = source.ID
	hcloudCertificate.Name = source.Name
	hcloudCertificate.Labels = source.Labels
	hcloudCertificate.Type = CertificateType(source.Type)
	hcloudCertificate.Certificate = source.Certificate
	hcloudCertificate.Created = c.timeTimeToTimeTime(source.Created)
	hcloudCertificate.NotValidBefore = c.timeTimeToTimeTime(source.NotValidBefore)
	hcloudCertificate.NotValidAfter = c.timeTimeToTimeTime(source.NotValidAfter)
	hcloudCertificate.DomainNames = source.DomainNames
	hcloudCertificate.Fingerprint = source.Fingerprint
	hcloudCertificate.Status = c.pSchemaCertificateStatusRefToPHcloudCertificateStatus(source.Status)
	if source.UsedBy != nil {
		hcloudCertificate.UsedBy = make([]CertificateUsedByRef, len(source.UsedBy))
		for i := 0; i < len(source.UsedBy); i++ {
			hcloudCertificate.UsedBy[i] = c.schemaCertificateUsedByRefToHcloudCertificateUsedByRef(source.UsedBy[i])
		}
	}
	return &hcloudCertificate
}
func (c *converterImpl) DatacenterFromSchema(source schema.Datacenter) *Datacenter {
	var hcloudDatacenter Datacenter
	hcloudDatacenter.ID = source.ID
	hcloudDatacenter.Name = source.Name
	hcloudDatacenter.Description = source.Description
	hcloudDatacenter.Location = c.LocationFromSchema(source.Location)
	hcloudDatacenter.ServerTypes = c.schemaDatacenterServerTypesToHcloudDatacenterServerTypes(source.ServerTypes)
	return &hcloudDatacenter
}
func (c *converterImpl) DeprecationFromSchema(source *schema.DeprecationInfo) *DeprecationInfo {
	var pHcloudDeprecationInfo *DeprecationInfo
	if source != nil {
		var hcloudDeprecationInfo DeprecationInfo
		hcloudDeprecationInfo.Announced = c.timeTimeToTimeTime((*source).Announced)
		hcloudDeprecationInfo.UnavailableAfter = c.timeTimeToTimeTime((*source).UnavailableAfter)
		pHcloudDeprecationInfo = &hcloudDeprecationInfo
	}
	return pHcloudDeprecationInfo
}
func (c *converterImpl) ErrorFromSchema(source schema.Error) Error {
	var hcloudError Error
	hcloudError.Code = ErrorCode(source.Code)
	hcloudError.Message = source.Message
	hcloudError.Details = errorDetailsFromSchema(source.Details)
	return hcloudError
}
func (c *converterImpl) FirewallFromSchema(source schema.Firewall) *Firewall {
	var hcloudFirewall Firewall
	hcloudFirewall.ID = source.ID
	hcloudFirewall.Name = source.Name
	hcloudFirewall.Labels = source.Labels
	hcloudFirewall.Created = c.timeTimeToTimeTime(source.Created)
	if source.Rules != nil {
		hcloudFirewall.Rules = make([]FirewallRule, len(source.Rules))
		for i := 0; i < len(source.Rules); i++ {
			hcloudFirewall.Rules[i] = c.schemaFirewallRuleToHcloudFirewallRule(source.Rules[i])
		}
	}
	if source.AppliedTo != nil {
		hcloudFirewall.AppliedTo = make([]FirewallResource, len(source.AppliedTo))
		for j := 0; j < len(source.AppliedTo); j++ {
			hcloudFirewall.AppliedTo[j] = c.schemaFirewallResourceToHcloudFirewallResource(source.AppliedTo[j])
		}
	}
	return &hcloudFirewall
}
func (c *converterImpl) FloatingIPFromSchema(source schema.FloatingIP) *FloatingIP {
	var hcloudFloatingIP FloatingIP
	hcloudFloatingIP.ID = source.ID
	if source.Description != nil {
		hcloudFloatingIP.Description = *source.Description
	}
	hcloudFloatingIP.Created = c.timeTimeToTimeTime(source.Created)
	hcloudFloatingIP.IP = ipFromFloatingIPSchema(source)
	hcloudFloatingIP.Network = networkFromFloatingIPSchema(source)
	hcloudFloatingIP.Type = FloatingIPType(source.Type)
	if source.Server != nil {
		hcloudServer := serverFromInt64(*source.Server)
		hcloudFloatingIP.Server = &hcloudServer
	}
	hcloudFloatingIP.DNSPtr = mapFromFloatingIPDNSPtrSchema(source.DNSPtr)
	hcloudFloatingIP.HomeLocation = c.LocationFromSchema(source.HomeLocation)
	hcloudFloatingIP.Blocked = source.Blocked
	hcloudFloatingIP.Protection = c.schemaFloatingIPProtectionToHcloudFloatingIPProtection(source.Protection)
	hcloudFloatingIP.Labels = source.Labels
	hcloudFloatingIP.Name = source.Name
	return &hcloudFloatingIP
}
func (c *converterImpl) ISOFromSchema(source schema.ISO) *ISO {
	hcloudISO := c.intISOFromSchema(source)
	return &hcloudISO
}
func (c *converterImpl) ImageFromSchema(source schema.Image) *Image {
	var hcloudImage Image
	hcloudImage.ID = source.ID
	if source.Name != nil {
		hcloudImage.Name = *source.Name
	}
	hcloudImage.Type = ImageType(source.Type)
	hcloudImage.Status = ImageStatus(source.Status)
	hcloudImage.Description = source.Description
	if source.ImageSize != nil {
		hcloudImage.ImageSize = *source.ImageSize
	}
	hcloudImage.DiskSize = source.DiskSize
	hcloudImage.Created = c.pTimeTimeToTimeTime(source.Created)
	hcloudImage.CreatedFrom = c.pSchemaImageCreatedFromToPHcloudServer(source.CreatedFrom)
	if source.BoundTo != nil {
		hcloudServer := serverFromInt64(*source.BoundTo)
		hcloudImage.BoundTo = &hcloudServer
	}
	hcloudImage.RapidDeploy = source.RapidDeploy
	hcloudImage.OSFlavor = source.OSFlavor
	if source.OSVersion != nil {
		hcloudImage.OSVersion = *source.OSVersion
	}
	hcloudImage.Architecture = Architecture(source.Architecture)
	hcloudImage.Protection = c.schemaImageProtectionToHcloudImageProtection(source.Protection)
	hcloudImage.Deprecated = c.pTimeTimeToTimeTime(source.Deprecated)
	hcloudImage.Labels = source.Labels
	hcloudImage.Deleted = c.pTimeTimeToTimeTime(source.Deleted)
	return &hcloudImage
}
func (c *converterImpl) LoadBalancerFromSchema(source schema.LoadBalancer) *LoadBalancer {
	var hcloudLoadBalancer LoadBalancer
	hcloudLoadBalancer.ID = source.ID
	hcloudLoadBalancer.Name = source.Name
	hcloudLoadBalancer.PublicNet = c.schemaLoadBalancerPublicNetToHcloudLoadBalancerPublicNet(source.PublicNet)
	if source.PrivateNet != nil {
		hcloudLoadBalancer.PrivateNet = make([]LoadBalancerPrivateNet, len(source.PrivateNet))
		for i := 0; i < len(source.PrivateNet); i++ {
			hcloudLoadBalancer.PrivateNet[i] = c.schemaLoadBalancerPrivateNetToHcloudLoadBalancerPrivateNet(source.PrivateNet[i])
		}
	}
	hcloudLoadBalancer.Location = c.LocationFromSchema(source.Location)
	hcloudLoadBalancer.LoadBalancerType = c.LoadBalancerTypeFromSchema(source.LoadBalancerType)
	hcloudLoadBalancer.Algorithm = c.schemaLoadBalancerAlgorithmToHcloudLoadBalancerAlgorithm(source.Algorithm)
	if source.Services != nil {
		hcloudLoadBalancer.Services = make([]LoadBalancerService, len(source.Services))
		for j := 0; j < len(source.Services); j++ {
			hcloudLoadBalancer.Services[j] = c.LoadBalancerServiceFromSchema(source.Services[j])
		}
	}
	if source.Targets != nil {
		hcloudLoadBalancer.Targets = make([]LoadBalancerTarget, len(source.Targets))
		for k := 0; k < len(source.Targets); k++ {
			hcloudLoadBalancer.Targets[k] = c.LoadBalancerTargetFromSchema(source.Targets[k])
		}
	}
	hcloudLoadBalancer.Protection = c.schemaLoadBalancerProtectionToHcloudLoadBalancerProtection(source.Protection)
	hcloudLoadBalancer.Labels = source.Labels
	hcloudLoadBalancer.Created = c.timeTimeToTimeTime(source.Created)
	hcloudLoadBalancer.IncludedTraffic = source.IncludedTraffic
	if source.OutgoingTraffic != nil {
		hcloudLoadBalancer.OutgoingTraffic = *source.OutgoingTraffic
	}
	if source.IngoingTraffic != nil {
		hcloudLoadBalancer.IngoingTraffic = *source.IngoingTraffic
	}
	return &hcloudLoadBalancer
}
func (c *converterImpl) LoadBalancerMetricsFromSchema(source *schema.LoadBalancerGetMetricsResponse) (*LoadBalancerMetrics, error) {
	var pHcloudLoadBalancerMetrics *LoadBalancerMetrics
	if source != nil {
		var hcloudLoadBalancerMetrics LoadBalancerMetrics
		hcloudLoadBalancerMetrics.Start = c.timeTimeToTimeTime((*source).Metrics.Start)
		hcloudLoadBalancerMetrics.End = c.timeTimeToTimeTime((*source).Metrics.End)
		hcloudLoadBalancerMetrics.Step = (*source).Metrics.Step
		if (*source).Metrics.TimeSeries != nil {
			hcloudLoadBalancerMetrics.TimeSeries = make(map[string][]LoadBalancerMetricsValue, len((*source).Metrics.TimeSeries))
			for key, value := range (*source).Metrics.TimeSeries {
				hcloudLoadBalancerMetricsValueList, err := loadBalancerMetricsTimeSeriesFromSchema(value)
				if err != nil {
					return nil, err
				}
				hcloudLoadBalancerMetrics.TimeSeries[key] = hcloudLoadBalancerMetricsValueList
			}
		}
		pHcloudLoadBalancerMetrics = &hcloudLoadBalancerMetrics
	}
	return pHcloudLoadBalancerMetrics, nil
}
func (c *converterImpl) LoadBalancerServiceFromSchema(source schema.LoadBalancerService) LoadBalancerService {
	var hcloudLoadBalancerService LoadBalancerService
	hcloudLoadBalancerService.Protocol = LoadBalancerServiceProtocol(source.Protocol)
	hcloudLoadBalancerService.ListenPort = source.ListenPort
	hcloudLoadBalancerService.DestinationPort = source.DestinationPort
	hcloudLoadBalancerService.Proxyprotocol = source.Proxyprotocol
	hcloudLoadBalancerService.HTTP = c.pSchemaLoadBalancerServiceHTTPToHcloudLoadBalancerServiceHTTP(source.HTTP)
	hcloudLoadBalancerService.HealthCheck = c.LoadBalancerServiceHealthCheckFromSchema(source.HealthCheck)
	return hcloudLoadBalancerService
}
func (c *converterImpl) LoadBalancerServiceHealthCheckFromSchema(source *schema.LoadBalancerServiceHealthCheck) LoadBalancerServiceHealthCheck {
	var hcloudLoadBalancerServiceHealthCheck LoadBalancerServiceHealthCheck
	if source != nil {
		hcloudLoadBalancerServiceHealthCheck.Protocol = LoadBalancerServiceProtocol((*source).Protocol)
		hcloudLoadBalancerServiceHealthCheck.Port = (*source).Port
		hcloudLoadBalancerServiceHealthCheck.Interval = durationFromIntSeconds((*source).Interval)
		hcloudLoadBalancerServiceHealthCheck.Timeout = durationFromIntSeconds((*source).Timeout)
		hcloudLoadBalancerServiceHealthCheck.Retries = (*source).Retries
		hcloudLoadBalancerServiceHealthCheck.HTTP = c.pSchemaLoadBalancerServiceHealthCheckHTTPToPHcloudLoadBalancerServiceHealthCheckHTTP((*source).HTTP)
	}
	return hcloudLoadBalancerServiceHealthCheck
}
func (c *converterImpl) LoadBalancerTargetFromSchema(source schema.LoadBalancerTarget) LoadBalancerTarget {
	var hcloudLoadBalancerTarget LoadBalancerTarget
	hcloudLoadBalancerTarget.Type = LoadBalancerTargetType(source.Type)
	hcloudLoadBalancerTarget.Server = c.pSchemaLoadBalancerTargetServerToPHcloudLoadBalancerTargetServer(source.Server)
	hcloudLoadBalancerTarget.LabelSelector = c.pSchemaLoadBalancerTargetLabelSelectorToPHcloudLoadBalancerTargetLabelSelector(source.LabelSelector)
	hcloudLoadBalancerTarget.IP = c.pSchemaLoadBalancerTargetIPToPHcloudLoadBalancerTargetIP(source.IP)
	if source.HealthStatus != nil {
		hcloudLoadBalancerTarget.HealthStatus = make([]LoadBalancerTargetHealthStatus, len(source.HealthStatus))
		for i := 0; i < len(source.HealthStatus); i++ {
			hcloudLoadBalancerTarget.HealthStatus[i] = c.LoadBalancerTargetHealthStatusFromSchema(source.HealthStatus[i])
		}
	}
	if source.Targets != nil {
		hcloudLoadBalancerTarget.Targets = make([]LoadBalancerTarget, len(source.Targets))
		for j := 0; j < len(source.Targets); j++ {
			hcloudLoadBalancerTarget.Targets[j] = c.LoadBalancerTargetFromSchema(source.Targets[j])
		}
	}
	hcloudLoadBalancerTarget.UsePrivateIP = source.UsePrivateIP
	return hcloudLoadBalancerTarget
}
func (c *converterImpl) LoadBalancerTargetHealthStatusFromSchema(source schema.LoadBalancerTargetHealthStatus) LoadBalancerTargetHealthStatus {
	var hcloudLoadBalancerTargetHealthStatus LoadBalancerTargetHealthStatus
	hcloudLoadBalancerTargetHealthStatus.ListenPort = source.ListenPort
	hcloudLoadBalancerTargetHealthStatus.Status = LoadBalancerTargetHealthStatusStatus(source.Status)
	return hcloudLoadBalancerTargetHealthStatus
}
func (c *converterImpl) LoadBalancerTargetServerFromSchema(source schema.LoadBalancerTargetServer) LoadBalancerTargetServer {
	var hcloudLoadBalancerTargetServer LoadBalancerTargetServer
	hcloudServer := serverFromInt64(source.ID)
	hcloudLoadBalancerTargetServer.Server = &hcloudServer
	return hcloudLoadBalancerTargetServer
}
func (c *converterImpl) LoadBalancerTypeFromSchema(source schema.LoadBalancerType) *LoadBalancerType {
	var hcloudLoadBalancerType LoadBalancerType
	hcloudLoadBalancerType.ID = source.ID
	hcloudLoadBalancerType.Name = source.Name
	hcloudLoadBalancerType.Description = source.Description
	hcloudLoadBalancerType.MaxConnections = source.MaxConnections
	hcloudLoadBalancerType.MaxServices = source.MaxServices
	hcloudLoadBalancerType.MaxTargets = source.MaxTargets
	hcloudLoadBalancerType.MaxAssignedCertificates = source.MaxAssignedCertificates
	if source.Prices != nil {
		hcloudLoadBalancerType.Pricings = make([]LoadBalancerTypeLocationPricing, len(source.Prices))
		for i := 0; i < len(source.Prices); i++ {
			hcloudLoadBalancerType.Pricings[i] = c.LoadBalancerTypeLocationPricingFromSchema(source.Prices[i])
		}
	}
	hcloudLoadBalancerType.Deprecated = source.Deprecated
	return &hcloudLoadBalancerType
}
func (c *converterImpl) LoadBalancerTypeLocationPricingFromSchema(source schema.PricingLoadBalancerTypePrice) LoadBalancerTypeLocationPricing {
	var hcloudLoadBalancerTypeLocationPricing LoadBalancerTypeLocationPricing
	hcloudLocation := locationFromString(source.Location)
	hcloudLoadBalancerTypeLocationPricing.Location = &hcloudLocation
	hcloudLoadBalancerTypeLocationPricing.Hourly = c.PriceFromSchema(source.PriceHourly)
	hcloudLoadBalancerTypeLocationPricing.Monthly = c.PriceFromSchema(source.PriceMonthly)
	hcloudLoadBalancerTypeLocationPricing.IncludedTraffic = source.IncludedTraffic
	hcloudLoadBalancerTypeLocationPricing.PerTBTraffic = c.PriceFromSchema(source.PricePerTBTraffic)
	return hcloudLoadBalancerTypeLocationPricing
}
func (c *converterImpl) LocationFromSchema(source schema.Location) *Location {
	var hcloudLocation Location
	hcloudLocation.ID = source.ID
	hcloudLocation.Name = source.Name
	hcloudLocation.Description = source.Description
	hcloudLocation.Country = source.Country
	hcloudLocation.City = source.City
	hcloudLocation.Latitude = source.Latitude
	hcloudLocation.Longitude = source.Longitude
	hcloudLocation.NetworkZone = NetworkZone(source.NetworkZone)
	return &hcloudLocation
}
func (c *converterImpl) NetworkFromSchema(source schema.Network) *Network {
	var hcloudNetwork Network
	hcloudNetwork.ID = source.ID
	hcloudNetwork.Name = source.Name
	hcloudNetwork.Created = c.timeTimeToTimeTime(source.Created)
	netIPNet := ipNetFromString(source.IPRange)
	hcloudNetwork.IPRange = &netIPNet
	if source.Subnets != nil {
		hcloudNetwork.Subnets = make([]NetworkSubnet, len(source.Subnets))
		for i := 0; i < len(source.Subnets); i++ {
			hcloudNetwork.Subnets[i] = c.NetworkSubnetFromSchema(source.Subnets[i])
		}
	}
	if source.Routes != nil {
		hcloudNetwork.Routes = make([]NetworkRoute, len(source.Routes))
		for j := 0; j < len(source.Routes); j++ {
			hcloudNetwork.Routes[j] = c.NetworkRouteFromSchema(source.Routes[j])
		}
	}
	if source.Servers != nil {
		hcloudNetwork.Servers = make([]*Server, len(source.Servers))
		for k := 0; k < len(source.Servers); k++ {
			hcloudServer := serverFromInt64(source.Servers[k])
			hcloudNetwork.Servers[k] = &hcloudServer
		}
	}
	if source.LoadBalancers != nil {
		hcloudNetwork.LoadBalancers = make([]*LoadBalancer, len(source.LoadBalancers))
		for l := 0; l < len(source.LoadBalancers); l++ {
			hcloudLoadBalancer := loadBalancerFromInt64(source.LoadBalancers[l])
			hcloudNetwork.LoadBalancers[l] = &hcloudLoadBalancer
		}
	}
	hcloudNetwork.Protection = c.schemaNetworkProtectionToHcloudNetworkProtection(source.Protection)
	hcloudNetwork.Labels = source.Labels
	hcloudNetwork.ExposeRoutesToVSwitch = source.ExposeRoutesToVSwitch
	return &hcloudNetwork
}
func (c *converterImpl) NetworkRouteFromSchema(source schema.NetworkRoute) NetworkRoute {
	var hcloudNetworkRoute NetworkRoute
	netIPNet := ipNetFromString(source.Destination)
	hcloudNetworkRoute.Destination = &netIPNet
	hcloudNetworkRoute.Gateway = ipFromString(source.Gateway)
	return hcloudNetworkRoute
}
func (c *converterImpl) NetworkSubnetFromSchema(source schema.NetworkSubnet) NetworkSubnet {
	var hcloudNetworkSubnet NetworkSubnet
	hcloudNetworkSubnet.Type = NetworkSubnetType(source.Type)
	netIPNet := ipNetFromString(source.IPRange)
	hcloudNetworkSubnet.IPRange = &netIPNet
	hcloudNetworkSubnet.NetworkZone = NetworkZone(source.NetworkZone)
	hcloudNetworkSubnet.Gateway = ipFromString(source.Gateway)
	hcloudNetworkSubnet.VSwitchID = source.VSwitchID
	return hcloudNetworkSubnet
}
func (c *converterImpl) PaginationFromSchema(source schema.MetaPagination) Pagination {
	var hcloudPagination Pagination
	hcloudPagination.Page = source.Page
	hcloudPagination.PerPage = source.PerPage
	hcloudPagination.PreviousPage = source.PreviousPage
	hcloudPagination.NextPage = source.NextPage
	hcloudPagination.LastPage = source.LastPage
	hcloudPagination.TotalEntries = source.TotalEntries
	return hcloudPagination
}
func (c *converterImpl) PlacementGroupFromSchema(source schema.PlacementGroup) *PlacementGroup {
	var hcloudPlacementGroup PlacementGroup
	hcloudPlacementGroup.ID = source.ID
	hcloudPlacementGroup.Name = source.Name
	hcloudPlacementGroup.Labels = source.Labels
	hcloudPlacementGroup.Created = c.timeTimeToTimeTime(source.Created)
	hcloudPlacementGroup.Servers = source.Servers
	hcloudPlacementGroup.Type = PlacementGroupType(source.Type)
	return &hcloudPlacementGroup
}
func (c *converterImpl) PriceFromSchema(source schema.Price) Price {
	var hcloudPrice Price
	hcloudPrice.Net = source.Net
	hcloudPrice.Gross = source.Gross
	return hcloudPrice
}
func (c *converterImpl) PricingFromSchema(source schema.Pricing) Pricing {
	var hcloudPricing Pricing
	hcloudPricing.Currency = source.Currency
	hcloudPricing.VATRate = source.VATRate
	hcloudPricing.Image = imagePricingFromSchema(source)
	hcloudPricing.FloatingIP = floatingIPPricingFromSchema(source)
	hcloudPricing.FloatingIPs = floatingIPTypePricingFromSchema(source)
	hcloudPricing.PrimaryIPs = primaryIPPricingFromSchema(source)
	hcloudPricing.Traffic = trafficPricingFromSchema(source)
	hcloudPricing.ServerBackup = c.schemaPricingServerBackupToHcloudServerBackupPricing(source.ServerBackup)
	hcloudPricing.ServerTypes = serverTypePricingFromSchema(source)
	hcloudPricing.LoadBalancerTypes = loadBalancerTypePricingFromSchema(source)
	hcloudPricing.Volume = volumePricingFromSchema(source)
	return hcloudPricing
}
func (c *converterImpl) PrimaryIPFromSchema(source schema.PrimaryIP) *PrimaryIP {
	var hcloudPrimaryIP PrimaryIP
	hcloudPrimaryIP.ID = source.ID
	hcloudPrimaryIP.IP = ipFromPrimaryIPSchema(source)
	hcloudPrimaryIP.Network = networkFromPrimaryIPSchema(source)
	hcloudPrimaryIP.Labels = source.Labels
	hcloudPrimaryIP.Name = source.Name
	hcloudPrimaryIP.Type = PrimaryIPType(source.Type)
	hcloudPrimaryIP.Protection = c.schemaPrimaryIPProtectionToHcloudPrimaryIPProtection(source.Protection)
	hcloudPrimaryIP.DNSPtr = mapFromPrimaryIPDNSPtrSchema(source.DNSPtr)
	if source.AssigneeID != nil {
		hcloudPrimaryIP.AssigneeID = *source.AssigneeID
	}
	hcloudPrimaryIP.AssigneeType = source.AssigneeType
	hcloudPrimaryIP.AutoDelete = source.AutoDelete
	hcloudPrimaryIP.Blocked = source.Blocked
	hcloudPrimaryIP.Created = c.timeTimeToTimeTime(source.Created)
	hcloudPrimaryIP.Datacenter = c.DatacenterFromSchema(source.Datacenter)
	return &hcloudPrimaryIP
}
func (c *converterImpl) SSHKeyFromSchema(source schema.SSHKey) *SSHKey {
	var hcloudSSHKey SSHKey
	hcloudSSHKey.ID = source.ID
	hcloudSSHKey.Name = source.Name
	hcloudSSHKey.Fingerprint = source.Fingerprint
	hcloudSSHKey.PublicKey = source.PublicKey
	hcloudSSHKey.Labels = source.Labels
	hcloudSSHKey.Created = c.timeTimeToTimeTime(source.Created)
	return &hcloudSSHKey
}
func (c *converterImpl) SchemaFromAction(source *Action) schema.Action {
	var schemaAction schema.Action
	if source != nil {
		schemaAction.ID = (*source).ID
		schemaAction.Status = string((*source).Status)
		schemaAction.Command = (*source).Command
		schemaAction.Progress = (*source).Progress
		schemaAction.Started = c.timeTimeToTimeTime((*source).Started)
		schemaAction.Finished = timeToTimePtr((*source).Finished)
		schemaAction.Error = schemaActionErrorFromAction((*source))
		if (*source).Resources != nil {
			schemaAction.Resources = make([]schema.ActionResourceReference, len((*source).Resources))
			for i := 0; i < len((*source).Resources); i++ {
				schemaAction.Resources[i] = c.pHcloudActionResourceToSchemaActionResourceReference((*source).Resources[i])
			}
		}
	}
	return schemaAction
}
func (c *converterImpl) SchemaFromActions(source []*Action) []schema.Action {
	var schemaActionList []schema.Action
	if source != nil {
		schemaActionList = make([]schema.Action, len(source))
		for i := 0; i < len(source); i++ {
			schemaActionList[i] = c.SchemaFromAction(source[i])
		}
	}
	return schemaActionList
}
func (c *converterImpl) SchemaFromCertificate(source *Certificate) schema.Certificate {
	var schemaCertificate schema.Certificate
	if source != nil {
		schemaCertificate.ID = (*source).ID
		schemaCertificate.Name = (*source).Name
		schemaCertificate.Labels = (*source).Labels
		schemaCertificate.Type = string((*source).Type)
		schemaCertificate.Certificate = (*source).Certificate
		schemaCertificate.Created = c.timeTimeToTimeTime((*source).Created)
		schemaCertificate.NotValidBefore = c.timeTimeToTimeTime((*source).NotValidBefore)
		schemaCertificate.NotValidAfter = c.timeTimeToTimeTime((*source).NotValidAfter)
		schemaCertificate.DomainNames = (*source).DomainNames
		schemaCertificate.Fingerprint = (*source).Fingerprint
		schemaCertificate.Status = c.pHcloudCertificateStatusToPSchemaCertificateStatusRef((*source).Status)
		if (*source).UsedBy != nil {
			schemaCertificate.UsedBy = make([]schema.CertificateUsedByRef, len((*source).UsedBy))
			for i := 0; i < len((*source).UsedBy); i++ {
				schemaCertificate.UsedBy[i] = c.hcloudCertificateUsedByRefToSchemaCertificateUsedByRef((*source).UsedBy[i])
			}
		}
	}
	return schemaCertificate
}
func (c *converterImpl) SchemaFromDatacenter(source *Datacenter) schema.Datacenter {
	var schemaDatacenter schema.Datacenter
	if source != nil {
		schemaDatacenter.ID = (*source).ID
		schemaDatacenter.Name = (*source).Name
		schemaDatacenter.Description = (*source).Description
		schemaDatacenter.Location = c.SchemaFromLocation((*source).Location)
		schemaDatacenter.ServerTypes = c.hcloudDatacenterServerTypesToSchemaDatacenterServerTypes((*source).ServerTypes)
	}
	return schemaDatacenter
}
func (c *converterImpl) SchemaFromDeprecation(source *DeprecationInfo) *schema.DeprecationInfo {
	var pSchemaDeprecationInfo *schema.DeprecationInfo
	if source != nil {
		var schemaDeprecationInfo schema.DeprecationInfo
		schemaDeprecationInfo.Announced = c.timeTimeToTimeTime((*source).Announced)
		schemaDeprecationInfo.UnavailableAfter = c.timeTimeToTimeTime((*source).UnavailableAfter)
		pSchemaDeprecationInfo = &schemaDeprecationInfo
	}
	return pSchemaDeprecationInfo
}
func (c *converterImpl) SchemaFromError(source Error) schema.Error {
	var schemaError schema.Error
	schemaError.Code = string(source.Code)
	schemaError.Message = source.Message
	schemaError.DetailsRaw = rawSchemaFromErrorDetails(source.Details)
	schemaError.Details = schemaFromErrorDetails(source.Details)
	return schemaError
}
func (c *converterImpl) SchemaFromFirewall(source *Firewall) schema.Firewall {
	var schemaFirewall schema.Firewall
	if source != nil {
		schemaFirewall.ID = (*source).ID
		schemaFirewall.Name = (*source).Name
		schemaFirewall.Labels = (*source).Labels
		schemaFirewall.Created = c.timeTimeToTimeTime((*source).Created)
		if (*source).Rules != nil {
			schemaFirewall.Rules = make([]schema.FirewallRule, len((*source).Rules))
			for i := 0; i < len((*source).Rules); i++ {
				schemaFirewall.Rules[i] = c.hcloudFirewallRuleToSchemaFirewallRule((*source).Rules[i])
			}
		}
		if (*source).AppliedTo != nil {
			schemaFirewall.AppliedTo = make([]schema.FirewallResource, len((*source).AppliedTo))
			for j := 0; j < len((*source).AppliedTo); j++ {
				schemaFirewall.AppliedTo[j] = c.SchemaFromFirewallResource((*source).AppliedTo[j])
			}
		}
	}
	return schemaFirewall
}
func (c *converterImpl) SchemaFromFirewallCreateOpts(source FirewallCreateOpts) schema.FirewallCreateRequest {
	var schemaFirewallCreateRequest schema.FirewallCreateRequest
	schemaFirewallCreateRequest.Name = source.Name
	schemaFirewallCreateRequest.Labels = stringMapToStringMapPtr(source.Labels)
	if source.Rules != nil {
		schemaFirewallCreateRequest.Rules = make([]schema.FirewallRuleRequest, len(source.Rules))
		for i := 0; i < len(source.Rules); i++ {
			schemaFirewallCreateRequest.Rules[i] = c.hcloudFirewallRuleToSchemaFirewallRuleRequest(source.Rules[i])
		}
	}
	if source.ApplyTo != nil {
		schemaFirewallCreateRequest.ApplyTo = make([]schema.FirewallResource, len(source.ApplyTo))
		for j := 0; j < len(source.ApplyTo); j++ {
			schemaFirewallCreateRequest.ApplyTo[j] = c.SchemaFromFirewallResource(source.ApplyTo[j])
		}
	}
	return schemaFirewallCreateRequest
}
func (c *converterImpl) SchemaFromFirewallResource(source FirewallResource) schema.FirewallResource {
	var schemaFirewallResource schema.FirewallResource
	schemaFirewallResource.Type = string(source.Type)
	schemaFirewallResource.Server = c.pHcloudFirewallResourceServerToPSchemaFirewallResourceServer(source.Server)
	schemaFirewallResource.LabelSelector = c.pHcloudFirewallResourceLabelSelectorToPSchemaFirewallResourceLabelSelector(source.LabelSelector)
	if source.AppliedToResources != nil {
		schemaFirewallResource.AppliedToResources = make([]schema.FirewallResource, len(source.AppliedToResources))
		for i := 0; i < len(source.AppliedToResources); i++ {
			schemaFirewallResource.AppliedToResources[i] = c.SchemaFromFirewallResource(source.AppliedToResources[i])
		}
	}
	return schemaFirewallResource
}
func (c *converterImpl) SchemaFromFirewallSetRulesOpts(source FirewallSetRulesOpts) schema.FirewallActionSetRulesRequest {
	var schemaFirewallActionSetRulesRequest schema.FirewallActionSetRulesRequest
	if source.Rules != nil {
		schemaFirewallActionSetRulesRequest.Rules = make([]schema.FirewallRuleRequest, len(source.Rules))
		for i := 0; i < len(source.Rules); i++ {
			schemaFirewallActionSetRulesRequest.Rules[i] = c.hcloudFirewallRuleToSchemaFirewallRuleRequest(source.Rules[i])
		}
	}
	return schemaFirewallActionSetRulesRequest
}
func (c *converterImpl) SchemaFromFloatingIP(source *FloatingIP) schema.FloatingIP {
	var schemaFloatingIP schema.FloatingIP
	if source != nil {
		schemaFloatingIP.ID = (*source).ID
		pString := (*source).Description
		schemaFloatingIP.Description = &pString
		schemaFloatingIP.Created = c.timeTimeToTimeTime((*source).Created)
		schemaFloatingIP.IP = floatingIPToIPString((*source))
		schemaFloatingIP.Type = string((*source).Type)
		schemaFloatingIP.Server = c.pHcloudServerToPInt64((*source).Server)
		schemaFloatingIP.DNSPtr = floatingIPDNSPtrSchemaFromMap((*source).DNSPtr)
		schemaFloatingIP.HomeLocation = c.SchemaFromLocation((*source).HomeLocation)
		schemaFloatingIP.Blocked = (*source).Blocked
		schemaFloatingIP.Protection = c.hcloudFloatingIPProtectionToSchemaFloatingIPProtection((*source).Protection)
		schemaFloatingIP.Labels = (*source).Labels
		schemaFloatingIP.Name = (*source).Name
	}
	return schemaFloatingIP
}
func (c *converterImpl) SchemaFromISO(source *ISO) schema.ISO {
	var schemaISO schema.ISO
	if source != nil {
		schemaISO.ID = (*source).ID
		schemaISO.Name = (*source).Name
		schemaISO.Description = (*source).Description
		schemaISO.Type = string((*source).Type)
		if (*source).Architecture != nil {
			xstring := string(*(*source).Architecture)
			schemaISO.Architecture = &xstring
		}
		schemaISO.DeprecatableResource = c.hcloudDeprecatableResourceToSchemaDeprecatableResource((*source).DeprecatableResource)
	}
	return schemaISO
}
func (c *converterImpl) SchemaFromImage(source *Image) schema.Image {
	var schemaImage schema.Image
	if source != nil {
		schemaImage = c.intSchemaFromImage((*source))
	}
	return schemaImage
}
func (c *converterImpl) SchemaFromLoadBalancer(source *LoadBalancer) schema.LoadBalancer {
	var schemaLoadBalancer schema.LoadBalancer
	if source != nil {
		schemaLoadBalancer.ID = (*source).ID
		schemaLoadBalancer.Name = (*source).Name
		schemaLoadBalancer.PublicNet = c.hcloudLoadBalancerPublicNetToSchemaLoadBalancerPublicNet((*source).PublicNet)
		if (*source).PrivateNet != nil {
			schemaLoadBalancer.PrivateNet = make([]schema.LoadBalancerPrivateNet, len((*source).PrivateNet))
			for i := 0; i < len((*source).PrivateNet); i++ {
				schemaLoadBalancer.PrivateNet[i] = c.hcloudLoadBalancerPrivateNetToSchemaLoadBalancerPrivateNet((*source).PrivateNet[i])
			}
		}
		schemaLoadBalancer.Location = c.SchemaFromLocation((*source).Location)
		schemaLoadBalancer.LoadBalancerType = c.SchemaFromLoadBalancerType((*source).LoadBalancerType)
		schemaLoadBalancer.Protection = c.hcloudLoadBalancerProtectionToSchemaLoadBalancerProtection((*source).Protection)
		schemaLoadBalancer.Labels = (*source).Labels
		schemaLoadBalancer.Created = c.timeTimeToTimeTime((*source).Created)
		if (*source).Services != nil {
			schemaLoadBalancer.Services = make([]schema.LoadBalancerService, len((*source).Services))
			for j := 0; j < len((*source).Services); j++ {
				schemaLoadBalancer.Services[j] = c.SchemaFromLoadBalancerService((*source).Services[j])
			}
		}
		if (*source).Targets != nil {
			schemaLoadBalancer.Targets = make([]schema.LoadBalancerTarget, len((*source).Targets))
			for k := 0; k < len((*source).Targets); k++ {
				schemaLoadBalancer.Targets[k] = c.SchemaFromLoadBalancerTarget((*source).Targets[k])
			}
		}
		schemaLoadBalancer.Algorithm = c.hcloudLoadBalancerAlgorithmToSchemaLoadBalancerAlgorithm((*source).Algorithm)
		schemaLoadBalancer.IncludedTraffic = (*source).IncludedTraffic
		schemaLoadBalancer.OutgoingTraffic = mapZeroUint64ToNil((*source).OutgoingTraffic)
		schemaLoadBalancer.IngoingTraffic = mapZeroUint64ToNil((*source).IngoingTraffic)
	}
	return schemaLoadBalancer
}
func (c *converterImpl) SchemaFromLoadBalancerAddServiceOpts(source LoadBalancerAddServiceOpts) schema.LoadBalancerActionAddServiceRequest {
	var schemaLoadBalancerActionAddServiceRequest schema.LoadBalancerActionAddServiceRequest
	schemaLoadBalancerActionAddServiceRequest.Protocol = string(source.Protocol)
	schemaLoadBalancerActionAddServiceRequest.ListenPort = source.ListenPort
	schemaLoadBalancerActionAddServiceRequest.DestinationPort = source.DestinationPort
	schemaLoadBalancerActionAddServiceRequest.Proxyprotocol = source.Proxyprotocol
	schemaLoadBalancerActionAddServiceRequest.HTTP = c.pHcloudLoadBalancerAddServiceOptsHTTPToPSchemaLoadBalancerActionAddServiceRequestHTTP(source.HTTP)
	schemaLoadBalancerActionAddServiceRequest.HealthCheck = c.pHcloudLoadBalancerAddServiceOptsHealthCheckToPSchemaLoadBalancerActionAddServiceRequestHealthCheck(source.HealthCheck)
	return schemaLoadBalancerActionAddServiceRequest
}
func (c *converterImpl) SchemaFromLoadBalancerCreateOpts(source LoadBalancerCreateOpts) schema.LoadBalancerCreateRequest {
	var schemaLoadBalancerCreateRequest schema.LoadBalancerCreateRequest
	schemaLoadBalancerCreateRequest.Name = source.Name
	schemaLoadBalancerCreateRequest.LoadBalancerType = c.pHcloudLoadBalancerTypeToSchemaIDOrName(source.LoadBalancerType)
	schemaLoadBalancerCreateRequest.Algorithm = c.pHcloudLoadBalancerAlgorithmToPSchemaLoadBalancerCreateRequestAlgorithm(source.Algorithm)
	schemaLoadBalancerCreateRequest.Location = c.pHcloudLocationToPString(source.Location)
	schemaLoadBalancerCreateRequest.NetworkZone = stringPtrFromNetworkZone(source.NetworkZone)
	schemaLoadBalancerCreateRequest.Labels = stringMapToStringMapPtr(source.Labels)
	if source.Targets != nil {
		schemaLoadBalancerCreateRequest.Targets = make([]schema.LoadBalancerCreateRequestTarget, len(source.Targets))
		for i := 0; i < len(source.Targets); i++ {
			schemaLoadBalancerCreateRequest.Targets[i] = c.hcloudLoadBalancerCreateOptsTargetToSchemaLoadBalancerCreateRequestTarget(source.Targets[i])
		}
	}
	if source.Services != nil {
		schemaLoadBalancerCreateRequest.Services = make([]schema.LoadBalancerCreateRequestService, len(source.Services))
		for j := 0; j < len(source.Services); j++ {
			schemaLoadBalancerCreateRequest.Services[j] = c.hcloudLoadBalancerCreateOptsServiceToSchemaLoadBalancerCreateRequestService(source.Services[j])
		}
	}
	schemaLoadBalancerCreateRequest.PublicInterface = source.PublicInterface
	schemaLoadBalancerCreateRequest.Network = c.pHcloudNetworkToPInt64(source.Network)
	return schemaLoadBalancerCreateRequest
}
func (c *converterImpl) SchemaFromLoadBalancerCreateOptsTargetServer(source LoadBalancerCreateOptsTargetServer) schema.LoadBalancerCreateRequestTargetServer {
	var schemaLoadBalancerCreateRequestTargetServer schema.LoadBalancerCreateRequestTargetServer
	var pInt64 *int64
	if source.Server != nil {
		pInt64 = &source.Server.ID
	}
	if pInt64 != nil {
		schemaLoadBalancerCreateRequestTargetServer.ID = *pInt64
	}
	return schemaLoadBalancerCreateRequestTargetServer
}
func (c *converterImpl) SchemaFromLoadBalancerServerTarget(source LoadBalancerTargetServer) schema.LoadBalancerTargetServer {
	var schemaLoadBalancerTargetServer schema.LoadBalancerTargetServer
	schemaLoadBalancerTargetServer.ID = c.pHcloudServerToInt64(source.Server)
	return schemaLoadBalancerTargetServer
}
func (c *converterImpl) SchemaFromLoadBalancerService(source LoadBalancerService) schema.LoadBalancerService {
	var schemaLoadBalancerService schema.LoadBalancerService
	schemaLoadBalancerService.Protocol = string(source.Protocol)
	schemaLoadBalancerService.ListenPort = source.ListenPort
	schemaLoadBalancerService.DestinationPort = source.DestinationPort
	schemaLoadBalancerService.Proxyprotocol = source.Proxyprotocol
	schemaLoadBalancerService.HTTP = c.hcloudLoadBalancerServiceHTTPToPSchemaLoadBalancerServiceHTTP(source.HTTP)
	schemaLoadBalancerService.HealthCheck = c.SchemaFromLoadBalancerServiceHealthCheck(source.HealthCheck)
	return schemaLoadBalancerService
}
func (c *converterImpl) SchemaFromLoadBalancerServiceHealthCheck(source LoadBalancerServiceHealthCheck) *schema.LoadBalancerServiceHealthCheck {
	var schemaLoadBalancerServiceHealthCheck schema.LoadBalancerServiceHealthCheck
	schemaLoadBalancerServiceHealthCheck.Protocol = string(source.Protocol)
	schemaLoadBalancerServiceHealthCheck.Port = source.Port
	schemaLoadBalancerServiceHealthCheck.Interval = intSecondsFromDuration(source.Interval)
	schemaLoadBalancerServiceHealthCheck.Timeout = intSecondsFromDuration(source.Timeout)
	schemaLoadBalancerServiceHealthCheck.Retries = source.Retries
	schemaLoadBalancerServiceHealthCheck.HTTP = c.pHcloudLoadBalancerServiceHealthCheckHTTPToPSchemaLoadBalancerServiceHealthCheckHTTP(source.HTTP)
	return &schemaLoadBalancerServiceHealthCheck
}
func (c *converterImpl) SchemaFromLoadBalancerTarget(source LoadBalancerTarget) schema.LoadBalancerTarget {
	var schemaLoadBalancerTarget schema.LoadBalancerTarget
	schemaLoadBalancerTarget.Type = string(source.Type)
	schemaLoadBalancerTarget.Server = c.pHcloudLoadBalancerTargetServerToPSchemaLoadBalancerTargetServer(source.Server)
	schemaLoadBalancerTarget.LabelSelector = c.pHcloudLoadBalancerTargetLabelSelectorToPSchemaLoadBalancerTargetLabelSelector(source.LabelSelector)
	schemaLoadBalancerTarget.IP = c.pHcloudLoadBalancerTargetIPToPSchemaLoadBalancerTargetIP(source.IP)
	if source.HealthStatus != nil {
		schemaLoadBalancerTarget.HealthStatus = make([]schema.LoadBalancerTargetHealthStatus, len(source.HealthStatus))
		for i := 0; i < len(source.HealthStatus); i++ {
			schemaLoadBalancerTarget.HealthStatus[i] = c.SchemaFromLoadBalancerTargetHealthStatus(source.HealthStatus[i])
		}
	}
	schemaLoadBalancerTarget.UsePrivateIP = source.UsePrivateIP
	if source.Targets != nil {
		schemaLoadBalancerTarget.Targets = make([]schema.LoadBalancerTarget, len(source.Targets))
		for j := 0; j < len(source.Targets); j++ {
			schemaLoadBalancerTarget.Targets[j] = c.SchemaFromLoadBalancerTarget(source.Targets[j])
		}
	}
	return schemaLoadBalancerTarget
}
func (c *converterImpl) SchemaFromLoadBalancerTargetHealthStatus(source LoadBalancerTargetHealthStatus) schema.LoadBalancerTargetHealthStatus {
	var schemaLoadBalancerTargetHealthStatus schema.LoadBalancerTargetHealthStatus
	schemaLoadBalancerTargetHealthStatus.ListenPort = source.ListenPort
	schemaLoadBalancerTargetHealthStatus.Status = string(source.Status)
	return schemaLoadBalancerTargetHealthStatus
}
func (c *converterImpl) SchemaFromLoadBalancerType(source *LoadBalancerType) schema.LoadBalancerType {
	var schemaLoadBalancerType schema.LoadBalancerType
	if source != nil {
		schemaLoadBalancerType.ID = (*source).ID
		schemaLoadBalancerType.Name = (*source).Name
		schemaLoadBalancerType.Description = (*source).Description
		schemaLoadBalancerType.MaxConnections = (*source).MaxConnections
		schemaLoadBalancerType.MaxServices = (*source).MaxServices
		schemaLoadBalancerType.MaxTargets = (*source).MaxTargets
		schemaLoadBalancerType.MaxAssignedCertificates = (*source).MaxAssignedCertificates
		if (*source).Pricings != nil {
			schemaLoadBalancerType.Prices = make([]schema.PricingLoadBalancerTypePrice, len((*source).Pricings))
			for i := 0; i < len((*source).Pricings); i++ {
				schemaLoadBalancerType.Prices[i] = c.SchemaFromLoadBalancerTypeLocationPricing((*source).Pricings[i])
			}
		}
		schemaLoadBalancerType.Deprecated = (*source).Deprecated
	}
	return schemaLoadBalancerType
}
func (c *converterImpl) SchemaFromLoadBalancerTypeLocationPricing(source LoadBalancerTypeLocationPricing) schema.PricingLoadBalancerTypePrice {
	var schemaPricingLoadBalancerTypePrice schema.PricingLoadBalancerTypePrice
	schemaPricingLoadBalancerTypePrice.Location = c.pHcloudLocationToString(source.Location)
	schemaPricingLoadBalancerTypePrice.PriceHourly = c.hcloudPriceToSchemaPrice(source.Hourly)
	schemaPricingLoadBalancerTypePrice.PriceMonthly = c.hcloudPriceToSchemaPrice(source.Monthly)
	schemaPricingLoadBalancerTypePrice.IncludedTraffic = source.IncludedTraffic
	schemaPricingLoadBalancerTypePrice.PricePerTBTraffic = c.hcloudPriceToSchemaPrice(source.PerTBTraffic)
	return schemaPricingLoadBalancerTypePrice
}
func (c *converterImpl) SchemaFromLoadBalancerUpdateServiceOpts(source LoadBalancerUpdateServiceOpts) schema.LoadBalancerActionUpdateServiceRequest {
	var schemaLoadBalancerActionUpdateServiceRequest schema.LoadBalancerActionUpdateServiceRequest
	schemaLoadBalancerActionUpdateServiceRequest.Protocol = stringPtrFromLoadBalancerServiceProtocol(source.Protocol)
	schemaLoadBalancerActionUpdateServiceRequest.DestinationPort = source.DestinationPort
	schemaLoadBalancerActionUpdateServiceRequest.Proxyprotocol = source.Proxyprotocol
	schemaLoadBalancerActionUpdateServiceRequest.HTTP = c.pHcloudLoadBalancerUpdateServiceOptsHTTPToPSchemaLoadBalancerActionUpdateServiceRequestHTTP(source.HTTP)
	schemaLoadBalancerActionUpdateServiceRequest.HealthCheck = c.pHcloudLoadBalancerUpdateServiceOptsHealthCheckToPSchemaLoadBalancerActionUpdateServiceRequestHealthCheck(source.HealthCheck)
	return schemaLoadBalancerActionUpdateServiceRequest
}
func (c *converterImpl) SchemaFromLocation(source *Location) schema.Location {
	var schemaLocation schema.Location
	if source != nil {
		schemaLocation.ID = (*source).ID
		schemaLocation.Name = (*source).Name
		schemaLocation.Description = (*source).Description
		schemaLocation.Country = (*source).Country
		schemaLocation.City = (*source).City
		schemaLocation.Latitude = (*source).Latitude
		schemaLocation.Longitude = (*source).Longitude
		schemaLocation.NetworkZone = string((*source).NetworkZone)
	}
	return schemaLocation
}
func (c *converterImpl) SchemaFromNetwork(source *Network) schema.Network {
	var schemaNetwork schema.Network
	if source != nil {
		schemaNetwork.ID = (*source).ID
		schemaNetwork.Name = (*source).Name
		schemaNetwork.Created = c.timeTimeToTimeTime((*source).Created)
		schemaNetwork.IPRange = c.pNetIPNetToString((*source).IPRange)
		if (*source).Subnets != nil {
			schemaNetwork.Subnets = make([]schema.NetworkSubnet, len((*source).Subnets))
			for i := 0; i < len((*source).Subnets); i++ {
				schemaNetwork.Subnets[i] = c.SchemaFromNetworkSubnet((*source).Subnets[i])
			}
		}
		if (*source).Routes != nil {
			schemaNetwork.Routes = make([]schema.NetworkRoute, len((*source).Routes))
			for j := 0; j < len((*source).Routes); j++ {
				schemaNetwork.Routes[j] = c.SchemaFromNetworkRoute((*source).Routes[j])
			}
		}
		if (*source).Servers != nil {
			schemaNetwork.Servers = make([]int64, len((*source).Servers))
			for k := 0; k < len((*source).Servers); k++ {
				schemaNetwork.Servers[k] = c.pHcloudServerToInt64((*source).Servers[k])
			}
		}
		if (*source).LoadBalancers != nil {
			schemaNetwork.LoadBalancers = make([]int64, len((*source).LoadBalancers))
			for l := 0; l < len((*source).LoadBalancers); l++ {
				schemaNetwork.LoadBalancers[l] = c.pHcloudLoadBalancerToInt64((*source).LoadBalancers[l])
			}
		}
		schemaNetwork.Protection = c.hcloudNetworkProtectionToSchemaNetworkProtection((*source).Protection)
		schemaNetwork.Labels = (*source).Labels
		schemaNetwork.ExposeRoutesToVSwitch = (*source).ExposeRoutesToVSwitch
	}
	return schemaNetwork
}
func (c *converterImpl) SchemaFromNetworkRoute(source NetworkRoute) schema.NetworkRoute {
	var schemaNetworkRoute schema.NetworkRoute
	schemaNetworkRoute.Destination = c.pNetIPNetToString(source.Destination)
	schemaNetworkRoute.Gateway = stringFromIP(source.Gateway)
	return schemaNetworkRoute
}
func (c *converterImpl) SchemaFromNetworkSubnet(source NetworkSubnet) schema.NetworkSubnet {
	var schemaNetworkSubnet schema.NetworkSubnet
	schemaNetworkSubnet.Type = string(source.Type)
	schemaNetworkSubnet.IPRange = c.pNetIPNetToString(source.IPRange)
	schemaNetworkSubnet.NetworkZone = string(source.NetworkZone)
	schemaNetworkSubnet.Gateway = stringFromIP(source.Gateway)
	schemaNetworkSubnet.VSwitchID = source.VSwitchID
	return schemaNetworkSubnet
}
func (c *converterImpl) SchemaFromPagination(source Pagination) schema.MetaPagination {
	var schemaMetaPagination schema.MetaPagination
	schemaMetaPagination.Page = source.Page
	schemaMetaPagination.PerPage = source.PerPage
	schemaMetaPagination.PreviousPage = source.PreviousPage
	schemaMetaPagination.NextPage = source.NextPage
	schemaMetaPagination.LastPage = source.LastPage
	schemaMetaPagination.TotalEntries = source.TotalEntries
	return schemaMetaPagination
}
func (c *converterImpl) SchemaFromPlacementGroup(source *PlacementGroup) schema.PlacementGroup {
	var schemaPlacementGroup schema.PlacementGroup
	if source != nil {
		schemaPlacementGroup.ID = (*source).ID
		schemaPlacementGroup.Name = (*source).Name
		schemaPlacementGroup.Labels = (*source).Labels
		schemaPlacementGroup.Created = c.timeTimeToTimeTime((*source).Created)
		schemaPlacementGroup.Servers = (*source).Servers
		schemaPlacementGroup.Type = string((*source).Type)
	}
	return schemaPlacementGroup
}
func (c *converterImpl) SchemaFromPlacementGroupCreateOpts(source PlacementGroupCreateOpts) schema.PlacementGroupCreateRequest {
	var schemaPlacementGroupCreateRequest schema.PlacementGroupCreateRequest
	schemaPlacementGroupCreateRequest.Name = source.Name
	schemaPlacementGroupCreateRequest.Labels = stringMapToStringMapPtr(source.Labels)
	schemaPlacementGroupCreateRequest.Type = string(source.Type)
	return schemaPlacementGroupCreateRequest
}
func (c *converterImpl) SchemaFromPricing(source Pricing) schema.Pricing {
	var schemaPricing schema.Pricing
	schemaPricing.Currency = source.Image.PerGBMonth.Currency
	schemaPricing.VATRate = source.Image.PerGBMonth.VATRate
	schemaPricing.Image = c.schemaFromImagePricing(source.Image)
	schemaPricing.FloatingIP = c.schemaFromFloatingIPPricing(source.FloatingIP)
	if source.FloatingIPs != nil {
		schemaPricing.FloatingIPs = make([]schema.PricingFloatingIPType, len(source.FloatingIPs))
		for i := 0; i < len(source.FloatingIPs); i++ {
			schemaPricing.FloatingIPs[i] = c.schemaFromFloatingIPTypePricing(source.FloatingIPs[i])
		}
	}
	if source.PrimaryIPs != nil {
		schemaPricing.PrimaryIPs = make([]schema.PricingPrimaryIP, len(source.PrimaryIPs))
		for j := 0; j < len(source.PrimaryIPs); j++ {
			schemaPricing.PrimaryIPs[j] = c.schemaFromPrimaryIPPricing(source.PrimaryIPs[j])
		}
	}
	schemaPricing.Traffic = c.schemaFromTrafficPricing(source.Traffic)
	schemaPricing.ServerBackup = c.hcloudServerBackupPricingToSchemaPricingServerBackup(source.ServerBackup)
	if source.ServerTypes != nil {
		schemaPricing.ServerTypes = make([]schema.PricingServerType, len(source.ServerTypes))
		for k := 0; k < len(source.ServerTypes); k++ {
			schemaPricing.ServerTypes[k] = c.schemaFromServerTypePricing(source.ServerTypes[k])
		}
	}
	if source.LoadBalancerTypes != nil {
		schemaPricing.LoadBalancerTypes = make([]schema.PricingLoadBalancerType, len(source.LoadBalancerTypes))
		for l := 0; l < len(source.LoadBalancerTypes); l++ {
			schemaPricing.LoadBalancerTypes[l] = c.schemaFromLoadBalancerTypePricing(source.LoadBalancerTypes[l])
		}
	}
	schemaPricing.Volume = c.schemaFromVolumePricing(source.Volume)
	return schemaPricing
}
func (c *converterImpl) SchemaFromPrimaryIP(source *PrimaryIP) schema.PrimaryIP {
	var schemaPrimaryIP schema.PrimaryIP
	if source != nil {
		schemaPrimaryIP.ID = (*source).ID
		schemaPrimaryIP.IP = primaryIPToIPString((*source))
		schemaPrimaryIP.Labels = (*source).Labels
		schemaPrimaryIP.Name = (*source).Name
		schemaPrimaryIP.Type = string((*source).Type)
		schemaPrimaryIP.Protection = c.hcloudPrimaryIPProtectionToSchemaPrimaryIPProtection((*source).Protection)
		schemaPrimaryIP.DNSPtr = primaryIPDNSPtrSchemaFromMap((*source).DNSPtr)
		schemaPrimaryIP.AssigneeID = mapZeroInt64ToNil((*source).AssigneeID)
		schemaPrimaryIP.AssigneeType = (*source).AssigneeType
		schemaPrimaryIP.AutoDelete = (*source).AutoDelete
		schemaPrimaryIP.Blocked = (*source).Blocked
		schemaPrimaryIP.Created = c.timeTimeToTimeTime((*source).Created)
		schemaPrimaryIP.Datacenter = c.SchemaFromDatacenter((*source).Datacenter)
	}
	return schemaPrimaryIP
}
func (c *converterImpl) SchemaFromPrimaryIPAssignOpts(source PrimaryIPAssignOpts) schema.PrimaryIPActionAssignRequest {
	var schemaPrimaryIPActionAssignRequest schema.PrimaryIPActionAssignRequest
	schemaPrimaryIPActionAssignRequest.AssigneeID = source.AssigneeID
	schemaPrimaryIPActionAssignRequest.AssigneeType = source.AssigneeType
	return schemaPrimaryIPActionAssignRequest
}
func (c *converterImpl) SchemaFromPrimaryIPChangeDNSPtrOpts(source PrimaryIPChangeDNSPtrOpts) schema.PrimaryIPActionChangeDNSPtrRequest {
	var schemaPrimaryIPActionChangeDNSPtrRequest schema.PrimaryIPActionChangeDNSPtrRequest
	schemaPrimaryIPActionChangeDNSPtrRequest.IP = source.IP
	pString := source.DNSPtr
	schemaPrimaryIPActionChangeDNSPtrRequest.DNSPtr = &pString
	return schemaPrimaryIPActionChangeDNSPtrRequest
}
func (c *converterImpl) SchemaFromPrimaryIPChangeProtectionOpts(source PrimaryIPChangeProtectionOpts) schema.PrimaryIPActionChangeProtectionRequest {
	var schemaPrimaryIPActionChangeProtectionRequest schema.PrimaryIPActionChangeProtectionRequest
	schemaPrimaryIPActionChangeProtectionRequest.Delete = source.Delete
	return schemaPrimaryIPActionChangeProtectionRequest
}
func (c *converterImpl) SchemaFromPrimaryIPCreateOpts(source PrimaryIPCreateOpts) schema.PrimaryIPCreateRequest {
	var schemaPrimaryIPCreateRequest schema.PrimaryIPCreateRequest
	schemaPrimaryIPCreateRequest.Name = source.Name
	schemaPrimaryIPCreateRequest.Type = string(source.Type)
	schemaPrimaryIPCreateRequest.AssigneeType = source.AssigneeType
	schemaPrimaryIPCreateRequest.AssigneeID = source.AssigneeID
	schemaPrimaryIPCreateRequest.Labels = stringMapToStringMapPtr(source.Labels)
	schemaPrimaryIPCreateRequest.AutoDelete = source.AutoDelete
	schemaPrimaryIPCreateRequest.Datacenter = source.Datacenter
	return schemaPrimaryIPCreateRequest
}
func (c *converterImpl) SchemaFromPrimaryIPUpdateOpts(source PrimaryIPUpdateOpts) schema.PrimaryIPUpdateRequest {
	var schemaPrimaryIPUpdateRequest schema.PrimaryIPUpdateRequest
	schemaPrimaryIPUpdateRequest.Name = source.Name
	schemaPrimaryIPUpdateRequest.Labels = source.Labels
	schemaPrimaryIPUpdateRequest.AutoDelete = source.AutoDelete
	return schemaPrimaryIPUpdateRequest
}
func (c *converterImpl) SchemaFromSSHKey(source *SSHKey) schema.SSHKey {
	var schemaSSHKey schema.SSHKey
	if source != nil {
		schemaSSHKey.ID = (*source).ID
		schemaSSHKey.Name = (*source).Name
		schemaSSHKey.Fingerprint = (*source).Fingerprint
		schemaSSHKey.PublicKey = (*source).PublicKey
		schemaSSHKey.Labels = (*source).Labels
		schemaSSHKey.Created = c.timeTimeToTimeTime((*source).Created)
	}
	return schemaSSHKey
}
func (c *converterImpl) SchemaFromServer(source *Server) schema.Server {
	var schemaServer schema.Server
	if source != nil {
		schemaServer.ID = (*source).ID
		schemaServer.Name = (*source).Name
		schemaServer.Status = string((*source).Status)
		schemaServer.Created = c.timeTimeToTimeTime((*source).Created)
		schemaServer.PublicNet = c.SchemaFromServerPublicNet((*source).PublicNet)
		if (*source).PrivateNet != nil {
			schemaServer.PrivateNet = make([]schema.ServerPrivateNet, len((*source).PrivateNet))
			for i := 0; i < len((*source).PrivateNet); i++ {
				schemaServer.PrivateNet[i] = c.SchemaFromServerPrivateNet((*source).PrivateNet[i])
			}
		}
		schemaServer.ServerType = c.SchemaFromServerType((*source).ServerType)
		schemaServer.IncludedTraffic = (*source).IncludedTraffic
		schemaServer.OutgoingTraffic = mapZeroUint64ToNil((*source).OutgoingTraffic)
		schemaServer.IngoingTraffic = mapZeroUint64ToNil((*source).IngoingTraffic)
		schemaServer.BackupWindow = mapEmptyStringToNil((*source).BackupWindow)
		schemaServer.RescueEnabled = (*source).RescueEnabled
		schemaServer.ISO = c.pHcloudISOToPSchemaISO((*source).ISO)
		schemaServer.Locked = (*source).Locked
		schemaServer.Datacenter = c.SchemaFromDatacenter((*source).Datacenter)
		schemaServer.Image = c.pHcloudImageToPSchemaImage((*source).Image)
		schemaServer.Protection = c.hcloudServerProtectionToSchemaServerProtection((*source).Protection)
		schemaServer.Labels = (*source).Labels
		if (*source).Volumes != nil {
			schemaServer.Volumes = make([]int64, len((*source).Volumes))
			for j := 0; j < len((*source).Volumes); j++ {
				schemaServer.Volumes[j] = int64FromVolume((*source).Volumes[j])
			}
		}
		schemaServer.PrimaryDiskSize = (*source).PrimaryDiskSize
		schemaServer.PlacementGroup = c.pHcloudPlacementGroupToPSchemaPlacementGroup((*source).PlacementGroup)
		if (*source).LoadBalancers != nil {
			schemaServer.LoadBalancers = make([]int64, len((*source).LoadBalancers))
			for k := 0; k < len((*source).LoadBalancers); k++ {
				schemaServer.LoadBalancers[k] = c.pHcloudLoadBalancerToInt64((*source).LoadBalancers[k])
			}
		}
	}
	return schemaServer
}
func (c *converterImpl) SchemaFromServerPrivateNet(source ServerPrivateNet) schema.ServerPrivateNet {
	var schemaServerPrivateNet schema.ServerPrivateNet
	schemaServerPrivateNet.Network = c.pHcloudNetworkToInt64(source.Network)
	schemaServerPrivateNet.IP = stringFromIP(source.IP)
	if source.Aliases != nil {
		schemaServerPrivateNet.AliasIPs = make([]string, len(source.Aliases))
		for i := 0; i < len(source.Aliases); i++ {
			schemaServerPrivateNet.AliasIPs[i] = stringFromIP(source.Aliases[i])
		}
	}
	schemaServerPrivateNet.MACAddress = source.MACAddress
	return schemaServerPrivateNet
}
func (c *converterImpl) SchemaFromServerPublicNet(source ServerPublicNet) schema.ServerPublicNet {
	var schemaServerPublicNet schema.ServerPublicNet
	schemaServerPublicNet.IPv4 = c.SchemaFromServerPublicNetIPv4(source.IPv4)
	schemaServerPublicNet.IPv6 = c.SchemaFromServerPublicNetIPv6(source.IPv6)
	if source.FloatingIPs != nil {
		schemaServerPublicNet.FloatingIPs = make([]int64, len(source.FloatingIPs))
		for i := 0; i < len(source.FloatingIPs); i++ {
			schemaServerPublicNet.FloatingIPs[i] = int64FromFloatingIP(source.FloatingIPs[i])
		}
	}
	if source.Firewalls != nil {
		schemaServerPublicNet.Firewalls = make([]schema.ServerFirewall, len(source.Firewalls))
		for j := 0; j < len(source.Firewalls); j++ {
			schemaServerPublicNet.Firewalls[j] = serverFirewallSchemaFromFirewallStatus(source.Firewalls[j])
		}
	}
	return schemaServerPublicNet
}
func (c *converterImpl) SchemaFromServerPublicNetIPv4(source ServerPublicNetIPv4) schema.ServerPublicNetIPv4 {
	var schemaServerPublicNetIPv4 schema.ServerPublicNetIPv4
	schemaServerPublicNetIPv4.ID = source.ID
	schemaServerPublicNetIPv4.IP = stringFromIP(source.IP)
	schemaServerPublicNetIPv4.Blocked = source.Blocked
	schemaServerPublicNetIPv4.DNSPtr = source.DNSPtr
	return schemaServerPublicNetIPv4
}
func (c *converterImpl) SchemaFromServerPublicNetIPv6(source ServerPublicNetIPv6) schema.ServerPublicNetIPv6 {
	var schemaServerPublicNetIPv6 schema.ServerPublicNetIPv6
	schemaServerPublicNetIPv6.ID = source.ID
	schemaServerPublicNetIPv6.IP = c.pNetIPNetToString(source.Network)
	schemaServerPublicNetIPv6.Blocked = source.Blocked
	schemaServerPublicNetIPv6.DNSPtr = serverPublicNetIPv6DNSPtrSchemaFromMap(source.DNSPtr)
	return schemaServerPublicNetIPv6
}
func (c *converterImpl) SchemaFromServerType(source *ServerType) schema.ServerType {
	var schemaServerType schema.ServerType
	if source != nil {
		schemaServerType.ID = (*source).ID
		schemaServerType.Name = (*source).Name
		schemaServerType.Description = (*source).Description
		schemaServerType.Category = (*source).Category
		schemaServerType.Cores = (*source).Cores
		schemaServerType.Memory = (*source).Memory
		schemaServerType.Disk = (*source).Disk
		schemaServerType.StorageType = string((*source).StorageType)
		schemaServerType.CPUType = string((*source).CPUType)
		schemaServerType.Architecture = string((*source).Architecture)
		schemaServerType.IncludedTraffic = (*source).IncludedTraffic
		if (*source).Pricings != nil {
			schemaServerType.Prices = make([]schema.PricingServerTypePrice, len((*source).Pricings))
			for i := 0; i < len((*source).Pricings); i++ {
				schemaServerType.Prices[i] = c.schemaFromServerTypeLocationPricing((*source).Pricings[i])
			}
		}
		schemaServerType.Deprecated = isDeprecationNotNil((*source).DeprecatableResource.Deprecation)
		schemaServerType.DeprecatableResource = c.hcloudDeprecatableResourceToSchemaDeprecatableResource((*source).DeprecatableResource)
		if (*source).Locations != nil {
			schemaServerType.Locations = make([]schema.ServerTypeLocation, len((*source).Locations))
			for j := 0; j < len((*source).Locations); j++ {
				schemaServerType.Locations[j] = c.schemaFromServerTypeLocation((*source).Locations[j])
			}
		}
	}
	return schemaServerType
}
func (c *converterImpl) SchemaFromStorageBox(source *StorageBox) schema.StorageBox {
	var schemaStorageBox schema.StorageBox
	if source != nil {
		schemaStorageBox.ID = (*source).ID
		pString := (*source).Username
		schemaStorageBox.Username = &pString
		schemaStorageBox.Status = string((*source).Status)
		schemaStorageBox.Name = (*source).Name
		schemaStorageBox.StorageBoxType = c.SchemaFromStorageBoxType((*source).StorageBoxType)
		schemaStorageBox.Location = c.SchemaFromLocation((*source).Location)
		schemaStorageBox.AccessSettings = c.hcloudStorageBoxAccessSettingsToSchemaStorageBoxAccessSettings((*source).AccessSettings)
		pString2 := (*source).Server
		schemaStorageBox.Server = &pString2
		pString3 := (*source).System
		schemaStorageBox.System = &pString3
		schemaStorageBox.Stats = c.hcloudStorageBoxStatsToSchemaStorageBoxStats((*source).Stats)
		schemaStorageBox.Labels = (*source).Labels
		schemaStorageBox.Protection = c.hcloudStorageBoxProtectionToSchemaStorageBoxProtection((*source).Protection)
		schemaStorageBox.SnapshotPlan = c.pHcloudStorageBoxSnapshotPlanToPSchemaStorageBoxSnapshotPlan((*source).SnapshotPlan)
		schemaStorageBox.Created = c.timeTimeToTimeTime((*source).Created)
	}
	return schemaStorageBox
}
func (c *converterImpl) SchemaFromStorageBoxChangeProtectionOpts(source StorageBoxChangeProtectionOpts) schema.StorageBoxChangeProtectionRequest {
	var schemaStorageBoxChangeProtectionRequest schema.StorageBoxChangeProtectionRequest
	schemaStorageBoxChangeProtectionRequest.Delete = source.Delete
	return schemaStorageBoxChangeProtectionRequest
}
func (c *converterImpl) SchemaFromStorageBoxChangeTypeOpts(source StorageBoxChangeTypeOpts) schema.StorageBoxChangeTypeRequest {
	var schemaStorageBoxChangeTypeRequest schema.StorageBoxChangeTypeRequest
	schemaStorageBoxChangeTypeRequest.StorageBoxType = c.pHcloudStorageBoxTypeToSchemaIDOrName(source.StorageBoxType)
	return schemaStorageBoxChangeTypeRequest
}
func (c *converterImpl) SchemaFromStorageBoxCreateOpts(source StorageBoxCreateOpts) schema.StorageBoxCreateRequest {
	var schemaStorageBoxCreateRequest schema.StorageBoxCreateRequest
	schemaStorageBoxCreateRequest.Name = source.Name
	schemaStorageBoxCreateRequest.StorageBoxType = c.pHcloudStorageBoxTypeToSchemaIDOrName(source.StorageBoxType)
	schemaStorageBoxCreateRequest.Location = c.pHcloudLocationToSchemaIDOrName(source.Location)
	schemaStorageBoxCreateRequest.Labels = stringMapToStringMapPtr(source.Labels)
	schemaStorageBoxCreateRequest.Password = source.Password
	schemaStorageBoxCreateRequest.SSHKeys = mapSSHKeyPtrSliceToPublicKeySlice(source.SSHKeys)
	schemaStorageBoxCreateRequest.AccessSettings = c.pHcloudStorageBoxCreateOptsAccessSettingsToPSchemaStorageBoxCreateRequestAccessSettings(source.AccessSettings)
	return schemaStorageBoxCreateRequest
}
func (c *converterImpl) SchemaFromStorageBoxEnableSnapshotPlanOpts(source StorageBoxEnableSnapshotPlanOpts) schema.StorageBoxEnableSnapshotPlanRequest {
	var schemaStorageBoxEnableSnapshotPlanRequest schema.StorageBoxEnableSnapshotPlanRequest
	schemaStorageBoxEnableSnapshotPlanRequest.MaxSnapshots = source.MaxSnapshots
	schemaStorageBoxEnableSnapshotPlanRequest.Minute = source.Minute
	schemaStorageBoxEnableSnapshotPlanRequest.Hour = source.Hour
	schemaStorageBoxEnableSnapshotPlanRequest.DayOfWeek = mapStorageBoxWeekdayPtrToIntPtr(source.DayOfWeek)
	schemaStorageBoxEnableSnapshotPlanRequest.DayOfMonth = source.DayOfMonth
	return schemaStorageBoxEnableSnapshotPlanRequest
}
func (c *converterImpl) SchemaFromStorageBoxResetPasswordOpts(source StorageBoxResetPasswordOpts) schema.StorageBoxResetPasswordRequest {
	var schemaStorageBoxResetPasswordRequest schema.StorageBoxResetPasswordRequest
	schemaStorageBoxResetPasswordRequest.Password = source.Password
	return schemaStorageBoxResetPasswordRequest
}
func (c *converterImpl) SchemaFromStorageBoxRollbackSnapshotOpts(source StorageBoxRollbackSnapshotOpts) schema.StorageBoxRollbackSnapshotRequest {
	var schemaStorageBoxRollbackSnapshotRequest schema.StorageBoxRollbackSnapshotRequest
	schemaStorageBoxRollbackSnapshotRequest.Snapshot = c.pHcloudStorageBoxSnapshotToSchemaIDOrName(source.Snapshot)
	return schemaStorageBoxRollbackSnapshotRequest
}
func (c *converterImpl) SchemaFromStorageBoxSnapshot(source *StorageBoxSnapshot) schema.StorageBoxSnapshot {
	var schemaStorageBoxSnapshot schema.StorageBoxSnapshot
	if source != nil {
		schemaStorageBoxSnapshot.ID = (*source).ID
		schemaStorageBoxSnapshot.Name = (*source).Name
		schemaStorageBoxSnapshot.Description = (*source).Description
		schemaStorageBoxSnapshot.Stats = c.hcloudStorageBoxSnapshotStatsToSchemaStorageBoxSnapshotStats((*source).Stats)
		schemaStorageBoxSnapshot.IsAutomatic = (*source).IsAutomatic
		schemaStorageBoxSnapshot.Labels = (*source).Labels
		schemaStorageBoxSnapshot.Created = c.timeTimeToTimeTime((*source).Created)
		schemaStorageBoxSnapshot.StorageBox = int64FromStorageBox((*source).StorageBox)
	}
	return schemaStorageBoxSnapshot
}
func (c *converterImpl) SchemaFromStorageBoxSnapshotCreateOpts(source StorageBoxSnapshotCreateOpts) schema.StorageBoxSnapshotCreateRequest {
	var schemaStorageBoxSnapshotCreateRequest schema.StorageBoxSnapshotCreateRequest
	schemaStorageBoxSnapshotCreateRequest.Description = source.Description
	schemaStorageBoxSnapshotCreateRequest.Labels = source.Labels
	return schemaStorageBoxSnapshotCreateRequest
}
func (c *converterImpl) SchemaFromStorageBoxSnapshotUpdateOpts(source StorageBoxSnapshotUpdateOpts) schema.StorageBoxSnapshotUpdateRequest {
	var schemaStorageBoxSnapshotUpdateRequest schema.StorageBoxSnapshotUpdateRequest
	schemaStorageBoxSnapshotUpdateRequest.Description = source.Description
	schemaStorageBoxSnapshotUpdateRequest.Labels = stringMapToStringMapPtr(source.Labels)
	return schemaStorageBoxSnapshotUpdateRequest
}
func (c *converterImpl) SchemaFromStorageBoxSubaccount(source *StorageBoxSubaccount) schema.StorageBoxSubaccount {
	var schemaStorageBoxSubaccount schema.StorageBoxSubaccount
	if source != nil {
		schemaStorageBoxSubaccount.ID = (*source).ID
		schemaStorageBoxSubaccount.Username = (*source).Username
		schemaStorageBoxSubaccount.HomeDirectory = (*source).HomeDirectory
		schemaStorageBoxSubaccount.Server = (*source).Server
		schemaStorageBoxSubaccount.AccessSettings = c.pHcloudStorageBoxSubaccountAccessSettingsToSchemaStorageBoxSubaccountAccessSettings((*source).AccessSettings)
		schemaStorageBoxSubaccount.Description = (*source).Description
		schemaStorageBoxSubaccount.Labels = (*source).Labels
		schemaStorageBoxSubaccount.Created = c.timeTimeToTimeTime((*source).Created)
		schemaStorageBoxSubaccount.StorageBox = int64FromStorageBox((*source).StorageBox)
	}
	return schemaStorageBoxSubaccount
}
func (c *converterImpl) SchemaFromStorageBoxSubaccountChangeHomeDirectoryOpts(source StorageBoxSubaccountChangeHomeDirectoryOpts) schema.StorageBoxSubaccountChangeHomeDirectoryRequest {
	var schemaStorageBoxSubaccountChangeHomeDirectoryRequest schema.StorageBoxSubaccountChangeHomeDirectoryRequest
	schemaStorageBoxSubaccountChangeHomeDirectoryRequest.HomeDirectory = source.HomeDirectory
	return schemaStorageBoxSubaccountChangeHomeDirectoryRequest
}
func (c *converterImpl) SchemaFromStorageBoxSubaccountCreateOpts(source StorageBoxSubaccountCreateOpts) schema.StorageBoxSubaccountCreateRequest {
	var schemaStorageBoxSubaccountCreateRequest schema.StorageBoxSubaccountCreateRequest
	schemaStorageBoxSubaccountCreateRequest.HomeDirectory = source.HomeDirectory
	schemaStorageBoxSubaccountCreateRequest.Password = source.Password
	schemaStorageBoxSubaccountCreateRequest.Description = source.Description
	schemaStorageBoxSubaccountCreateRequest.AccessSettings = c.pHcloudStorageBoxSubaccountCreateOptsAccessSettingsToPSchemaStorageBoxSubaccountCreateRequestAccessSettings(source.AccessSettings)
	schemaStorageBoxSubaccountCreateRequest.Labels = source.Labels
	return schemaStorageBoxSubaccountCreateRequest
}
func (c *converterImpl) SchemaFromStorageBoxSubaccountResetPasswordOpts(source StorageBoxSubaccountResetPasswordOpts) schema.StorageBoxSubaccountResetPasswordRequest {
	var schemaStorageBoxSubaccountResetPasswordRequest schema.StorageBoxSubaccountResetPasswordRequest
	schemaStorageBoxSubaccountResetPasswordRequest.Password = source.Password
	return schemaStorageBoxSubaccountResetPasswordRequest
}
func (c *converterImpl) SchemaFromStorageBoxSubaccountUpdateAccessSettingsOpts(source StorageBoxSubaccountUpdateAccessSettingsOpts) schema.StorageBoxSubaccountUpdateAccessSettingsRequest {
	var schemaStorageBoxSubaccountUpdateAccessSettingsRequest schema.StorageBoxSubaccountUpdateAccessSettingsRequest
	schemaStorageBoxSubaccountUpdateAccessSettingsRequest.ReachableExternally = source.ReachableExternally
	schemaStorageBoxSubaccountUpdateAccessSettingsRequest.Readonly = source.Readonly
	schemaStorageBoxSubaccountUpdateAccessSettingsRequest.SambaEnabled = source.SambaEnabled
	schemaStorageBoxSubaccountUpdateAccessSettingsRequest.SSHEnabled = source.SSHEnabled
	schemaStorageBoxSubaccountUpdateAccessSettingsRequest.WebDAVEnabled = source.WebDAVEnabled
	return schemaStorageBoxSubaccountUpdateAccessSettingsRequest
}
func (c *converterImpl) SchemaFromStorageBoxSubaccountUpdateOpts(source StorageBoxSubaccountUpdateOpts) schema.StorageBoxSubaccountUpdateRequest {
	var schemaStorageBoxSubaccountUpdateRequest schema.StorageBoxSubaccountUpdateRequest
	schemaStorageBoxSubaccountUpdateRequest.Description = source.Description
	schemaStorageBoxSubaccountUpdateRequest.Labels = stringMapToStringMapPtr(source.Labels)
	return schemaStorageBoxSubaccountUpdateRequest
}
func (c *converterImpl) SchemaFromStorageBoxType(source *StorageBoxType) schema.StorageBoxType {
	var schemaStorageBoxType schema.StorageBoxType
	if source != nil {
		schemaStorageBoxType.ID = (*source).ID
		schemaStorageBoxType.Name = (*source).Name
		schemaStorageBoxType.Description = (*source).Description
		schemaStorageBoxType.SnapshotLimit = (*source).SnapshotLimit
		schemaStorageBoxType.AutomaticSnapshotLimit = (*source).AutomaticSnapshotLimit
		schemaStorageBoxType.SubaccountsLimit = (*source).SubaccountsLimit
		schemaStorageBoxType.Size = (*source).Size
		if (*source).Pricings != nil {
			schemaStorageBoxType.Prices = make([]schema.StorageBoxTypePrice, len((*source).Pricings))
			for i := 0; i < len((*source).Pricings); i++ {
				schemaStorageBoxType.Prices[i] = c.hcloudStorageBoxTypeLocationPricingToSchemaStorageBoxTypePrice((*source).Pricings[i])
			}
		}
		schemaStorageBoxType.DeprecatableResource = c.hcloudDeprecatableResourceToSchemaDeprecatableResource((*source).DeprecatableResource)
	}
	return schemaStorageBoxType
}
func (c *converterImpl) SchemaFromStorageBoxUpdateAccessSettingsOpts(source StorageBoxUpdateAccessSettingsOpts) schema.StorageBoxUpdateAccessSettingsRequest {
	var schemaStorageBoxUpdateAccessSettingsRequest schema.StorageBoxUpdateAccessSettingsRequest
	schemaStorageBoxUpdateAccessSettingsRequest.ReachableExternally = source.ReachableExternally
	schemaStorageBoxUpdateAccessSettingsRequest.SambaEnabled = source.SambaEnabled
	schemaStorageBoxUpdateAccessSettingsRequest.SSHEnabled = source.SSHEnabled
	schemaStorageBoxUpdateAccessSettingsRequest.WebDAVEnabled = source.WebDAVEnabled
	schemaStorageBoxUpdateAccessSettingsRequest.ZFSEnabled = source.ZFSEnabled
	return schemaStorageBoxUpdateAccessSettingsRequest
}
func (c *converterImpl) SchemaFromStorageBoxUpdateOpts(source StorageBoxUpdateOpts) schema.StorageBoxUpdateRequest {
	var schemaStorageBoxUpdateRequest schema.StorageBoxUpdateRequest
	schemaStorageBoxUpdateRequest.Name = source.Name
	schemaStorageBoxUpdateRequest.Labels = stringMapToStringMapPtr(source.Labels)
	return schemaStorageBoxUpdateRequest
}
func (c *converterImpl) SchemaFromVolume(source *Volume) schema.Volume {
	var schemaVolume schema.Volume
	if source != nil {
		schemaVolume.ID = (*source).ID
		schemaVolume.Name = (*source).Name
		schemaVolume.Server = c.pHcloudServerToPInt64((*source).Server)
		schemaVolume.Status = string((*source).Status)
		schemaVolume.Location = c.SchemaFromLocation((*source).Location)
		schemaVolume.Size = (*source).Size
		schemaVolume.Format = (*source).Format
		schemaVolume.Protection = c.hcloudVolumeProtectionToSchemaVolumeProtection((*source).Protection)
		schemaVolume.Labels = (*source).Labels
		schemaVolume.LinuxDevice = (*source).LinuxDevice
		schemaVolume.Created = c.timeTimeToTimeTime((*source).Created)
	}
	return schemaVolume
}
func (c *converterImpl) SchemaFromZone(source *Zone) schema.Zone {
	var schemaZone schema.Zone
	if source != nil {
		schemaZone.ID = (*source).ID
		schemaZone.Name = (*source).Name
		schemaZone.Created = c.timeTimeToTimeTime((*source).Created)
		schemaZone.TTL = (*source).TTL
		schemaZone.Mode = string((*source).Mode)
		if (*source).PrimaryNameservers != nil {
			schemaZone.PrimaryNameservers = make([]schema.ZonePrimaryNameserver, len((*source).PrimaryNameservers))
			for i := 0; i < len((*source).PrimaryNameservers); i++ {
				schemaZone.PrimaryNameservers[i] = c.hcloudZonePrimaryNameserverToSchemaZonePrimaryNameserver((*source).PrimaryNameservers[i])
			}
		}
		schemaZone.Protection = c.hcloudZoneProtectionToSchemaZoneProtection((*source).Protection)
		schemaZone.Labels = (*source).Labels
		schemaZone.AuthoritativeNameservers = c.hcloudZoneAuthoritativeNameserversToSchemaZoneAuthoritativeNameservers((*source).AuthoritativeNameservers)
		schemaZone.Registrar = string((*source).Registrar)
		schemaZone.Status = string((*source).Status)
		schemaZone.RecordCount = (*source).RecordCount
	}
	return schemaZone
}
func (c *converterImpl) SchemaFromZoneChangePrimaryNameserversOpts(source ZoneChangePrimaryNameserversOpts) schema.ZoneChangePrimaryNameserversRequest {
	var schemaZoneChangePrimaryNameserversRequest schema.ZoneChangePrimaryNameserversRequest
	if source.PrimaryNameservers != nil {
		schemaZoneChangePrimaryNameserversRequest.PrimaryNameservers = make([]schema.ZoneChangePrimaryNameserversRequestPrimaryNameserver, len(source.PrimaryNameservers))
		for i := 0; i < len(source.PrimaryNameservers); i++ {
			schemaZoneChangePrimaryNameserversRequest.PrimaryNameservers[i] = c.hcloudZoneChangePrimaryNameserversOptsPrimaryNameserverToSchemaZoneChangePrimaryNameserversRequestPrimaryNameserver(source.PrimaryNameservers[i])
		}
	}
	return schemaZoneChangePrimaryNameserversRequest
}
func (c *converterImpl) SchemaFromZoneChangeProtectionOpts(source ZoneChangeProtectionOpts) schema.ZoneChangeProtectionRequest {
	var schemaZoneChangeProtectionRequest schema.ZoneChangeProtectionRequest
	schemaZoneChangeProtectionRequest.Delete = source.Delete
	return schemaZoneChangeProtectionRequest
}
func (c *converterImpl) SchemaFromZoneChangeTTLOpts(source ZoneChangeTTLOpts) schema.ZoneChangeTTLRequest {
	var schemaZoneChangeTTLRequest schema.ZoneChangeTTLRequest
	schemaZoneChangeTTLRequest.TTL = source.TTL
	return schemaZoneChangeTTLRequest
}
func (c *converterImpl) SchemaFromZoneCreateOpts(source ZoneCreateOpts) schema.ZoneCreateRequest {
	var schemaZoneCreateRequest schema.ZoneCreateRequest
	schemaZoneCreateRequest.Name = source.Name
	schemaZoneCreateRequest.Mode = string(source.Mode)
	schemaZoneCreateRequest.TTL = source.TTL
	schemaZoneCreateRequest.Labels = stringMapToStringMapPtr(source.Labels)
	if source.PrimaryNameservers != nil {
		schemaZoneCreateRequest.PrimaryNameservers = make([]schema.ZoneCreateRequestPrimaryNameserver, len(source.PrimaryNameservers))
		for i := 0; i < len(source.PrimaryNameservers); i++ {
			schemaZoneCreateRequest.PrimaryNameservers[i] = c.hcloudZoneCreateOptsPrimaryNameserverToSchemaZoneCreateRequestPrimaryNameserver(source.PrimaryNameservers[i])
		}
	}
	if source.RRSets != nil {
		schemaZoneCreateRequest.RRSets = make([]schema.ZoneCreateRequestRRSet, len(source.RRSets))
		for j := 0; j < len(source.RRSets); j++ {
			schemaZoneCreateRequest.RRSets[j] = c.hcloudZoneCreateOptsRRSetToSchemaZoneCreateRequestRRSet(source.RRSets[j])
		}
	}
	schemaZoneCreateRequest.Zonefile = source.Zonefile
	return schemaZoneCreateRequest
}
func (c *converterImpl) SchemaFromZoneImportZonefileOpts(source ZoneImportZonefileOpts) schema.ZoneImportZonefileRequest {
	var schemaZoneImportZonefileRequest schema.ZoneImportZonefileRequest
	schemaZoneImportZonefileRequest.Zonefile = source.Zonefile
	return schemaZoneImportZonefileRequest
}
func (c *converterImpl) SchemaFromZoneRRSet(source *ZoneRRSet) schema.ZoneRRSet {
	var schemaZoneRRSet schema.ZoneRRSet
	if source != nil {
		schemaZoneRRSet.ID = (*source).ID
		schemaZoneRRSet.Name = (*source).Name
		schemaZoneRRSet.Type = string((*source).Type)
		schemaZoneRRSet.TTL = (*source).TTL
		schemaZoneRRSet.Labels = (*source).Labels
		schemaZoneRRSet.Protection = c.hcloudZoneRRSetProtectionToSchemaZoneRRSetProtection((*source).Protection)
		if (*source).Records != nil {
			schemaZoneRRSet.Records = make([]schema.ZoneRRSetRecord, len((*source).Records))
			for i := 0; i < len((*source).Records); i++ {
				schemaZoneRRSet.Records[i] = c.hcloudZoneRRSetRecordToSchemaZoneRRSetRecord((*source).Records[i])
			}
		}
		schemaZoneRRSet.Zone = int64FromZone((*source).Zone)
	}
	return schemaZoneRRSet
}
func (c *converterImpl) SchemaFromZoneRRSetAddRecordsOpts(source ZoneRRSetAddRecordsOpts) schema.ZoneRRSetAddRecordsRequest {
	var schemaZoneRRSetAddRecordsRequest schema.ZoneRRSetAddRecordsRequest
	if source.Records != nil {
		schemaZoneRRSetAddRecordsRequest.Records = make([]schema.ZoneRRSetRecord, len(source.Records))
		for i := 0; i < len(source.Records); i++ {
			schemaZoneRRSetAddRecordsRequest.Records[i] = c.hcloudZoneRRSetRecordToSchemaZoneRRSetRecord(source.Records[i])
		}
	}
	schemaZoneRRSetAddRecordsRequest.TTL = source.TTL
	return schemaZoneRRSetAddRecordsRequest
}
func (c *converterImpl) SchemaFromZoneRRSetChangeProtectionOpts(source ZoneRRSetChangeProtectionOpts) schema.ZoneRRSetChangeProtectionRequest {
	var schemaZoneRRSetChangeProtectionRequest schema.ZoneRRSetChangeProtectionRequest
	schemaZoneRRSetChangeProtectionRequest.Change = source.Change
	return schemaZoneRRSetChangeProtectionRequest
}
func (c *converterImpl) SchemaFromZoneRRSetChangeTTLOpts(source ZoneRRSetChangeTTLOpts) schema.ZoneRRSetChangeTTLRequest {
	var schemaZoneRRSetChangeTTLRequest schema.ZoneRRSetChangeTTLRequest
	schemaZoneRRSetChangeTTLRequest.TTL = source.TTL
	return schemaZoneRRSetChangeTTLRequest
}
func (c *converterImpl) SchemaFromZoneRRSetCreateOpts(source ZoneRRSetCreateOpts) schema.ZoneRRSetCreateRequest {
	var schemaZoneRRSetCreateRequest schema.ZoneRRSetCreateRequest
	schemaZoneRRSetCreateRequest.Name = source.Name
	schemaZoneRRSetCreateRequest.Type = string(source.Type)
	schemaZoneRRSetCreateRequest.TTL = source.TTL
	schemaZoneRRSetCreateRequest.Labels = stringMapToStringMapPtr(source.Labels)
	if source.Records != nil {
		schemaZoneRRSetCreateRequest.Records = make([]schema.ZoneRRSetRecord, len(source.Records))
		for i := 0; i < len(source.Records); i++ {
			schemaZoneRRSetCreateRequest.Records[i] = c.hcloudZoneRRSetRecordToSchemaZoneRRSetRecord(source.Records[i])
		}
	}
	return schemaZoneRRSetCreateRequest
}
func (c *converterImpl) SchemaFromZoneRRSetRemoveRecordsOpts(source ZoneRRSetRemoveRecordsOpts) schema.ZoneRRSetRemoveRecordsRequest {
	var schemaZoneRRSetRemoveRecordsRequest schema.ZoneRRSetRemoveRecordsRequest
	if source.Records != nil {
		schemaZoneRRSetRemoveRecordsRequest.Records = make([]schema.ZoneRRSetRecord, len(source.Records))
		for i := 0; i < len(source.Records); i++ {
			schemaZoneRRSetRemoveRecordsRequest.Records[i] = c.hcloudZoneRRSetRecordToSchemaZoneRRSetRecord(source.Records[i])
		}
	}
	return schemaZoneRRSetRemoveRecordsRequest
}
func (c *converterImpl) SchemaFromZoneRRSetSetRecordsOpts(source ZoneRRSetSetRecordsOpts) schema.ZoneRRSetSetRecordsRequest {
	var schemaZoneRRSetSetRecordsRequest schema.ZoneRRSetSetRecordsRequest
	if source.Records != nil {
		schemaZoneRRSetSetRecordsRequest.Records = make([]schema.ZoneRRSetRecord, len(source.Records))
		for i := 0; i < len(source.Records); i++ {
			schemaZoneRRSetSetRecordsRequest.Records[i] = c.hcloudZoneRRSetRecordToSchemaZoneRRSetRecord(source.Records[i])
		}
	}
	return schemaZoneRRSetSetRecordsRequest
}
func (c *converterImpl) SchemaFromZoneRRSetUpdateOpts(source ZoneRRSetUpdateOpts) schema.ZoneRRSetUpdateRequest {
	var schemaZoneRRSetUpdateRequest schema.ZoneRRSetUpdateRequest
	schemaZoneRRSetUpdateRequest.Labels = stringMapToStringMapPtr(source.Labels)
	return schemaZoneRRSetUpdateRequest
}
func (c *converterImpl) SchemaFromZoneUpdateOpts(source ZoneUpdateOpts) schema.ZoneUpdateRequest {
	var schemaZoneUpdateRequest schema.ZoneUpdateRequest
	schemaZoneUpdateRequest.Labels = stringMapToStringMapPtr(source.Labels)
	return schemaZoneUpdateRequest
}
func (c *converterImpl) ServerFromSchema(source schema.Server) *Server {
	var hcloudServer Server
	hcloudServer.ID = source.ID
	hcloudServer.Name = source.Name
	hcloudServer.Status = ServerStatus(source.Status)
	hcloudServer.Created = c.timeTimeToTimeTime(source.Created)
	hcloudServer.PublicNet = c.ServerPublicNetFromSchema(source.PublicNet)
	if source.PrivateNet != nil {
		hcloudServer.PrivateNet = make([]ServerPrivateNet, len(source.PrivateNet))
		for i := 0; i < len(source.PrivateNet); i++ {
			hcloudServer.PrivateNet[i] = c.ServerPrivateNetFromSchema(source.PrivateNet[i])
		}
	}
	hcloudServer.ServerType = c.ServerTypeFromSchema(source.ServerType)
	hcloudServer.Datacenter = c.DatacenterFromSchema(source.Datacenter)
	hcloudServer.IncludedTraffic = source.IncludedTraffic
	if source.OutgoingTraffic != nil {
		hcloudServer.OutgoingTraffic = *source.OutgoingTraffic
	}
	if source.IngoingTraffic != nil {
		hcloudServer.IngoingTraffic = *source.IngoingTraffic
	}
	if source.BackupWindow != nil {
		hcloudServer.BackupWindow = *source.BackupWindow
	}
	hcloudServer.RescueEnabled = source.RescueEnabled
	hcloudServer.Locked = source.Locked
	hcloudServer.ISO = c.pSchemaISOToPHcloudISO(source.ISO)
	hcloudServer.Image = c.pSchemaImageToPHcloudImage(source.Image)
	hcloudServer.Protection = c.schemaServerProtectionToHcloudServerProtection(source.Protection)
	hcloudServer.Labels = source.Labels
	if source.Volumes != nil {
		hcloudServer.Volumes = make([]*Volume, len(source.Volumes))
		for j := 0; j < len(source.Volumes); j++ {
			hcloudServer.Volumes[j] = volumeFromInt64(source.Volumes[j])
		}
	}
	hcloudServer.PrimaryDiskSize = source.PrimaryDiskSize
	hcloudServer.PlacementGroup = c.pSchemaPlacementGroupToPHcloudPlacementGroup(source.PlacementGroup)
	if source.LoadBalancers != nil {
		hcloudServer.LoadBalancers = make([]*LoadBalancer, len(source.LoadBalancers))
		for k := 0; k < len(source.LoadBalancers); k++ {
			hcloudLoadBalancer := loadBalancerFromInt64(source.LoadBalancers[k])
			hcloudServer.LoadBalancers[k] = &hcloudLoadBalancer
		}
	}
	return &hcloudServer
}
func (c *converterImpl) ServerMetricsFromSchema(source *schema.ServerGetMetricsResponse) (*ServerMetrics, error) {
	var pHcloudServerMetrics *ServerMetrics
	if source != nil {
		var hcloudServerMetrics ServerMetrics
		hcloudServerMetrics.Start = c.timeTimeToTimeTime((*source).Metrics.Start)
		hcloudServerMetrics.End = c.timeTimeToTimeTime((*source).Metrics.End)
		hcloudServerMetrics.Step = (*source).Metrics.Step
		if (*source).Metrics.TimeSeries != nil {
			hcloudServerMetrics.TimeSeries = make(map[string][]ServerMetricsValue, len((*source).Metrics.TimeSeries))
			for key, value := range (*source).Metrics.TimeSeries {
				hcloudServerMetricsValueList, err := serverMetricsTimeSeriesFromSchema(value)
				if err != nil {
					return nil, err
				}
				hcloudServerMetrics.TimeSeries[key] = hcloudServerMetricsValueList
			}
		}
		pHcloudServerMetrics = &hcloudServerMetrics
	}
	return pHcloudServerMetrics, nil
}
func (c *converterImpl) ServerPrivateNetFromSchema(source schema.ServerPrivateNet) ServerPrivateNet {
	var hcloudServerPrivateNet ServerPrivateNet
	hcloudNetwork := networkFromInt64(source.Network)
	hcloudServerPrivateNet.Network = &hcloudNetwork
	hcloudServerPrivateNet.IP = ipFromString(source.IP)
	if source.AliasIPs != nil {
		hcloudServerPrivateNet.Aliases = make([]net.IP, len(source.AliasIPs))
		for i := 0; i < len(source.AliasIPs); i++ {
			hcloudServerPrivateNet.Aliases[i] = ipFromString(source.AliasIPs[i])
		}
	}
	hcloudServerPrivateNet.MACAddress = source.MACAddress
	return hcloudServerPrivateNet
}
func (c *converterImpl) ServerPublicNetFromSchema(source schema.ServerPublicNet) ServerPublicNet {
	var hcloudServerPublicNet ServerPublicNet
	hcloudServerPublicNet.IPv4 = c.ServerPublicNetIPv4FromSchema(source.IPv4)
	hcloudServerPublicNet.IPv6 = c.ServerPublicNetIPv6FromSchema(source.IPv6)
	if source.FloatingIPs != nil {
		hcloudServerPublicNet.FloatingIPs = make([]*FloatingIP, len(source.FloatingIPs))
		for i := 0; i < len(source.FloatingIPs); i++ {
			hcloudServerPublicNet.FloatingIPs[i] = floatingIPFromInt64(source.FloatingIPs[i])
		}
	}
	if source.Firewalls != nil {
		hcloudServerPublicNet.Firewalls = make([]*ServerFirewallStatus, len(source.Firewalls))
		for j := 0; j < len(source.Firewalls); j++ {
			hcloudServerPublicNet.Firewalls[j] = firewallStatusFromSchemaServerFirewall(source.Firewalls[j])
		}
	}
	return hcloudServerPublicNet
}
func (c *converterImpl) ServerPublicNetIPv4FromSchema(source schema.ServerPublicNetIPv4) ServerPublicNetIPv4 {
	var hcloudServerPublicNetIPv4 ServerPublicNetIPv4
	hcloudServerPublicNetIPv4.ID = source.ID
	hcloudServerPublicNetIPv4.IP = ipFromString(source.IP)
	hcloudServerPublicNetIPv4.Blocked = source.Blocked
	hcloudServerPublicNetIPv4.DNSPtr = source.DNSPtr
	return hcloudServerPublicNetIPv4
}
func (c *converterImpl) ServerPublicNetIPv6FromSchema(source schema.ServerPublicNetIPv6) ServerPublicNetIPv6 {
	var hcloudServerPublicNetIPv6 ServerPublicNetIPv6
	hcloudServerPublicNetIPv6.ID = source.ID
	hcloudServerPublicNetIPv6.IP = ipFromServerPublicNetIPv6Schema(source)
	hcloudServerPublicNetIPv6.Network = ipNetFromServerPublicNetIPv6Schema(source)
	hcloudServerPublicNetIPv6.Blocked = source.Blocked
	hcloudServerPublicNetIPv6.DNSPtr = mapFromServerPublicNetIPv6DNSPtrSchema(source.DNSPtr)
	return hcloudServerPublicNetIPv6
}
func (c *converterImpl) ServerTypeFromSchema(source schema.ServerType) *ServerType {
	var hcloudServerType ServerType
	hcloudServerType.ID = source.ID
	hcloudServerType.Name = source.Name
	hcloudServerType.Description = source.Description
	hcloudServerType.Category = source.Category
	hcloudServerType.Cores = source.Cores
	hcloudServerType.Memory = source.Memory
	hcloudServerType.Disk = source.Disk
	hcloudServerType.StorageType = StorageType(source.StorageType)
	hcloudServerType.CPUType = CPUType(source.CPUType)
	hcloudServerType.Architecture = Architecture(source.Architecture)
	hcloudServerType.IncludedTraffic = source.IncludedTraffic
	if source.Prices != nil {
		hcloudServerType.Pricings = make([]ServerTypeLocationPricing, len(source.Prices))
		for i := 0; i < len(source.Prices); i++ {
			hcloudServerType.Pricings[i] = c.serverTypePricingFromSchema(source.Prices[i])
		}
	}
	hcloudServerType.DeprecatableResource = c.schemaDeprecatableResourceToHcloudDeprecatableResource(source.DeprecatableResource)
	if source.Locations != nil {
		hcloudServerType.Locations = make([]ServerTypeLocation, len(source.Locations))
		for j := 0; j < len(source.Locations); j++ {
			hcloudServerType.Locations[j] = c.serverTypeLocationFromSchema(source.Locations[j])
		}
	}
	return &hcloudServerType
}
func (c *converterImpl) StorageBoxFromSchema(source schema.StorageBox) *StorageBox {
	var hcloudStorageBox StorageBox
	hcloudStorageBox.ID = source.ID
	if source.Username != nil {
		hcloudStorageBox.Username = *source.Username
	}
	hcloudStorageBox.Status = StorageBoxStatus(source.Status)
	hcloudStorageBox.Name = source.Name
	hcloudStorageBox.StorageBoxType = c.StorageBoxTypeFromSchema(source.StorageBoxType)
	hcloudStorageBox.Location = c.LocationFromSchema(source.Location)
	hcloudStorageBox.AccessSettings = c.schemaStorageBoxAccessSettingsToHcloudStorageBoxAccessSettings(source.AccessSettings)
	if source.Server != nil {
		hcloudStorageBox.Server = *source.Server
	}
	if source.System != nil {
		hcloudStorageBox.System = *source.System
	}
	hcloudStorageBox.Stats = c.schemaStorageBoxStatsToHcloudStorageBoxStats(source.Stats)
	hcloudStorageBox.Labels = source.Labels
	hcloudStorageBox.Protection = c.schemaStorageBoxProtectionToHcloudStorageBoxProtection(source.Protection)
	hcloudStorageBox.SnapshotPlan = c.pSchemaStorageBoxSnapshotPlanToPHcloudStorageBoxSnapshotPlan(source.SnapshotPlan)
	hcloudStorageBox.Created = c.timeTimeToTimeTime(source.Created)
	return &hcloudStorageBox
}
func (c *converterImpl) StorageBoxSnapshotFromSchema(source schema.StorageBoxSnapshot) *StorageBoxSnapshot {
	var hcloudStorageBoxSnapshot StorageBoxSnapshot
	hcloudStorageBoxSnapshot.ID = source.ID
	hcloudStorageBoxSnapshot.Name = source.Name
	hcloudStorageBoxSnapshot.Description = source.Description
	hcloudStorageBoxSnapshot.Stats = c.schemaStorageBoxSnapshotStatsToHcloudStorageBoxSnapshotStats(source.Stats)
	hcloudStorageBoxSnapshot.IsAutomatic = source.IsAutomatic
	hcloudStorageBoxSnapshot.Labels = source.Labels
	hcloudStorageBoxSnapshot.Created = c.timeTimeToTimeTime(source.Created)
	hcloudStorageBoxSnapshot.StorageBox = storageBoxFromInt64(source.StorageBox)
	return &hcloudStorageBoxSnapshot
}
func (c *converterImpl) StorageBoxSnapshotPlanFromSchema(source schema.StorageBoxSnapshotPlan) StorageBoxSnapshotPlan {
	var hcloudStorageBoxSnapshotPlan StorageBoxSnapshotPlan
	hcloudStorageBoxSnapshotPlan.MaxSnapshots = source.MaxSnapshots
	hcloudStorageBoxSnapshotPlan.Minute = source.Minute
	hcloudStorageBoxSnapshotPlan.Hour = source.Hour
	hcloudStorageBoxSnapshotPlan.DayOfWeek = mapStorageBoxIntPtrToWeekdayPtr(source.DayOfWeek)
	hcloudStorageBoxSnapshotPlan.DayOfMonth = source.DayOfMonth
	return hcloudStorageBoxSnapshotPlan
}
func (c *converterImpl) StorageBoxSubaccountFromCreateResponse(source schema.StorageBoxSubaccountCreateResponseSubaccount) *StorageBoxSubaccount {
	var hcloudStorageBoxSubaccount StorageBoxSubaccount
	hcloudStorageBoxSubaccount.ID = source.ID
	hcloudStorageBoxSubaccount.StorageBox = storageBoxFromInt64(source.StorageBox)
	return &hcloudStorageBoxSubaccount
}
func (c *converterImpl) StorageBoxSubaccountFromSchema(source schema.StorageBoxSubaccount) *StorageBoxSubaccount {
	var hcloudStorageBoxSubaccount StorageBoxSubaccount
	hcloudStorageBoxSubaccount.ID = source.ID
	hcloudStorageBoxSubaccount.Username = source.Username
	hcloudStorageBoxSubaccount.HomeDirectory = source.HomeDirectory
	hcloudStorageBoxSubaccount.Server = source.Server
	hcloudStorageBoxSubaccount.AccessSettings = c.schemaStorageBoxSubaccountAccessSettingsToPHcloudStorageBoxSubaccountAccessSettings(source.AccessSettings)
	hcloudStorageBoxSubaccount.Description = source.Description
	hcloudStorageBoxSubaccount.Labels = source.Labels
	hcloudStorageBoxSubaccount.Created = c.timeTimeToTimeTime(source.Created)
	hcloudStorageBoxSubaccount.StorageBox = storageBoxFromInt64(source.StorageBox)
	return &hcloudStorageBoxSubaccount
}
func (c *converterImpl) StorageBoxTypeFromSchema(source schema.StorageBoxType) *StorageBoxType {
	var hcloudStorageBoxType StorageBoxType
	hcloudStorageBoxType.ID = source.ID
	hcloudStorageBoxType.Name = source.Name
	hcloudStorageBoxType.Description = source.Description
	hcloudStorageBoxType.SnapshotLimit = source.SnapshotLimit
	hcloudStorageBoxType.AutomaticSnapshotLimit = source.AutomaticSnapshotLimit
	hcloudStorageBoxType.SubaccountsLimit = source.SubaccountsLimit
	hcloudStorageBoxType.Size = source.Size
	if source.Prices != nil {
		hcloudStorageBoxType.Pricings = make([]StorageBoxTypeLocationPricing, len(source.Prices))
		for i := 0; i < len(source.Prices); i++ {
			hcloudStorageBoxType.Pricings[i] = c.schemaStorageBoxTypePriceToHcloudStorageBoxTypeLocationPricing(source.Prices[i])
		}
	}
	hcloudStorageBoxType.DeprecatableResource = c.schemaDeprecatableResourceToHcloudDeprecatableResource(source.DeprecatableResource)
	return &hcloudStorageBoxType
}
func (c *converterImpl) VolumeFromSchema(source schema.Volume) *Volume {
	var hcloudVolume Volume
	hcloudVolume.ID = source.ID
	hcloudVolume.Name = source.Name
	hcloudVolume.Status = VolumeStatus(source.Status)
	if source.Server != nil {
		hcloudServer := serverFromInt64(*source.Server)
		hcloudVolume.Server = &hcloudServer
	}
	hcloudVolume.Location = c.LocationFromSchema(source.Location)
	hcloudVolume.Size = source.Size
	hcloudVolume.Format = source.Format
	hcloudVolume.Protection = c.schemaVolumeProtectionToHcloudVolumeProtection(source.Protection)
	hcloudVolume.Labels = source.Labels
	hcloudVolume.LinuxDevice = source.LinuxDevice
	hcloudVolume.Created = c.timeTimeToTimeTime(source.Created)
	return &hcloudVolume
}
func (c *converterImpl) ZoneFromSchema(source schema.Zone) *Zone {
	var hcloudZone Zone
	hcloudZone.ID = source.ID
	hcloudZone.Name = source.Name
	hcloudZone.Created = c.timeTimeToTimeTime(source.Created)
	hcloudZone.TTL = source.TTL
	hcloudZone.Mode = ZoneMode(source.Mode)
	if source.PrimaryNameservers != nil {
		hcloudZone.PrimaryNameservers = make([]ZonePrimaryNameserver, len(source.PrimaryNameservers))
		for i := 0; i < len(source.PrimaryNameservers); i++ {
			hcloudZone.PrimaryNameservers[i] = c.schemaZonePrimaryNameserverToHcloudZonePrimaryNameserver(source.PrimaryNameservers[i])
		}
	}
	hcloudZone.Protection = c.schemaZoneProtectionToHcloudZoneProtection(source.Protection)
	hcloudZone.Labels = source.Labels
	hcloudZone.RecordCount = source.RecordCount
	hcloudZone.AuthoritativeNameservers = c.schemaZoneAuthoritativeNameserversToHcloudZoneAuthoritativeNameservers(source.AuthoritativeNameservers)
	hcloudZone.Registrar = ZoneRegistrar(source.Registrar)
	hcloudZone.Status = ZoneStatus(source.Status)
	return &hcloudZone
}
func (c *converterImpl) ZoneRRSetFromSchema(source schema.ZoneRRSet) *ZoneRRSet {
	var hcloudZoneRRSet ZoneRRSet
	hcloudZoneRRSet.Zone = zoneFromInt64(source.Zone)
	hcloudZoneRRSet.ID = source.ID
	hcloudZoneRRSet.Name = source.Name
	hcloudZoneRRSet.Type = ZoneRRSetType(source.Type)
	hcloudZoneRRSet.TTL = source.TTL
	hcloudZoneRRSet.Labels = source.Labels
	if source.Records != nil {
		hcloudZoneRRSet.Records = make([]ZoneRRSetRecord, len(source.Records))
		for i := 0; i < len(source.Records); i++ {
			hcloudZoneRRSet.Records[i] = c.schemaZoneRRSetRecordToHcloudZoneRRSetRecord(source.Records[i])
		}
	}
	hcloudZoneRRSet.Protection = c.schemaZoneRRSetProtectionToHcloudZoneRRSetProtection(source.Protection)
	return &hcloudZoneRRSet
}
func (c *converterImpl) ZoneRRSetRecordFromSchema(source schema.ZoneRRSetRecord) *ZoneRRSetRecord {
	hcloudZoneRRSetRecord := c.schemaZoneRRSetRecordToHcloudZoneRRSetRecord(source)
	return &hcloudZoneRRSetRecord
}
func (c *converterImpl) hcloudCertificateStatusTypeToString(source CertificateStatusType) string {
	return string(source)
}
func (c *converterImpl) hcloudCertificateUsedByRefToSchemaCertificateUsedByRef(source CertificateUsedByRef) schema.CertificateUsedByRef {
	var schemaCertificateUsedByRef schema.CertificateUsedByRef
	schemaCertificateUsedByRef.ID = source.ID
	schemaCertificateUsedByRef.Type = string(source.Type)
	return schemaCertificateUsedByRef
}
func (c *converterImpl) hcloudDatacenterServerTypesToSchemaDatacenterServerTypes(source DatacenterServerTypes) schema.DatacenterServerTypes {
	var schemaDatacenterServerTypes schema.DatacenterServerTypes
	if source.Supported != nil {
		schemaDatacenterServerTypes.Supported = make([]int64, len(source.Supported))
		for i := 0; i < len(source.Supported); i++ {
			schemaDatacenterServerTypes.Supported[i] = int64FromServerType(source.Supported[i])
		}
	}
	if source.AvailableForMigration != nil {
		schemaDatacenterServerTypes.AvailableForMigration = make([]int64, len(source.AvailableForMigration))
		for j := 0; j < len(source.AvailableForMigration); j++ {
			schemaDatacenterServerTypes.AvailableForMigration[j] = int64FromServerType(source.AvailableForMigration[j])
		}
	}
	if source.Available != nil {
		schemaDatacenterServerTypes.Available = make([]int64, len(source.Available))
		for k := 0; k < len(source.Available); k++ {
			schemaDatacenterServerTypes.Available[k] = int64FromServerType(source.Available[k])
		}
	}
	return schemaDatacenterServerTypes
}
func (c *converterImpl) hcloudDeprecatableResourceToSchemaDeprecatableResource(source DeprecatableResource) schema.DeprecatableResource {
	var schemaDeprecatableResource schema.DeprecatableResource
	schemaDeprecatableResource.Deprecation = c.SchemaFromDeprecation(source.Deprecation)
	return schemaDeprecatableResource
}
func (c *converterImpl) hcloudFirewallRuleToSchemaFirewallRule(source FirewallRule) schema.FirewallRule {
	var schemaFirewallRule schema.FirewallRule
	schemaFirewallRule.Direction = string(source.Direction)
	if source.SourceIPs != nil {
		schemaFirewallRule.SourceIPs = make([]string, len(source.SourceIPs))
		for i := 0; i < len(source.SourceIPs); i++ {
			schemaFirewallRule.SourceIPs[i] = stringFromIPNet(source.SourceIPs[i])
		}
	}
	if source.DestinationIPs != nil {
		schemaFirewallRule.DestinationIPs = make([]string, len(source.DestinationIPs))
		for j := 0; j < len(source.DestinationIPs); j++ {
			schemaFirewallRule.DestinationIPs[j] = stringFromIPNet(source.DestinationIPs[j])
		}
	}
	schemaFirewallRule.Protocol = string(source.Protocol)
	schemaFirewallRule.Port = source.Port
	schemaFirewallRule.Description = source.Description
	return schemaFirewallRule
}
func (c *converterImpl) hcloudFirewallRuleToSchemaFirewallRuleRequest(source FirewallRule) schema.FirewallRuleRequest {
	var schemaFirewallRuleRequest schema.FirewallRuleRequest
	schemaFirewallRuleRequest.Direction = string(source.Direction)
	if source.SourceIPs != nil {
		schemaFirewallRuleRequest.SourceIPs = make([]string, len(source.SourceIPs))
		for i := 0; i < len(source.SourceIPs); i++ {
			schemaFirewallRuleRequest.SourceIPs[i] = stringFromIPNet(source.SourceIPs[i])
		}
	}
	if source.DestinationIPs != nil {
		schemaFirewallRuleRequest.DestinationIPs = make([]string, len(source.DestinationIPs))
		for j := 0; j < len(source.DestinationIPs); j++ {
			schemaFirewallRuleRequest.DestinationIPs[j] = stringFromIPNet(source.DestinationIPs[j])
		}
	}
	schemaFirewallRuleRequest.Protocol = string(source.Protocol)
	schemaFirewallRuleRequest.Port = source.Port
	schemaFirewallRuleRequest.Description = source.Description
	return schemaFirewallRuleRequest
}
func (c *converterImpl) hcloudFloatingIPProtectionToSchemaFloatingIPProtection(source FloatingIPProtection) schema.FloatingIPProtection {
	var schemaFloatingIPProtection schema.FloatingIPProtection
	schemaFloatingIPProtection.Delete = source.Delete
	return schemaFloatingIPProtection
}
func (c *converterImpl) hcloudImageProtectionToSchemaImageProtection(source ImageProtection) schema.ImageProtection {
	var schemaImageProtection schema.ImageProtection
	schemaImageProtection.Delete = source.Delete
	return schemaImageProtection
}
func (c *converterImpl) hcloudLoadBalancerAlgorithmToSchemaLoadBalancerAlgorithm(source LoadBalancerAlgorithm) schema.LoadBalancerAlgorithm {
	var schemaLoadBalancerAlgorithm schema.LoadBalancerAlgorithm
	schemaLoadBalancerAlgorithm.Type = string(source.Type)
	return schemaLoadBalancerAlgorithm
}
func (c *converterImpl) hcloudLoadBalancerCreateOptsServiceToSchemaLoadBalancerCreateRequestService(source LoadBalancerCreateOptsService) schema.LoadBalancerCreateRequestService {
	var schemaLoadBalancerCreateRequestService schema.LoadBalancerCreateRequestService
	schemaLoadBalancerCreateRequestService.Protocol = string(source.Protocol)
	schemaLoadBalancerCreateRequestService.ListenPort = source.ListenPort
	schemaLoadBalancerCreateRequestService.DestinationPort = source.DestinationPort
	schemaLoadBalancerCreateRequestService.Proxyprotocol = source.Proxyprotocol
	schemaLoadBalancerCreateRequestService.HTTP = c.pHcloudLoadBalancerCreateOptsServiceHTTPToPSchemaLoadBalancerCreateRequestServiceHTTP(source.HTTP)
	schemaLoadBalancerCreateRequestService.HealthCheck = c.pHcloudLoadBalancerCreateOptsServiceHealthCheckToPSchemaLoadBalancerCreateRequestServiceHealthCheck(source.HealthCheck)
	return schemaLoadBalancerCreateRequestService
}
func (c *converterImpl) hcloudLoadBalancerCreateOptsTargetToSchemaLoadBalancerCreateRequestTarget(source LoadBalancerCreateOptsTarget) schema.LoadBalancerCreateRequestTarget {
	var schemaLoadBalancerCreateRequestTarget schema.LoadBalancerCreateRequestTarget
	schemaLoadBalancerCreateRequestTarget.Type = string(source.Type)
	schemaLoadBalancerCreateRequestTarget.Server = schemaFromLoadBalancerCreateOptsTargetServer(source.Server)
	schemaLoadBalancerCreateRequestTarget.LabelSelector = schemaFromLoadBalancerCreateOptsTargetLabelSelector(source.LabelSelector)
	schemaLoadBalancerCreateRequestTarget.IP = schemaFromLoadBalancerCreateOptsTargetIP(source.IP)
	schemaLoadBalancerCreateRequestTarget.UsePrivateIP = source.UsePrivateIP
	return schemaLoadBalancerCreateRequestTarget
}
func (c *converterImpl) hcloudLoadBalancerPrivateNetToSchemaLoadBalancerPrivateNet(source LoadBalancerPrivateNet) schema.LoadBalancerPrivateNet {
	var schemaLoadBalancerPrivateNet schema.LoadBalancerPrivateNet
	schemaLoadBalancerPrivateNet.Network = c.pHcloudNetworkToInt64(source.Network)
	schemaLoadBalancerPrivateNet.IP = stringFromIP(source.IP)
	return schemaLoadBalancerPrivateNet
}
func (c *converterImpl) hcloudLoadBalancerProtectionToSchemaLoadBalancerProtection(source LoadBalancerProtection) schema.LoadBalancerProtection {
	var schemaLoadBalancerProtection schema.LoadBalancerProtection
	schemaLoadBalancerProtection.Delete = source.Delete
	return schemaLoadBalancerProtection
}
func (c *converterImpl) hcloudLoadBalancerPublicNetIPv4ToSchemaLoadBalancerPublicNetIPv4(source LoadBalancerPublicNetIPv4) schema.LoadBalancerPublicNetIPv4 {
	var schemaLoadBalancerPublicNetIPv4 schema.LoadBalancerPublicNetIPv4
	schemaLoadBalancerPublicNetIPv4.IP = stringFromIP(source.IP)
	schemaLoadBalancerPublicNetIPv4.DNSPtr = source.DNSPtr
	return schemaLoadBalancerPublicNetIPv4
}
func (c *converterImpl) hcloudLoadBalancerPublicNetIPv6ToSchemaLoadBalancerPublicNetIPv6(source LoadBalancerPublicNetIPv6) schema.LoadBalancerPublicNetIPv6 {
	var schemaLoadBalancerPublicNetIPv6 schema.LoadBalancerPublicNetIPv6
	schemaLoadBalancerPublicNetIPv6.IP = stringFromIP(source.IP)
	schemaLoadBalancerPublicNetIPv6.DNSPtr = source.DNSPtr
	return schemaLoadBalancerPublicNetIPv6
}
func (c *converterImpl) hcloudLoadBalancerPublicNetToSchemaLoadBalancerPublicNet(source LoadBalancerPublicNet) schema.LoadBalancerPublicNet {
	var schemaLoadBalancerPublicNet schema.LoadBalancerPublicNet
	schemaLoadBalancerPublicNet.Enabled = source.Enabled
	schemaLoadBalancerPublicNet.IPv4 = c.hcloudLoadBalancerPublicNetIPv4ToSchemaLoadBalancerPublicNetIPv4(source.IPv4)
	schemaLoadBalancerPublicNet.IPv6 = c.hcloudLoadBalancerPublicNetIPv6ToSchemaLoadBalancerPublicNetIPv6(source.IPv6)
	return schemaLoadBalancerPublicNet
}
func (c *converterImpl) hcloudLoadBalancerServiceHTTPToPSchemaLoadBalancerServiceHTTP(source LoadBalancerServiceHTTP) *schema.LoadBalancerServiceHTTP {
	var schemaLoadBalancerServiceHTTP schema.LoadBalancerServiceHTTP
	schemaLoadBalancerServiceHTTP.CookieName = source.CookieName
	schemaLoadBalancerServiceHTTP.CookieLifetime = intSecondsFromDuration(source.CookieLifetime)
	if source.Certificates != nil {
		schemaLoadBalancerServiceHTTP.Certificates = make([]int64, len(source.Certificates))
		for i := 0; i < len(source.Certificates); i++ {
			schemaLoadBalancerServiceHTTP.Certificates[i] = int64FromCertificate(source.Certificates[i])
		}
	}
	schemaLoadBalancerServiceHTTP.RedirectHTTP = source.RedirectHTTP
	schemaLoadBalancerServiceHTTP.StickySessions = source.StickySessions
	return &schemaLoadBalancerServiceHTTP
}
func (c *converterImpl) hcloudNetworkProtectionToSchemaNetworkProtection(source NetworkProtection) schema.NetworkProtection {
	var schemaNetworkProtection schema.NetworkProtection
	schemaNetworkProtection.Delete = source.Delete
	return schemaNetworkProtection
}
func (c *converterImpl) hcloudPriceToSchemaPrice(source Price) schema.Price {
	var schemaPrice schema.Price
	schemaPrice.Net = source.Net
	schemaPrice.Gross = source.Gross
	return schemaPrice
}
func (c *converterImpl) hcloudPrimaryIPPriceToSchemaPrice(source PrimaryIPPrice) schema.Price {
	var schemaPrice schema.Price
	schemaPrice.Net = source.Net
	schemaPrice.Gross = source.Gross
	return schemaPrice
}
func (c *converterImpl) hcloudPrimaryIPProtectionToSchemaPrimaryIPProtection(source PrimaryIPProtection) schema.PrimaryIPProtection {
	var schemaPrimaryIPProtection schema.PrimaryIPProtection
	schemaPrimaryIPProtection.Delete = source.Delete
	return schemaPrimaryIPProtection
}
func (c *converterImpl) hcloudServerBackupPricingToSchemaPricingServerBackup(source ServerBackupPricing) schema.PricingServerBackup {
	var schemaPricingServerBackup schema.PricingServerBackup
	schemaPricingServerBackup.Percentage = source.Percentage
	return schemaPricingServerBackup
}
func (c *converterImpl) hcloudServerProtectionToSchemaServerProtection(source ServerProtection) schema.ServerProtection {
	var schemaServerProtection schema.ServerProtection
	schemaServerProtection.Delete = source.Delete
	schemaServerProtection.Rebuild = source.Rebuild
	return schemaServerProtection
}
func (c *converterImpl) hcloudStorageBoxAccessSettingsToSchemaStorageBoxAccessSettings(source StorageBoxAccessSettings) schema.StorageBoxAccessSettings {
	var schemaStorageBoxAccessSettings schema.StorageBoxAccessSettings
	schemaStorageBoxAccessSettings.ReachableExternally = source.ReachableExternally
	schemaStorageBoxAccessSettings.SambaEnabled = source.SambaEnabled
	schemaStorageBoxAccessSettings.SSHEnabled = source.SSHEnabled
	schemaStorageBoxAccessSettings.WebDAVEnabled = source.WebDAVEnabled
	schemaStorageBoxAccessSettings.ZFSEnabled = source.ZFSEnabled
	return schemaStorageBoxAccessSettings
}
func (c *converterImpl) hcloudStorageBoxProtectionToSchemaStorageBoxProtection(source StorageBoxProtection) schema.StorageBoxProtection {
	var schemaStorageBoxProtection schema.StorageBoxProtection
	schemaStorageBoxProtection.Delete = source.Delete
	return schemaStorageBoxProtection
}
func (c *converterImpl) hcloudStorageBoxSnapshotStatsToSchemaStorageBoxSnapshotStats(source StorageBoxSnapshotStats) schema.StorageBoxSnapshotStats {
	var schemaStorageBoxSnapshotStats schema.StorageBoxSnapshotStats
	schemaStorageBoxSnapshotStats.Size = source.Size
	schemaStorageBoxSnapshotStats.SizeFilesystem = source.SizeFilesystem
	return schemaStorageBoxSnapshotStats
}
func (c *converterImpl) hcloudStorageBoxStatsToSchemaStorageBoxStats(source StorageBoxStats) schema.StorageBoxStats {
	var schemaStorageBoxStats schema.StorageBoxStats
	schemaStorageBoxStats.Size = source.Size
	schemaStorageBoxStats.SizeData = source.SizeData
	schemaStorageBoxStats.SizeSnapshots = source.SizeSnapshots
	return schemaStorageBoxStats
}
func (c *converterImpl) hcloudStorageBoxTypeLocationPricingToSchemaStorageBoxTypePrice(source StorageBoxTypeLocationPricing) schema.StorageBoxTypePrice {
	var schemaStorageBoxTypePrice schema.StorageBoxTypePrice
	schemaStorageBoxTypePrice.Location = source.Location
	schemaStorageBoxTypePrice.PriceHourly = c.hcloudPriceToSchemaPrice(source.PriceHourly)
	schemaStorageBoxTypePrice.PriceMonthly = c.hcloudPriceToSchemaPrice(source.PriceMonthly)
	schemaStorageBoxTypePrice.SetupFee = c.hcloudPriceToSchemaPrice(source.SetupFee)
	return schemaStorageBoxTypePrice
}
func (c *converterImpl) hcloudVolumeProtectionToSchemaVolumeProtection(source VolumeProtection) schema.VolumeProtection {
	var schemaVolumeProtection schema.VolumeProtection
	schemaVolumeProtection.Delete = source.Delete
	return schemaVolumeProtection
}
func (c *converterImpl) hcloudZoneAuthoritativeNameserversToSchemaZoneAuthoritativeNameservers(source ZoneAuthoritativeNameservers) schema.ZoneAuthoritativeNameservers {
	var schemaZoneAuthoritativeNameservers schema.ZoneAuthoritativeNameservers
	schemaZoneAuthoritativeNameservers.Assigned = source.Assigned
	schemaZoneAuthoritativeNameservers.Delegated = source.Delegated
	schemaZoneAuthoritativeNameservers.DelegationLastCheck = c.timeTimeToTimeTime(source.DelegationLastCheck)
	schemaZoneAuthoritativeNameservers.DelegationStatus = string(source.DelegationStatus)
	return schemaZoneAuthoritativeNameservers
}
func (c *converterImpl) hcloudZoneChangePrimaryNameserversOptsPrimaryNameserverToSchemaZoneChangePrimaryNameserversRequestPrimaryNameserver(source ZoneChangePrimaryNameserversOptsPrimaryNameserver) schema.ZoneChangePrimaryNameserversRequestPrimaryNameserver {
	var schemaZoneChangePrimaryNameserversRequestPrimaryNameserver schema.ZoneChangePrimaryNameserversRequestPrimaryNameserver
	schemaZoneChangePrimaryNameserversRequestPrimaryNameserver.Address = source.Address
	schemaZoneChangePrimaryNameserversRequestPrimaryNameserver.Port = source.Port
	schemaZoneChangePrimaryNameserversRequestPrimaryNameserver.TSIGAlgorithm = string(source.TSIGAlgorithm)
	schemaZoneChangePrimaryNameserversRequestPrimaryNameserver.TSIGKey = source.TSIGKey
	return schemaZoneChangePrimaryNameserversRequestPrimaryNameserver
}
func (c *converterImpl) hcloudZoneCreateOptsPrimaryNameserverToSchemaZoneCreateRequestPrimaryNameserver(source ZoneCreateOptsPrimaryNameserver) schema.ZoneCreateRequestPrimaryNameserver {
	var schemaZoneCreateRequestPrimaryNameserver schema.ZoneCreateRequestPrimaryNameserver
	schemaZoneCreateRequestPrimaryNameserver.Address = source.Address
	schemaZoneCreateRequestPrimaryNameserver.Port = source.Port
	schemaZoneCreateRequestPrimaryNameserver.TSIGAlgorithm = string(source.TSIGAlgorithm)
	schemaZoneCreateRequestPrimaryNameserver.TSIGKey = source.TSIGKey
	return schemaZoneCreateRequestPrimaryNameserver
}
func (c *converterImpl) hcloudZoneCreateOptsRRSetToSchemaZoneCreateRequestRRSet(source ZoneCreateOptsRRSet) schema.ZoneCreateRequestRRSet {
	var schemaZoneCreateRequestRRSet schema.ZoneCreateRequestRRSet
	schemaZoneCreateRequestRRSet.Type = string(source.Type)
	schemaZoneCreateRequestRRSet.Name = source.Name
	schemaZoneCreateRequestRRSet.TTL = source.TTL
	schemaZoneCreateRequestRRSet.Labels = stringMapToStringMapPtr(source.Labels)
	if source.Records != nil {
		schemaZoneCreateRequestRRSet.Records = make([]schema.ZoneRRSetRecord, len(source.Records))
		for i := 0; i < len(source.Records); i++ {
			schemaZoneCreateRequestRRSet.Records[i] = c.hcloudZoneRRSetRecordToSchemaZoneRRSetRecord(source.Records[i])
		}
	}
	return schemaZoneCreateRequestRRSet
}
func (c *converterImpl) hcloudZonePrimaryNameserverToSchemaZonePrimaryNameserver(source ZonePrimaryNameserver) schema.ZonePrimaryNameserver {
	var schemaZonePrimaryNameserver schema.ZonePrimaryNameserver
	schemaZonePrimaryNameserver.Address = source.Address
	schemaZonePrimaryNameserver.Port = source.Port
	schemaZonePrimaryNameserver.TSIGAlgorithm = string(source.TSIGAlgorithm)
	schemaZonePrimaryNameserver.TSIGKey = source.TSIGKey
	return schemaZonePrimaryNameserver
}
func (c *converterImpl) hcloudZoneProtectionToSchemaZoneProtection(source ZoneProtection) schema.ZoneProtection {
	var schemaZoneProtection schema.ZoneProtection
	schemaZoneProtection.Delete = source.Delete
	return schemaZoneProtection
}
func (c *converterImpl) hcloudZoneRRSetProtectionToSchemaZoneRRSetProtection(source ZoneRRSetProtection) schema.ZoneRRSetProtection {
	var schemaZoneRRSetProtection schema.ZoneRRSetProtection
	schemaZoneRRSetProtection.Change = source.Change
	return schemaZoneRRSetProtection
}
func (c *converterImpl) hcloudZoneRRSetRecordToSchemaZoneRRSetRecord(source ZoneRRSetRecord) schema.ZoneRRSetRecord {
	var schemaZoneRRSetRecord schema.ZoneRRSetRecord
	schemaZoneRRSetRecord.Value = source.Value
	schemaZoneRRSetRecord.Comment = source.Comment
	return schemaZoneRRSetRecord
}
func (c *converterImpl) intISOFromSchema(source schema.ISO) ISO {
	var hcloudISO ISO
	hcloudISO.ID = source.ID
	hcloudISO.Name = source.Name
	hcloudISO.Description = source.Description
	hcloudISO.Type = ISOType(source.Type)
	if source.Architecture != nil {
		hcloudArchitecture := Architecture(*source.Architecture)
		hcloudISO.Architecture = &hcloudArchitecture
	}
	var pTimeTime *time.Time
	if source.DeprecatableResource.Deprecation != nil {
		pTimeTime = &source.DeprecatableResource.Deprecation.UnavailableAfter
	}
	hcloudISO.Deprecated = c.pTimeTimeToTimeTime(pTimeTime)
	hcloudISO.DeprecatableResource = c.schemaDeprecatableResourceToHcloudDeprecatableResource(source.DeprecatableResource)
	return hcloudISO
}
func (c *converterImpl) intSchemaFromImage(source Image) schema.Image {
	var schemaImage schema.Image
	schemaImage.ID = source.ID
	schemaImage.Status = string(source.Status)
	schemaImage.Type = string(source.Type)
	pString := source.Name
	schemaImage.Name = &pString
	schemaImage.Description = source.Description
	schemaImage.ImageSize = mapZeroFloat32ToNil(source.ImageSize)
	schemaImage.DiskSize = source.DiskSize
	schemaImage.Created = timeToTimePtr(source.Created)
	schemaImage.CreatedFrom = c.pHcloudServerToPSchemaImageCreatedFrom(source.CreatedFrom)
	schemaImage.BoundTo = c.pHcloudServerToPInt64(source.BoundTo)
	schemaImage.OSFlavor = source.OSFlavor
	pString2 := source.OSVersion
	schemaImage.OSVersion = &pString2
	schemaImage.Architecture = string(source.Architecture)
	schemaImage.RapidDeploy = source.RapidDeploy
	schemaImage.Protection = c.hcloudImageProtectionToSchemaImageProtection(source.Protection)
	schemaImage.Deprecated = timeToTimePtr(source.Deprecated)
	schemaImage.Deleted = timeToTimePtr(source.Deleted)
	schemaImage.Labels = source.Labels
	return schemaImage
}
func (c *converterImpl) pHcloudActionResourceToSchemaActionResourceReference(source *ActionResource) schema.ActionResourceReference {
	var schemaActionResourceReference schema.ActionResourceReference
	if source != nil {
		schemaActionResourceReference.ID = (*source).ID
		schemaActionResourceReference.Type = string((*source).Type)
	}
	return schemaActionResourceReference
}
func (c *converterImpl) pHcloudCertificateStatusToPSchemaCertificateStatusRef(source *CertificateStatus) *schema.CertificateStatusRef {
	var pSchemaCertificateStatusRef *schema.CertificateStatusRef
	if source != nil {
		var schemaCertificateStatusRef schema.CertificateStatusRef
		schemaCertificateStatusRef.Issuance = c.hcloudCertificateStatusTypeToString((*source).Issuance)
		schemaCertificateStatusRef.Renewal = c.hcloudCertificateStatusTypeToString((*source).Renewal)
		schemaCertificateStatusRef.Error = c.pHcloudErrorToPSchemaError((*source).Error)
		pSchemaCertificateStatusRef = &schemaCertificateStatusRef
	}
	return pSchemaCertificateStatusRef
}
func (c *converterImpl) pHcloudErrorToPSchemaError(source *Error) *schema.Error {
	var pSchemaError *schema.Error
	if source != nil {
		schemaError := c.SchemaFromError((*source))
		pSchemaError = &schemaError
	}
	return pSchemaError
}
func (c *converterImpl) pHcloudFirewallResourceLabelSelectorToPSchemaFirewallResourceLabelSelector(source *FirewallResourceLabelSelector) *schema.FirewallResourceLabelSelector {
	var pSchemaFirewallResourceLabelSelector *schema.FirewallResourceLabelSelector
	if source != nil {
		var schemaFirewallResourceLabelSelector schema.FirewallResourceLabelSelector
		schemaFirewallResourceLabelSelector.Selector = (*source).Selector
		pSchemaFirewallResourceLabelSelector = &schemaFirewallResourceLabelSelector
	}
	return pSchemaFirewallResourceLabelSelector
}
func (c *converterImpl) pHcloudFirewallResourceServerToPSchemaFirewallResourceServer(source *FirewallResourceServer) *schema.FirewallResourceServer {
	var pSchemaFirewallResourceServer *schema.FirewallResourceServer
	if source != nil {
		var schemaFirewallResourceServer schema.FirewallResourceServer
		schemaFirewallResourceServer.ID = (*source).ID
		pSchemaFirewallResourceServer = &schemaFirewallResourceServer
	}
	return pSchemaFirewallResourceServer
}
func (c *converterImpl) pHcloudISOToPSchemaISO(source *ISO) *schema.ISO {
	var pSchemaISO *schema.ISO
	if source != nil {
		var schemaISO schema.ISO
		schemaISO.ID = (*source).ID
		schemaISO.Name = (*source).Name
		schemaISO.Description = (*source).Description
		schemaISO.Type = string((*source).Type)
		if (*source).Architecture != nil {
			xstring := string(*(*source).Architecture)
			schemaISO.Architecture = &xstring
		}
		schemaISO.DeprecatableResource = c.hcloudDeprecatableResourceToSchemaDeprecatableResource((*source).DeprecatableResource)
		pSchemaISO = &schemaISO
	}
	return pSchemaISO
}
func (c *converterImpl) pHcloudImageToPSchemaImage(source *Image) *schema.Image {
	var pSchemaImage *schema.Image
	if source != nil {
		schemaImage := c.intSchemaFromImage((*source))
		pSchemaImage = &schemaImage
	}
	return pSchemaImage
}
func (c *converterImpl) pHcloudLoadBalancerAddServiceOptsHTTPToPSchemaLoadBalancerActionAddServiceRequestHTTP(source *LoadBalancerAddServiceOptsHTTP) *schema.LoadBalancerActionAddServiceRequestHTTP {
	var pSchemaLoadBalancerActionAddServiceRequestHTTP *schema.LoadBalancerActionAddServiceRequestHTTP
	if source != nil {
		var schemaLoadBalancerActionAddServiceRequestHTTP schema.LoadBalancerActionAddServiceRequestHTTP
		schemaLoadBalancerActionAddServiceRequestHTTP.CookieName = (*source).CookieName
		if (*source).CookieLifetime != nil {
			xint := intSecondsFromDuration(*(*source).CookieLifetime)
			schemaLoadBalancerActionAddServiceRequestHTTP.CookieLifetime = &xint
		}
		schemaLoadBalancerActionAddServiceRequestHTTP.Certificates = int64SlicePtrFromCertificatePtrSlice((*source).Certificates)
		schemaLoadBalancerActionAddServiceRequestHTTP.RedirectHTTP = (*source).RedirectHTTP
		schemaLoadBalancerActionAddServiceRequestHTTP.StickySessions = (*source).StickySessions
		pSchemaLoadBalancerActionAddServiceRequestHTTP = &schemaLoadBalancerActionAddServiceRequestHTTP
	}
	return pSchemaLoadBalancerActionAddServiceRequestHTTP
}
func (c *converterImpl) pHcloudLoadBalancerAddServiceOptsHealthCheckHTTPToPSchemaLoadBalancerActionAddServiceRequestHealthCheckHTTP(source *LoadBalancerAddServiceOptsHealthCheckHTTP) *schema.LoadBalancerActionAddServiceRequestHealthCheckHTTP {
	var pSchemaLoadBalancerActionAddServiceRequestHealthCheckHTTP *schema.LoadBalancerActionAddServiceRequestHealthCheckHTTP
	if source != nil {
		var schemaLoadBalancerActionAddServiceRequestHealthCheckHTTP schema.LoadBalancerActionAddServiceRequestHealthCheckHTTP
		schemaLoadBalancerActionAddServiceRequestHealthCheckHTTP.Domain = (*source).Domain
		schemaLoadBalancerActionAddServiceRequestHealthCheckHTTP.Path = (*source).Path
		schemaLoadBalancerActionAddServiceRequestHealthCheckHTTP.Response = (*source).Response
		schemaLoadBalancerActionAddServiceRequestHealthCheckHTTP.StatusCodes = stringSlicePtrFromStringSlice((*source).StatusCodes)
		schemaLoadBalancerActionAddServiceRequestHealthCheckHTTP.TLS = (*source).TLS
		pSchemaLoadBalancerActionAddServiceRequestHealthCheckHTTP = &schemaLoadBalancerActionAddServiceRequestHealthCheckHTTP
	}
	return pSchemaLoadBalancerActionAddServiceRequestHealthCheckHTTP
}
func (c *converterImpl) pHcloudLoadBalancerAddServiceOptsHealthCheckToPSchemaLoadBalancerActionAddServiceRequestHealthCheck(source *LoadBalancerAddServiceOptsHealthCheck) *schema.LoadBalancerActionAddServiceRequestHealthCheck {
	var pSchemaLoadBalancerActionAddServiceRequestHealthCheck *schema.LoadBalancerActionAddServiceRequestHealthCheck
	if source != nil {
		var schemaLoadBalancerActionAddServiceRequestHealthCheck schema.LoadBalancerActionAddServiceRequestHealthCheck
		schemaLoadBalancerActionAddServiceRequestHealthCheck.Protocol = string((*source).Protocol)
		schemaLoadBalancerActionAddServiceRequestHealthCheck.Port = (*source).Port
		if (*source).Interval != nil {
			xint := intSecondsFromDuration(*(*source).Interval)
			schemaLoadBalancerActionAddServiceRequestHealthCheck.Interval = &xint
		}
		if (*source).Timeout != nil {
			xint2 := intSecondsFromDuration(*(*source).Timeout)
			schemaLoadBalancerActionAddServiceRequestHealthCheck.Timeout = &xint2
		}
		schemaLoadBalancerActionAddServiceRequestHealthCheck.Retries = (*source).Retries
		schemaLoadBalancerActionAddServiceRequestHealthCheck.HTTP = c.pHcloudLoadBalancerAddServiceOptsHealthCheckHTTPToPSchemaLoadBalancerActionAddServiceRequestHealthCheckHTTP((*source).HTTP)
		pSchemaLoadBalancerActionAddServiceRequestHealthCheck = &schemaLoadBalancerActionAddServiceRequestHealthCheck
	}
	return pSchemaLoadBalancerActionAddServiceRequestHealthCheck
}
func (c *converterImpl) pHcloudLoadBalancerAlgorithmToPSchemaLoadBalancerCreateRequestAlgorithm(source *LoadBalancerAlgorithm) *schema.LoadBalancerCreateRequestAlgorithm {
	var pSchemaLoadBalancerCreateRequestAlgorithm *schema.LoadBalancerCreateRequestAlgorithm
	if source != nil {
		var schemaLoadBalancerCreateRequestAlgorithm schema.LoadBalancerCreateRequestAlgorithm
		schemaLoadBalancerCreateRequestAlgorithm.Type = string((*source).Type)
		pSchemaLoadBalancerCreateRequestAlgorithm = &schemaLoadBalancerCreateRequestAlgorithm
	}
	return pSchemaLoadBalancerCreateRequestAlgorithm
}
func (c *converterImpl) pHcloudLoadBalancerCreateOptsServiceHTTPToPSchemaLoadBalancerCreateRequestServiceHTTP(source *LoadBalancerCreateOptsServiceHTTP) *schema.LoadBalancerCreateRequestServiceHTTP {
	var pSchemaLoadBalancerCreateRequestServiceHTTP *schema.LoadBalancerCreateRequestServiceHTTP
	if source != nil {
		var schemaLoadBalancerCreateRequestServiceHTTP schema.LoadBalancerCreateRequestServiceHTTP
		schemaLoadBalancerCreateRequestServiceHTTP.CookieName = (*source).CookieName
		if (*source).CookieLifetime != nil {
			xint := intSecondsFromDuration(*(*source).CookieLifetime)
			schemaLoadBalancerCreateRequestServiceHTTP.CookieLifetime = &xint
		}
		schemaLoadBalancerCreateRequestServiceHTTP.Certificates = int64SlicePtrFromCertificatePtrSlice((*source).Certificates)
		schemaLoadBalancerCreateRequestServiceHTTP.RedirectHTTP = (*source).RedirectHTTP
		schemaLoadBalancerCreateRequestServiceHTTP.StickySessions = (*source).StickySessions
		pSchemaLoadBalancerCreateRequestServiceHTTP = &schemaLoadBalancerCreateRequestServiceHTTP
	}
	return pSchemaLoadBalancerCreateRequestServiceHTTP
}
func (c *converterImpl) pHcloudLoadBalancerCreateOptsServiceHealthCheckHTTPToPSchemaLoadBalancerCreateRequestServiceHealthCheckHTTP(source *LoadBalancerCreateOptsServiceHealthCheckHTTP) *schema.LoadBalancerCreateRequestServiceHealthCheckHTTP {
	var pSchemaLoadBalancerCreateRequestServiceHealthCheckHTTP *schema.LoadBalancerCreateRequestServiceHealthCheckHTTP
	if source != nil {
		var schemaLoadBalancerCreateRequestServiceHealthCheckHTTP schema.LoadBalancerCreateRequestServiceHealthCheckHTTP
		schemaLoadBalancerCreateRequestServiceHealthCheckHTTP.Domain = (*source).Domain
		schemaLoadBalancerCreateRequestServiceHealthCheckHTTP.Path = (*source).Path
		schemaLoadBalancerCreateRequestServiceHealthCheckHTTP.Response = (*source).Response
		schemaLoadBalancerCreateRequestServiceHealthCheckHTTP.StatusCodes = stringSlicePtrFromStringSlice((*source).StatusCodes)
		schemaLoadBalancerCreateRequestServiceHealthCheckHTTP.TLS = (*source).TLS
		pSchemaLoadBalancerCreateRequestServiceHealthCheckHTTP = &schemaLoadBalancerCreateRequestServiceHealthCheckHTTP
	}
	return pSchemaLoadBalancerCreateRequestServiceHealthCheckHTTP
}
func (c *converterImpl) pHcloudLoadBalancerCreateOptsServiceHealthCheckToPSchemaLoadBalancerCreateRequestServiceHealthCheck(source *LoadBalancerCreateOptsServiceHealthCheck) *schema.LoadBalancerCreateRequestServiceHealthCheck {
	var pSchemaLoadBalancerCreateRequestServiceHealthCheck *schema.LoadBalancerCreateRequestServiceHealthCheck
	if source != nil {
		var schemaLoadBalancerCreateRequestServiceHealthCheck schema.LoadBalancerCreateRequestServiceHealthCheck
		schemaLoadBalancerCreateRequestServiceHealthCheck.Protocol = string((*source).Protocol)
		schemaLoadBalancerCreateRequestServiceHealthCheck.Port = (*source).Port
		if (*source).Interval != nil {
			xint := intSecondsFromDuration(*(*source).Interval)
			schemaLoadBalancerCreateRequestServiceHealthCheck.Interval = &xint
		}
		if (*source).Timeout != nil {
			xint2 := intSecondsFromDuration(*(*source).Timeout)
			schemaLoadBalancerCreateRequestServiceHealthCheck.Timeout = &xint2
		}
		schemaLoadBalancerCreateRequestServiceHealthCheck.Retries = (*source).Retries
		schemaLoadBalancerCreateRequestServiceHealthCheck.HTTP = c.pHcloudLoadBalancerCreateOptsServiceHealthCheckHTTPToPSchemaLoadBalancerCreateRequestServiceHealthCheckHTTP((*source).HTTP)
		pSchemaLoadBalancerCreateRequestServiceHealthCheck = &schemaLoadBalancerCreateRequestServiceHealthCheck
	}
	return pSchemaLoadBalancerCreateRequestServiceHealthCheck
}
func (c *converterImpl) pHcloudLoadBalancerServiceHealthCheckHTTPToPSchemaLoadBalancerServiceHealthCheckHTTP(source *LoadBalancerServiceHealthCheckHTTP) *schema.LoadBalancerServiceHealthCheckHTTP {
	var pSchemaLoadBalancerServiceHealthCheckHTTP *schema.LoadBalancerServiceHealthCheckHTTP
	if source != nil {
		var schemaLoadBalancerServiceHealthCheckHTTP schema.LoadBalancerServiceHealthCheckHTTP
		schemaLoadBalancerServiceHealthCheckHTTP.Domain = (*source).Domain
		schemaLoadBalancerServiceHealthCheckHTTP.Path = (*source).Path
		schemaLoadBalancerServiceHealthCheckHTTP.Response = (*source).Response
		schemaLoadBalancerServiceHealthCheckHTTP.StatusCodes = (*source).StatusCodes
		schemaLoadBalancerServiceHealthCheckHTTP.TLS = (*source).TLS
		pSchemaLoadBalancerServiceHealthCheckHTTP = &schemaLoadBalancerServiceHealthCheckHTTP
	}
	return pSchemaLoadBalancerServiceHealthCheckHTTP
}
func (c *converterImpl) pHcloudLoadBalancerTargetIPToPSchemaLoadBalancerTargetIP(source *LoadBalancerTargetIP) *schema.LoadBalancerTargetIP {
	var pSchemaLoadBalancerTargetIP *schema.LoadBalancerTargetIP
	if source != nil {
		var schemaLoadBalancerTargetIP schema.LoadBalancerTargetIP
		schemaLoadBalancerTargetIP.IP = (*source).IP
		pSchemaLoadBalancerTargetIP = &schemaLoadBalancerTargetIP
	}
	return pSchemaLoadBalancerTargetIP
}
func (c *converterImpl) pHcloudLoadBalancerTargetLabelSelectorToPSchemaLoadBalancerTargetLabelSelector(source *LoadBalancerTargetLabelSelector) *schema.LoadBalancerTargetLabelSelector {
	var pSchemaLoadBalancerTargetLabelSelector *schema.LoadBalancerTargetLabelSelector
	if source != nil {
		var schemaLoadBalancerTargetLabelSelector schema.LoadBalancerTargetLabelSelector
		schemaLoadBalancerTargetLabelSelector.Selector = (*source).Selector
		pSchemaLoadBalancerTargetLabelSelector = &schemaLoadBalancerTargetLabelSelector
	}
	return pSchemaLoadBalancerTargetLabelSelector
}
func (c *converterImpl) pHcloudLoadBalancerTargetServerToPSchemaLoadBalancerTargetServer(source *LoadBalancerTargetServer) *schema.LoadBalancerTargetServer {
	var pSchemaLoadBalancerTargetServer *schema.LoadBalancerTargetServer
	if source != nil {
		schemaLoadBalancerTargetServer := c.SchemaFromLoadBalancerServerTarget((*source))
		pSchemaLoadBalancerTargetServer = &schemaLoadBalancerTargetServer
	}
	return pSchemaLoadBalancerTargetServer
}
func (c *converterImpl) pHcloudLoadBalancerToInt64(source *LoadBalancer) int64 {
	var xint64 int64
	if source != nil {
		xint64 = int64FromLoadBalancer((*source))
	}
	return xint64
}
func (c *converterImpl) pHcloudLoadBalancerTypeToSchemaIDOrName(source *LoadBalancerType) schema.IDOrName {
	var schemaIDOrName schema.IDOrName
	if source != nil {
		schemaIDOrName.ID = (*source).ID
		schemaIDOrName.Name = (*source).Name
	}
	return schemaIDOrName
}
func (c *converterImpl) pHcloudLoadBalancerUpdateServiceOptsHTTPToPSchemaLoadBalancerActionUpdateServiceRequestHTTP(source *LoadBalancerUpdateServiceOptsHTTP) *schema.LoadBalancerActionUpdateServiceRequestHTTP {
	var pSchemaLoadBalancerActionUpdateServiceRequestHTTP *schema.LoadBalancerActionUpdateServiceRequestHTTP
	if source != nil {
		var schemaLoadBalancerActionUpdateServiceRequestHTTP schema.LoadBalancerActionUpdateServiceRequestHTTP
		schemaLoadBalancerActionUpdateServiceRequestHTTP.CookieName = (*source).CookieName
		if (*source).CookieLifetime != nil {
			xint := intSecondsFromDuration(*(*source).CookieLifetime)
			schemaLoadBalancerActionUpdateServiceRequestHTTP.CookieLifetime = &xint
		}
		schemaLoadBalancerActionUpdateServiceRequestHTTP.Certificates = int64SlicePtrFromCertificatePtrSlice((*source).Certificates)
		schemaLoadBalancerActionUpdateServiceRequestHTTP.RedirectHTTP = (*source).RedirectHTTP
		schemaLoadBalancerActionUpdateServiceRequestHTTP.StickySessions = (*source).StickySessions
		pSchemaLoadBalancerActionUpdateServiceRequestHTTP = &schemaLoadBalancerActionUpdateServiceRequestHTTP
	}
	return pSchemaLoadBalancerActionUpdateServiceRequestHTTP
}
func (c *converterImpl) pHcloudLoadBalancerUpdateServiceOptsHealthCheckHTTPToPSchemaLoadBalancerActionUpdateServiceRequestHealthCheckHTTP(source *LoadBalancerUpdateServiceOptsHealthCheckHTTP) *schema.LoadBalancerActionUpdateServiceRequestHealthCheckHTTP {
	var pSchemaLoadBalancerActionUpdateServiceRequestHealthCheckHTTP *schema.LoadBalancerActionUpdateServiceRequestHealthCheckHTTP
	if source != nil {
		var schemaLoadBalancerActionUpdateServiceRequestHealthCheckHTTP schema.LoadBalancerActionUpdateServiceRequestHealthCheckHTTP
		schemaLoadBalancerActionUpdateServiceRequestHealthCheckHTTP.Domain = (*source).Domain
		schemaLoadBalancerActionUpdateServiceRequestHealthCheckHTTP.Path = (*source).Path
		schemaLoadBalancerActionUpdateServiceRequestHealthCheckHTTP.Response = (*source).Response
		schemaLoadBalancerActionUpdateServiceRequestHealthCheckHTTP.StatusCodes = stringSlicePtrFromStringSlice((*source).StatusCodes)
		schemaLoadBalancerActionUpdateServiceRequestHealthCheckHTTP.TLS = (*source).TLS
		pSchemaLoadBalancerActionUpdateServiceRequestHealthCheckHTTP = &schemaLoadBalancerActionUpdateServiceRequestHealthCheckHTTP
	}
	return pSchemaLoadBalancerActionUpdateServiceRequestHealthCheckHTTP
}
func (c *converterImpl) pHcloudLoadBalancerUpdateServiceOptsHealthCheckToPSchemaLoadBalancerActionUpdateServiceRequestHealthCheck(source *LoadBalancerUpdateServiceOptsHealthCheck) *schema.LoadBalancerActionUpdateServiceRequestHealthCheck {
	var pSchemaLoadBalancerActionUpdateServiceRequestHealthCheck *schema.LoadBalancerActionUpdateServiceRequestHealthCheck
	if source != nil {
		var schemaLoadBalancerActionUpdateServiceRequestHealthCheck schema.LoadBalancerActionUpdateServiceRequestHealthCheck
		schemaLoadBalancerActionUpdateServiceRequestHealthCheck.Protocol = stringPtrFromLoadBalancerServiceProtocol((*source).Protocol)
		schemaLoadBalancerActionUpdateServiceRequestHealthCheck.Port = (*source).Port
		if (*source).Interval != nil {
			xint := intSecondsFromDuration(*(*source).Interval)
			schemaLoadBalancerActionUpdateServiceRequestHealthCheck.Interval = &xint
		}
		if (*source).Timeout != nil {
			xint2 := intSecondsFromDuration(*(*source).Timeout)
			schemaLoadBalancerActionUpdateServiceRequestHealthCheck.Timeout = &xint2
		}
		schemaLoadBalancerActionUpdateServiceRequestHealthCheck.Retries = (*source).Retries
		schemaLoadBalancerActionUpdateServiceRequestHealthCheck.HTTP = c.pHcloudLoadBalancerUpdateServiceOptsHealthCheckHTTPToPSchemaLoadBalancerActionUpdateServiceRequestHealthCheckHTTP((*source).HTTP)
		pSchemaLoadBalancerActionUpdateServiceRequestHealthCheck = &schemaLoadBalancerActionUpdateServiceRequestHealthCheck
	}
	return pSchemaLoadBalancerActionUpdateServiceRequestHealthCheck
}
func (c *converterImpl) pHcloudLocationToPString(source *Location) *string {
	var pString *string
	if source != nil {
		xstring := stringFromLocation((*source))
		pString = &xstring
	}
	return pString
}
func (c *converterImpl) pHcloudLocationToSchemaIDOrName(source *Location) schema.IDOrName {
	var schemaIDOrName schema.IDOrName
	if source != nil {
		schemaIDOrName.ID = (*source).ID
		schemaIDOrName.Name = (*source).Name
	}
	return schemaIDOrName
}
func (c *converterImpl) pHcloudLocationToString(source *Location) string {
	var xstring string
	if source != nil {
		xstring = stringFromLocation((*source))
	}
	return xstring
}
func (c *converterImpl) pHcloudNetworkToInt64(source *Network) int64 {
	var xint64 int64
	if source != nil {
		xint64 = int64FromNetwork((*source))
	}
	return xint64
}
func (c *converterImpl) pHcloudNetworkToPInt64(source *Network) *int64 {
	var pInt64 *int64
	if source != nil {
		xint64 := int64FromNetwork((*source))
		pInt64 = &xint64
	}
	return pInt64
}
func (c *converterImpl) pHcloudPlacementGroupToPSchemaPlacementGroup(source *PlacementGroup) *schema.PlacementGroup {
	var pSchemaPlacementGroup *schema.PlacementGroup
	if source != nil {
		var schemaPlacementGroup schema.PlacementGroup
		schemaPlacementGroup.ID = (*source).ID
		schemaPlacementGroup.Name = (*source).Name
		schemaPlacementGroup.Labels = (*source).Labels
		schemaPlacementGroup.Created = c.timeTimeToTimeTime((*source).Created)
		schemaPlacementGroup.Servers = (*source).Servers
		schemaPlacementGroup.Type = string((*source).Type)
		pSchemaPlacementGroup = &schemaPlacementGroup
	}
	return pSchemaPlacementGroup
}
func (c *converterImpl) pHcloudServerToInt64(source *Server) int64 {
	var xint64 int64
	if source != nil {
		xint64 = int64FromServer((*source))
	}
	return xint64
}
func (c *converterImpl) pHcloudServerToPInt64(source *Server) *int64 {
	var pInt64 *int64
	if source != nil {
		xint64 := int64FromServer((*source))
		pInt64 = &xint64
	}
	return pInt64
}
func (c *converterImpl) pHcloudServerToPSchemaImageCreatedFrom(source *Server) *schema.ImageCreatedFrom {
	var pSchemaImageCreatedFrom *schema.ImageCreatedFrom
	if source != nil {
		var schemaImageCreatedFrom schema.ImageCreatedFrom
		schemaImageCreatedFrom.ID = (*source).ID
		schemaImageCreatedFrom.Name = (*source).Name
		pSchemaImageCreatedFrom = &schemaImageCreatedFrom
	}
	return pSchemaImageCreatedFrom
}
func (c *converterImpl) pHcloudStorageBoxCreateOptsAccessSettingsToPSchemaStorageBoxCreateRequestAccessSettings(source *StorageBoxCreateOptsAccessSettings) *schema.StorageBoxCreateRequestAccessSettings {
	var pSchemaStorageBoxCreateRequestAccessSettings *schema.StorageBoxCreateRequestAccessSettings
	if source != nil {
		var schemaStorageBoxCreateRequestAccessSettings schema.StorageBoxCreateRequestAccessSettings
		schemaStorageBoxCreateRequestAccessSettings.ReachableExternally = (*source).ReachableExternally
		schemaStorageBoxCreateRequestAccessSettings.SambaEnabled = (*source).SambaEnabled
		schemaStorageBoxCreateRequestAccessSettings.SSHEnabled = (*source).SSHEnabled
		schemaStorageBoxCreateRequestAccessSettings.WebDAVEnabled = (*source).WebDAVEnabled
		schemaStorageBoxCreateRequestAccessSettings.ZFSEnabled = (*source).ZFSEnabled
		pSchemaStorageBoxCreateRequestAccessSettings = &schemaStorageBoxCreateRequestAccessSettings
	}
	return pSchemaStorageBoxCreateRequestAccessSettings
}
func (c *converterImpl) pHcloudStorageBoxSnapshotPlanToPSchemaStorageBoxSnapshotPlan(source *StorageBoxSnapshotPlan) *schema.StorageBoxSnapshotPlan {
	var pSchemaStorageBoxSnapshotPlan *schema.StorageBoxSnapshotPlan
	if source != nil {
		var schemaStorageBoxSnapshotPlan schema.StorageBoxSnapshotPlan
		schemaStorageBoxSnapshotPlan.MaxSnapshots = (*source).MaxSnapshots
		schemaStorageBoxSnapshotPlan.Minute = (*source).Minute
		schemaStorageBoxSnapshotPlan.Hour = (*source).Hour
		if (*source).DayOfWeek != nil {
			xint := int(*(*source).DayOfWeek)
			schemaStorageBoxSnapshotPlan.DayOfWeek = &xint
		}
		schemaStorageBoxSnapshotPlan.DayOfMonth = (*source).DayOfMonth
		pSchemaStorageBoxSnapshotPlan = &schemaStorageBoxSnapshotPlan
	}
	return pSchemaStorageBoxSnapshotPlan
}
func (c *converterImpl) pHcloudStorageBoxSnapshotToSchemaIDOrName(source *StorageBoxSnapshot) schema.IDOrName {
	var schemaIDOrName schema.IDOrName
	if source != nil {
		schemaIDOrName.ID = (*source).ID
		schemaIDOrName.Name = (*source).Name
	}
	return schemaIDOrName
}
func (c *converterImpl) pHcloudStorageBoxSubaccountAccessSettingsToSchemaStorageBoxSubaccountAccessSettings(source *StorageBoxSubaccountAccessSettings) schema.StorageBoxSubaccountAccessSettings {
	var schemaStorageBoxSubaccountAccessSettings schema.StorageBoxSubaccountAccessSettings
	if source != nil {
		schemaStorageBoxSubaccountAccessSettings.ReachableExternally = (*source).ReachableExternally
		schemaStorageBoxSubaccountAccessSettings.Readonly = (*source).Readonly
		schemaStorageBoxSubaccountAccessSettings.SambaEnabled = (*source).SambaEnabled
		schemaStorageBoxSubaccountAccessSettings.SSHEnabled = (*source).SSHEnabled
		schemaStorageBoxSubaccountAccessSettings.WebDAVEnabled = (*source).WebDAVEnabled
	}
	return schemaStorageBoxSubaccountAccessSettings
}
func (c *converterImpl) pHcloudStorageBoxSubaccountCreateOptsAccessSettingsToPSchemaStorageBoxSubaccountCreateRequestAccessSettings(source *StorageBoxSubaccountCreateOptsAccessSettings) *schema.StorageBoxSubaccountCreateRequestAccessSettings {
	var pSchemaStorageBoxSubaccountCreateRequestAccessSettings *schema.StorageBoxSubaccountCreateRequestAccessSettings
	if source != nil {
		var schemaStorageBoxSubaccountCreateRequestAccessSettings schema.StorageBoxSubaccountCreateRequestAccessSettings
		schemaStorageBoxSubaccountCreateRequestAccessSettings.ReachableExternally = (*source).ReachableExternally
		schemaStorageBoxSubaccountCreateRequestAccessSettings.Readonly = (*source).Readonly
		schemaStorageBoxSubaccountCreateRequestAccessSettings.SambaEnabled = (*source).SambaEnabled
		schemaStorageBoxSubaccountCreateRequestAccessSettings.SSHEnabled = (*source).SSHEnabled
		schemaStorageBoxSubaccountCreateRequestAccessSettings.WebDAVEnabled = (*source).WebDAVEnabled
		pSchemaStorageBoxSubaccountCreateRequestAccessSettings = &schemaStorageBoxSubaccountCreateRequestAccessSettings
	}
	return pSchemaStorageBoxSubaccountCreateRequestAccessSettings
}
func (c *converterImpl) pHcloudStorageBoxTypeToSchemaIDOrName(source *StorageBoxType) schema.IDOrName {
	var schemaIDOrName schema.IDOrName
	if source != nil {
		schemaIDOrName.ID = (*source).ID
		schemaIDOrName.Name = (*source).Name
	}
	return schemaIDOrName
}
func (c *converterImpl) pNetIPNetToString(source *net.IPNet) string {
	var xstring string
	if source != nil {
		xstring = stringFromIPNet((*source))
	}
	return xstring
}
func (c *converterImpl) pSchemaCertificateStatusRefToPHcloudCertificateStatus(source *schema.CertificateStatusRef) *CertificateStatus {
	var pHcloudCertificateStatus *CertificateStatus
	if source != nil {
		var hcloudCertificateStatus CertificateStatus
		hcloudCertificateStatus.Issuance = CertificateStatusType((*source).Issuance)
		hcloudCertificateStatus.Renewal = CertificateStatusType((*source).Renewal)
		hcloudCertificateStatus.Error = c.pSchemaErrorToPHcloudError((*source).Error)
		pHcloudCertificateStatus = &hcloudCertificateStatus
	}
	return pHcloudCertificateStatus
}
func (c *converterImpl) pSchemaErrorToPHcloudError(source *schema.Error) *Error {
	var pHcloudError *Error
	if source != nil {
		hcloudError := c.ErrorFromSchema((*source))
		pHcloudError = &hcloudError
	}
	return pHcloudError
}
func (c *converterImpl) pSchemaFirewallResourceLabelSelectorToPHcloudFirewallResourceLabelSelector(source *schema.FirewallResourceLabelSelector) *FirewallResourceLabelSelector {
	var pHcloudFirewallResourceLabelSelector *FirewallResourceLabelSelector
	if source != nil {
		var hcloudFirewallResourceLabelSelector FirewallResourceLabelSelector
		hcloudFirewallResourceLabelSelector.Selector = (*source).Selector
		pHcloudFirewallResourceLabelSelector = &hcloudFirewallResourceLabelSelector
	}
	return pHcloudFirewallResourceLabelSelector
}
func (c *converterImpl) pSchemaFirewallResourceServerToPHcloudFirewallResourceServer(source *schema.FirewallResourceServer) *FirewallResourceServer {
	var pHcloudFirewallResourceServer *FirewallResourceServer
	if source != nil {
		var hcloudFirewallResourceServer FirewallResourceServer
		hcloudFirewallResourceServer.ID = (*source).ID
		pHcloudFirewallResourceServer = &hcloudFirewallResourceServer
	}
	return pHcloudFirewallResourceServer
}
func (c *converterImpl) pSchemaISOToPHcloudISO(source *schema.ISO) *ISO {
	var pHcloudISO *ISO
	if source != nil {
		hcloudISO := c.intISOFromSchema((*source))
		pHcloudISO = &hcloudISO
	}
	return pHcloudISO
}
func (c *converterImpl) pSchemaImageCreatedFromToPHcloudServer(source *schema.ImageCreatedFrom) *Server {
	var pHcloudServer *Server
	if source != nil {
		hcloudServer := serverFromImageCreatedFromSchema((*source))
		pHcloudServer = &hcloudServer
	}
	return pHcloudServer
}
func (c *converterImpl) pSchemaImageToPHcloudImage(source *schema.Image) *Image {
	var pHcloudImage *Image
	if source != nil {
		var hcloudImage Image
		hcloudImage.ID = (*source).ID
		if (*source).Name != nil {
			hcloudImage.Name = *(*source).Name
		}
		hcloudImage.Type = ImageType((*source).Type)
		hcloudImage.Status = ImageStatus((*source).Status)
		hcloudImage.Description = (*source).Description
		if (*source).ImageSize != nil {
			hcloudImage.ImageSize = *(*source).ImageSize
		}
		hcloudImage.DiskSize = (*source).DiskSize
		hcloudImage.Created = c.pTimeTimeToTimeTime((*source).Created)
		hcloudImage.CreatedFrom = c.pSchemaImageCreatedFromToPHcloudServer((*source).CreatedFrom)
		if (*source).BoundTo != nil {
			hcloudServer := serverFromInt64(*(*source).BoundTo)
			hcloudImage.BoundTo = &hcloudServer
		}
		hcloudImage.RapidDeploy = (*source).RapidDeploy
		hcloudImage.OSFlavor = (*source).OSFlavor
		if (*source).OSVersion != nil {
			hcloudImage.OSVersion = *(*source).OSVersion
		}
		hcloudImage.Architecture = Architecture((*source).Architecture)
		hcloudImage.Protection = c.schemaImageProtectionToHcloudImageProtection((*source).Protection)
		hcloudImage.Deprecated = c.pTimeTimeToTimeTime((*source).Deprecated)
		hcloudImage.Labels = (*source).Labels
		hcloudImage.Deleted = c.pTimeTimeToTimeTime((*source).Deleted)
		pHcloudImage = &hcloudImage
	}
	return pHcloudImage
}
func (c *converterImpl) pSchemaLoadBalancerServiceHTTPToHcloudLoadBalancerServiceHTTP(source *schema.LoadBalancerServiceHTTP) LoadBalancerServiceHTTP {
	var hcloudLoadBalancerServiceHTTP LoadBalancerServiceHTTP
	if source != nil {
		hcloudLoadBalancerServiceHTTP.CookieName = (*source).CookieName
		hcloudLoadBalancerServiceHTTP.CookieLifetime = durationFromIntSeconds((*source).CookieLifetime)
		if (*source).Certificates != nil {
			hcloudLoadBalancerServiceHTTP.Certificates = make([]*Certificate, len((*source).Certificates))
			for i := 0; i < len((*source).Certificates); i++ {
				hcloudLoadBalancerServiceHTTP.Certificates[i] = certificateFromInt64((*source).Certificates[i])
			}
		}
		hcloudLoadBalancerServiceHTTP.RedirectHTTP = (*source).RedirectHTTP
		hcloudLoadBalancerServiceHTTP.StickySessions = (*source).StickySessions
	}
	return hcloudLoadBalancerServiceHTTP
}
func (c *converterImpl) pSchemaLoadBalancerServiceHealthCheckHTTPToPHcloudLoadBalancerServiceHealthCheckHTTP(source *schema.LoadBalancerServiceHealthCheckHTTP) *LoadBalancerServiceHealthCheckHTTP {
	var pHcloudLoadBalancerServiceHealthCheckHTTP *LoadBalancerServiceHealthCheckHTTP
	if source != nil {
		var hcloudLoadBalancerServiceHealthCheckHTTP LoadBalancerServiceHealthCheckHTTP
		hcloudLoadBalancerServiceHealthCheckHTTP.Domain = (*source).Domain
		hcloudLoadBalancerServiceHealthCheckHTTP.Path = (*source).Path
		hcloudLoadBalancerServiceHealthCheckHTTP.Response = (*source).Response
		hcloudLoadBalancerServiceHealthCheckHTTP.StatusCodes = (*source).StatusCodes
		hcloudLoadBalancerServiceHealthCheckHTTP.TLS = (*source).TLS
		pHcloudLoadBalancerServiceHealthCheckHTTP = &hcloudLoadBalancerServiceHealthCheckHTTP
	}
	return pHcloudLoadBalancerServiceHealthCheckHTTP
}
func (c *converterImpl) pSchemaLoadBalancerTargetIPToPHcloudLoadBalancerTargetIP(source *schema.LoadBalancerTargetIP) *LoadBalancerTargetIP {
	var pHcloudLoadBalancerTargetIP *LoadBalancerTargetIP
	if source != nil {
		var hcloudLoadBalancerTargetIP LoadBalancerTargetIP
		hcloudLoadBalancerTargetIP.IP = (*source).IP
		pHcloudLoadBalancerTargetIP = &hcloudLoadBalancerTargetIP
	}
	return pHcloudLoadBalancerTargetIP
}
func (c *converterImpl) pSchemaLoadBalancerTargetLabelSelectorToPHcloudLoadBalancerTargetLabelSelector(source *schema.LoadBalancerTargetLabelSelector) *LoadBalancerTargetLabelSelector {
	var pHcloudLoadBalancerTargetLabelSelector *LoadBalancerTargetLabelSelector
	if source != nil {
		var hcloudLoadBalancerTargetLabelSelector LoadBalancerTargetLabelSelector
		hcloudLoadBalancerTargetLabelSelector.Selector = (*source).Selector
		pHcloudLoadBalancerTargetLabelSelector = &hcloudLoadBalancerTargetLabelSelector
	}
	return pHcloudLoadBalancerTargetLabelSelector
}
func (c *converterImpl) pSchemaLoadBalancerTargetServerToPHcloudLoadBalancerTargetServer(source *schema.LoadBalancerTargetServer) *LoadBalancerTargetServer {
	var pHcloudLoadBalancerTargetServer *LoadBalancerTargetServer
	if source != nil {
		hcloudLoadBalancerTargetServer := c.LoadBalancerTargetServerFromSchema((*source))
		pHcloudLoadBalancerTargetServer = &hcloudLoadBalancerTargetServer
	}
	return pHcloudLoadBalancerTargetServer
}
func (c *converterImpl) pSchemaPlacementGroupToPHcloudPlacementGroup(source *schema.PlacementGroup) *PlacementGroup {
	var pHcloudPlacementGroup *PlacementGroup
	if source != nil {
		var hcloudPlacementGroup PlacementGroup
		hcloudPlacementGroup.ID = (*source).ID
		hcloudPlacementGroup.Name = (*source).Name
		hcloudPlacementGroup.Labels = (*source).Labels
		hcloudPlacementGroup.Created = c.timeTimeToTimeTime((*source).Created)
		hcloudPlacementGroup.Servers = (*source).Servers
		hcloudPlacementGroup.Type = PlacementGroupType((*source).Type)
		pHcloudPlacementGroup = &hcloudPlacementGroup
	}
	return pHcloudPlacementGroup
}
func (c *converterImpl) pSchemaStorageBoxSnapshotPlanToPHcloudStorageBoxSnapshotPlan(source *schema.StorageBoxSnapshotPlan) *StorageBoxSnapshotPlan {
	var pHcloudStorageBoxSnapshotPlan *StorageBoxSnapshotPlan
	if source != nil {
		hcloudStorageBoxSnapshotPlan := c.StorageBoxSnapshotPlanFromSchema((*source))
		pHcloudStorageBoxSnapshotPlan = &hcloudStorageBoxSnapshotPlan
	}
	return pHcloudStorageBoxSnapshotPlan
}
func (c *converterImpl) pTimeTimeToTimeTime(source *time.Time) time.Time {
	var timeTime time.Time
	if source != nil {
		timeTime = (*source)
	}
	return timeTime
}
func (c *converterImpl) schemaActionResourceReferenceToPHcloudActionResource(source schema.ActionResourceReference) *ActionResource {
	var hcloudActionResource ActionResource
	hcloudActionResource.ID = source.ID
	hcloudActionResource.Type = ActionResourceType(source.Type)
	return &hcloudActionResource
}
func (c *converterImpl) schemaCertificateUsedByRefToHcloudCertificateUsedByRef(source schema.CertificateUsedByRef) CertificateUsedByRef {
	var hcloudCertificateUsedByRef CertificateUsedByRef
	hcloudCertificateUsedByRef.ID = source.ID
	hcloudCertificateUsedByRef.Type = CertificateUsedByRefType(source.Type)
	return hcloudCertificateUsedByRef
}
func (c *converterImpl) schemaDatacenterServerTypesToHcloudDatacenterServerTypes(source schema.DatacenterServerTypes) DatacenterServerTypes {
	var hcloudDatacenterServerTypes DatacenterServerTypes
	if source.Supported != nil {
		hcloudDatacenterServerTypes.Supported = make([]*ServerType, len(source.Supported))
		for i := 0; i < len(source.Supported); i++ {
			hcloudDatacenterServerTypes.Supported[i] = serverTypeFromInt64(source.Supported[i])
		}
	}
	if source.AvailableForMigration != nil {
		hcloudDatacenterServerTypes.AvailableForMigration = make([]*ServerType, len(source.AvailableForMigration))
		for j := 0; j < len(source.AvailableForMigration); j++ {
			hcloudDatacenterServerTypes.AvailableForMigration[j] = serverTypeFromInt64(source.AvailableForMigration[j])
		}
	}
	if source.Available != nil {
		hcloudDatacenterServerTypes.Available = make([]*ServerType, len(source.Available))
		for k := 0; k < len(source.Available); k++ {
			hcloudDatacenterServerTypes.Available[k] = serverTypeFromInt64(source.Available[k])
		}
	}
	return hcloudDatacenterServerTypes
}
func (c *converterImpl) schemaDeprecatableResourceToHcloudDeprecatableResource(source schema.DeprecatableResource) DeprecatableResource {
	var hcloudDeprecatableResource DeprecatableResource
	hcloudDeprecatableResource.Deprecation = c.DeprecationFromSchema(source.Deprecation)
	return hcloudDeprecatableResource
}
func (c *converterImpl) schemaFirewallResourceToHcloudFirewallResource(source schema.FirewallResource) FirewallResource {
	var hcloudFirewallResource FirewallResource
	hcloudFirewallResource.Type = FirewallResourceType(source.Type)
	hcloudFirewallResource.Server = c.pSchemaFirewallResourceServerToPHcloudFirewallResourceServer(source.Server)
	hcloudFirewallResource.LabelSelector = c.pSchemaFirewallResourceLabelSelectorToPHcloudFirewallResourceLabelSelector(source.LabelSelector)
	if source.AppliedToResources != nil {
		hcloudFirewallResource.AppliedToResources = make([]FirewallResource, len(source.AppliedToResources))
		for i := 0; i < len(source.AppliedToResources); i++ {
			hcloudFirewallResource.AppliedToResources[i] = c.schemaFirewallResourceToHcloudFirewallResource(source.AppliedToResources[i])
		}
	}
	return hcloudFirewallResource
}
func (c *converterImpl) schemaFirewallRuleToHcloudFirewallRule(source schema.FirewallRule) FirewallRule {
	var hcloudFirewallRule FirewallRule
	hcloudFirewallRule.Direction = FirewallRuleDirection(source.Direction)
	if source.SourceIPs != nil {
		hcloudFirewallRule.SourceIPs = make([]net.IPNet, len(source.SourceIPs))
		for i := 0; i < len(source.SourceIPs); i++ {
			hcloudFirewallRule.SourceIPs[i] = ipNetFromString(source.SourceIPs[i])
		}
	}
	if source.DestinationIPs != nil {
		hcloudFirewallRule.DestinationIPs = make([]net.IPNet, len(source.DestinationIPs))
		for j := 0; j < len(source.DestinationIPs); j++ {
			hcloudFirewallRule.DestinationIPs[j] = ipNetFromString(source.DestinationIPs[j])
		}
	}
	hcloudFirewallRule.Protocol = FirewallRuleProtocol(source.Protocol)
	hcloudFirewallRule.Port = source.Port
	hcloudFirewallRule.Description = source.Description
	return hcloudFirewallRule
}
func (c *converterImpl) schemaFloatingIPProtectionToHcloudFloatingIPProtection(source schema.FloatingIPProtection) FloatingIPProtection {
	var hcloudFloatingIPProtection FloatingIPProtection
	hcloudFloatingIPProtection.Delete = source.Delete
	return hcloudFloatingIPProtection
}
func (c *converterImpl) schemaFromFloatingIPPricing(source FloatingIPPricing) schema.PricingFloatingIP {
	var schemaPricingFloatingIP schema.PricingFloatingIP
	schemaPricingFloatingIP.PriceMonthly = c.hcloudPriceToSchemaPrice(source.Monthly)
	return schemaPricingFloatingIP
}
func (c *converterImpl) schemaFromFloatingIPTypeLocationPricing(source FloatingIPTypeLocationPricing) schema.PricingFloatingIPTypePrice {
	var schemaPricingFloatingIPTypePrice schema.PricingFloatingIPTypePrice
	schemaPricingFloatingIPTypePrice.Location = c.pHcloudLocationToString(source.Location)
	schemaPricingFloatingIPTypePrice.PriceMonthly = c.hcloudPriceToSchemaPrice(source.Monthly)
	return schemaPricingFloatingIPTypePrice
}
func (c *converterImpl) schemaFromFloatingIPTypePricing(source FloatingIPTypePricing) schema.PricingFloatingIPType {
	var schemaPricingFloatingIPType schema.PricingFloatingIPType
	schemaPricingFloatingIPType.Type = string(source.Type)
	if source.Pricings != nil {
		schemaPricingFloatingIPType.Prices = make([]schema.PricingFloatingIPTypePrice, len(source.Pricings))
		for i := 0; i < len(source.Pricings); i++ {
			schemaPricingFloatingIPType.Prices[i] = c.schemaFromFloatingIPTypeLocationPricing(source.Pricings[i])
		}
	}
	return schemaPricingFloatingIPType
}
func (c *converterImpl) schemaFromImagePricing(source ImagePricing) schema.PricingImage {
	var schemaPricingImage schema.PricingImage
	schemaPricingImage.PricePerGBMonth = c.hcloudPriceToSchemaPrice(source.PerGBMonth)
	return schemaPricingImage
}
func (c *converterImpl) schemaFromLoadBalancerTypePricing(source LoadBalancerTypePricing) schema.PricingLoadBalancerType {
	var schemaPricingLoadBalancerType schema.PricingLoadBalancerType
	var pInt64 *int64
	if source.LoadBalancerType != nil {
		pInt64 = &source.LoadBalancerType.ID
	}
	if pInt64 != nil {
		schemaPricingLoadBalancerType.ID = *pInt64
	}
	var pString *string
	if source.LoadBalancerType != nil {
		pString = &source.LoadBalancerType.Name
	}
	if pString != nil {
		schemaPricingLoadBalancerType.Name = *pString
	}
	if source.Pricings != nil {
		schemaPricingLoadBalancerType.Prices = make([]schema.PricingLoadBalancerTypePrice, len(source.Pricings))
		for i := 0; i < len(source.Pricings); i++ {
			schemaPricingLoadBalancerType.Prices[i] = c.SchemaFromLoadBalancerTypeLocationPricing(source.Pricings[i])
		}
	}
	return schemaPricingLoadBalancerType
}
func (c *converterImpl) schemaFromPrimaryIPPricing(source PrimaryIPPricing) schema.PricingPrimaryIP {
	var schemaPricingPrimaryIP schema.PricingPrimaryIP
	schemaPricingPrimaryIP.Type = source.Type
	if source.Pricings != nil {
		schemaPricingPrimaryIP.Prices = make([]schema.PricingPrimaryIPTypePrice, len(source.Pricings))
		for i := 0; i < len(source.Pricings); i++ {
			schemaPricingPrimaryIP.Prices[i] = c.schemaFromPrimaryIPTypePricing(source.Pricings[i])
		}
	}
	return schemaPricingPrimaryIP
}
func (c *converterImpl) schemaFromPrimaryIPTypePricing(source PrimaryIPTypePricing) schema.PricingPrimaryIPTypePrice {
	var schemaPricingPrimaryIPTypePrice schema.PricingPrimaryIPTypePrice
	schemaPricingPrimaryIPTypePrice.Datacenter = source.Datacenter
	schemaPricingPrimaryIPTypePrice.Location = source.Location
	schemaPricingPrimaryIPTypePrice.PriceHourly = c.hcloudPrimaryIPPriceToSchemaPrice(source.Hourly)
	schemaPricingPrimaryIPTypePrice.PriceMonthly = c.hcloudPrimaryIPPriceToSchemaPrice(source.Monthly)
	return schemaPricingPrimaryIPTypePrice
}
func (c *converterImpl) schemaFromServerTypeLocation(source ServerTypeLocation) schema.ServerTypeLocation {
	var schemaServerTypeLocation schema.ServerTypeLocation
	var pInt64 *int64
	if source.Location != nil {
		pInt64 = &source.Location.ID
	}
	if pInt64 != nil {
		schemaServerTypeLocation.ID = *pInt64
	}
	var pString *string
	if source.Location != nil {
		pString = &source.Location.Name
	}
	if pString != nil {
		schemaServerTypeLocation.Name = *pString
	}
	schemaServerTypeLocation.DeprecatableResource = c.hcloudDeprecatableResourceToSchemaDeprecatableResource(source.DeprecatableResource)
	return schemaServerTypeLocation
}
func (c *converterImpl) schemaFromServerTypeLocationPricing(source ServerTypeLocationPricing) schema.PricingServerTypePrice {
	var schemaPricingServerTypePrice schema.PricingServerTypePrice
	schemaPricingServerTypePrice.Location = c.pHcloudLocationToString(source.Location)
	schemaPricingServerTypePrice.PriceHourly = c.hcloudPriceToSchemaPrice(source.Hourly)
	schemaPricingServerTypePrice.PriceMonthly = c.hcloudPriceToSchemaPrice(source.Monthly)
	schemaPricingServerTypePrice.IncludedTraffic = source.IncludedTraffic
	schemaPricingServerTypePrice.PricePerTBTraffic = c.hcloudPriceToSchemaPrice(source.PerTBTraffic)
	return schemaPricingServerTypePrice
}
func (c *converterImpl) schemaFromServerTypePricing(source ServerTypePricing) schema.PricingServerType {
	var schemaPricingServerType schema.PricingServerType
	var pInt64 *int64
	if source.ServerType != nil {
		pInt64 = &source.ServerType.ID
	}
	if pInt64 != nil {
		schemaPricingServerType.ID = *pInt64
	}
	var pString *string
	if source.ServerType != nil {
		pString = &source.ServerType.Name
	}
	if pString != nil {
		schemaPricingServerType.Name = *pString
	}
	if source.Pricings != nil {
		schemaPricingServerType.Prices = make([]schema.PricingServerTypePrice, len(source.Pricings))
		for i := 0; i < len(source.Pricings); i++ {
			schemaPricingServerType.Prices[i] = c.schemaFromServerTypeLocationPricing(source.Pricings[i])
		}
	}
	return schemaPricingServerType
}
func (c *converterImpl) schemaFromTrafficPricing(source TrafficPricing) schema.PricingTraffic {
	var schemaPricingTraffic schema.PricingTraffic
	schemaPricingTraffic.PricePerTB = c.hcloudPriceToSchemaPrice(source.PerTB)
	return schemaPricingTraffic
}
func (c *converterImpl) schemaFromVolumePricing(source VolumePricing) schema.PricingVolume {
	var schemaPricingVolume schema.PricingVolume
	schemaPricingVolume.PricePerGBPerMonth = c.hcloudPriceToSchemaPrice(source.PerGBMonthly)
	return schemaPricingVolume
}
func (c *converterImpl) schemaImageProtectionToHcloudImageProtection(source schema.ImageProtection) ImageProtection {
	var hcloudImageProtection ImageProtection
	hcloudImageProtection.Delete = source.Delete
	return hcloudImageProtection
}
func (c *converterImpl) schemaLoadBalancerAlgorithmToHcloudLoadBalancerAlgorithm(source schema.LoadBalancerAlgorithm) LoadBalancerAlgorithm {
	var hcloudLoadBalancerAlgorithm LoadBalancerAlgorithm
	hcloudLoadBalancerAlgorithm.Type = LoadBalancerAlgorithmType(source.Type)
	return hcloudLoadBalancerAlgorithm
}
func (c *converterImpl) schemaLoadBalancerPrivateNetToHcloudLoadBalancerPrivateNet(source schema.LoadBalancerPrivateNet) LoadBalancerPrivateNet {
	var hcloudLoadBalancerPrivateNet LoadBalancerPrivateNet
	hcloudNetwork := networkFromInt64(source.Network)
	hcloudLoadBalancerPrivateNet.Network = &hcloudNetwork
	hcloudLoadBalancerPrivateNet.IP = ipFromString(source.IP)
	return hcloudLoadBalancerPrivateNet
}
func (c *converterImpl) schemaLoadBalancerProtectionToHcloudLoadBalancerProtection(source schema.LoadBalancerProtection) LoadBalancerProtection {
	var hcloudLoadBalancerProtection LoadBalancerProtection
	hcloudLoadBalancerProtection.Delete = source.Delete
	return hcloudLoadBalancerProtection
}
func (c *converterImpl) schemaLoadBalancerPublicNetIPv4ToHcloudLoadBalancerPublicNetIPv4(source schema.LoadBalancerPublicNetIPv4) LoadBalancerPublicNetIPv4 {
	var hcloudLoadBalancerPublicNetIPv4 LoadBalancerPublicNetIPv4
	hcloudLoadBalancerPublicNetIPv4.IP = ipFromString(source.IP)
	hcloudLoadBalancerPublicNetIPv4.DNSPtr = source.DNSPtr
	return hcloudLoadBalancerPublicNetIPv4
}
func (c *converterImpl) schemaLoadBalancerPublicNetIPv6ToHcloudLoadBalancerPublicNetIPv6(source schema.LoadBalancerPublicNetIPv6) LoadBalancerPublicNetIPv6 {
	var hcloudLoadBalancerPublicNetIPv6 LoadBalancerPublicNetIPv6
	hcloudLoadBalancerPublicNetIPv6.IP = ipFromString(source.IP)
	hcloudLoadBalancerPublicNetIPv6.DNSPtr = source.DNSPtr
	return hcloudLoadBalancerPublicNetIPv6
}
func (c *converterImpl) schemaLoadBalancerPublicNetToHcloudLoadBalancerPublicNet(source schema.LoadBalancerPublicNet) LoadBalancerPublicNet {
	var hcloudLoadBalancerPublicNet LoadBalancerPublicNet
	hcloudLoadBalancerPublicNet.Enabled = source.Enabled
	hcloudLoadBalancerPublicNet.IPv4 = c.schemaLoadBalancerPublicNetIPv4ToHcloudLoadBalancerPublicNetIPv4(source.IPv4)
	hcloudLoadBalancerPublicNet.IPv6 = c.schemaLoadBalancerPublicNetIPv6ToHcloudLoadBalancerPublicNetIPv6(source.IPv6)
	return hcloudLoadBalancerPublicNet
}
func (c *converterImpl) schemaNetworkProtectionToHcloudNetworkProtection(source schema.NetworkProtection) NetworkProtection {
	var hcloudNetworkProtection NetworkProtection
	hcloudNetworkProtection.Delete = source.Delete
	return hcloudNetworkProtection
}
func (c *converterImpl) schemaPricingServerBackupToHcloudServerBackupPricing(source schema.PricingServerBackup) ServerBackupPricing {
	var hcloudServerBackupPricing ServerBackupPricing
	hcloudServerBackupPricing.Percentage = source.Percentage
	return hcloudServerBackupPricing
}
func (c *converterImpl) schemaPrimaryIPProtectionToHcloudPrimaryIPProtection(source schema.PrimaryIPProtection) PrimaryIPProtection {
	var hcloudPrimaryIPProtection PrimaryIPProtection
	hcloudPrimaryIPProtection.Delete = source.Delete
	return hcloudPrimaryIPProtection
}
func (c *converterImpl) schemaServerProtectionToHcloudServerProtection(source schema.ServerProtection) ServerProtection {
	var hcloudServerProtection ServerProtection
	hcloudServerProtection.Delete = source.Delete
	hcloudServerProtection.Rebuild = source.Rebuild
	return hcloudServerProtection
}
func (c *converterImpl) schemaStorageBoxAccessSettingsToHcloudStorageBoxAccessSettings(source schema.StorageBoxAccessSettings) StorageBoxAccessSettings {
	var hcloudStorageBoxAccessSettings StorageBoxAccessSettings
	hcloudStorageBoxAccessSettings.ReachableExternally = source.ReachableExternally
	hcloudStorageBoxAccessSettings.SambaEnabled = source.SambaEnabled
	hcloudStorageBoxAccessSettings.SSHEnabled = source.SSHEnabled
	hcloudStorageBoxAccessSettings.WebDAVEnabled = source.WebDAVEnabled
	hcloudStorageBoxAccessSettings.ZFSEnabled = source.ZFSEnabled
	return hcloudStorageBoxAccessSettings
}
func (c *converterImpl) schemaStorageBoxProtectionToHcloudStorageBoxProtection(source schema.StorageBoxProtection) StorageBoxProtection {
	var hcloudStorageBoxProtection StorageBoxProtection
	hcloudStorageBoxProtection.Delete = source.Delete
	return hcloudStorageBoxProtection
}
func (c *converterImpl) schemaStorageBoxSnapshotStatsToHcloudStorageBoxSnapshotStats(source schema.StorageBoxSnapshotStats) StorageBoxSnapshotStats {
	var hcloudStorageBoxSnapshotStats StorageBoxSnapshotStats
	hcloudStorageBoxSnapshotStats.Size = source.Size
	hcloudStorageBoxSnapshotStats.SizeFilesystem = source.SizeFilesystem
	return hcloudStorageBoxSnapshotStats
}
func (c *converterImpl) schemaStorageBoxStatsToHcloudStorageBoxStats(source schema.StorageBoxStats) StorageBoxStats {
	var hcloudStorageBoxStats StorageBoxStats
	hcloudStorageBoxStats.Size = source.Size
	hcloudStorageBoxStats.SizeData = source.SizeData
	hcloudStorageBoxStats.SizeSnapshots = source.SizeSnapshots
	return hcloudStorageBoxStats
}
func (c *converterImpl) schemaStorageBoxSubaccountAccessSettingsToPHcloudStorageBoxSubaccountAccessSettings(source schema.StorageBoxSubaccountAccessSettings) *StorageBoxSubaccountAccessSettings {
	var hcloudStorageBoxSubaccountAccessSettings StorageBoxSubaccountAccessSettings
	hcloudStorageBoxSubaccountAccessSettings.ReachableExternally = source.ReachableExternally
	hcloudStorageBoxSubaccountAccessSettings.Readonly = source.Readonly
	hcloudStorageBoxSubaccountAccessSettings.SambaEnabled = source.SambaEnabled
	hcloudStorageBoxSubaccountAccessSettings.SSHEnabled = source.SSHEnabled
	hcloudStorageBoxSubaccountAccessSettings.WebDAVEnabled = source.WebDAVEnabled
	return &hcloudStorageBoxSubaccountAccessSettings
}
func (c *converterImpl) schemaStorageBoxTypePriceToHcloudStorageBoxTypeLocationPricing(source schema.StorageBoxTypePrice) StorageBoxTypeLocationPricing {
	var hcloudStorageBoxTypeLocationPricing StorageBoxTypeLocationPricing
	hcloudStorageBoxTypeLocationPricing.Location = source.Location
	hcloudStorageBoxTypeLocationPricing.PriceHourly = c.PriceFromSchema(source.PriceHourly)
	hcloudStorageBoxTypeLocationPricing.PriceMonthly = c.PriceFromSchema(source.PriceMonthly)
	hcloudStorageBoxTypeLocationPricing.SetupFee = c.PriceFromSchema(source.SetupFee)
	return hcloudStorageBoxTypeLocationPricing
}
func (c *converterImpl) schemaVolumeProtectionToHcloudVolumeProtection(source schema.VolumeProtection) VolumeProtection {
	var hcloudVolumeProtection VolumeProtection
	hcloudVolumeProtection.Delete = source.Delete
	return hcloudVolumeProtection
}
func (c *converterImpl) schemaZoneAuthoritativeNameserversToHcloudZoneAuthoritativeNameservers(source schema.ZoneAuthoritativeNameservers) ZoneAuthoritativeNameservers {
	var hcloudZoneAuthoritativeNameservers ZoneAuthoritativeNameservers
	hcloudZoneAuthoritativeNameservers.Assigned = source.Assigned
	hcloudZoneAuthoritativeNameservers.Delegated = source.Delegated
	hcloudZoneAuthoritativeNameservers.DelegationLastCheck = c.timeTimeToTimeTime(source.DelegationLastCheck)
	hcloudZoneAuthoritativeNameservers.DelegationStatus = ZoneDelegationStatus(source.DelegationStatus)
	return hcloudZoneAuthoritativeNameservers
}
func (c *converterImpl) schemaZonePrimaryNameserverToHcloudZonePrimaryNameserver(source schema.ZonePrimaryNameserver) ZonePrimaryNameserver {
	var hcloudZonePrimaryNameserver ZonePrimaryNameserver
	hcloudZonePrimaryNameserver.Address = source.Address
	hcloudZonePrimaryNameserver.Port = source.Port
	hcloudZonePrimaryNameserver.TSIGAlgorithm = ZoneTSIGAlgorithm(source.TSIGAlgorithm)
	hcloudZonePrimaryNameserver.TSIGKey = source.TSIGKey
	return hcloudZonePrimaryNameserver
}
func (c *converterImpl) schemaZoneProtectionToHcloudZoneProtection(source schema.ZoneProtection) ZoneProtection {
	var hcloudZoneProtection ZoneProtection
	hcloudZoneProtection.Delete = source.Delete
	return hcloudZoneProtection
}
func (c *converterImpl) schemaZoneRRSetProtectionToHcloudZoneRRSetProtection(source schema.ZoneRRSetProtection) ZoneRRSetProtection {
	var hcloudZoneRRSetProtection ZoneRRSetProtection
	hcloudZoneRRSetProtection.Change = source.Change
	return hcloudZoneRRSetProtection
}
func (c *converterImpl) schemaZoneRRSetRecordToHcloudZoneRRSetRecord(source schema.ZoneRRSetRecord) ZoneRRSetRecord {
	var hcloudZoneRRSetRecord ZoneRRSetRecord
	hcloudZoneRRSetRecord.Value = source.Value
	hcloudZoneRRSetRecord.Comment = source.Comment
	return hcloudZoneRRSetRecord
}
func (c *converterImpl) serverTypeLocationFromSchema(source schema.ServerTypeLocation) ServerTypeLocation {
	var hcloudServerTypeLocation ServerTypeLocation
	hcloudServerTypeLocation.Location = locationFromServerTypeLocationSchema(source)
	hcloudServerTypeLocation.DeprecatableResource = c.schemaDeprecatableResourceToHcloudDeprecatableResource(source.DeprecatableResource)
	return hcloudServerTypeLocation
}
func (c *converterImpl) serverTypePricingFromSchema(source schema.PricingServerTypePrice) ServerTypeLocationPricing {
	var hcloudServerTypeLocationPricing ServerTypeLocationPricing
	hcloudLocation := locationFromString(source.Location)
	hcloudServerTypeLocationPricing.Location = &hcloudLocation
	hcloudServerTypeLocationPricing.Hourly = c.PriceFromSchema(source.PriceHourly)
	hcloudServerTypeLocationPricing.Monthly = c.PriceFromSchema(source.PriceMonthly)
	hcloudServerTypeLocationPricing.IncludedTraffic = source.IncludedTraffic
	hcloudServerTypeLocationPricing.PerTBTraffic = c.PriceFromSchema(source.PricePerTBTraffic)
	return hcloudServerTypeLocationPricing
}
func (c *converterImpl) timeTimeToTimeTime(source time.Time) time.Time {
	return source
}
