// Code generated by bpf2go; DO NOT EDIT.
//go:build 386 || amd64

package tpinjector

import (
	"bytes"
	_ "embed"
	"fmt"
	"io"
	"structs"

	"github.com/cilium/ebpf"
)

type BpfDebugCallProtocolArgsT struct {
	_               structs.HostLayout
	PidConn         BpfDebugPidConnectionInfoT
	ProtocolType    BpfDebugProtocolType
	Ssl             uint8
	Direction       uint8
	PacketType      uint8
	SmallBuf        [24]uint8
	Pad             [4]uint8
	BytesLen        int32
	OrigDport       uint16
	Pad2            uint16
	U_buf           uint64
	SelfRefParentId uint64
}

type BpfDebugConnectionInfoPartT struct {
	_    structs.HostLayout
	Addr [16]uint8
	Pid  uint32
	Port uint16
	Type uint8
	Pad  uint8
}

type BpfDebugConnectionInfoT struct {
	_      structs.HostLayout
	S_addr [16]uint8
	D_addr [16]uint8
	S_port uint16
	D_port uint16
}

type BpfDebugCpSupportDataT struct {
	_           structs.HostLayout
	T_key       BpfDebugTraceKeyT
	Ts          uint64
	RealClient  uint8
	Established uint8
	Failed      uint8
	Pad         [5]uint8
}

type BpfDebugEgressKeyT struct {
	_      structs.HostLayout
	S_port uint16
	D_port uint16
}

type BpfDebugFdInfoT struct {
	_    structs.HostLayout
	Pid  BpfDebugPidKeyT
	Fd   int32
	Type uint32
}

type BpfDebugFdKey struct {
	_       structs.HostLayout
	PidTgid uint64
	Fd      int32
	Pad     [4]uint8
}

type BpfDebugGrpcFramesCtxT struct {
	_               structs.HostLayout
	PrevInfo        BpfDebugHttp2GrpcRequestT
	HasPrevInfo     uint8
	FoundDataFrame  uint8
	Iterations      uint8
	TerminateSearch uint8
	Pos             int32
	SavedBufPos     int32
	SavedStreamId   uint32
	Args            BpfDebugCallProtocolArgsT
	Stream          BpfDebugHttp2ConnStreamT
	Pad             [4]uint8
}

type BpfDebugHttp2ConnInfoDataT struct {
	_     structs.HostLayout
	Id    uint64
	Flags uint8
	Pad   [7]uint8
}

type BpfDebugHttp2ConnStreamT struct {
	_        structs.HostLayout
	PidConn  BpfDebugPidConnectionInfoT
	StreamId uint32
}

type BpfDebugHttp2GrpcRequestT struct {
	_               structs.HostLayout
	Flags           uint8
	Ssl             uint8
	Type            uint8
	Pad0            [1]uint8
	ConnInfo        BpfDebugConnectionInfoT
	StartMonotimeNs uint64
	EndMonotimeNs   uint64
	Data            [256]uint8
	RetData         [64]uint8
	Len             int32
	Pid             struct {
		_       structs.HostLayout
		HostPid uint32
		UserPid uint32
		Ns      uint32
	}
	NewConnId uint64
	Tp        struct {
		_        structs.HostLayout
		TraceId  [16]uint8
		SpanId   [8]uint8
		ParentId [8]uint8
		Ts       uint64
		Flags    uint8
		Pad      [7]uint8
	}
}

type BpfDebugHttpConnectionMetadataT struct {
	_   structs.HostLayout
	Pid struct {
		_       structs.HostLayout
		HostPid uint32
		UserPid uint32
		Ns      uint32
	}
	Type uint8
	Pad  [3]uint8
}

type BpfDebugHttpInfoT struct {
	_               structs.HostLayout
	Flags           uint8
	Type            uint8
	Ssl             uint8
	Delayed         uint8
	ConnInfo        BpfDebugConnectionInfoT
	StartMonotimeNs uint64
	EndMonotimeNs   uint64
	ReqMonotimeNs   uint64
	ExtraId         uint64
	Tp              struct {
		_        structs.HostLayout
		TraceId  [16]uint8
		SpanId   [8]uint8
		ParentId [8]uint8
		Ts       uint64
		Flags    uint8
		Pad      [7]uint8
	}
	Pid struct {
		_       structs.HostLayout
		HostPid uint32
		UserPid uint32
		Ns      uint32
	}
	Len             uint32
	RespLen         uint32
	TaskTid         uint32
	Status          uint16
	Buf             [256]uint8
	HasLargeBuffers uint8
	Direction       uint8
	Submitted       uint8
	Pad             [3]uint8
}

type BpfDebugMsgBufferT struct {
	_           structs.HostLayout
	FallbackBuf [256]uint8
	Pos         uint16
	RealSize    uint16
	CpuId       uint32
}

type BpfDebugMysqlStateData struct {
	_             structs.HostLayout
	PayloadLength [3]uint8
	SequenceId    uint8
}

type BpfDebugPidConnectionInfoT struct {
	_    structs.HostLayout
	Conn BpfDebugConnectionInfoT
	Pid  uint32
}

type BpfDebugPidKeyT struct {
	_   structs.HostLayout
	Tid uint32
	Pid uint32
	Ns  uint32
}

type BpfDebugProtocolType uint8

const (
	BpfDebugProtocolTypeK_protocolTypeUnknown  BpfDebugProtocolType = 0
	BpfDebugProtocolTypeK_protocolTypeMysql    BpfDebugProtocolType = 1
	BpfDebugProtocolTypeK_protocolTypePostgres BpfDebugProtocolType = 2
	BpfDebugProtocolTypeK_protocolTypeHttp     BpfDebugProtocolType = 3
)

type BpfDebugSockPortNs struct {
	_     structs.HostLayout
	Netns uint32
	Port  uint16
	Pad   [2]uint8
}

type BpfDebugSslArgsT struct {
	_      structs.HostLayout
	Ssl    uint64
	Buf    uint64
	LenPtr uint64
	Flags  uint64
}

type BpfDebugSslPidConnectionInfoT struct {
	_         structs.HostLayout
	P_conn    BpfDebugPidConnectionInfoT
	OrigDport uint16
	Pad       [6]uint8
}

type BpfDebugTcpReqT struct {
	_               structs.HostLayout
	Flags           uint8
	Ssl             uint8
	Direction       uint8
	HasLargeBuffers uint8
	ProtocolType    BpfDebugProtocolType
	Pad1            [3]uint8
	ConnInfo        BpfDebugConnectionInfoT
	Len             uint32
	StartMonotimeNs uint64
	EndMonotimeNs   uint64
	ExtraId         uint64
	ReqLen          uint32
	RespLen         uint32
	Pad2            [4]uint8
	Buf             [256]uint8
	Rbuf            [128]uint8
	Pid             struct {
		_       structs.HostLayout
		HostPid uint32
		UserPid uint32
		Ns      uint32
	}
	Tp struct {
		_        structs.HostLayout
		TraceId  [16]uint8
		SpanId   [8]uint8
		ParentId [8]uint8
		Ts       uint64
		Flags    uint8
		Pad      [7]uint8
	}
}

type BpfDebugTpInfoPidT struct {
	_  structs.HostLayout
	Tp struct {
		_        structs.HostLayout
		TraceId  [16]uint8
		SpanId   [8]uint8
		ParentId [8]uint8
		Ts       uint64
		Flags    uint8
		Pad      [7]uint8
	}
	Pid     uint32
	Valid   uint8
	Written uint8
	ReqType uint8
	Pad     [1]uint8
}

type BpfDebugTraceKeyT struct {
	_       structs.HostLayout
	ExtraId uint64
	P_key   BpfDebugPidKeyT
	Pad     [4]uint8
}

type BpfDebugTraceMapKeyT struct {
	_    structs.HostLayout
	Conn BpfDebugConnectionInfoT
	Type uint32
}

// LoadBpfDebug returns the embedded CollectionSpec for BpfDebug.
func LoadBpfDebug() (*ebpf.CollectionSpec, error) {
	reader := bytes.NewReader(_BpfDebugBytes)
	spec, err := ebpf.LoadCollectionSpecFromReader(reader)
	if err != nil {
		return nil, fmt.Errorf("can't load BpfDebug: %w", err)
	}

	return spec, err
}

// LoadBpfDebugObjects loads BpfDebug and converts it into a struct.
//
// The following types are suitable as obj argument:
//
//	*BpfDebugObjects
//	*BpfDebugPrograms
//	*BpfDebugMaps
//
// See ebpf.CollectionSpec.LoadAndAssign documentation for details.
func LoadBpfDebugObjects(obj interface{}, opts *ebpf.CollectionOptions) error {
	spec, err := LoadBpfDebug()
	if err != nil {
		return err
	}

	return spec.LoadAndAssign(obj, opts)
}

// BpfDebugSpecs contains maps and programs before they are loaded into the kernel.
//
// It can be passed ebpf.CollectionSpec.Assign.
type BpfDebugSpecs struct {
	BpfDebugProgramSpecs
	BpfDebugMapSpecs
	BpfDebugVariableSpecs
}

// BpfDebugProgramSpecs contains programs before they are loaded into the kernel.
//
// It can be passed ebpf.CollectionSpec.Assign.
type BpfDebugProgramSpecs struct {
	ObiContinue2ProtocolHttp             *ebpf.ProgramSpec `ebpf:"obi_continue2_protocol_http"`
	ObiContinueProtocolHttp              *ebpf.ProgramSpec `ebpf:"obi_continue_protocol_http"`
	ObiPacketExtender                    *ebpf.ProgramSpec `ebpf:"obi_packet_extender"`
	ObiPacketExtenderWriteMsgTp          *ebpf.ProgramSpec `ebpf:"obi_packet_extender_write_msg_tp"`
	ObiProtocolHttp                      *ebpf.ProgramSpec `ebpf:"obi_protocol_http"`
	ObiProtocolHttp2                     *ebpf.ProgramSpec `ebpf:"obi_protocol_http2"`
	ObiProtocolHttp2GrpcFrames           *ebpf.ProgramSpec `ebpf:"obi_protocol_http2_grpc_frames"`
	ObiProtocolHttp2GrpcHandleEndFrame   *ebpf.ProgramSpec `ebpf:"obi_protocol_http2_grpc_handle_end_frame"`
	ObiProtocolHttp2GrpcHandleStartFrame *ebpf.ProgramSpec `ebpf:"obi_protocol_http2_grpc_handle_start_frame"`
	ObiProtocolHttpLegacy                *ebpf.ProgramSpec `ebpf:"obi_protocol_http_legacy"`
	ObiProtocolTcp                       *ebpf.ProgramSpec `ebpf:"obi_protocol_tcp"`
	ObiSockmapTracker                    *ebpf.ProgramSpec `ebpf:"obi_sockmap_tracker"`
}

// BpfDebugMapSpecs contains maps before they are loaded into the kernel.
//
// It can be passed ebpf.CollectionSpec.Assign.
type BpfDebugMapSpecs struct {
	AcceptedConnections         *ebpf.MapSpec `ebpf:"accepted_connections"`
	ActiveSslConnections        *ebpf.MapSpec `ebpf:"active_ssl_connections"`
	ActiveSslReadArgs           *ebpf.MapSpec `ebpf:"active_ssl_read_args"`
	ActiveSslWriteArgs          *ebpf.MapSpec `ebpf:"active_ssl_write_args"`
	ActiveUnixSocks             *ebpf.MapSpec `ebpf:"active_unix_socks"`
	CloneMap                    *ebpf.MapSpec `ebpf:"clone_map"`
	ConnectionMetaMem           *ebpf.MapSpec `ebpf:"connection_meta_mem"`
	CpSupportConnectInfo        *ebpf.MapSpec `ebpf:"cp_support_connect_info"`
	DebugEvents                 *ebpf.MapSpec `ebpf:"debug_events"`
	EgressKeyMem                *ebpf.MapSpec `ebpf:"egress_key_mem"`
	Events                      *ebpf.MapSpec `ebpf:"events"`
	ExtenderJumpTable           *ebpf.MapSpec `ebpf:"extender_jump_table"`
	FdMap                       *ebpf.MapSpec `ebpf:"fd_map"`
	FdToConnection              *ebpf.MapSpec `ebpf:"fd_to_connection"`
	GrpcFramesCtxMem            *ebpf.MapSpec `ebpf:"grpc_frames_ctx_mem"`
	Http2InfoMem                *ebpf.MapSpec `ebpf:"http2_info_mem"`
	HttpInfoMem                 *ebpf.MapSpec `ebpf:"http_info_mem"`
	HttpLargeBuffersStorage     *ebpf.MapSpec `ebpf:"http_large_buffers_storage"`
	IncomingTraceMap            *ebpf.MapSpec `ebpf:"incoming_trace_map"`
	IovecMem                    *ebpf.MapSpec `ebpf:"iovec_mem"`
	JumpTable                   *ebpf.MapSpec `ebpf:"jump_table"`
	ListeningPorts              *ebpf.MapSpec `ebpf:"listening_ports"`
	MsgBufferMem                *ebpf.MapSpec `ebpf:"msg_buffer_mem"`
	MsgBuffers                  *ebpf.MapSpec `ebpf:"msg_buffers"`
	MysqlLargeBuffersStorage    *ebpf.MapSpec `ebpf:"mysql_large_buffers_storage"`
	MysqlState                  *ebpf.MapSpec `ebpf:"mysql_state"`
	NginxUpstream               *ebpf.MapSpec `ebpf:"nginx_upstream"`
	NodejsFdMap                 *ebpf.MapSpec `ebpf:"nodejs_fd_map"`
	OngoingHttp                 *ebpf.MapSpec `ebpf:"ongoing_http"`
	OngoingHttp2Connections     *ebpf.MapSpec `ebpf:"ongoing_http2_connections"`
	OngoingHttp2Grpc            *ebpf.MapSpec `ebpf:"ongoing_http2_grpc"`
	OngoingTcpReq               *ebpf.MapSpec `ebpf:"ongoing_tcp_req"`
	OutgoingTraceMap            *ebpf.MapSpec `ebpf:"outgoing_trace_map"`
	PidCache                    *ebpf.MapSpec `ebpf:"pid_cache"`
	PidConnectionInfoMem        *ebpf.MapSpec `ebpf:"pid_connection_info_mem"`
	PostgresLargeBuffersStorage *ebpf.MapSpec `ebpf:"postgres_large_buffers_storage"`
	ProtocolArgsMem             *ebpf.MapSpec `ebpf:"protocol_args_mem"`
	ProtocolCache               *ebpf.MapSpec `ebpf:"protocol_cache"`
	ServerTraces                *ebpf.MapSpec `ebpf:"server_traces"`
	ServerTracesAux             *ebpf.MapSpec `ebpf:"server_traces_aux"`
	SockDir                     *ebpf.MapSpec `ebpf:"sock_dir"`
	SslToConn                   *ebpf.MapSpec `ebpf:"ssl_to_conn"`
	TcpReqMem                   *ebpf.MapSpec `ebpf:"tcp_req_mem"`
	TpCharBufMem                *ebpf.MapSpec `ebpf:"tp_char_buf_mem"`
	TpInfoMem                   *ebpf.MapSpec `ebpf:"tp_info_mem"`
	TraceMap                    *ebpf.MapSpec `ebpf:"trace_map"`
	ValidPids                   *ebpf.MapSpec `ebpf:"valid_pids"`
}

// BpfDebugVariableSpecs contains global variables before they are loaded into the kernel.
//
// It can be passed ebpf.CollectionSpec.Assign.
type BpfDebugVariableSpecs struct {
	EXTEND_SIZE         *ebpf.VariableSpec `ebpf:"EXTEND_SIZE"`
	INVALID_POS         *ebpf.VariableSpec `ebpf:"INVALID_POS"`
	TP                  *ebpf.VariableSpec `ebpf:"TP"`
	TP_PREFIX           *ebpf.VariableSpec `ebpf:"TP_PREFIX"`
	TP_PREFIX_SIZE      *ebpf.VariableSpec `ebpf:"TP_PREFIX_SIZE"`
	PnUnused            *ebpf.VariableSpec `ebpf:"__pn_unused"`
	CaptureHeaderBuffer *ebpf.VariableSpec `ebpf:"capture_header_buffer"`
	DisableBlackBoxCp   *ebpf.VariableSpec `ebpf:"disable_black_box_cp"`
	FilterPids          *ebpf.VariableSpec `ebpf:"filter_pids"`
	HighRequestVolume   *ebpf.VariableSpec `ebpf:"high_request_volume"`
	HttpBufferSize      *ebpf.VariableSpec `ebpf:"http_buffer_size"`
	Ip4ip6Prefix        *ebpf.VariableSpec `ebpf:"ip4ip6_prefix"`
	MaxTransactionTime  *ebpf.VariableSpec `ebpf:"max_transaction_time"`
	MysqlBufferSize     *ebpf.VariableSpec `ebpf:"mysql_buffer_size"`
	PostgresBufferSize  *ebpf.VariableSpec `ebpf:"postgres_buffer_size"`
	Unused              *ebpf.VariableSpec `ebpf:"unused"`
	UnusedHttp2         *ebpf.VariableSpec `ebpf:"unused_http2"`
	WakeupDataBytes     *ebpf.VariableSpec `ebpf:"wakeup_data_bytes"`
}

// BpfDebugObjects contains all objects after they have been loaded into the kernel.
//
// It can be passed to LoadBpfDebugObjects or ebpf.CollectionSpec.LoadAndAssign.
type BpfDebugObjects struct {
	BpfDebugPrograms
	BpfDebugMaps
	BpfDebugVariables
}

func (o *BpfDebugObjects) Close() error {
	return _BpfDebugClose(
		&o.BpfDebugPrograms,
		&o.BpfDebugMaps,
	)
}

// BpfDebugMaps contains all maps after they have been loaded into the kernel.
//
// It can be passed to LoadBpfDebugObjects or ebpf.CollectionSpec.LoadAndAssign.
type BpfDebugMaps struct {
	AcceptedConnections         *ebpf.Map `ebpf:"accepted_connections"`
	ActiveSslConnections        *ebpf.Map `ebpf:"active_ssl_connections"`
	ActiveSslReadArgs           *ebpf.Map `ebpf:"active_ssl_read_args"`
	ActiveSslWriteArgs          *ebpf.Map `ebpf:"active_ssl_write_args"`
	ActiveUnixSocks             *ebpf.Map `ebpf:"active_unix_socks"`
	CloneMap                    *ebpf.Map `ebpf:"clone_map"`
	ConnectionMetaMem           *ebpf.Map `ebpf:"connection_meta_mem"`
	CpSupportConnectInfo        *ebpf.Map `ebpf:"cp_support_connect_info"`
	DebugEvents                 *ebpf.Map `ebpf:"debug_events"`
	EgressKeyMem                *ebpf.Map `ebpf:"egress_key_mem"`
	Events                      *ebpf.Map `ebpf:"events"`
	ExtenderJumpTable           *ebpf.Map `ebpf:"extender_jump_table"`
	FdMap                       *ebpf.Map `ebpf:"fd_map"`
	FdToConnection              *ebpf.Map `ebpf:"fd_to_connection"`
	GrpcFramesCtxMem            *ebpf.Map `ebpf:"grpc_frames_ctx_mem"`
	Http2InfoMem                *ebpf.Map `ebpf:"http2_info_mem"`
	HttpInfoMem                 *ebpf.Map `ebpf:"http_info_mem"`
	HttpLargeBuffersStorage     *ebpf.Map `ebpf:"http_large_buffers_storage"`
	IncomingTraceMap            *ebpf.Map `ebpf:"incoming_trace_map"`
	IovecMem                    *ebpf.Map `ebpf:"iovec_mem"`
	JumpTable                   *ebpf.Map `ebpf:"jump_table"`
	ListeningPorts              *ebpf.Map `ebpf:"listening_ports"`
	MsgBufferMem                *ebpf.Map `ebpf:"msg_buffer_mem"`
	MsgBuffers                  *ebpf.Map `ebpf:"msg_buffers"`
	MysqlLargeBuffersStorage    *ebpf.Map `ebpf:"mysql_large_buffers_storage"`
	MysqlState                  *ebpf.Map `ebpf:"mysql_state"`
	NginxUpstream               *ebpf.Map `ebpf:"nginx_upstream"`
	NodejsFdMap                 *ebpf.Map `ebpf:"nodejs_fd_map"`
	OngoingHttp                 *ebpf.Map `ebpf:"ongoing_http"`
	OngoingHttp2Connections     *ebpf.Map `ebpf:"ongoing_http2_connections"`
	OngoingHttp2Grpc            *ebpf.Map `ebpf:"ongoing_http2_grpc"`
	OngoingTcpReq               *ebpf.Map `ebpf:"ongoing_tcp_req"`
	OutgoingTraceMap            *ebpf.Map `ebpf:"outgoing_trace_map"`
	PidCache                    *ebpf.Map `ebpf:"pid_cache"`
	PidConnectionInfoMem        *ebpf.Map `ebpf:"pid_connection_info_mem"`
	PostgresLargeBuffersStorage *ebpf.Map `ebpf:"postgres_large_buffers_storage"`
	ProtocolArgsMem             *ebpf.Map `ebpf:"protocol_args_mem"`
	ProtocolCache               *ebpf.Map `ebpf:"protocol_cache"`
	ServerTraces                *ebpf.Map `ebpf:"server_traces"`
	ServerTracesAux             *ebpf.Map `ebpf:"server_traces_aux"`
	SockDir                     *ebpf.Map `ebpf:"sock_dir"`
	SslToConn                   *ebpf.Map `ebpf:"ssl_to_conn"`
	TcpReqMem                   *ebpf.Map `ebpf:"tcp_req_mem"`
	TpCharBufMem                *ebpf.Map `ebpf:"tp_char_buf_mem"`
	TpInfoMem                   *ebpf.Map `ebpf:"tp_info_mem"`
	TraceMap                    *ebpf.Map `ebpf:"trace_map"`
	ValidPids                   *ebpf.Map `ebpf:"valid_pids"`
}

func (m *BpfDebugMaps) Close() error {
	return _BpfDebugClose(
		m.AcceptedConnections,
		m.ActiveSslConnections,
		m.ActiveSslReadArgs,
		m.ActiveSslWriteArgs,
		m.ActiveUnixSocks,
		m.CloneMap,
		m.ConnectionMetaMem,
		m.CpSupportConnectInfo,
		m.DebugEvents,
		m.EgressKeyMem,
		m.Events,
		m.ExtenderJumpTable,
		m.FdMap,
		m.FdToConnection,
		m.GrpcFramesCtxMem,
		m.Http2InfoMem,
		m.HttpInfoMem,
		m.HttpLargeBuffersStorage,
		m.IncomingTraceMap,
		m.IovecMem,
		m.JumpTable,
		m.ListeningPorts,
		m.MsgBufferMem,
		m.MsgBuffers,
		m.MysqlLargeBuffersStorage,
		m.MysqlState,
		m.NginxUpstream,
		m.NodejsFdMap,
		m.OngoingHttp,
		m.OngoingHttp2Connections,
		m.OngoingHttp2Grpc,
		m.OngoingTcpReq,
		m.OutgoingTraceMap,
		m.PidCache,
		m.PidConnectionInfoMem,
		m.PostgresLargeBuffersStorage,
		m.ProtocolArgsMem,
		m.ProtocolCache,
		m.ServerTraces,
		m.ServerTracesAux,
		m.SockDir,
		m.SslToConn,
		m.TcpReqMem,
		m.TpCharBufMem,
		m.TpInfoMem,
		m.TraceMap,
		m.ValidPids,
	)
}

// BpfDebugVariables contains all global variables after they have been loaded into the kernel.
//
// It can be passed to LoadBpfDebugObjects or ebpf.CollectionSpec.LoadAndAssign.
type BpfDebugVariables struct {
	EXTEND_SIZE         *ebpf.Variable `ebpf:"EXTEND_SIZE"`
	INVALID_POS         *ebpf.Variable `ebpf:"INVALID_POS"`
	TP                  *ebpf.Variable `ebpf:"TP"`
	TP_PREFIX           *ebpf.Variable `ebpf:"TP_PREFIX"`
	TP_PREFIX_SIZE      *ebpf.Variable `ebpf:"TP_PREFIX_SIZE"`
	PnUnused            *ebpf.Variable `ebpf:"__pn_unused"`
	CaptureHeaderBuffer *ebpf.Variable `ebpf:"capture_header_buffer"`
	DisableBlackBoxCp   *ebpf.Variable `ebpf:"disable_black_box_cp"`
	FilterPids          *ebpf.Variable `ebpf:"filter_pids"`
	HighRequestVolume   *ebpf.Variable `ebpf:"high_request_volume"`
	HttpBufferSize      *ebpf.Variable `ebpf:"http_buffer_size"`
	Ip4ip6Prefix        *ebpf.Variable `ebpf:"ip4ip6_prefix"`
	MaxTransactionTime  *ebpf.Variable `ebpf:"max_transaction_time"`
	MysqlBufferSize     *ebpf.Variable `ebpf:"mysql_buffer_size"`
	PostgresBufferSize  *ebpf.Variable `ebpf:"postgres_buffer_size"`
	Unused              *ebpf.Variable `ebpf:"unused"`
	UnusedHttp2         *ebpf.Variable `ebpf:"unused_http2"`
	WakeupDataBytes     *ebpf.Variable `ebpf:"wakeup_data_bytes"`
}

// BpfDebugPrograms contains all programs after they have been loaded into the kernel.
//
// It can be passed to LoadBpfDebugObjects or ebpf.CollectionSpec.LoadAndAssign.
type BpfDebugPrograms struct {
	ObiContinue2ProtocolHttp             *ebpf.Program `ebpf:"obi_continue2_protocol_http"`
	ObiContinueProtocolHttp              *ebpf.Program `ebpf:"obi_continue_protocol_http"`
	ObiPacketExtender                    *ebpf.Program `ebpf:"obi_packet_extender"`
	ObiPacketExtenderWriteMsgTp          *ebpf.Program `ebpf:"obi_packet_extender_write_msg_tp"`
	ObiProtocolHttp                      *ebpf.Program `ebpf:"obi_protocol_http"`
	ObiProtocolHttp2                     *ebpf.Program `ebpf:"obi_protocol_http2"`
	ObiProtocolHttp2GrpcFrames           *ebpf.Program `ebpf:"obi_protocol_http2_grpc_frames"`
	ObiProtocolHttp2GrpcHandleEndFrame   *ebpf.Program `ebpf:"obi_protocol_http2_grpc_handle_end_frame"`
	ObiProtocolHttp2GrpcHandleStartFrame *ebpf.Program `ebpf:"obi_protocol_http2_grpc_handle_start_frame"`
	ObiProtocolHttpLegacy                *ebpf.Program `ebpf:"obi_protocol_http_legacy"`
	ObiProtocolTcp                       *ebpf.Program `ebpf:"obi_protocol_tcp"`
	ObiSockmapTracker                    *ebpf.Program `ebpf:"obi_sockmap_tracker"`
}

func (p *BpfDebugPrograms) Close() error {
	return _BpfDebugClose(
		p.ObiContinue2ProtocolHttp,
		p.ObiContinueProtocolHttp,
		p.ObiPacketExtender,
		p.ObiPacketExtenderWriteMsgTp,
		p.ObiProtocolHttp,
		p.ObiProtocolHttp2,
		p.ObiProtocolHttp2GrpcFrames,
		p.ObiProtocolHttp2GrpcHandleEndFrame,
		p.ObiProtocolHttp2GrpcHandleStartFrame,
		p.ObiProtocolHttpLegacy,
		p.ObiProtocolTcp,
		p.ObiSockmapTracker,
	)
}

func _BpfDebugClose(closers ...io.Closer) error {
	for _, closer := range closers {
		if err := closer.Close(); err != nil {
			return err
		}
	}
	return nil
}

// Do not access this directly.
//
//go:embed bpfdebug_x86_bpfel.o
var _BpfDebugBytes []byte
