/* user-collection.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from user-collection.vala, do not modify */

/* This file is part of GNOME Games. License: GPL-3.0+.*/

#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include "gnome-games.h"
#include <gio/gio.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define GAMES_TYPE_COLLECTION (games_collection_get_type ())
#define GAMES_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAMES_TYPE_COLLECTION, GamesCollection))
#define GAMES_IS_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAMES_TYPE_COLLECTION))
#define GAMES_COLLECTION_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GAMES_TYPE_COLLECTION, GamesCollectionIface))

typedef struct _GamesCollection GamesCollection;
typedef struct _GamesCollectionIface GamesCollectionIface;

#define GAMES_TYPE_GAME_MODEL (games_game_model_get_type ())
#define GAMES_GAME_MODEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAMES_TYPE_GAME_MODEL, GamesGameModel))
#define GAMES_GAME_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAMES_TYPE_GAME_MODEL, GamesGameModelClass))
#define GAMES_IS_GAME_MODEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAMES_TYPE_GAME_MODEL))
#define GAMES_IS_GAME_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAMES_TYPE_GAME_MODEL))
#define GAMES_GAME_MODEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAMES_TYPE_GAME_MODEL, GamesGameModelClass))

typedef struct _GamesGameModel GamesGameModel;
typedef struct _GamesGameModelClass GamesGameModelClass;
typedef enum  {
	GAMES_COLLECTION_TYPE_AUTO,
	GAMES_COLLECTION_TYPE_USER,
	GAMES_COLLECTION_TYPE_PLACEHOLDER
} GamesCollectionType;

#define GAMES_TYPE_COLLECTION_TYPE (games_collection_type_get_type ())

#define GAMES_TYPE_USER_COLLECTION (games_user_collection_get_type ())
#define GAMES_USER_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAMES_TYPE_USER_COLLECTION, GamesUserCollection))
#define GAMES_USER_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAMES_TYPE_USER_COLLECTION, GamesUserCollectionClass))
#define GAMES_IS_USER_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAMES_TYPE_USER_COLLECTION))
#define GAMES_IS_USER_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAMES_TYPE_USER_COLLECTION))
#define GAMES_USER_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAMES_TYPE_USER_COLLECTION, GamesUserCollectionClass))

typedef struct _GamesUserCollection GamesUserCollection;
typedef struct _GamesUserCollectionClass GamesUserCollectionClass;
typedef struct _GamesUserCollectionPrivate GamesUserCollectionPrivate;

#define GAMES_TYPE_DATABASE (games_database_get_type ())
#define GAMES_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAMES_TYPE_DATABASE, GamesDatabase))
#define GAMES_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAMES_TYPE_DATABASE, GamesDatabaseClass))
#define GAMES_IS_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAMES_TYPE_DATABASE))
#define GAMES_IS_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAMES_TYPE_DATABASE))
#define GAMES_DATABASE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAMES_TYPE_DATABASE, GamesDatabaseClass))

typedef struct _GamesDatabase GamesDatabase;
typedef struct _GamesDatabaseClass GamesDatabaseClass;

#define GAMES_TYPE_GAME_COLLECTION (games_game_collection_get_type ())
#define GAMES_GAME_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAMES_TYPE_GAME_COLLECTION, GamesGameCollection))
#define GAMES_GAME_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAMES_TYPE_GAME_COLLECTION, GamesGameCollectionClass))
#define GAMES_IS_GAME_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAMES_TYPE_GAME_COLLECTION))
#define GAMES_IS_GAME_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAMES_TYPE_GAME_COLLECTION))
#define GAMES_GAME_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAMES_TYPE_GAME_COLLECTION, GamesGameCollectionClass))

typedef struct _GamesGameCollection GamesGameCollection;
typedef struct _GamesGameCollectionClass GamesGameCollectionClass;
enum  {
	GAMES_USER_COLLECTION_0_PROPERTY,
	GAMES_USER_COLLECTION_IS_EMPTY_PROPERTY,
	GAMES_USER_COLLECTION_TITLE_PROPERTY,
	GAMES_USER_COLLECTION_NUM_PROPERTIES
};
static GParamSpec* games_user_collection_properties[GAMES_USER_COLLECTION_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _GamesGameModelPrivate GamesGameModelPrivate;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _Block2Data Block2Data;

struct _GamesCollectionIface {
	GTypeInterface parent_iface;
	void (*load) (GamesCollection* self);
	gchar* (*get_id) (GamesCollection* self);
	gboolean (*get_hide_stars) (GamesCollection* self);
	GamesGameModel* (*get_game_model) (GamesCollection* self);
	GamesCollectionType (*get_collection_type) (GamesCollection* self);
	void (*add_games) (GamesCollection* self, GamesGame** games, gint games_length1);
	void (*remove_games) (GamesCollection* self, GamesGame** games, gint games_length1);
	void (*on_game_added) (GamesCollection* self, GamesGame* game);
	void (*on_game_removed) (GamesCollection* self, GamesGame* game);
	void (*on_game_replaced) (GamesCollection* self, GamesGame* game, GamesGame* prev_game);
	gboolean (*get_is_empty) (GamesCollection* self);
	const gchar* (*get_title) (GamesCollection* self);
};

struct _GamesUserCollection {
	GObject parent_instance;
	GamesUserCollectionPrivate * priv;
};

struct _GamesUserCollectionClass {
	GObjectClass parent_class;
};

struct _GamesUserCollectionPrivate {
	GamesGameModel* game_model;
	GamesDatabase* database;
	GHashTable* load_game_uids;
	GHashTable* game_uids;
	GamesGameCollection* game_collection;
	gchar* id;
	gulong idle_id;
	gulong on_game_added_id;
	gchar* _title;
};

struct _GamesGameModel {
	GObject parent_instance;
	GamesGameModelPrivate * priv;
	gboolean always_replace;
};

struct _GamesGameModelClass {
	GObjectClass parent_class;
};

struct _Block2Data {
	int _ref_count_;
	GHashTable* self;
	GFunc func;
	gpointer func_target;
};

static gint GamesUserCollection_private_offset;
static gpointer games_user_collection_parent_class = NULL;
static GamesCollectionIface * games_user_collection_games_collection_parent_iface = NULL;

VALA_EXTERN GType games_game_model_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType games_collection_type_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType games_collection_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType games_user_collection_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType games_database_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType games_game_collection_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GamesUserCollection* games_user_collection_new (const gchar* id,
                                                const gchar* title,
                                                GamesDatabase* database);
VALA_EXTERN GamesUserCollection* games_user_collection_construct (GType object_type,
                                                      const gchar* id,
                                                      const gchar* title,
                                                      GamesDatabase* database);
static guint _games_uid_hash_ghash_func (gconstpointer key);
static gboolean _games_uid_equal_gequal_func (gconstpointer a,
                                       gconstpointer b);
static void _g_object_unref0_ (gpointer var);
VALA_EXTERN GamesApplication* games_application_get_default (void);
VALA_EXTERN GamesGameCollection* games_application_get_collection (GamesApplication* self);
VALA_EXTERN void games_collection_on_game_added (GamesCollection* self,
                                     GamesGame* game);
static void _games_collection_on_game_added_games_game_collection_game_added (GamesGameCollection* _sender,
                                                                       GamesGame* game,
                                                                       gpointer self);
VALA_EXTERN void games_collection_on_game_removed (GamesCollection* self,
                                       GamesGame* game);
static void _games_collection_on_game_removed_games_game_collection_game_removed (GamesGameCollection* _sender,
                                                                           GamesGame* game,
                                                                           gpointer self);
VALA_EXTERN void games_collection_on_game_replaced (GamesCollection* self,
                                        GamesGame* game,
                                        GamesGame* prev_game);
static void _games_collection_on_game_replaced_games_game_collection_game_replaced (GamesGameCollection* _sender,
                                                                             GamesGame* game,
                                                                             GamesGame* prev_game,
                                                                             gpointer self);
VALA_EXTERN GamesGameModel* games_game_model_new (void);
VALA_EXTERN GamesGameModel* games_game_model_construct (GType object_type);
static gchar* games_user_collection_real_get_id (GamesCollection* base);
VALA_EXTERN void games_user_collection_set_title (GamesUserCollection* self,
                                      const gchar* value);
VALA_EXTERN const gchar* games_collection_get_title (GamesCollection* self);
VALA_EXTERN gboolean games_database_rename_user_collection (GamesDatabase* self,
                                                GamesUserCollection* collection,
                                                const gchar* title,
                                                GError** error);
static GamesGameModel* games_user_collection_real_get_game_model (GamesCollection* base);
static gboolean games_user_collection_real_get_hide_stars (GamesCollection* base);
static GamesCollectionType games_user_collection_real_get_collection_type (GamesCollection* base);
static void games_user_collection_real_load (GamesCollection* base);
VALA_EXTERN GHashTable* games_database_list_games_in_user_collection (GamesDatabase* self,
                                                          GamesUserCollection* collection,
                                                          GError** error);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
static void ___lambda2__gh_func (gconstpointer key,
                          gconstpointer value,
                          gpointer self);
static void ___lambda16_ (GamesUserCollection* self,
                   GamesUid* uid);
static void ____lambda16__gfunc (gconstpointer data,
                          gpointer self);
static void games_user_collection_real_add_games (GamesCollection* base,
                                           GamesGame** games,
                                           gint games_length1);
VALA_EXTERN gboolean games_database_add_game_to_user_collection (GamesDatabase* self,
                                                     GamesGame* game,
                                                     GamesUserCollection* collection,
                                                     GError** error);
VALA_EXTERN void games_game_model_add_game (GamesGameModel* self,
                                GamesGame* game);
static void games_user_collection_real_remove_games (GamesCollection* base,
                                              GamesGame** games,
                                              gint games_length1);
VALA_EXTERN gboolean games_database_remove_game_from_user_collection (GamesDatabase* self,
                                                          GamesGame* game,
                                                          GamesUserCollection* collection,
                                                          GError** error);
VALA_EXTERN void games_game_model_remove_game (GamesGameModel* self,
                                   GamesGame* game);
static void games_user_collection_real_on_game_added (GamesCollection* base,
                                               GamesGame* game);
static gboolean ____lambda15_ (GamesUserCollection* self);
static gboolean _____lambda15__gsource_func (gpointer self);
static void games_user_collection_real_on_game_removed (GamesCollection* base,
                                                 GamesGame* game);
static void games_user_collection_real_on_game_replaced (GamesCollection* base,
                                                  GamesGame* game,
                                                  GamesGame* prev_game);
VALA_EXTERN void games_game_model_replace_game (GamesGameModel* self,
                                    GamesGame* game,
                                    GamesGame* prev_game);
VALA_EXTERN gchar* games_collection_get_id (GamesCollection* self);
VALA_EXTERN GamesGameModel* games_collection_get_game_model (GamesCollection* self);
VALA_EXTERN gboolean games_collection_get_hide_stars (GamesCollection* self);
VALA_EXTERN GamesCollectionType games_collection_get_collection_type (GamesCollection* self);
VALA_EXTERN void games_collection_load (GamesCollection* self);
VALA_EXTERN void games_collection_add_games (GamesCollection* self,
                                 GamesGame** games,
                                 gint games_length1);
VALA_EXTERN void games_collection_remove_games (GamesCollection* self,
                                    GamesGame** games,
                                    gint games_length1);
VALA_EXTERN gboolean games_collection_get_is_empty (GamesCollection* self);
static void games_user_collection_finalize (GObject * obj);
static GType games_user_collection_get_type_once (void);
static void _vala_games_user_collection_get_property (GObject * object,
                                               guint property_id,
                                               GValue * value,
                                               GParamSpec * pspec);

static inline gpointer
games_user_collection_get_instance_private (GamesUserCollection* self)
{
	return G_STRUCT_MEMBER_P (self, GamesUserCollection_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static guint
_games_uid_hash_ghash_func (gconstpointer key)
{
	guint result;
	result = games_uid_hash ((GamesUid*) key);
	return result;
}

static gboolean
_games_uid_equal_gequal_func (gconstpointer a,
                              gconstpointer b)
{
	gboolean result;
	result = games_uid_equal ((GamesUid*) a, (GamesUid*) b);
	return result;
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static void
_games_collection_on_game_added_games_game_collection_game_added (GamesGameCollection* _sender,
                                                                  GamesGame* game,
                                                                  gpointer self)
{
	games_collection_on_game_added ((GamesCollection*) self, game);
}

static void
_games_collection_on_game_removed_games_game_collection_game_removed (GamesGameCollection* _sender,
                                                                      GamesGame* game,
                                                                      gpointer self)
{
	games_collection_on_game_removed ((GamesCollection*) self, game);
}

static void
_games_collection_on_game_replaced_games_game_collection_game_replaced (GamesGameCollection* _sender,
                                                                        GamesGame* game,
                                                                        GamesGame* prev_game,
                                                                        gpointer self)
{
	games_collection_on_game_replaced ((GamesCollection*) self, game, prev_game);
}

GamesUserCollection*
games_user_collection_construct (GType object_type,
                                 const gchar* id,
                                 const gchar* title,
                                 GamesDatabase* database)
{
	GamesUserCollection * self = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	GamesDatabase* _tmp2_;
	GHashTable* _tmp3_;
	GamesApplication* _tmp4_;
	GamesApplication* _tmp5_;
	GamesGameCollection* _tmp6_;
	GamesGameCollection* _tmp7_;
	gulong _tmp8_;
	GamesGameCollection* _tmp9_;
	GamesGameCollection* _tmp10_;
	GamesGameModel* _tmp11_;
	GamesGameModel* _tmp12_;
	g_return_val_if_fail (id != NULL, NULL);
	g_return_val_if_fail (title != NULL, NULL);
	g_return_val_if_fail (database != NULL, NULL);
	self = (GamesUserCollection*) g_object_new (object_type, NULL);
	_tmp0_ = g_strdup (id);
	_g_free0 (self->priv->id);
	self->priv->id = _tmp0_;
	_tmp1_ = g_strdup (title);
	_g_free0 (self->priv->_title);
	self->priv->_title = _tmp1_;
	_tmp2_ = _g_object_ref0 (database);
	_g_object_unref0 (self->priv->database);
	self->priv->database = _tmp2_;
	_tmp3_ = g_hash_table_new_full (_games_uid_hash_ghash_func, _games_uid_equal_gequal_func, NULL, _g_object_unref0_);
	_g_hash_table_unref0 (self->priv->game_uids);
	self->priv->game_uids = _tmp3_;
	_tmp4_ = games_application_get_default ();
	_tmp5_ = _tmp4_;
	_tmp6_ = games_application_get_collection (_tmp5_);
	_g_object_unref0 (self->priv->game_collection);
	self->priv->game_collection = _tmp6_;
	_g_object_unref0 (_tmp5_);
	_tmp7_ = self->priv->game_collection;
	_tmp8_ = g_signal_connect_object (_tmp7_, "game-added", (GCallback) _games_collection_on_game_added_games_game_collection_game_added, (GamesCollection*) self, 0);
	self->priv->on_game_added_id = _tmp8_;
	_tmp9_ = self->priv->game_collection;
	g_signal_connect_object (_tmp9_, "game-removed", (GCallback) _games_collection_on_game_removed_games_game_collection_game_removed, (GamesCollection*) self, 0);
	_tmp10_ = self->priv->game_collection;
	g_signal_connect_object (_tmp10_, "game-replaced", (GCallback) _games_collection_on_game_replaced_games_game_collection_game_replaced, (GamesCollection*) self, 0);
	_tmp11_ = games_game_model_new ();
	_g_object_unref0 (self->priv->game_model);
	self->priv->game_model = _tmp11_;
	_tmp12_ = self->priv->game_model;
	_tmp12_->always_replace = TRUE;
	return self;
}

GamesUserCollection*
games_user_collection_new (const gchar* id,
                           const gchar* title,
                           GamesDatabase* database)
{
	return games_user_collection_construct (GAMES_TYPE_USER_COLLECTION, id, title, database);
}

static gchar*
games_user_collection_real_get_id (GamesCollection* base)
{
	GamesUserCollection * self;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
	self = (GamesUserCollection*) base;
	_tmp0_ = self->priv->id;
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}

void
games_user_collection_set_title (GamesUserCollection* self,
                                 const gchar* value)
{
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (value != NULL);
	_tmp0_ = games_collection_get_title ((GamesCollection*) self);
	_tmp1_ = _tmp0_;
	if (g_strcmp0 (_tmp1_, value) == 0) {
		return;
	}
	{
		gboolean _tmp2_ = FALSE;
		GamesDatabase* _tmp3_;
		_tmp3_ = self->priv->database;
		_tmp2_ = games_database_rename_user_collection (_tmp3_, self, value, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		if (_tmp2_) {
			gchar* _tmp4_;
			_tmp4_ = g_strdup (value);
			_g_free0 (self->priv->_title);
			self->priv->_title = _tmp4_;
			g_object_notify ((GObject*) self, "title");
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp5_;
		const gchar* _tmp6_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp5_ = e;
		_tmp6_ = _tmp5_->message;
		g_critical ("user-collection.vala:53: %s", _tmp6_);
		_g_error_free0 (e);
		return;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static GamesGameModel*
games_user_collection_real_get_game_model (GamesCollection* base)
{
	GamesUserCollection * self;
	GamesGameModel* _tmp0_;
	GamesGameModel* _tmp1_;
	GamesGameModel* result;
	self = (GamesUserCollection*) base;
	_tmp0_ = self->priv->game_model;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

static gboolean
games_user_collection_real_get_hide_stars (GamesCollection* base)
{
	GamesUserCollection * self;
	gboolean result;
	self = (GamesUserCollection*) base;
	result = FALSE;
	return result;
}

static GamesCollectionType
games_user_collection_real_get_collection_type (GamesCollection* base)
{
	GamesUserCollection * self;
	GamesCollectionType result;
	self = (GamesUserCollection*) base;
	result = GAMES_COLLECTION_TYPE_USER;
	return result;
}

static Block2Data*
block2_data_ref (Block2Data* _data2_)
{
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}

static void
block2_data_unref (void * _userdata_)
{
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		GHashTable* self;
		self = _data2_->self;
		_g_hash_table_unref0 (self);
		g_slice_free (Block2Data, _data2_);
	}
}

static void
__lambda2_ (Block2Data* _data2_,
            gconstpointer k,
            gconstpointer v)
{
	GHashTable* self;
	self = _data2_->self;
	_data2_->func (v, _data2_->func_target);
}

static void
___lambda2__gh_func (gconstpointer key,
                     gconstpointer value,
                     gpointer self)
{
	__lambda2_ (self, key, value);
}

static void
_vala_g_hash_set_foreach (GHashTable* self,
                          GFunc func,
                          gpointer func_target)
{
	Block2Data* _data2_;
	g_return_if_fail (self != NULL);
	_data2_ = g_slice_new0 (Block2Data);
	_data2_->_ref_count_ = 1;
	_data2_->self = g_hash_table_ref (self);
	_data2_->func = func;
	_data2_->func_target = func_target;
	g_hash_table_foreach ((GHashTable*) self, ___lambda2__gh_func, _data2_);
	block2_data_unref (_data2_);
	_data2_ = NULL;
}

static void
___lambda16_ (GamesUserCollection* self,
              GamesUid* uid)
{
	GHashTable* _tmp0_;
	GamesUid* _tmp1_;
	g_return_if_fail (uid != NULL);
	_tmp0_ = self->priv->game_uids;
	_tmp1_ = _g_object_ref0 (uid);
	g_hash_table_add (_tmp0_, _tmp1_);
}

static void
____lambda16__gfunc (gconstpointer data,
                     gpointer self)
{
	___lambda16_ ((GamesUserCollection*) self, (GamesUid*) data);
}

static void
games_user_collection_real_load (GamesCollection* base)
{
	GamesUserCollection * self;
	GError* _inner_error0_ = NULL;
	self = (GamesUserCollection*) base;
	{
		GHashTable* _tmp0_ = NULL;
		GamesDatabase* _tmp1_;
		GHashTable* _tmp2_;
		GHashTable* _tmp3_;
		GHashTable* _tmp4_;
		_tmp1_ = self->priv->database;
		_tmp2_ = games_database_list_games_in_user_collection (_tmp1_, self, &_inner_error0_);
		_tmp0_ = _tmp2_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp3_ = _tmp0_;
		_tmp0_ = NULL;
		_g_hash_table_unref0 (self->priv->load_game_uids);
		self->priv->load_game_uids = _tmp3_;
		_tmp4_ = self->priv->load_game_uids;
		_vala_g_hash_set_foreach (_tmp4_, ____lambda16__gfunc, self);
		_g_hash_table_unref0 (_tmp0_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp5_;
		const gchar* _tmp6_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp5_ = e;
		_tmp6_ = _tmp5_->message;
		g_critical ("user-collection.vala:77: Failed to load favorite game uids: %s", _tmp6_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
games_user_collection_real_add_games (GamesCollection* base,
                                      GamesGame** games,
                                      gint games_length1)
{
	GamesUserCollection * self;
	GError* _inner_error0_ = NULL;
	self = (GamesUserCollection*) base;
	{
		{
			GamesGame** game_collection = NULL;
			gint game_collection_length1 = 0;
			gint _game_collection_size_ = 0;
			gint game_it = 0;
			game_collection = games;
			game_collection_length1 = games_length1;
			for (game_it = 0; game_it < game_collection_length1; game_it = game_it + 1) {
				GamesGame* _tmp0_;
				GamesGame* game = NULL;
				_tmp0_ = _g_object_ref0 (game_collection[game_it]);
				game = _tmp0_;
				{
					gboolean _tmp1_ = FALSE;
					GamesDatabase* _tmp2_;
					GamesGame* _tmp3_;
					_tmp2_ = self->priv->database;
					_tmp3_ = game;
					_tmp1_ = games_database_add_game_to_user_collection (_tmp2_, _tmp3_, self, &_inner_error0_);
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						_g_object_unref0 (game);
						goto __catch0_g_error;
					}
					if (_tmp1_) {
						GamesGameModel* _tmp4_;
						GamesGame* _tmp5_;
						_tmp4_ = self->priv->game_model;
						_tmp5_ = game;
						games_game_model_add_game (_tmp4_, _tmp5_);
					}
					_g_object_unref0 (game);
				}
			}
		}
		g_signal_emit_by_name ((GamesCollection*) self, "games-changed");
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp6_;
		const gchar* _tmp7_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp6_ = e;
		_tmp7_ = _tmp6_->message;
		g_critical ("user-collection.vala:90: Failed to add games to user collection: %s", _tmp7_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
games_user_collection_real_remove_games (GamesCollection* base,
                                         GamesGame** games,
                                         gint games_length1)
{
	GamesUserCollection * self;
	GError* _inner_error0_ = NULL;
	self = (GamesUserCollection*) base;
	{
		{
			GamesGame** game_collection = NULL;
			gint game_collection_length1 = 0;
			gint _game_collection_size_ = 0;
			gint game_it = 0;
			game_collection = games;
			game_collection_length1 = games_length1;
			for (game_it = 0; game_it < game_collection_length1; game_it = game_it + 1) {
				GamesGame* _tmp0_;
				GamesGame* game = NULL;
				_tmp0_ = _g_object_ref0 (game_collection[game_it]);
				game = _tmp0_;
				{
					gboolean _tmp1_ = FALSE;
					GamesDatabase* _tmp2_;
					GamesGame* _tmp3_;
					_tmp2_ = self->priv->database;
					_tmp3_ = game;
					_tmp1_ = games_database_remove_game_from_user_collection (_tmp2_, _tmp3_, self, &_inner_error0_);
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						_g_object_unref0 (game);
						goto __catch0_g_error;
					}
					if (_tmp1_) {
						GamesGameModel* _tmp4_;
						GamesGame* _tmp5_;
						_tmp4_ = self->priv->game_model;
						_tmp5_ = game;
						games_game_model_remove_game (_tmp4_, _tmp5_);
					}
					_g_object_unref0 (game);
				}
			}
		}
		g_signal_emit_by_name ((GamesCollection*) self, "games-changed");
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp6_;
		const gchar* _tmp7_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp6_ = e;
		_tmp7_ = _tmp6_->message;
		g_critical ("user-collection.vala:103: Failed to remove games from user collection:" \
" %s", _tmp7_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static gboolean
____lambda15_ (GamesUserCollection* self)
{
	gboolean result;
	g_signal_emit_by_name ((GamesCollection*) self, "games-changed");
	self->priv->idle_id = (gulong) 0;
	result = G_SOURCE_REMOVE;
	return result;
}

static gboolean
_____lambda15__gsource_func (gpointer self)
{
	gboolean result;
	result = ____lambda15_ ((GamesUserCollection*) self);
	return result;
}

static void
games_user_collection_real_on_game_added (GamesCollection* base,
                                          GamesGame* game)
{
	GamesUserCollection * self;
	GHashTable* _tmp0_;
	GamesUid* _tmp1_;
	GamesUid* _tmp2_;
	self = (GamesUserCollection*) base;
	g_return_if_fail (game != NULL);
	_tmp0_ = self->priv->load_game_uids;
	_tmp1_ = games_game_get_uid (game);
	_tmp2_ = _tmp1_;
	if (g_hash_table_remove (_tmp0_, _tmp2_)) {
		GamesGameModel* _tmp3_;
		GHashTable* _tmp4_;
		guint _tmp5_;
		guint _tmp6_;
		_tmp3_ = self->priv->game_model;
		games_game_model_add_game (_tmp3_, game);
		if (self->priv->idle_id == ((gulong) 0)) {
			self->priv->idle_id = (gulong) g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, _____lambda15__gsource_func, g_object_ref (self), g_object_unref);
		}
		_tmp4_ = self->priv->load_game_uids;
		_tmp5_ = g_hash_table_size (_tmp4_);
		_tmp6_ = _tmp5_;
		if (_tmp6_ == ((guint) 0)) {
			GamesGameCollection* _tmp7_;
			_tmp7_ = self->priv->game_collection;
			g_signal_handler_disconnect ((GObject*) _tmp7_, self->priv->on_game_added_id);
		}
	}
}

static void
games_user_collection_real_on_game_removed (GamesCollection* base,
                                            GamesGame* game)
{
	GamesUserCollection * self;
	GamesGameModel* _tmp0_;
	self = (GamesUserCollection*) base;
	g_return_if_fail (game != NULL);
	_tmp0_ = self->priv->game_model;
	games_game_model_remove_game (_tmp0_, game);
	g_signal_emit_by_name ((GamesCollection*) self, "games-changed");
}

static void
games_user_collection_real_on_game_replaced (GamesCollection* base,
                                             GamesGame* game,
                                             GamesGame* prev_game)
{
	GamesUserCollection * self;
	GHashTable* _tmp0_;
	GamesUid* _tmp1_;
	GamesUid* _tmp2_;
	self = (GamesUserCollection*) base;
	g_return_if_fail (game != NULL);
	g_return_if_fail (prev_game != NULL);
	_tmp0_ = self->priv->game_uids;
	_tmp1_ = games_game_get_uid (prev_game);
	_tmp2_ = _tmp1_;
	if (g_hash_table_contains (_tmp0_, _tmp2_)) {
		GamesGameModel* _tmp3_;
		_tmp3_ = self->priv->game_model;
		games_game_model_replace_game (_tmp3_, game, prev_game);
	}
}

static gboolean
games_user_collection_real_get_is_empty (GamesCollection* base)
{
	gboolean result;
	GamesUserCollection* self;
	self = (GamesUserCollection*) base;
	result = FALSE;
	return result;
}

static const gchar*
games_user_collection_real_get_title (GamesCollection* base)
{
	const gchar* result;
	GamesUserCollection* self;
	const gchar* _tmp0_;
	self = (GamesUserCollection*) base;
	_tmp0_ = self->priv->_title;
	result = _tmp0_;
	return result;
}

static void
games_user_collection_class_init (GamesUserCollectionClass * klass,
                                  gpointer klass_data)
{
	games_user_collection_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GamesUserCollection_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_games_user_collection_get_property;
	G_OBJECT_CLASS (klass)->finalize = games_user_collection_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAMES_USER_COLLECTION_IS_EMPTY_PROPERTY, games_user_collection_properties[GAMES_USER_COLLECTION_IS_EMPTY_PROPERTY] = g_param_spec_boolean ("is-empty", "is-empty", "is-empty", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAMES_USER_COLLECTION_TITLE_PROPERTY, games_user_collection_properties[GAMES_USER_COLLECTION_TITLE_PROPERTY] = g_param_spec_string ("title", "title", "title", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
games_user_collection_games_collection_interface_init (GamesCollectionIface * iface,
                                                       gpointer iface_data)
{
	games_user_collection_games_collection_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_id = (gchar* (*) (GamesCollection*)) games_user_collection_real_get_id;
	iface->get_game_model = (GamesGameModel* (*) (GamesCollection*)) games_user_collection_real_get_game_model;
	iface->get_hide_stars = (gboolean (*) (GamesCollection*)) games_user_collection_real_get_hide_stars;
	iface->get_collection_type = (GamesCollectionType (*) (GamesCollection*)) games_user_collection_real_get_collection_type;
	iface->load = (void (*) (GamesCollection*)) games_user_collection_real_load;
	iface->add_games = (void (*) (GamesCollection*, GamesGame**, gint)) games_user_collection_real_add_games;
	iface->remove_games = (void (*) (GamesCollection*, GamesGame**, gint)) games_user_collection_real_remove_games;
	iface->on_game_added = (void (*) (GamesCollection*, GamesGame*)) games_user_collection_real_on_game_added;
	iface->on_game_removed = (void (*) (GamesCollection*, GamesGame*)) games_user_collection_real_on_game_removed;
	iface->on_game_replaced = (void (*) (GamesCollection*, GamesGame*, GamesGame*)) games_user_collection_real_on_game_replaced;
	iface->get_is_empty = games_user_collection_real_get_is_empty;
	iface->get_title = games_user_collection_real_get_title;
}

static void
games_user_collection_instance_init (GamesUserCollection * self,
                                     gpointer klass)
{
	self->priv = games_user_collection_get_instance_private (self);
	self->priv->idle_id = (gulong) 0;
	self->priv->on_game_added_id = (gulong) 0;
}

static void
games_user_collection_finalize (GObject * obj)
{
	GamesUserCollection * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GAMES_TYPE_USER_COLLECTION, GamesUserCollection);
	_g_object_unref0 (self->priv->game_model);
	_g_object_unref0 (self->priv->database);
	_g_hash_table_unref0 (self->priv->load_game_uids);
	_g_hash_table_unref0 (self->priv->game_uids);
	_g_object_unref0 (self->priv->game_collection);
	_g_free0 (self->priv->id);
	_g_free0 (self->priv->_title);
	G_OBJECT_CLASS (games_user_collection_parent_class)->finalize (obj);
}

static GType
games_user_collection_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GamesUserCollectionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) games_user_collection_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GamesUserCollection), 0, (GInstanceInitFunc) games_user_collection_instance_init, NULL };
	static const GInterfaceInfo games_collection_info = { (GInterfaceInitFunc) games_user_collection_games_collection_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType games_user_collection_type_id;
	games_user_collection_type_id = g_type_register_static (G_TYPE_OBJECT, "GamesUserCollection", &g_define_type_info, 0);
	g_type_add_interface_static (games_user_collection_type_id, GAMES_TYPE_COLLECTION, &games_collection_info);
	GamesUserCollection_private_offset = g_type_add_instance_private (games_user_collection_type_id, sizeof (GamesUserCollectionPrivate));
	return games_user_collection_type_id;
}

GType
games_user_collection_get_type (void)
{
	static volatile gsize games_user_collection_type_id__once = 0;
	if (g_once_init_enter (&games_user_collection_type_id__once)) {
		GType games_user_collection_type_id;
		games_user_collection_type_id = games_user_collection_get_type_once ();
		g_once_init_leave (&games_user_collection_type_id__once, games_user_collection_type_id);
	}
	return games_user_collection_type_id__once;
}

static void
_vala_games_user_collection_get_property (GObject * object,
                                          guint property_id,
                                          GValue * value,
                                          GParamSpec * pspec)
{
	GamesUserCollection * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GAMES_TYPE_USER_COLLECTION, GamesUserCollection);
	switch (property_id) {
		case GAMES_USER_COLLECTION_IS_EMPTY_PROPERTY:
		g_value_set_boolean (value, games_collection_get_is_empty ((GamesCollection*) self));
		break;
		case GAMES_USER_COLLECTION_TITLE_PROPERTY:
		g_value_set_string (value, games_collection_get_title ((GamesCollection*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

