/* auto-generated, do not modify */
#include "config.h"

#include <glib.h>

#include "fu-smbios-struct.h"
#include "fu-byte-array.h"
#include "fu-mem-private.h"
#include "fu-string.h"

#ifdef G_LOG_DOMAIN
  #undef G_LOG_DOMAIN
#endif
#define G_LOG_DOMAIN "FuStruct"

/**
 * fu_smbios_structure_type_to_string:
 * @val: value, e.g. %FU_SMBIOS_STRUCTURE_TYPE_SYSTEM
 *
 * Converts an enumerated value to a string.
 *
 * Returns: identifier string
 **/
static const gchar *
fu_smbios_structure_type_to_string(FuSmbiosStructureType val)
{
    if (val == FU_SMBIOS_STRUCTURE_TYPE_BIOS)
        return "bios";
    if (val == FU_SMBIOS_STRUCTURE_TYPE_SYSTEM)
        return "system";
    if (val == FU_SMBIOS_STRUCTURE_TYPE_BASEBOARD)
        return "baseboard";
    if (val == FU_SMBIOS_STRUCTURE_TYPE_CHASSIS)
        return "chassis";
    return NULL;
}

/**
 * fu_smbios_chassis_kind_to_string:
 * @val: value, e.g. %FU_SMBIOS_CHASSIS_KIND_OTHER
 *
 * Converts an enumerated value to a string.
 *
 * Returns: identifier string
 **/
const gchar *
fu_smbios_chassis_kind_to_string(FuSmbiosChassisKind val)
{
    if (val == FU_SMBIOS_CHASSIS_KIND_UNSET)
        return "unset";
    if (val == FU_SMBIOS_CHASSIS_KIND_OTHER)
        return "other";
    if (val == FU_SMBIOS_CHASSIS_KIND_DESKTOP)
        return "desktop";
    if (val == FU_SMBIOS_CHASSIS_KIND_LOW_PROFILE_DESKTOP)
        return "low-profile-desktop";
    if (val == FU_SMBIOS_CHASSIS_KIND_PIZZA_BOX)
        return "pizza-box";
    if (val == FU_SMBIOS_CHASSIS_KIND_MINI_TOWER)
        return "mini-tower";
    if (val == FU_SMBIOS_CHASSIS_KIND_TOWER)
        return "tower";
    if (val == FU_SMBIOS_CHASSIS_KIND_PORTABLE)
        return "portable";
    if (val == FU_SMBIOS_CHASSIS_KIND_LAPTOP)
        return "laptop";
    if (val == FU_SMBIOS_CHASSIS_KIND_NOTEBOOK)
        return "notebook";
    if (val == FU_SMBIOS_CHASSIS_KIND_HAND_HELD)
        return "hand-held";
    if (val == FU_SMBIOS_CHASSIS_KIND_DOCKING_STATION)
        return "docking-station";
    if (val == FU_SMBIOS_CHASSIS_KIND_ALL_IN_ONE)
        return "all-in-one";
    if (val == FU_SMBIOS_CHASSIS_KIND_SUB_NOTEBOOK)
        return "sub-notebook";
    if (val == FU_SMBIOS_CHASSIS_KIND_SPACE_SAVING)
        return "space-saving";
    if (val == FU_SMBIOS_CHASSIS_KIND_LUNCH_BOX)
        return "lunch-box";
    if (val == FU_SMBIOS_CHASSIS_KIND_MAIN_SERVER)
        return "main-server";
    if (val == FU_SMBIOS_CHASSIS_KIND_EXPANSION)
        return "expansion";
    if (val == FU_SMBIOS_CHASSIS_KIND_SUBCHASSIS)
        return "subchassis";
    if (val == FU_SMBIOS_CHASSIS_KIND_BUS_EXPANSION)
        return "bus-expansion";
    if (val == FU_SMBIOS_CHASSIS_KIND_PERIPHERAL)
        return "peripheral";
    if (val == FU_SMBIOS_CHASSIS_KIND_RAID)
        return "raid";
    if (val == FU_SMBIOS_CHASSIS_KIND_RACK_MOUNT)
        return "rack-mount";
    if (val == FU_SMBIOS_CHASSIS_KIND_SEALED_CASE_PC)
        return "sealed-case-pc";
    if (val == FU_SMBIOS_CHASSIS_KIND_MULTI_SYSTEM)
        return "multi-system";
    if (val == FU_SMBIOS_CHASSIS_KIND_COMPACT_PCI)
        return "compact-pci";
    if (val == FU_SMBIOS_CHASSIS_KIND_ADVANCED_TCA)
        return "advanced-tca";
    if (val == FU_SMBIOS_CHASSIS_KIND_BLADE)
        return "blade";
    if (val == FU_SMBIOS_CHASSIS_KIND_RESERVED)
        return "reserved";
    if (val == FU_SMBIOS_CHASSIS_KIND_TABLET)
        return "tablet";
    if (val == FU_SMBIOS_CHASSIS_KIND_CONVERTIBLE)
        return "convertible";
    if (val == FU_SMBIOS_CHASSIS_KIND_DETACHABLE)
        return "detachable";
    if (val == FU_SMBIOS_CHASSIS_KIND_IOT_GATEWAY)
        return "iot-gateway";
    if (val == FU_SMBIOS_CHASSIS_KIND_EMBEDDED_PC)
        return "embedded-pc";
    if (val == FU_SMBIOS_CHASSIS_KIND_MINI_PC)
        return "mini-pc";
    if (val == FU_SMBIOS_CHASSIS_KIND_STICK_PC)
        return "stick-pc";
    return NULL;
}

/**
 * fu_smbios_bios_characteristics_to_string:
 * @val: value, e.g. %FU_SMBIOS_BIOS_CHARACTERISTICS___RESERVED
 *
 * Converts an enumerated value to a string.
 *
 * Returns: identifier string
 *
 **/
static gchar *
fu_smbios_bios_characteristics_to_string(FuSmbiosBiosCharacteristics val)
{
    const gchar *data[17] = {0};
    guint idx = 0;
    if (val == FU_SMBIOS_BIOS_CHARACTERISTICS___NONE)
        return g_strdup("--none");
    if (val & FU_SMBIOS_BIOS_CHARACTERISTICS___RESERVED)
        data[idx++] = "--reserved";
    if (val & FU_SMBIOS_BIOS_CHARACTERISTICS___UNKNOWN)
        data[idx++] = "--unknown";
    if (val & FU_SMBIOS_BIOS_CHARACTERISTICS_BIOS_CHARACTERISTICS_NOT_SUPPORTED)
        data[idx++] = "bios-characteristics-not-supported";
    if (val & FU_SMBIOS_BIOS_CHARACTERISTICS_ISA_SUPPORTED)
        data[idx++] = "isa-supported";
    if (val & FU_SMBIOS_BIOS_CHARACTERISTICS_MCA_SUPPORTED)
        data[idx++] = "mca-supported";
    if (val & FU_SMBIOS_BIOS_CHARACTERISTICS_EISA_SUPPORTED)
        data[idx++] = "eisa-supported";
    if (val & FU_SMBIOS_BIOS_CHARACTERISTICS_PCI_SUPPORTED)
        data[idx++] = "pci-supported";
    if (val & FU_SMBIOS_BIOS_CHARACTERISTICS_PCCARD_SUPPORTED)
        data[idx++] = "pccard-supported";
    if (val & FU_SMBIOS_BIOS_CHARACTERISTICS_PLUG_AND_PLAY_SUPPORTED)
        data[idx++] = "plug-and-play-supported";
    if (val & FU_SMBIOS_BIOS_CHARACTERISTICS_APM_SUPPORTED)
        data[idx++] = "apm-supported";
    if (val & FU_SMBIOS_BIOS_CHARACTERISTICS_BIOS_IS_UPGRADEABLE)
        data[idx++] = "bios-is-upgradeable";
    if (val & FU_SMBIOS_BIOS_CHARACTERISTICS_BIOS_SHADOWING_ALLOWED)
        data[idx++] = "bios-shadowing-allowed";
    if (val & FU_SMBIOS_BIOS_CHARACTERISTICS_VLVESA_SUPPORTED)
        data[idx++] = "vlvesa-supported";
    if (val & FU_SMBIOS_BIOS_CHARACTERISTICS_ESCD_SUPPORT_AVAILABLE)
        data[idx++] = "escd-support-available";
    if (val & FU_SMBIOS_BIOS_CHARACTERISTICS_BOOT_FROM_CD_SUPPORTED)
        data[idx++] = "boot-from-cd-supported";
    if (val & FU_SMBIOS_BIOS_CHARACTERISTICS_SELECTABLE_BOOT_SUPPORTED)
        data[idx++] = "selectable-boot-supported";
    return g_strjoinv(",", (gchar **)data);
}

/**
 * fu_smbios_bios_characteristics_ext_to_string:
 * @val: value, e.g. %FU_SMBIOS_BIOS_CHARACTERISTICS_EXT_USB_LEGACY_SUPPORTED
 *
 * Converts an enumerated value to a string.
 *
 * Returns: identifier string
 *
 **/
static gchar *
fu_smbios_bios_characteristics_ext_to_string(FuSmbiosBiosCharacteristicsExt val)
{
    const gchar *data[16] = {0};
    guint idx = 0;
    if (val == FU_SMBIOS_BIOS_CHARACTERISTICS_EXT_ACPI_SUPPORTED)
        return g_strdup("acpi-supported");
    if (val & FU_SMBIOS_BIOS_CHARACTERISTICS_EXT_USB_LEGACY_SUPPORTED)
        data[idx++] = "usb-legacy-supported";
    if (val & FU_SMBIOS_BIOS_CHARACTERISTICS_EXT_AGP_SUPPORTED)
        data[idx++] = "agp-supported";
    if (val & FU_SMBIOS_BIOS_CHARACTERISTICS_EXT_I2O_BOOT_SUPPORTED)
        data[idx++] = "i2o-boot-supported";
    if (val & FU_SMBIOS_BIOS_CHARACTERISTICS_EXT_LS120_SUPER_DISK_BOOT_SUPPORTED)
        data[idx++] = "ls120-super-disk-boot-supported";
    if (val & FU_SMBIOS_BIOS_CHARACTERISTICS_EXT_ATAPI_ZIP_SUPPORTED)
        data[idx++] = "atapi-zip-supported";
    if (val & FU_SMBIOS_BIOS_CHARACTERISTICS_EXT_1394_BOOT_SUPPORTED)
        data[idx++] = "1394-boot-supported";
    if (val & FU_SMBIOS_BIOS_CHARACTERISTICS_EXT_SMART_BATTERY_SUPPORTED)
        data[idx++] = "smart-battery-supported";
    if (val & FU_SMBIOS_BIOS_CHARACTERISTICS_EXT_BIOS_BOOT_SPECIFICATION_SUPPORTED)
        data[idx++] = "bios-boot-specification-supported";
    if (val & FU_SMBIOS_BIOS_CHARACTERISTICS_EXT_FUNCTION_KEY_NETWORK_BOOT_SUPPORTED)
        data[idx++] = "function-key-network-boot-supported";
    if (val & FU_SMBIOS_BIOS_CHARACTERISTICS_EXT_ENABLE_TARGETED_CONTENT_DISTRIBUTION)
        data[idx++] = "enable-targeted-content-distribution";
    if (val & FU_SMBIOS_BIOS_CHARACTERISTICS_EXT_UEFI_SPECIFICATION_SUPPORTED)
        data[idx++] = "uefi-specification-supported";
    if (val & FU_SMBIOS_BIOS_CHARACTERISTICS_EXT_IS_VIRTUAL_MACHINE)
        data[idx++] = "is-virtual-machine";
    if (val & FU_SMBIOS_BIOS_CHARACTERISTICS_EXT_MANUFACTURING_MODE_SUPPORTED)
        data[idx++] = "manufacturing-mode-supported";
    if (val & FU_SMBIOS_BIOS_CHARACTERISTICS_EXT_MANUFACTURING_MODE_ENABLED)
        data[idx++] = "manufacturing-mode-enabled";
    if (val & FU_SMBIOS_BIOS_CHARACTERISTICS_EXT___RESERVED)
        data[idx++] = "--reserved";
    return g_strjoinv(",", (gchar **)data);
}
/**
 * fu_struct_smbios_ep32_ref: (skip):
 **/
FuStructSmbiosEp32 *
fu_struct_smbios_ep32_ref(FuStructSmbiosEp32 *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_smbios_ep32_unref: (skip):
 **/
void
fu_struct_smbios_ep32_unref(FuStructSmbiosEp32 *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructSmbiosEp32 refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_struct_smbios_ep32_new_internal: (skip):
 **/
static FuStructSmbiosEp32 *
fu_struct_smbios_ep32_new_internal(void)
{
    FuStructSmbiosEp32 *st = g_new0(FuStructSmbiosEp32, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_struct_smbios_ep32_get_anchor_str: (skip):
 **/
gchar *
fu_struct_smbios_ep32_get_anchor_str(const FuStructSmbiosEp32 *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    return fu_memstrsafe(st->buf->data, st->buf->len, 0, 4, NULL);
}
/**
 * fu_struct_smbios_ep32_get_entry_point_csum: (skip):
 **/
guint8
fu_struct_smbios_ep32_get_entry_point_csum(const FuStructSmbiosEp32 *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[4];
}
/**
 * fu_struct_smbios_ep32_get_entry_point_len: (skip):
 **/
guint8
fu_struct_smbios_ep32_get_entry_point_len(const FuStructSmbiosEp32 *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[5];
}
/**
 * fu_struct_smbios_ep32_get_smbios_major_ver: (skip):
 **/
guint8
fu_struct_smbios_ep32_get_smbios_major_ver(const FuStructSmbiosEp32 *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[6];
}
/**
 * fu_struct_smbios_ep32_get_smbios_minor_ver: (skip):
 **/
guint8
fu_struct_smbios_ep32_get_smbios_minor_ver(const FuStructSmbiosEp32 *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[7];
}
/**
 * fu_struct_smbios_ep32_get_max_structure_sz: (skip):
 **/
guint16
fu_struct_smbios_ep32_get_max_structure_sz(const FuStructSmbiosEp32 *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 8, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_smbios_ep32_get_entry_point_rev: (skip):
 **/
guint8
fu_struct_smbios_ep32_get_entry_point_rev(const FuStructSmbiosEp32 *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[10];
}
/**
 * fu_struct_smbios_ep32_get_intermediate_anchor_str: (skip):
 **/
gchar *
fu_struct_smbios_ep32_get_intermediate_anchor_str(const FuStructSmbiosEp32 *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    return fu_memstrsafe(st->buf->data, st->buf->len, 16, 5, NULL);
}
/**
 * fu_struct_smbios_ep32_get_intermediate_csum: (skip):
 **/
guint8
fu_struct_smbios_ep32_get_intermediate_csum(const FuStructSmbiosEp32 *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[21];
}
/**
 * fu_struct_smbios_ep32_get_structure_table_len: (skip):
 **/
guint16
fu_struct_smbios_ep32_get_structure_table_len(const FuStructSmbiosEp32 *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 22, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_smbios_ep32_get_structure_table_addr: (skip):
 **/
guint32
fu_struct_smbios_ep32_get_structure_table_addr(const FuStructSmbiosEp32 *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 24, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_smbios_ep32_get_number_smbios_structs: (skip):
 **/
guint16
fu_struct_smbios_ep32_get_number_smbios_structs(const FuStructSmbiosEp32 *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 28, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_smbios_ep32_get_smbios_bcd_rev: (skip):
 **/
guint8
fu_struct_smbios_ep32_get_smbios_bcd_rev(const FuStructSmbiosEp32 *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[30];
}

/* setters */
/**
 * fu_struct_smbios_ep32_set_anchor_str: (skip):
 **/
gboolean
fu_struct_smbios_ep32_set_anchor_str(FuStructSmbiosEp32 *st, const gchar *value, GError **error)
{
    gsize len;
    g_return_val_if_fail(st != NULL, FALSE);
    g_return_val_if_fail(error == NULL || *error == NULL, FALSE);
    if (value == NULL) {
        memset(st->buf->data + 0, 0x0, 4);
        return TRUE;
    }
    len = strlen(value);
    if (len > 4) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "string '%s' (0x%x bytes) does not fit in FuStructSmbiosEp32.anchor_str (0x%x bytes)",
                    value, (guint) len, (guint) 4);
        return FALSE;
    }
    return fu_memcpy_safe(st->buf->data, st->buf->len, 0, (const guint8 *)value, len, 0x0, len, error);
}
/**
 * fu_struct_smbios_ep32_set_entry_point_csum: (skip):
 **/
void
fu_struct_smbios_ep32_set_entry_point_csum(FuStructSmbiosEp32 *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[4] = value;
}
/**
 * fu_struct_smbios_ep32_set_entry_point_len: (skip):
 **/
void
fu_struct_smbios_ep32_set_entry_point_len(FuStructSmbiosEp32 *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[5] = value;
}
/**
 * fu_struct_smbios_ep32_set_smbios_major_ver: (skip):
 **/
void
fu_struct_smbios_ep32_set_smbios_major_ver(FuStructSmbiosEp32 *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[6] = value;
}
/**
 * fu_struct_smbios_ep32_set_smbios_minor_ver: (skip):
 **/
void
fu_struct_smbios_ep32_set_smbios_minor_ver(FuStructSmbiosEp32 *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[7] = value;
}
/**
 * fu_struct_smbios_ep32_set_max_structure_sz: (skip):
 **/
void
fu_struct_smbios_ep32_set_max_structure_sz(FuStructSmbiosEp32 *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->buf->data + 8, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_smbios_ep32_set_entry_point_rev: (skip):
 **/
void
fu_struct_smbios_ep32_set_entry_point_rev(FuStructSmbiosEp32 *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[10] = value;
}
/**
 * fu_struct_smbios_ep32_set_intermediate_anchor_str: (skip):
 **/
gboolean
fu_struct_smbios_ep32_set_intermediate_anchor_str(FuStructSmbiosEp32 *st, const gchar *value, GError **error)
{
    gsize len;
    g_return_val_if_fail(st != NULL, FALSE);
    g_return_val_if_fail(error == NULL || *error == NULL, FALSE);
    if (value == NULL) {
        memset(st->buf->data + 16, 0x0, 5);
        return TRUE;
    }
    len = strlen(value);
    if (len > 5) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "string '%s' (0x%x bytes) does not fit in FuStructSmbiosEp32.intermediate_anchor_str (0x%x bytes)",
                    value, (guint) len, (guint) 5);
        return FALSE;
    }
    return fu_memcpy_safe(st->buf->data, st->buf->len, 16, (const guint8 *)value, len, 0x0, len, error);
}
/**
 * fu_struct_smbios_ep32_set_intermediate_csum: (skip):
 **/
void
fu_struct_smbios_ep32_set_intermediate_csum(FuStructSmbiosEp32 *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[21] = value;
}
/**
 * fu_struct_smbios_ep32_set_structure_table_len: (skip):
 **/
void
fu_struct_smbios_ep32_set_structure_table_len(FuStructSmbiosEp32 *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->buf->data + 22, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_smbios_ep32_set_structure_table_addr: (skip):
 **/
void
fu_struct_smbios_ep32_set_structure_table_addr(FuStructSmbiosEp32 *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->buf->data + 24, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_smbios_ep32_set_number_smbios_structs: (skip):
 **/
void
fu_struct_smbios_ep32_set_number_smbios_structs(FuStructSmbiosEp32 *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->buf->data + 28, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_smbios_ep32_set_smbios_bcd_rev: (skip):
 **/
void
fu_struct_smbios_ep32_set_smbios_bcd_rev(FuStructSmbiosEp32 *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[30] = value;
}
/**
 * fu_struct_smbios_ep32_new: (skip):
 **/
FuStructSmbiosEp32 *
fu_struct_smbios_ep32_new(void)
{
    FuStructSmbiosEp32 *st = fu_struct_smbios_ep32_new_internal();
    st->buf = g_byte_array_sized_new(31);
    fu_byte_array_set_size(st->buf, 31, 0x0);
    return st;
}
/**
 * fu_struct_smbios_ep32_to_string: (skip):
 **/
static gchar *
fu_struct_smbios_ep32_to_string(const FuStructSmbiosEp32 *st)
{
    g_autoptr(GString) str = g_string_new("FuStructSmbiosEp32:\n");
    g_return_val_if_fail(st != NULL, NULL);
    {
        g_autofree gchar *tmp = fu_struct_smbios_ep32_get_anchor_str(st);
        if (tmp != NULL)
            g_string_append_printf(str, "  anchor_str: %s\n", tmp);
    }
    g_string_append_printf(str, "  entry_point_csum: 0x%x\n",
                           (guint) fu_struct_smbios_ep32_get_entry_point_csum(st));
    g_string_append_printf(str, "  entry_point_len: 0x%x\n",
                           (guint) fu_struct_smbios_ep32_get_entry_point_len(st));
    g_string_append_printf(str, "  smbios_major_ver: 0x%x\n",
                           (guint) fu_struct_smbios_ep32_get_smbios_major_ver(st));
    g_string_append_printf(str, "  smbios_minor_ver: 0x%x\n",
                           (guint) fu_struct_smbios_ep32_get_smbios_minor_ver(st));
    g_string_append_printf(str, "  max_structure_sz: 0x%x\n",
                           (guint) fu_struct_smbios_ep32_get_max_structure_sz(st));
    g_string_append_printf(str, "  entry_point_rev: 0x%x\n",
                           (guint) fu_struct_smbios_ep32_get_entry_point_rev(st));
    {
        g_autofree gchar *tmp = fu_struct_smbios_ep32_get_intermediate_anchor_str(st);
        if (tmp != NULL)
            g_string_append_printf(str, "  intermediate_anchor_str: %s\n", tmp);
    }
    g_string_append_printf(str, "  intermediate_csum: 0x%x\n",
                           (guint) fu_struct_smbios_ep32_get_intermediate_csum(st));
    g_string_append_printf(str, "  structure_table_len: 0x%x\n",
                           (guint) fu_struct_smbios_ep32_get_structure_table_len(st));
    g_string_append_printf(str, "  structure_table_addr: 0x%x\n",
                           (guint) fu_struct_smbios_ep32_get_structure_table_addr(st));
    g_string_append_printf(str, "  number_smbios_structs: 0x%x\n",
                           (guint) fu_struct_smbios_ep32_get_number_smbios_structs(st));
    g_string_append_printf(str, "  smbios_bcd_rev: 0x%x\n",
                           (guint) fu_struct_smbios_ep32_get_smbios_bcd_rev(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_struct_smbios_ep32_validate_internal(FuStructSmbiosEp32 *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    return TRUE;
}
static gboolean
fu_struct_smbios_ep32_parse_internal(FuStructSmbiosEp32 *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_struct_smbios_ep32_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_struct_smbios_ep32_validate_internal(st, error))
        return FALSE;
    return TRUE;
}

/**
 * fu_struct_smbios_ep32_parse: (skip):
 **/
FuStructSmbiosEp32 *
fu_struct_smbios_ep32_parse(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    g_autoptr(FuStructSmbiosEp32) st = fu_struct_smbios_ep32_new_internal();
    g_return_val_if_fail(buf != NULL, NULL);
    g_return_val_if_fail(error == NULL || *error == NULL, NULL);
    if (!fu_memchk_read(bufsz, offset, 31, error)) {
        g_prefix_error_literal(error, "invalid struct FuStructSmbiosEp32: ");
        return NULL;
    }
    st->buf = g_byte_array_new();
    g_byte_array_append(st->buf, buf + offset, 31);
    if (!fu_struct_smbios_ep32_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
/**
 * fu_struct_smbios_ep64_ref: (skip):
 **/
FuStructSmbiosEp64 *
fu_struct_smbios_ep64_ref(FuStructSmbiosEp64 *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_smbios_ep64_unref: (skip):
 **/
void
fu_struct_smbios_ep64_unref(FuStructSmbiosEp64 *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructSmbiosEp64 refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_struct_smbios_ep64_new_internal: (skip):
 **/
static FuStructSmbiosEp64 *
fu_struct_smbios_ep64_new_internal(void)
{
    FuStructSmbiosEp64 *st = g_new0(FuStructSmbiosEp64, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_struct_smbios_ep64_get_anchor_str: (skip):
 **/
gchar *
fu_struct_smbios_ep64_get_anchor_str(const FuStructSmbiosEp64 *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    return fu_memstrsafe(st->buf->data, st->buf->len, 0, 5, NULL);
}
/**
 * fu_struct_smbios_ep64_get_entry_point_csum: (skip):
 **/
guint8
fu_struct_smbios_ep64_get_entry_point_csum(const FuStructSmbiosEp64 *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[5];
}
/**
 * fu_struct_smbios_ep64_get_entry_point_len: (skip):
 **/
guint8
fu_struct_smbios_ep64_get_entry_point_len(const FuStructSmbiosEp64 *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[6];
}
/**
 * fu_struct_smbios_ep64_get_smbios_major_ver: (skip):
 **/
guint8
fu_struct_smbios_ep64_get_smbios_major_ver(const FuStructSmbiosEp64 *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[7];
}
/**
 * fu_struct_smbios_ep64_get_smbios_minor_ver: (skip):
 **/
guint8
fu_struct_smbios_ep64_get_smbios_minor_ver(const FuStructSmbiosEp64 *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[8];
}
/**
 * fu_struct_smbios_ep64_get_smbios_docrev: (skip):
 **/
guint8
fu_struct_smbios_ep64_get_smbios_docrev(const FuStructSmbiosEp64 *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[9];
}
/**
 * fu_struct_smbios_ep64_get_entry_point_rev: (skip):
 **/
guint8
fu_struct_smbios_ep64_get_entry_point_rev(const FuStructSmbiosEp64 *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[10];
}
/**
 * fu_struct_smbios_ep64_get_reserved0: (skip):
 **/
guint8
fu_struct_smbios_ep64_get_reserved0(const FuStructSmbiosEp64 *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[11];
}
/**
 * fu_struct_smbios_ep64_get_structure_table_len: (skip):
 **/
guint32
fu_struct_smbios_ep64_get_structure_table_len(const FuStructSmbiosEp64 *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 12, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_smbios_ep64_get_structure_table_addr: (skip):
 **/
guint64
fu_struct_smbios_ep64_get_structure_table_addr(const FuStructSmbiosEp64 *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint64(st->buf->data + 16, G_LITTLE_ENDIAN);
}

/* setters */
/**
 * fu_struct_smbios_ep64_set_anchor_str: (skip):
 **/
gboolean
fu_struct_smbios_ep64_set_anchor_str(FuStructSmbiosEp64 *st, const gchar *value, GError **error)
{
    gsize len;
    g_return_val_if_fail(st != NULL, FALSE);
    g_return_val_if_fail(error == NULL || *error == NULL, FALSE);
    if (value == NULL) {
        memset(st->buf->data + 0, 0x0, 5);
        return TRUE;
    }
    len = strlen(value);
    if (len > 5) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "string '%s' (0x%x bytes) does not fit in FuStructSmbiosEp64.anchor_str (0x%x bytes)",
                    value, (guint) len, (guint) 5);
        return FALSE;
    }
    return fu_memcpy_safe(st->buf->data, st->buf->len, 0, (const guint8 *)value, len, 0x0, len, error);
}
/**
 * fu_struct_smbios_ep64_set_entry_point_csum: (skip):
 **/
void
fu_struct_smbios_ep64_set_entry_point_csum(FuStructSmbiosEp64 *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[5] = value;
}
/**
 * fu_struct_smbios_ep64_set_entry_point_len: (skip):
 **/
void
fu_struct_smbios_ep64_set_entry_point_len(FuStructSmbiosEp64 *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[6] = value;
}
/**
 * fu_struct_smbios_ep64_set_smbios_major_ver: (skip):
 **/
void
fu_struct_smbios_ep64_set_smbios_major_ver(FuStructSmbiosEp64 *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[7] = value;
}
/**
 * fu_struct_smbios_ep64_set_smbios_minor_ver: (skip):
 **/
void
fu_struct_smbios_ep64_set_smbios_minor_ver(FuStructSmbiosEp64 *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[8] = value;
}
/**
 * fu_struct_smbios_ep64_set_smbios_docrev: (skip):
 **/
void
fu_struct_smbios_ep64_set_smbios_docrev(FuStructSmbiosEp64 *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[9] = value;
}
/**
 * fu_struct_smbios_ep64_set_entry_point_rev: (skip):
 **/
void
fu_struct_smbios_ep64_set_entry_point_rev(FuStructSmbiosEp64 *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[10] = value;
}
/**
 * fu_struct_smbios_ep64_set_reserved0: (skip):
 **/
void
fu_struct_smbios_ep64_set_reserved0(FuStructSmbiosEp64 *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[11] = value;
}
/**
 * fu_struct_smbios_ep64_set_structure_table_len: (skip):
 **/
void
fu_struct_smbios_ep64_set_structure_table_len(FuStructSmbiosEp64 *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->buf->data + 12, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_smbios_ep64_set_structure_table_addr: (skip):
 **/
void
fu_struct_smbios_ep64_set_structure_table_addr(FuStructSmbiosEp64 *st, guint64 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint64(st->buf->data + 16, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_smbios_ep64_new: (skip):
 **/
FuStructSmbiosEp64 *
fu_struct_smbios_ep64_new(void)
{
    FuStructSmbiosEp64 *st = fu_struct_smbios_ep64_new_internal();
    st->buf = g_byte_array_sized_new(24);
    fu_byte_array_set_size(st->buf, 24, 0x0);
    return st;
}
/**
 * fu_struct_smbios_ep64_to_string: (skip):
 **/
static gchar *
fu_struct_smbios_ep64_to_string(const FuStructSmbiosEp64 *st)
{
    g_autoptr(GString) str = g_string_new("FuStructSmbiosEp64:\n");
    g_return_val_if_fail(st != NULL, NULL);
    {
        g_autofree gchar *tmp = fu_struct_smbios_ep64_get_anchor_str(st);
        if (tmp != NULL)
            g_string_append_printf(str, "  anchor_str: %s\n", tmp);
    }
    g_string_append_printf(str, "  entry_point_csum: 0x%x\n",
                           (guint) fu_struct_smbios_ep64_get_entry_point_csum(st));
    g_string_append_printf(str, "  entry_point_len: 0x%x\n",
                           (guint) fu_struct_smbios_ep64_get_entry_point_len(st));
    g_string_append_printf(str, "  smbios_major_ver: 0x%x\n",
                           (guint) fu_struct_smbios_ep64_get_smbios_major_ver(st));
    g_string_append_printf(str, "  smbios_minor_ver: 0x%x\n",
                           (guint) fu_struct_smbios_ep64_get_smbios_minor_ver(st));
    g_string_append_printf(str, "  smbios_docrev: 0x%x\n",
                           (guint) fu_struct_smbios_ep64_get_smbios_docrev(st));
    g_string_append_printf(str, "  entry_point_rev: 0x%x\n",
                           (guint) fu_struct_smbios_ep64_get_entry_point_rev(st));
    g_string_append_printf(str, "  reserved0: 0x%x\n",
                           (guint) fu_struct_smbios_ep64_get_reserved0(st));
    g_string_append_printf(str, "  structure_table_len: 0x%x\n",
                           (guint) fu_struct_smbios_ep64_get_structure_table_len(st));
    g_string_append_printf(str, "  structure_table_addr: 0x%x\n",
                           (guint) fu_struct_smbios_ep64_get_structure_table_addr(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_struct_smbios_ep64_validate_internal(FuStructSmbiosEp64 *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    return TRUE;
}
static gboolean
fu_struct_smbios_ep64_parse_internal(FuStructSmbiosEp64 *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_struct_smbios_ep64_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_struct_smbios_ep64_validate_internal(st, error))
        return FALSE;
    return TRUE;
}

/**
 * fu_struct_smbios_ep64_parse: (skip):
 **/
FuStructSmbiosEp64 *
fu_struct_smbios_ep64_parse(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    g_autoptr(FuStructSmbiosEp64) st = fu_struct_smbios_ep64_new_internal();
    g_return_val_if_fail(buf != NULL, NULL);
    g_return_val_if_fail(error == NULL || *error == NULL, NULL);
    if (!fu_memchk_read(bufsz, offset, 24, error)) {
        g_prefix_error_literal(error, "invalid struct FuStructSmbiosEp64: ");
        return NULL;
    }
    st->buf = g_byte_array_new();
    g_byte_array_append(st->buf, buf + offset, 24);
    if (!fu_struct_smbios_ep64_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
/**
 * fu_struct_smbios_structure_ref: (skip):
 **/
FuStructSmbiosStructure *
fu_struct_smbios_structure_ref(FuStructSmbiosStructure *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_smbios_structure_unref: (skip):
 **/
void
fu_struct_smbios_structure_unref(FuStructSmbiosStructure *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructSmbiosStructure refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_struct_smbios_structure_new_internal: (skip):
 **/
static FuStructSmbiosStructure *
fu_struct_smbios_structure_new_internal(void)
{
    FuStructSmbiosStructure *st = g_new0(FuStructSmbiosStructure, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_struct_smbios_structure_get_type: (skip):
 **/
guint8
fu_struct_smbios_structure_get_type(const FuStructSmbiosStructure *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[0];
}
/**
 * fu_struct_smbios_structure_get_length: (skip):
 **/
guint8
fu_struct_smbios_structure_get_length(const FuStructSmbiosStructure *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[1];
}
/**
 * fu_struct_smbios_structure_get_handle: (skip):
 **/
guint16
fu_struct_smbios_structure_get_handle(const FuStructSmbiosStructure *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 2, G_LITTLE_ENDIAN);
}

/* setters */
/**
 * fu_struct_smbios_structure_set_type: (skip):
 **/
void
fu_struct_smbios_structure_set_type(FuStructSmbiosStructure *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[0] = value;
}
/**
 * fu_struct_smbios_structure_set_length: (skip):
 **/
void
fu_struct_smbios_structure_set_length(FuStructSmbiosStructure *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[1] = value;
}
/**
 * fu_struct_smbios_structure_set_handle: (skip):
 **/
void
fu_struct_smbios_structure_set_handle(FuStructSmbiosStructure *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->buf->data + 2, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_smbios_structure_new: (skip):
 **/
FuStructSmbiosStructure *
fu_struct_smbios_structure_new(void)
{
    FuStructSmbiosStructure *st = fu_struct_smbios_structure_new_internal();
    st->buf = g_byte_array_sized_new(4);
    fu_byte_array_set_size(st->buf, 4, 0x0);
    return st;
}
/**
 * fu_struct_smbios_structure_to_string: (skip):
 **/
static gchar *
fu_struct_smbios_structure_to_string(const FuStructSmbiosStructure *st)
{
    g_autoptr(GString) str = g_string_new("FuStructSmbiosStructure:\n");
    g_return_val_if_fail(st != NULL, NULL);
    g_string_append_printf(str, "  type: 0x%x\n",
                           (guint) fu_struct_smbios_structure_get_type(st));
    g_string_append_printf(str, "  length: 0x%x\n",
                           (guint) fu_struct_smbios_structure_get_length(st));
    g_string_append_printf(str, "  handle: 0x%x\n",
                           (guint) fu_struct_smbios_structure_get_handle(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_struct_smbios_structure_validate_internal(FuStructSmbiosStructure *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    return TRUE;
}
static gboolean
fu_struct_smbios_structure_parse_internal(FuStructSmbiosStructure *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_struct_smbios_structure_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_struct_smbios_structure_validate_internal(st, error))
        return FALSE;
    return TRUE;
}

/**
 * fu_struct_smbios_structure_parse: (skip):
 **/
FuStructSmbiosStructure *
fu_struct_smbios_structure_parse(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    g_autoptr(FuStructSmbiosStructure) st = fu_struct_smbios_structure_new_internal();
    g_return_val_if_fail(buf != NULL, NULL);
    g_return_val_if_fail(error == NULL || *error == NULL, NULL);
    if (!fu_memchk_read(bufsz, offset, 4, error)) {
        g_prefix_error_literal(error, "invalid struct FuStructSmbiosStructure: ");
        return NULL;
    }
    st->buf = g_byte_array_new();
    g_byte_array_append(st->buf, buf + offset, 4);
    if (!fu_struct_smbios_structure_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
/**
 * fu_struct_smbios_bios_information_ref: (skip):
 **/
FuStructSmbiosBiosInformation *
fu_struct_smbios_bios_information_ref(FuStructSmbiosBiosInformation *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_smbios_bios_information_unref: (skip):
 **/
void
fu_struct_smbios_bios_information_unref(FuStructSmbiosBiosInformation *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructSmbiosBiosInformation refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_struct_smbios_bios_information_new_internal: (skip):
 **/
static FuStructSmbiosBiosInformation *
fu_struct_smbios_bios_information_new_internal(void)
{
    FuStructSmbiosBiosInformation *st = g_new0(FuStructSmbiosBiosInformation, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_struct_smbios_bios_information_get_type: (skip):
 **/
static FuSmbiosStructureType
fu_struct_smbios_bios_information_get_type(const FuStructSmbiosBiosInformation *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[0];
}
/**
 * fu_struct_smbios_bios_information_get_length: (skip):
 **/
guint8
fu_struct_smbios_bios_information_get_length(const FuStructSmbiosBiosInformation *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[1];
}
/**
 * fu_struct_smbios_bios_information_get_handle: (skip):
 **/
guint16
fu_struct_smbios_bios_information_get_handle(const FuStructSmbiosBiosInformation *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 2, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_smbios_bios_information_get_vendor: (skip):
 **/
guint8
fu_struct_smbios_bios_information_get_vendor(const FuStructSmbiosBiosInformation *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[4];
}
/**
 * fu_struct_smbios_bios_information_get_version: (skip):
 **/
guint8
fu_struct_smbios_bios_information_get_version(const FuStructSmbiosBiosInformation *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[5];
}
/**
 * fu_struct_smbios_bios_information_get_starting_addr_segment: (skip):
 **/
guint16
fu_struct_smbios_bios_information_get_starting_addr_segment(const FuStructSmbiosBiosInformation *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 6, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_smbios_bios_information_get_release_date: (skip):
 **/
guint8
fu_struct_smbios_bios_information_get_release_date(const FuStructSmbiosBiosInformation *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[8];
}
/**
 * fu_struct_smbios_bios_information_get_rom_size: (skip):
 **/
guint8
fu_struct_smbios_bios_information_get_rom_size(const FuStructSmbiosBiosInformation *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[9];
}
/**
 * fu_struct_smbios_bios_information_get_characteristics: (skip):
 **/
FuSmbiosBiosCharacteristics
fu_struct_smbios_bios_information_get_characteristics(const FuStructSmbiosBiosInformation *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint64(st->buf->data + 10, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_smbios_bios_information_get_characteristics_ext: (skip):
 **/
FuSmbiosBiosCharacteristicsExt
fu_struct_smbios_bios_information_get_characteristics_ext(const FuStructSmbiosBiosInformation *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 18, G_LITTLE_ENDIAN);
}

/* setters */
/**
 * fu_struct_smbios_bios_information_to_string: (skip):
 **/
static gchar *
fu_struct_smbios_bios_information_to_string(const FuStructSmbiosBiosInformation *st)
{
    g_autoptr(GString) str = g_string_new("FuStructSmbiosBiosInformation:\n");
    g_return_val_if_fail(st != NULL, NULL);
    g_string_append_printf(str, "  length: 0x%x\n",
                           (guint) fu_struct_smbios_bios_information_get_length(st));
    g_string_append_printf(str, "  handle: 0x%x\n",
                           (guint) fu_struct_smbios_bios_information_get_handle(st));
    g_string_append_printf(str, "  vendor: 0x%x\n",
                           (guint) fu_struct_smbios_bios_information_get_vendor(st));
    g_string_append_printf(str, "  version: 0x%x\n",
                           (guint) fu_struct_smbios_bios_information_get_version(st));
    g_string_append_printf(str, "  starting_addr_segment: 0x%x\n",
                           (guint) fu_struct_smbios_bios_information_get_starting_addr_segment(st));
    g_string_append_printf(str, "  release_date: 0x%x\n",
                           (guint) fu_struct_smbios_bios_information_get_release_date(st));
    g_string_append_printf(str, "  rom_size: 0x%x\n",
                           (guint) fu_struct_smbios_bios_information_get_rom_size(st));
    {
        g_autofree gchar *tmp = fu_smbios_bios_characteristics_to_string(fu_struct_smbios_bios_information_get_characteristics(st));
        if (tmp != NULL) {
            g_string_append_printf(str, "  characteristics: 0x%x [%s]\n", (guint) fu_struct_smbios_bios_information_get_characteristics(st), tmp);
        } else {
            g_string_append_printf(str, "  characteristics: 0x%x\n", (guint) fu_struct_smbios_bios_information_get_characteristics(st));
        }
    }
    {
        g_autofree gchar *tmp = fu_smbios_bios_characteristics_ext_to_string(fu_struct_smbios_bios_information_get_characteristics_ext(st));
        if (tmp != NULL) {
            g_string_append_printf(str, "  characteristics_ext: 0x%x [%s]\n", (guint) fu_struct_smbios_bios_information_get_characteristics_ext(st), tmp);
        } else {
            g_string_append_printf(str, "  characteristics_ext: 0x%x\n", (guint) fu_struct_smbios_bios_information_get_characteristics_ext(st));
        }
    }
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_struct_smbios_bios_information_validate_internal(FuStructSmbiosBiosInformation *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    if (fu_struct_smbios_bios_information_get_type(st) != FU_SMBIOS_STRUCTURE_TYPE_BIOS) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "constant FuStructSmbiosBiosInformation.type was not valid, "
                    "expected 'FuSmbiosStructureType' and got '%s'",
                    fu_smbios_structure_type_to_string(fu_struct_smbios_bios_information_get_type(st)));
        return FALSE;
    }
    return TRUE;
}
static gboolean
fu_struct_smbios_bios_information_parse_internal(FuStructSmbiosBiosInformation *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_struct_smbios_bios_information_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_struct_smbios_bios_information_validate_internal(st, error))
        return FALSE;
    return TRUE;
}

/**
 * fu_struct_smbios_bios_information_parse: (skip):
 **/
static FuStructSmbiosBiosInformation *
fu_struct_smbios_bios_information_parse(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    g_autoptr(FuStructSmbiosBiosInformation) st = fu_struct_smbios_bios_information_new_internal();
    g_return_val_if_fail(buf != NULL, NULL);
    g_return_val_if_fail(error == NULL || *error == NULL, NULL);
    if (!fu_memchk_read(bufsz, offset, 20, error)) {
        g_prefix_error_literal(error, "invalid struct FuStructSmbiosBiosInformation: ");
        return NULL;
    }
    st->buf = g_byte_array_new();
    g_byte_array_append(st->buf, buf + offset, 20);
    if (!fu_struct_smbios_bios_information_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
/**
 * fu_struct_smbios_bios_information_parse_bytes: (skip):
 **/
FuStructSmbiosBiosInformation *
fu_struct_smbios_bios_information_parse_bytes(GBytes *blob, gsize offset, GError **error)
{
    gsize bufsz = 0;
    const guint8 *buf = g_bytes_get_data(blob, &bufsz);
    return fu_struct_smbios_bios_information_parse(buf, bufsz, offset, error);
}
