/* voice_processor.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from voice_processor.vala, do not modify */

#include <gst/base/base.h>
#include <gst/gst.h>
#include "rtp.h"
#include <gst/audio/audio.h>
#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	DINO_PLUGINS_RTP_ECHO_PROBE_0_PROPERTY,
	DINO_PLUGINS_RTP_ECHO_PROBE_AUDIO_INFO_PROPERTY,
	DINO_PLUGINS_RTP_ECHO_PROBE_DELAY_PROPERTY,
	DINO_PLUGINS_RTP_ECHO_PROBE_NUM_PROPERTIES
};
static GParamSpec* dino_plugins_rtp_echo_probe_properties[DINO_PLUGINS_RTP_ECHO_PROBE_NUM_PROPERTIES];
#define __vala_GstAudioInfo_free0(var) ((var == NULL) ? NULL : (var = (_vala_GstAudioInfo_free (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _gst_query_unref0(var) ((var == NULL) ? NULL : (var = (gst_query_unref (var), NULL)))
#define _gst_event_unref0(var) ((var == NULL) ? NULL : (var = (gst_event_unref (var), NULL)))
enum  {
	DINO_PLUGINS_RTP_ECHO_PROBE_ON_NEW_BUFFER_SIGNAL,
	DINO_PLUGINS_RTP_ECHO_PROBE_ON_NEW_DELAY_SIGNAL,
	DINO_PLUGINS_RTP_ECHO_PROBE_NUM_SIGNALS
};
static guint dino_plugins_rtp_echo_probe_signals[DINO_PLUGINS_RTP_ECHO_PROBE_NUM_SIGNALS] = {0};
enum  {
	DINO_PLUGINS_RTP_VOICE_PROCESSOR_0_PROPERTY,
	DINO_PLUGINS_RTP_VOICE_PROCESSOR_AUDIO_INFO_PROPERTY,
	DINO_PLUGINS_RTP_VOICE_PROCESSOR_NUM_PROPERTIES
};
static GParamSpec* dino_plugins_rtp_voice_processor_properties[DINO_PLUGINS_RTP_VOICE_PROCESSOR_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _gst_caps_unref0(var) ((var == NULL) ? NULL : (var = (gst_caps_unref (var), NULL)))
#define _gst_buffer_unref0(var) ((var == NULL) ? NULL : (var = (gst_buffer_unref (var), NULL)))

struct _DinoPluginsRtpEchoProbePrivate {
	GstAudioInfo* _audio_info;
	guint period_samples;
	guint period_size;
	gint _delay;
	GstAdapter* adapter;
	GRecMutex __lock_adapter;
};

struct _DinoPluginsRtpVoiceProcessorPrivate {
	GstAudioInfo* _audio_info;
	gulong process_outgoing_buffer_handler_id;
	gulong process_stream_delay_handler_id;
	guint adjust_delay_timeout_id;
	guint period_samples;
	guint period_size;
	GstAdapter* adapter;
	GRecMutex __lock_adapter;
	DinoPluginsRtpEchoProbe* echo_probe;
	GstStreamVolume* stream_volume;
	GstClockTime last_reverse;
	void* native;
};

static gint DinoPluginsRtpEchoProbe_private_offset;
static gpointer dino_plugins_rtp_echo_probe_parent_class = NULL;
static GstStaticPadTemplate dino_plugins_rtp_echo_probe_sink_template;
static GstStaticPadTemplate dino_plugins_rtp_echo_probe_sink_template = {"sink", GST_PAD_SINK, GST_PAD_ALWAYS, {NULL, "audio/x-raw,rate=48000,channels=1,layout=interleaved,format=S16LE"}};
static GstStaticPadTemplate dino_plugins_rtp_echo_probe_src_template;
static GstStaticPadTemplate dino_plugins_rtp_echo_probe_src_template = {"src", GST_PAD_SRC, GST_PAD_ALWAYS, {NULL, "audio/x-raw,rate=48000,channels=1,layout=interleaved,format=S16LE"}};
static gint DinoPluginsRtpVoiceProcessor_private_offset;
static gpointer dino_plugins_rtp_voice_processor_parent_class = NULL;
static GstStaticPadTemplate dino_plugins_rtp_voice_processor_sink_template;
static GstStaticPadTemplate dino_plugins_rtp_voice_processor_sink_template = {"sink", GST_PAD_SINK, GST_PAD_ALWAYS, {NULL, "audio/x-raw,rate=48000,channels=1,layout=interleaved,format=S16LE"}};
static GstStaticPadTemplate dino_plugins_rtp_voice_processor_src_template;
static GstStaticPadTemplate dino_plugins_rtp_voice_processor_src_template = {"src", GST_PAD_SRC, GST_PAD_ALWAYS, {NULL, "audio/x-raw,rate=48000,channels=1,layout=interleaved,format=S16LE"}};

static void _vala_GstAudioInfo_free (GstAudioInfo* self);
static gboolean dino_plugins_rtp_echo_probe_real_setup (GstAudioFilter* base,
                                                 GstAudioInfo* info);
static void dino_plugins_rtp_echo_probe_set_audio_info (DinoPluginsRtpEchoProbe* self,
                                                 GstAudioInfo* value);
static gboolean dino_plugins_rtp_echo_probe_real_src_event (GstBaseTransform* base,
                                                     GstEvent* event);
static void dino_plugins_rtp_echo_probe_set_delay (DinoPluginsRtpEchoProbe* self,
                                            gint value);
static GstFlowReturn dino_plugins_rtp_echo_probe_real_transform_ip (GstBaseTransform* base,
                                                             GstBuffer* buf);
static gboolean dino_plugins_rtp_echo_probe_real_stop (GstBaseTransform* base);
static GstAudioInfo* _vala_GstAudioInfo_copy (GstAudioInfo* self);
static GObject * dino_plugins_rtp_echo_probe_constructor (GType type,
                                                   guint n_construct_properties,
                                                   GObjectConstructParam * construct_properties);
static void dino_plugins_rtp_echo_probe_finalize (GObject * obj);
static GType dino_plugins_rtp_echo_probe_get_type_once (void);
static void _vala_dino_plugins_rtp_echo_probe_get_property (GObject * object,
                                                     guint property_id,
                                                     GValue * value,
                                                     GParamSpec * pspec);
static void _vala_dino_plugins_rtp_echo_probe_set_property (GObject * object,
                                                     guint property_id,
                                                     const GValue * value,
                                                     GParamSpec * pspec);
void* dino_plugins_rtp_voice_processor_init_native (gint stream_delay);
void dino_plugins_rtp_voice_processor_destroy_native (void* native);
void dino_plugins_rtp_voice_processor_analyze_reverse_stream (void* native,
                                                              GstAudioInfo* info,
                                                              GstBuffer* buffer);
void dino_plugins_rtp_voice_processor_process_stream (void* native,
                                                      GstAudioInfo* info,
                                                      GstBuffer* buffer);
void dino_plugins_rtp_voice_processor_adjust_stream_delay (void* native);
void dino_plugins_rtp_voice_processor_set_stream_delay (void* native,
                                                        gint delay);
void dino_plugins_rtp_voice_processor_notify_gain_level (void* native,
                                                         gint gain_level);
gint dino_plugins_rtp_voice_processor_get_suggested_gain_level (void* native);
gboolean dino_plugins_rtp_voice_processor_get_stream_has_voice (void* native);
static gboolean dino_plugins_rtp_voice_processor_real_setup (GstAudioFilter* base,
                                                      GstAudioInfo* info);
static void dino_plugins_rtp_voice_processor_set_audio_info (DinoPluginsRtpVoiceProcessor* self,
                                                      GstAudioInfo* value);
static gboolean dino_plugins_rtp_voice_processor_real_start (GstBaseTransform* base);
static void dino_plugins_rtp_voice_processor_process_outgoing_buffer (DinoPluginsRtpVoiceProcessor* self,
                                                               GstBuffer* buffer);
static void _dino_plugins_rtp_voice_processor_process_outgoing_buffer_dino_plugins_rtp_echo_probe_on_new_buffer (DinoPluginsRtpEchoProbe* _sender,
                                                                                                          GstBuffer* buffer,
                                                                                                          gpointer self);
static void dino_plugins_rtp_voice_processor_process_stream_delay (DinoPluginsRtpVoiceProcessor* self,
                                                            gint stream_delay);
static void _dino_plugins_rtp_voice_processor_process_stream_delay_dino_plugins_rtp_echo_probe_on_new_delay (DinoPluginsRtpEchoProbe* _sender,
                                                                                                      gint delay,
                                                                                                      gpointer self);
static gboolean dino_plugins_rtp_voice_processor_adjust_delay (DinoPluginsRtpVoiceProcessor* self);
static gboolean _dino_plugins_rtp_voice_processor_adjust_delay_gsource_func (gpointer self);
static GstFlowReturn dino_plugins_rtp_voice_processor_real_submit_input_buffer (GstBaseTransform* base,
                                                                         gboolean is_discont,
                                                                         GstBuffer* input);
static GstFlowReturn dino_plugins_rtp_voice_processor_real_generate_output (GstBaseTransform* base,
                                                                     GstBuffer** output_buffer);
static gboolean dino_plugins_rtp_voice_processor_real_stop (GstBaseTransform* base);
static GObject * dino_plugins_rtp_voice_processor_constructor (GType type,
                                                        guint n_construct_properties,
                                                        GObjectConstructParam * construct_properties);
static void dino_plugins_rtp_voice_processor_finalize (GObject * obj);
static GType dino_plugins_rtp_voice_processor_get_type_once (void);
static void _vala_dino_plugins_rtp_voice_processor_get_property (GObject * object,
                                                          guint property_id,
                                                          GValue * value,
                                                          GParamSpec * pspec);
static void _vala_dino_plugins_rtp_voice_processor_set_property (GObject * object,
                                                          guint property_id,
                                                          const GValue * value,
                                                          GParamSpec * pspec);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
dino_plugins_rtp_echo_probe_get_instance_private (DinoPluginsRtpEchoProbe* self)
{
	return G_STRUCT_MEMBER_P (self, DinoPluginsRtpEchoProbe_private_offset);
}

static void
_vala_GstAudioInfo_free (GstAudioInfo* self)
{
	g_boxed_free (gst_audio_info_get_type (), self);
}

static gboolean
dino_plugins_rtp_echo_probe_real_setup (GstAudioFilter* base,
                                        GstAudioInfo* info)
{
	DinoPluginsRtpEchoProbe * self;
	gboolean result;
	self = (DinoPluginsRtpEchoProbe*) base;
	g_return_val_if_fail (info != NULL, FALSE);
	dino_plugins_rtp_echo_probe_set_audio_info (self, info);
	self->priv->period_samples = (guint) (info->rate / 100);
	self->priv->period_size = self->priv->period_samples * info->bpf;
	result = TRUE;
	return result;
}

static gboolean
dino_plugins_rtp_echo_probe_real_src_event (GstBaseTransform* base,
                                            GstEvent* event)
{
	DinoPluginsRtpEchoProbe * self;
	GstQuery* query = NULL;
	GstQuery* _tmp0_;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	GstEvent* _tmp11_;
	gboolean result;
	self = (DinoPluginsRtpEchoProbe*) base;
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = gst_query_new_latency ();
	query = _tmp0_;
	if (event->type == GST_EVENT_LATENCY) {
		GstPad* _tmp3_;
		_tmp3_ = ((GstBaseTransform*) self)->srcpad;
		_tmp2_ = _tmp3_ != NULL;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		GstPad* _tmp4_;
		GstQuery* _tmp5_;
		_tmp4_ = ((GstBaseTransform*) self)->srcpad;
		_tmp5_ = query;
		_tmp1_ = gst_pad_query (_tmp4_, _tmp5_);
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		GstClockTime upstream_latency = 0ULL;
		GstQuery* _tmp6_;
		GstClockTime _tmp7_ = 0ULL;
		gint delay = 0;
		gint _tmp8_;
		gint _tmp9_;
		_tmp6_ = query;
		gst_query_parse_latency (_tmp6_, NULL, &_tmp7_, NULL);
		upstream_latency = _tmp7_;
		_tmp8_ = self->priv->_delay;
		delay = _tmp8_;
		if (upstream_latency != GST_CLOCK_TIME_NONE) {
			delay = (gint) (upstream_latency / GST_MSECOND);
		} else {
			delay = 0;
		}
		_tmp9_ = self->priv->_delay;
		if (delay != _tmp9_) {
			gint _tmp10_;
			_tmp10_ = self->priv->_delay;
			g_debug ("voice_processor.vala:47: Delay adjusted from %ms to %dms", _tmp10_, delay);
			dino_plugins_rtp_echo_probe_set_delay (self, delay);
			g_signal_emit (self, dino_plugins_rtp_echo_probe_signals[DINO_PLUGINS_RTP_ECHO_PROBE_ON_NEW_DELAY_SIGNAL], 0, delay);
		}
	}
	_tmp11_ = event;
	event = NULL;
	result = GST_BASE_TRANSFORM_CLASS (dino_plugins_rtp_echo_probe_parent_class)->src_event ((GstBaseTransform*) G_TYPE_CHECK_INSTANCE_CAST (self, gst_audio_filter_get_type (), GstAudioFilter), _tmp11_);
	_gst_query_unref0 (query);
	_gst_event_unref0 (event);
	return result;
}

static GstFlowReturn
dino_plugins_rtp_echo_probe_real_transform_ip (GstBaseTransform* base,
                                               GstBuffer* buf)
{
	DinoPluginsRtpEchoProbe * self;
	GError* _inner_error0_ = NULL;
	GstFlowReturn result;
	self = (DinoPluginsRtpEchoProbe*) base;
	g_return_val_if_fail (buf != NULL, 0);
	{
		GstAdapter* _tmp0_;
		_tmp0_ = self->priv->adapter;
		g_rec_mutex_lock (&self->priv->__lock_adapter);
		{
			GstAdapter* _tmp1_;
			GstBuffer* _tmp2_;
			_tmp1_ = self->priv->adapter;
			_tmp2_ = dino_plugins_rtp_adjust_to_running_time ((GstBaseTransform*) self, buf);
			gst_adapter_push (_tmp1_, _tmp2_);
			while (TRUE) {
				GstAdapter* _tmp3_;
				GstAdapter* _tmp4_;
				GstBuffer* _tmp5_;
				_tmp3_ = self->priv->adapter;
				if (!(gst_adapter_available (_tmp3_) > ((gsize) self->priv->period_size))) {
					break;
				}
				_tmp4_ = self->priv->adapter;
				_tmp5_ = gst_adapter_take_buffer (_tmp4_, (gsize) self->priv->period_size);
				g_signal_emit (self, dino_plugins_rtp_echo_probe_signals[DINO_PLUGINS_RTP_ECHO_PROBE_ON_NEW_BUFFER_SIGNAL], 0, _tmp5_);
			}
		}
		__finally0:
		{
			GstAdapter* _tmp6_;
			_tmp6_ = self->priv->adapter;
			g_rec_mutex_unlock (&self->priv->__lock_adapter);
		}
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return 0;
		}
	}
	result = GST_FLOW_OK;
	return result;
}

static gboolean
dino_plugins_rtp_echo_probe_real_stop (GstBaseTransform* base)
{
	DinoPluginsRtpEchoProbe * self;
	GstAdapter* _tmp0_;
	gboolean result;
	self = (DinoPluginsRtpEchoProbe*) base;
	_tmp0_ = self->priv->adapter;
	gst_adapter_clear (_tmp0_);
	result = TRUE;
	return result;
}

DinoPluginsRtpEchoProbe*
dino_plugins_rtp_echo_probe_construct (GType object_type)
{
	DinoPluginsRtpEchoProbe * self = NULL;
	self = (DinoPluginsRtpEchoProbe*) g_object_new (object_type, NULL);
	return self;
}

DinoPluginsRtpEchoProbe*
dino_plugins_rtp_echo_probe_new (void)
{
	return dino_plugins_rtp_echo_probe_construct (DINO_PLUGINS_RTP_TYPE_ECHO_PROBE);
}

GstAudioInfo*
dino_plugins_rtp_echo_probe_get_audio_info (DinoPluginsRtpEchoProbe* self)
{
	GstAudioInfo* result;
	GstAudioInfo* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_audio_info;
	result = _tmp0_;
	return result;
}

static GstAudioInfo*
_vala_GstAudioInfo_copy (GstAudioInfo* self)
{
	return g_boxed_copy (gst_audio_info_get_type (), self);
}

static gpointer
__vala_GstAudioInfo_copy0 (gpointer self)
{
	return self ? _vala_GstAudioInfo_copy (self) : NULL;
}

static void
dino_plugins_rtp_echo_probe_set_audio_info (DinoPluginsRtpEchoProbe* self,
                                            GstAudioInfo* value)
{
	GstAudioInfo* old_value;
	g_return_if_fail (self != NULL);
	old_value = dino_plugins_rtp_echo_probe_get_audio_info (self);
	if (old_value != value) {
		GstAudioInfo* _tmp0_;
		_tmp0_ = __vala_GstAudioInfo_copy0 (value);
		__vala_GstAudioInfo_free0 (self->priv->_audio_info);
		self->priv->_audio_info = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, dino_plugins_rtp_echo_probe_properties[DINO_PLUGINS_RTP_ECHO_PROBE_AUDIO_INFO_PROPERTY]);
	}
}

gint
dino_plugins_rtp_echo_probe_get_delay (DinoPluginsRtpEchoProbe* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_delay;
	return result;
}

static void
dino_plugins_rtp_echo_probe_set_delay (DinoPluginsRtpEchoProbe* self,
                                       gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = dino_plugins_rtp_echo_probe_get_delay (self);
	if (old_value != value) {
		self->priv->_delay = value;
		g_object_notify_by_pspec ((GObject *) self, dino_plugins_rtp_echo_probe_properties[DINO_PLUGINS_RTP_ECHO_PROBE_DELAY_PROPERTY]);
	}
}

static GObject *
dino_plugins_rtp_echo_probe_constructor (GType type,
                                         guint n_construct_properties,
                                         GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	DinoPluginsRtpEchoProbe * self;
	parent_class = G_OBJECT_CLASS (dino_plugins_rtp_echo_probe_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, DINO_PLUGINS_RTP_TYPE_ECHO_PROBE, DinoPluginsRtpEchoProbe);
	gst_base_transform_set_passthrough ((GstBaseTransform*) self, TRUE);
	return obj;
}

static void
dino_plugins_rtp_echo_probe_class_init (DinoPluginsRtpEchoProbeClass * klass,
                                        gpointer klass_data)
{
	GstStaticPadTemplate _tmp0_;
	GstStaticPadTemplate _tmp1_;
	dino_plugins_rtp_echo_probe_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &DinoPluginsRtpEchoProbe_private_offset);
	((GstAudioFilterClass *) klass)->setup = (gboolean (*) (GstAudioFilter*, GstAudioInfo*)) dino_plugins_rtp_echo_probe_real_setup;
	((GstBaseTransformClass *) klass)->src_event = (gboolean (*) (GstBaseTransform*, GstEvent*)) dino_plugins_rtp_echo_probe_real_src_event;
	((GstBaseTransformClass *) klass)->transform_ip = (GstFlowReturn (*) (GstBaseTransform*, GstBuffer*)) dino_plugins_rtp_echo_probe_real_transform_ip;
	((GstBaseTransformClass *) klass)->stop = (gboolean (*) (GstBaseTransform*)) dino_plugins_rtp_echo_probe_real_stop;
	G_OBJECT_CLASS (klass)->get_property = _vala_dino_plugins_rtp_echo_probe_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_dino_plugins_rtp_echo_probe_set_property;
	G_OBJECT_CLASS (klass)->constructor = dino_plugins_rtp_echo_probe_constructor;
	G_OBJECT_CLASS (klass)->finalize = dino_plugins_rtp_echo_probe_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), DINO_PLUGINS_RTP_ECHO_PROBE_AUDIO_INFO_PROPERTY, dino_plugins_rtp_echo_probe_properties[DINO_PLUGINS_RTP_ECHO_PROBE_AUDIO_INFO_PROPERTY] = g_param_spec_boxed ("audio-info", "audio-info", "audio-info", gst_audio_info_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DINO_PLUGINS_RTP_ECHO_PROBE_DELAY_PROPERTY, dino_plugins_rtp_echo_probe_properties[DINO_PLUGINS_RTP_ECHO_PROBE_DELAY_PROPERTY] = g_param_spec_int ("delay", "delay", "delay", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	dino_plugins_rtp_echo_probe_signals[DINO_PLUGINS_RTP_ECHO_PROBE_ON_NEW_BUFFER_SIGNAL] = g_signal_new ("on-new-buffer", DINO_PLUGINS_RTP_TYPE_ECHO_PROBE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__BOXED, G_TYPE_NONE, 1, gst_buffer_get_type ());
	dino_plugins_rtp_echo_probe_signals[DINO_PLUGINS_RTP_ECHO_PROBE_ON_NEW_DELAY_SIGNAL] = g_signal_new ("on-new-delay", DINO_PLUGINS_RTP_TYPE_ECHO_PROBE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__INT, G_TYPE_NONE, 1, G_TYPE_INT);
	_tmp0_ = dino_plugins_rtp_echo_probe_sink_template;
	gst_element_class_add_static_pad_template (GST_ELEMENT_CLASS (klass), &_tmp0_);
	_tmp1_ = dino_plugins_rtp_echo_probe_src_template;
	gst_element_class_add_static_pad_template (GST_ELEMENT_CLASS (klass), &_tmp1_);
	gst_element_class_set_static_metadata (GST_ELEMENT_CLASS (klass), "Acoustic Echo Canceller probe", "Generic/Audio", "Gathers playback buffers for echo cancellation", "Dino Team <contact@dino.im>");
}

static void
dino_plugins_rtp_echo_probe_instance_init (DinoPluginsRtpEchoProbe * self,
                                           gpointer klass)
{
	GstAdapter* _tmp0_;
	self->priv = dino_plugins_rtp_echo_probe_get_instance_private (self);
	g_rec_mutex_init (&self->priv->__lock_adapter);
	_tmp0_ = gst_adapter_new ();
	self->priv->adapter = _tmp0_;
}

static void
dino_plugins_rtp_echo_probe_finalize (GObject * obj)
{
	DinoPluginsRtpEchoProbe * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, DINO_PLUGINS_RTP_TYPE_ECHO_PROBE, DinoPluginsRtpEchoProbe);
	__vala_GstAudioInfo_free0 (self->priv->_audio_info);
	g_rec_mutex_clear (&self->priv->__lock_adapter);
	_g_object_unref0 (self->priv->adapter);
	G_OBJECT_CLASS (dino_plugins_rtp_echo_probe_parent_class)->finalize (obj);
}

static GType
dino_plugins_rtp_echo_probe_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (DinoPluginsRtpEchoProbeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) dino_plugins_rtp_echo_probe_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DinoPluginsRtpEchoProbe), 0, (GInstanceInitFunc) dino_plugins_rtp_echo_probe_instance_init, NULL };
	GType dino_plugins_rtp_echo_probe_type_id;
	dino_plugins_rtp_echo_probe_type_id = g_type_register_static (gst_audio_filter_get_type (), "DinoPluginsRtpEchoProbe", &g_define_type_info, 0);
	DinoPluginsRtpEchoProbe_private_offset = g_type_add_instance_private (dino_plugins_rtp_echo_probe_type_id, sizeof (DinoPluginsRtpEchoProbePrivate));
	return dino_plugins_rtp_echo_probe_type_id;
}

GType
dino_plugins_rtp_echo_probe_get_type (void)
{
	static volatile gsize dino_plugins_rtp_echo_probe_type_id__once = 0;
	if (g_once_init_enter (&dino_plugins_rtp_echo_probe_type_id__once)) {
		GType dino_plugins_rtp_echo_probe_type_id;
		dino_plugins_rtp_echo_probe_type_id = dino_plugins_rtp_echo_probe_get_type_once ();
		g_once_init_leave (&dino_plugins_rtp_echo_probe_type_id__once, dino_plugins_rtp_echo_probe_type_id);
	}
	return dino_plugins_rtp_echo_probe_type_id__once;
}

static void
_vala_dino_plugins_rtp_echo_probe_get_property (GObject * object,
                                                guint property_id,
                                                GValue * value,
                                                GParamSpec * pspec)
{
	DinoPluginsRtpEchoProbe * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, DINO_PLUGINS_RTP_TYPE_ECHO_PROBE, DinoPluginsRtpEchoProbe);
	switch (property_id) {
		case DINO_PLUGINS_RTP_ECHO_PROBE_AUDIO_INFO_PROPERTY:
		g_value_set_boxed (value, dino_plugins_rtp_echo_probe_get_audio_info (self));
		break;
		case DINO_PLUGINS_RTP_ECHO_PROBE_DELAY_PROPERTY:
		g_value_set_int (value, dino_plugins_rtp_echo_probe_get_delay (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_dino_plugins_rtp_echo_probe_set_property (GObject * object,
                                                guint property_id,
                                                const GValue * value,
                                                GParamSpec * pspec)
{
	DinoPluginsRtpEchoProbe * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, DINO_PLUGINS_RTP_TYPE_ECHO_PROBE, DinoPluginsRtpEchoProbe);
	switch (property_id) {
		case DINO_PLUGINS_RTP_ECHO_PROBE_AUDIO_INFO_PROPERTY:
		dino_plugins_rtp_echo_probe_set_audio_info (self, g_value_get_boxed (value));
		break;
		case DINO_PLUGINS_RTP_ECHO_PROBE_DELAY_PROPERTY:
		dino_plugins_rtp_echo_probe_set_delay (self, g_value_get_int (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
dino_plugins_rtp_voice_processor_get_instance_private (DinoPluginsRtpVoiceProcessor* self)
{
	return G_STRUCT_MEMBER_P (self, DinoPluginsRtpVoiceProcessor_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

DinoPluginsRtpVoiceProcessor*
dino_plugins_rtp_voice_processor_construct (GType object_type,
                                            DinoPluginsRtpEchoProbe* echo_probe,
                                            GstStreamVolume* stream_volume)
{
	DinoPluginsRtpVoiceProcessor * self = NULL;
	DinoPluginsRtpEchoProbe* _tmp0_;
	GstStreamVolume* _tmp1_;
	self = (DinoPluginsRtpVoiceProcessor*) g_object_new (object_type, NULL);
	_tmp0_ = _g_object_ref0 (echo_probe);
	_g_object_unref0 (self->priv->echo_probe);
	self->priv->echo_probe = _tmp0_;
	_tmp1_ = _g_object_ref0 (stream_volume);
	_g_object_unref0 (self->priv->stream_volume);
	self->priv->stream_volume = _tmp1_;
	return self;
}

DinoPluginsRtpVoiceProcessor*
dino_plugins_rtp_voice_processor_new (DinoPluginsRtpEchoProbe* echo_probe,
                                      GstStreamVolume* stream_volume)
{
	return dino_plugins_rtp_voice_processor_construct (DINO_PLUGINS_RTP_TYPE_VOICE_PROCESSOR, echo_probe, stream_volume);
}

static gboolean
dino_plugins_rtp_voice_processor_real_setup (GstAudioFilter* base,
                                             GstAudioInfo* info)
{
	DinoPluginsRtpVoiceProcessor * self;
	GstCaps* _tmp0_;
	GstCaps* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	GstAdapter* _tmp4_;
	gboolean result;
	self = (DinoPluginsRtpVoiceProcessor*) base;
	g_return_val_if_fail (info != NULL, FALSE);
	_tmp0_ = gst_audio_info_to_caps (info);
	_tmp1_ = _tmp0_;
	_tmp2_ = gst_caps_to_string (_tmp1_);
	_tmp3_ = _tmp2_;
	g_debug ("voice_processor.vala:112: VoiceProcessor.setup(%s)", _tmp3_);
	_g_free0 (_tmp3_);
	_gst_caps_unref0 (_tmp1_);
	dino_plugins_rtp_voice_processor_set_audio_info (self, info);
	self->priv->period_samples = (guint) (info->rate / 100);
	self->priv->period_size = self->priv->period_samples * info->bpf;
	_tmp4_ = self->priv->adapter;
	gst_adapter_clear (_tmp4_);
	result = TRUE;
	return result;
}

static void
_dino_plugins_rtp_voice_processor_process_outgoing_buffer_dino_plugins_rtp_echo_probe_on_new_buffer (DinoPluginsRtpEchoProbe* _sender,
                                                                                                     GstBuffer* buffer,
                                                                                                     gpointer self)
{
	dino_plugins_rtp_voice_processor_process_outgoing_buffer ((DinoPluginsRtpVoiceProcessor*) self, buffer);
}

static void
_dino_plugins_rtp_voice_processor_process_stream_delay_dino_plugins_rtp_echo_probe_on_new_delay (DinoPluginsRtpEchoProbe* _sender,
                                                                                                 gint delay,
                                                                                                 gpointer self)
{
	dino_plugins_rtp_voice_processor_process_stream_delay ((DinoPluginsRtpVoiceProcessor*) self, delay);
}

static gboolean
dino_plugins_rtp_voice_processor_real_start (GstBaseTransform* base)
{
	DinoPluginsRtpVoiceProcessor * self;
	DinoPluginsRtpEchoProbe* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	void* _tmp3_;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp8_ = FALSE;
	gboolean _tmp12_ = FALSE;
	gboolean _tmp13_ = FALSE;
	GstStreamVolume* _tmp14_;
	gboolean result;
	self = (DinoPluginsRtpVoiceProcessor*) base;
	_tmp0_ = self->priv->echo_probe;
	_tmp1_ = dino_plugins_rtp_echo_probe_get_delay (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = dino_plugins_rtp_voice_processor_init_native (_tmp2_);
	self->priv->native = _tmp3_;
	if (self->priv->process_outgoing_buffer_handler_id == ((gulong) 0)) {
		DinoPluginsRtpEchoProbe* _tmp5_;
		_tmp5_ = self->priv->echo_probe;
		_tmp4_ = _tmp5_ != NULL;
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		DinoPluginsRtpEchoProbe* _tmp6_;
		gulong _tmp7_;
		_tmp6_ = self->priv->echo_probe;
		_tmp7_ = g_signal_connect_object (_tmp6_, "on-new-buffer", (GCallback) _dino_plugins_rtp_voice_processor_process_outgoing_buffer_dino_plugins_rtp_echo_probe_on_new_buffer, self, 0);
		self->priv->process_outgoing_buffer_handler_id = _tmp7_;
	}
	if (self->priv->process_stream_delay_handler_id == ((gulong) 0)) {
		DinoPluginsRtpEchoProbe* _tmp9_;
		_tmp9_ = self->priv->echo_probe;
		_tmp8_ = _tmp9_ != NULL;
	} else {
		_tmp8_ = FALSE;
	}
	if (_tmp8_) {
		DinoPluginsRtpEchoProbe* _tmp10_;
		gulong _tmp11_;
		_tmp10_ = self->priv->echo_probe;
		_tmp11_ = g_signal_connect_object (_tmp10_, "on-new-delay", (GCallback) _dino_plugins_rtp_voice_processor_process_stream_delay_dino_plugins_rtp_echo_probe_on_new_delay, self, 0);
		self->priv->process_stream_delay_handler_id = _tmp11_;
	}
	_tmp14_ = self->priv->stream_volume;
	if (_tmp14_ == NULL) {
		GstPad* _tmp15_;
		GstPad* _tmp16_;
		GstPad* _tmp17_;
		_tmp15_ = ((GstBaseTransform*) self)->sinkpad;
		_tmp16_ = gst_pad_get_peer (_tmp15_);
		_tmp17_ = _tmp16_;
		_tmp13_ = _tmp17_ != NULL;
		_g_object_unref0 (_tmp17_);
	} else {
		_tmp13_ = FALSE;
	}
	if (_tmp13_) {
		GstPad* _tmp18_;
		GstPad* _tmp19_;
		GstPad* _tmp20_;
		GstElement* _tmp21_;
		GstElement* _tmp22_;
		_tmp18_ = ((GstBaseTransform*) self)->sinkpad;
		_tmp19_ = gst_pad_get_peer (_tmp18_);
		_tmp20_ = _tmp19_;
		_tmp21_ = gst_pad_get_parent_element (_tmp20_);
		_tmp22_ = _tmp21_;
		_tmp12_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp22_, gst_stream_volume_get_type ());
		_g_object_unref0 (_tmp22_);
		_g_object_unref0 (_tmp20_);
	} else {
		_tmp12_ = FALSE;
	}
	if (_tmp12_) {
		GstPad* _tmp23_;
		GstPad* _tmp24_;
		GstPad* _tmp25_;
		GstElement* _tmp26_;
		GstStreamVolume* _tmp27_;
		_tmp23_ = ((GstBaseTransform*) self)->sinkpad;
		_tmp24_ = gst_pad_get_peer (_tmp23_);
		_tmp25_ = _tmp24_;
		_tmp26_ = gst_pad_get_parent_element (_tmp25_);
		_tmp27_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp26_, gst_stream_volume_get_type ()) ? ((GstStreamVolume*) _tmp26_) : NULL;
		if (_tmp27_ == NULL) {
			_g_object_unref0 (_tmp26_);
		}
		_g_object_unref0 (self->priv->stream_volume);
		self->priv->stream_volume = _tmp27_;
		_g_object_unref0 (_tmp25_);
	}
	result = TRUE;
	return result;
}

static gboolean
dino_plugins_rtp_voice_processor_adjust_delay (DinoPluginsRtpVoiceProcessor* self)
{
	void* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->native;
	if (_tmp0_ != NULL) {
		void* _tmp1_;
		_tmp1_ = self->priv->native;
		dino_plugins_rtp_voice_processor_adjust_stream_delay (_tmp1_);
		result = G_SOURCE_CONTINUE;
		return result;
	} else {
		self->priv->adjust_delay_timeout_id = (guint) 0;
		result = G_SOURCE_REMOVE;
		return result;
	}
}

static gboolean
_dino_plugins_rtp_voice_processor_adjust_delay_gsource_func (gpointer self)
{
	gboolean result;
	result = dino_plugins_rtp_voice_processor_adjust_delay ((DinoPluginsRtpVoiceProcessor*) self);
	return result;
}

static void
dino_plugins_rtp_voice_processor_process_outgoing_buffer (DinoPluginsRtpVoiceProcessor* self,
                                                          GstBuffer* buffer)
{
	void* _tmp0_;
	gboolean _tmp7_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (buffer != NULL);
	if (buffer->pts != ((GstClockTime) G_MAXUINT64)) {
		self->priv->last_reverse = buffer->pts;
	}
	_tmp0_ = self->priv->native;
	if (_tmp0_ != NULL) {
		GstBuffer* _tmp1_;
		GstMiniObject* _tmp2_;
		void* _tmp3_;
		DinoPluginsRtpEchoProbe* _tmp4_;
		GstAudioInfo* _tmp5_;
		GstAudioInfo* _tmp6_;
		_tmp1_ = buffer;
		buffer = NULL;
		_tmp2_ = _tmp1_ = gst_mini_object_make_writable (_tmp1_);
		_gst_buffer_unref0 (buffer);
		buffer = (GstBuffer*) _tmp2_;
		_tmp3_ = self->priv->native;
		_tmp4_ = self->priv->echo_probe;
		_tmp5_ = dino_plugins_rtp_echo_probe_get_audio_info (_tmp4_);
		_tmp6_ = _tmp5_;
		dino_plugins_rtp_voice_processor_analyze_reverse_stream (_tmp3_, _tmp6_, buffer);
	}
	if (self->priv->adjust_delay_timeout_id == ((guint) 0)) {
		DinoPluginsRtpEchoProbe* _tmp8_;
		_tmp8_ = self->priv->echo_probe;
		_tmp7_ = _tmp8_ != NULL;
	} else {
		_tmp7_ = FALSE;
	}
	if (_tmp7_) {
		self->priv->adjust_delay_timeout_id = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 1000, _dino_plugins_rtp_voice_processor_adjust_delay_gsource_func, g_object_ref (self), g_object_unref);
	}
	_gst_buffer_unref0 (buffer);
}

static void
dino_plugins_rtp_voice_processor_process_stream_delay (DinoPluginsRtpVoiceProcessor* self,
                                                       gint stream_delay)
{
	void* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->native;
	if (_tmp0_ != NULL) {
		void* _tmp1_;
		_tmp1_ = self->priv->native;
		dino_plugins_rtp_voice_processor_set_stream_delay (_tmp1_, stream_delay);
	}
}

static GstFlowReturn
dino_plugins_rtp_voice_processor_real_submit_input_buffer (GstBaseTransform* base,
                                                           gboolean is_discont,
                                                           GstBuffer* input)
{
	DinoPluginsRtpVoiceProcessor * self;
	GError* _inner_error0_ = NULL;
	GstFlowReturn result;
	self = (DinoPluginsRtpVoiceProcessor*) base;
	g_return_val_if_fail (input != NULL, 0);
	{
		GstAdapter* _tmp0_;
		_tmp0_ = self->priv->adapter;
		g_rec_mutex_lock (&self->priv->__lock_adapter);
		{
			GstAdapter* _tmp2_;
			GstBuffer* _tmp3_;
			if (is_discont) {
				GstAdapter* _tmp1_;
				_tmp1_ = self->priv->adapter;
				gst_adapter_clear (_tmp1_);
			}
			_tmp2_ = self->priv->adapter;
			_tmp3_ = dino_plugins_rtp_adjust_to_running_time ((GstBaseTransform*) self, input);
			gst_adapter_push (_tmp2_, _tmp3_);
		}
		__finally0:
		{
			GstAdapter* _tmp4_;
			_tmp4_ = self->priv->adapter;
			g_rec_mutex_unlock (&self->priv->__lock_adapter);
		}
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return 0;
		}
	}
	result = GST_FLOW_OK;
	return result;
}

static GstFlowReturn
dino_plugins_rtp_voice_processor_real_generate_output (GstBaseTransform* base,
                                                       GstBuffer** output_buffer)
{
	DinoPluginsRtpVoiceProcessor * self;
	GstBuffer* _vala_output_buffer = NULL;
	GError* _inner_error0_ = NULL;
	GstFlowReturn result;
	self = (DinoPluginsRtpVoiceProcessor*) base;
	{
		GstAdapter* _tmp0_;
		_tmp0_ = self->priv->adapter;
		g_rec_mutex_lock (&self->priv->__lock_adapter);
		{
			GstAdapter* _tmp1_;
			_tmp1_ = self->priv->adapter;
			if (gst_adapter_available (_tmp1_) >= ((gsize) self->priv->period_size)) {
				GstAdapter* _tmp2_;
				GstBuffer* _tmp3_;
				GstBuffer* _tmp4_;
				GstMiniObject* _tmp5_;
				gint old_gain_level = 0;
				GstStreamVolume* _tmp6_;
				void* _tmp9_;
				GstAudioInfo* _tmp10_;
				GstBuffer* _tmp11_;
				GstStreamVolume* _tmp12_;
				_tmp2_ = self->priv->adapter;
				_tmp3_ = gst_adapter_take_buffer (_tmp2_, (gsize) self->priv->period_size);
				_tmp4_ = _tmp3_;
				_tmp3_ = NULL;
				_tmp5_ = _tmp4_ = gst_mini_object_make_writable (_tmp4_);
				_gst_buffer_unref0 (_vala_output_buffer);
				_vala_output_buffer = (GstBuffer*) _tmp5_;
				old_gain_level = 0;
				_tmp6_ = self->priv->stream_volume;
				if (_tmp6_ != NULL) {
					GstStreamVolume* _tmp7_;
					void* _tmp8_;
					_tmp7_ = self->priv->stream_volume;
					old_gain_level = (gint) (gst_stream_volume_get_volume (_tmp7_, GST_STREAM_VOLUME_FORMAT_LINEAR) * 255.0);
					_tmp8_ = self->priv->native;
					dino_plugins_rtp_voice_processor_notify_gain_level (_tmp8_, old_gain_level);
				}
				_tmp9_ = self->priv->native;
				_tmp10_ = self->priv->_audio_info;
				_tmp11_ = _vala_output_buffer;
				dino_plugins_rtp_voice_processor_process_stream (_tmp9_, _tmp10_, _tmp11_);
				_tmp12_ = self->priv->stream_volume;
				if (_tmp12_ != NULL) {
					gint new_gain_level = 0;
					void* _tmp13_;
					_tmp13_ = self->priv->native;
					new_gain_level = dino_plugins_rtp_voice_processor_get_suggested_gain_level (_tmp13_);
					if (old_gain_level != new_gain_level) {
						GstStreamVolume* _tmp14_;
						g_debug ("voice_processor.vala:186: Gain: %i -> %i", old_gain_level, new_gain_level);
						_tmp14_ = self->priv->stream_volume;
						gst_stream_volume_set_volume (_tmp14_, GST_STREAM_VOLUME_FORMAT_LINEAR, ((gdouble) new_gain_level) / 255.0);
					}
				}
			}
		}
		__finally0:
		{
			GstAdapter* _tmp15_;
			_tmp15_ = self->priv->adapter;
			g_rec_mutex_unlock (&self->priv->__lock_adapter);
		}
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_gst_buffer_unref0 (_vala_output_buffer);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return 0;
		}
	}
	result = GST_FLOW_OK;
	if (output_buffer) {
		*output_buffer = _vala_output_buffer;
	} else {
		_gst_buffer_unref0 (_vala_output_buffer);
	}
	return result;
}

static gboolean
dino_plugins_rtp_voice_processor_real_stop (GstBaseTransform* base)
{
	DinoPluginsRtpVoiceProcessor * self;
	GstAdapter* _tmp1_;
	void* _tmp2_;
	gboolean result;
	self = (DinoPluginsRtpVoiceProcessor*) base;
	if (self->priv->process_outgoing_buffer_handler_id != ((gulong) 0)) {
		DinoPluginsRtpEchoProbe* _tmp0_;
		_tmp0_ = self->priv->echo_probe;
		g_signal_handler_disconnect ((GObject*) _tmp0_, self->priv->process_outgoing_buffer_handler_id);
		self->priv->process_outgoing_buffer_handler_id = (gulong) 0;
	}
	if (self->priv->adjust_delay_timeout_id != ((guint) 0)) {
		g_source_remove (self->priv->adjust_delay_timeout_id);
		self->priv->adjust_delay_timeout_id = (guint) 0;
	}
	_tmp1_ = self->priv->adapter;
	gst_adapter_clear (_tmp1_);
	_tmp2_ = self->priv->native;
	dino_plugins_rtp_voice_processor_destroy_native (_tmp2_);
	self->priv->native = NULL;
	result = TRUE;
	return result;
}

GstAudioInfo*
dino_plugins_rtp_voice_processor_get_audio_info (DinoPluginsRtpVoiceProcessor* self)
{
	GstAudioInfo* result;
	GstAudioInfo* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_audio_info;
	result = _tmp0_;
	return result;
}

static void
dino_plugins_rtp_voice_processor_set_audio_info (DinoPluginsRtpVoiceProcessor* self,
                                                 GstAudioInfo* value)
{
	GstAudioInfo* old_value;
	g_return_if_fail (self != NULL);
	old_value = dino_plugins_rtp_voice_processor_get_audio_info (self);
	if (old_value != value) {
		GstAudioInfo* _tmp0_;
		_tmp0_ = __vala_GstAudioInfo_copy0 (value);
		__vala_GstAudioInfo_free0 (self->priv->_audio_info);
		self->priv->_audio_info = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, dino_plugins_rtp_voice_processor_properties[DINO_PLUGINS_RTP_VOICE_PROCESSOR_AUDIO_INFO_PROPERTY]);
	}
}

static GObject *
dino_plugins_rtp_voice_processor_constructor (GType type,
                                              guint n_construct_properties,
                                              GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	DinoPluginsRtpVoiceProcessor * self;
	parent_class = G_OBJECT_CLASS (dino_plugins_rtp_voice_processor_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, DINO_PLUGINS_RTP_TYPE_VOICE_PROCESSOR, DinoPluginsRtpVoiceProcessor);
	gst_base_transform_set_passthrough ((GstBaseTransform*) self, FALSE);
	return obj;
}

static void
dino_plugins_rtp_voice_processor_class_init (DinoPluginsRtpVoiceProcessorClass * klass,
                                             gpointer klass_data)
{
	GstStaticPadTemplate _tmp0_;
	GstStaticPadTemplate _tmp1_;
	dino_plugins_rtp_voice_processor_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &DinoPluginsRtpVoiceProcessor_private_offset);
	((GstAudioFilterClass *) klass)->setup = (gboolean (*) (GstAudioFilter*, GstAudioInfo*)) dino_plugins_rtp_voice_processor_real_setup;
	((GstBaseTransformClass *) klass)->start = (gboolean (*) (GstBaseTransform*)) dino_plugins_rtp_voice_processor_real_start;
	((GstBaseTransformClass *) klass)->submit_input_buffer = (GstFlowReturn (*) (GstBaseTransform*, gboolean, GstBuffer*)) dino_plugins_rtp_voice_processor_real_submit_input_buffer;
	((GstBaseTransformClass *) klass)->generate_output = (GstFlowReturn (*) (GstBaseTransform*, GstBuffer**)) dino_plugins_rtp_voice_processor_real_generate_output;
	((GstBaseTransformClass *) klass)->stop = (gboolean (*) (GstBaseTransform*)) dino_plugins_rtp_voice_processor_real_stop;
	G_OBJECT_CLASS (klass)->get_property = _vala_dino_plugins_rtp_voice_processor_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_dino_plugins_rtp_voice_processor_set_property;
	G_OBJECT_CLASS (klass)->constructor = dino_plugins_rtp_voice_processor_constructor;
	G_OBJECT_CLASS (klass)->finalize = dino_plugins_rtp_voice_processor_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), DINO_PLUGINS_RTP_VOICE_PROCESSOR_AUDIO_INFO_PROPERTY, dino_plugins_rtp_voice_processor_properties[DINO_PLUGINS_RTP_VOICE_PROCESSOR_AUDIO_INFO_PROPERTY] = g_param_spec_boxed ("audio-info", "audio-info", "audio-info", gst_audio_info_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	_tmp0_ = dino_plugins_rtp_voice_processor_sink_template;
	gst_element_class_add_static_pad_template (GST_ELEMENT_CLASS (klass), &_tmp0_);
	_tmp1_ = dino_plugins_rtp_voice_processor_src_template;
	gst_element_class_add_static_pad_template (GST_ELEMENT_CLASS (klass), &_tmp1_);
	gst_element_class_set_static_metadata (GST_ELEMENT_CLASS (klass), "Voice Processor (AGC, AEC, filters, etc.)", "Generic/Audio", "Pre-processes voice with WebRTC Audio Processing Library", "Dino Team <contact@dino.im>");
}

static void
dino_plugins_rtp_voice_processor_instance_init (DinoPluginsRtpVoiceProcessor * self,
                                                gpointer klass)
{
	GstAdapter* _tmp0_;
	self->priv = dino_plugins_rtp_voice_processor_get_instance_private (self);
	g_rec_mutex_init (&self->priv->__lock_adapter);
	_tmp0_ = gst_adapter_new ();
	self->priv->adapter = _tmp0_;
}

static void
dino_plugins_rtp_voice_processor_finalize (GObject * obj)
{
	DinoPluginsRtpVoiceProcessor * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, DINO_PLUGINS_RTP_TYPE_VOICE_PROCESSOR, DinoPluginsRtpVoiceProcessor);
	__vala_GstAudioInfo_free0 (self->priv->_audio_info);
	g_rec_mutex_clear (&self->priv->__lock_adapter);
	_g_object_unref0 (self->priv->adapter);
	_g_object_unref0 (self->priv->echo_probe);
	_g_object_unref0 (self->priv->stream_volume);
	G_OBJECT_CLASS (dino_plugins_rtp_voice_processor_parent_class)->finalize (obj);
}

static GType
dino_plugins_rtp_voice_processor_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (DinoPluginsRtpVoiceProcessorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) dino_plugins_rtp_voice_processor_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DinoPluginsRtpVoiceProcessor), 0, (GInstanceInitFunc) dino_plugins_rtp_voice_processor_instance_init, NULL };
	GType dino_plugins_rtp_voice_processor_type_id;
	dino_plugins_rtp_voice_processor_type_id = g_type_register_static (gst_audio_filter_get_type (), "DinoPluginsRtpVoiceProcessor", &g_define_type_info, 0);
	DinoPluginsRtpVoiceProcessor_private_offset = g_type_add_instance_private (dino_plugins_rtp_voice_processor_type_id, sizeof (DinoPluginsRtpVoiceProcessorPrivate));
	return dino_plugins_rtp_voice_processor_type_id;
}

GType
dino_plugins_rtp_voice_processor_get_type (void)
{
	static volatile gsize dino_plugins_rtp_voice_processor_type_id__once = 0;
	if (g_once_init_enter (&dino_plugins_rtp_voice_processor_type_id__once)) {
		GType dino_plugins_rtp_voice_processor_type_id;
		dino_plugins_rtp_voice_processor_type_id = dino_plugins_rtp_voice_processor_get_type_once ();
		g_once_init_leave (&dino_plugins_rtp_voice_processor_type_id__once, dino_plugins_rtp_voice_processor_type_id);
	}
	return dino_plugins_rtp_voice_processor_type_id__once;
}

static void
_vala_dino_plugins_rtp_voice_processor_get_property (GObject * object,
                                                     guint property_id,
                                                     GValue * value,
                                                     GParamSpec * pspec)
{
	DinoPluginsRtpVoiceProcessor * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, DINO_PLUGINS_RTP_TYPE_VOICE_PROCESSOR, DinoPluginsRtpVoiceProcessor);
	switch (property_id) {
		case DINO_PLUGINS_RTP_VOICE_PROCESSOR_AUDIO_INFO_PROPERTY:
		g_value_set_boxed (value, dino_plugins_rtp_voice_processor_get_audio_info (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_dino_plugins_rtp_voice_processor_set_property (GObject * object,
                                                     guint property_id,
                                                     const GValue * value,
                                                     GParamSpec * pspec)
{
	DinoPluginsRtpVoiceProcessor * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, DINO_PLUGINS_RTP_TYPE_VOICE_PROCESSOR, DinoPluginsRtpVoiceProcessor);
	switch (property_id) {
		case DINO_PLUGINS_RTP_VOICE_PROCESSOR_AUDIO_INFO_PROPERTY:
		dino_plugins_rtp_voice_processor_set_audio_info (self, g_value_get_boxed (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

