/* Generated by wayland-scanner 1.24.0 */

#ifndef TREELAND_WINDOW_MANAGEMENT_V1_CLIENT_PROTOCOL_H
#define TREELAND_WINDOW_MANAGEMENT_V1_CLIENT_PROTOCOL_H

#include <stdint.h>
#include <stddef.h>
#include "wayland-client-core.h"

#ifdef  __cplusplus
extern "C" {
#endif

/**
 * @page page_treeland_window_management_v1 The treeland_window_management_v1 protocol
 * @section page_ifaces_treeland_window_management_v1 Interfaces
 * - @subpage page_iface_treeland_window_management_v1 - application windows management
 * @section page_copyright_treeland_window_management_v1 Copyright
 * <pre>
 *
 * SPDX-FileCopyrightText: 2024 UnionTech Software Technology Co., Ltd.
 * SPDX-License-Identifier: MIT
 * </pre>
 */
struct treeland_window_management_v1;

#ifndef TREELAND_WINDOW_MANAGEMENT_V1_INTERFACE
#define TREELAND_WINDOW_MANAGEMENT_V1_INTERFACE
/**
 * @page page_iface_treeland_window_management_v1 treeland_window_management_v1
 * @section page_iface_treeland_window_management_v1_desc Description
 *
 * This interface manages application windows.
 * It provides requests to show and hide the desktop and emits
 * an event every time a window is created so that the client can
 * use it to manage the window.
 *
 * Only one client can bind this interface at a time.
 * @section page_iface_treeland_window_management_v1_api API
 * See @ref iface_treeland_window_management_v1.
 */
/**
 * @defgroup iface_treeland_window_management_v1 The treeland_window_management_v1 interface
 *
 * This interface manages application windows.
 * It provides requests to show and hide the desktop and emits
 * an event every time a window is created so that the client can
 * use it to manage the window.
 *
 * Only one client can bind this interface at a time.
 */
extern const struct wl_interface treeland_window_management_v1_interface;
#endif

#ifndef TREELAND_WINDOW_MANAGEMENT_V1_DESKTOP_STATE_ENUM
#define TREELAND_WINDOW_MANAGEMENT_V1_DESKTOP_STATE_ENUM
enum treeland_window_management_v1_desktop_state {
	TREELAND_WINDOW_MANAGEMENT_V1_DESKTOP_STATE_NORMAL = 0,
	TREELAND_WINDOW_MANAGEMENT_V1_DESKTOP_STATE_SHOW = 1,
	TREELAND_WINDOW_MANAGEMENT_V1_DESKTOP_STATE_PREVIEW_SHOW = 2,
};
#endif /* TREELAND_WINDOW_MANAGEMENT_V1_DESKTOP_STATE_ENUM */

/**
 * @ingroup iface_treeland_window_management_v1
 * @struct treeland_window_management_v1_listener
 */
struct treeland_window_management_v1_listener {
	/**
	 * notify the client when the show desktop mode is entered/left
	 *
	 * This event will be sent whenever the show desktop mode
	 * changes. E.g. when it is entered or left.
	 *
	 * On binding the interface the current state is sent.
	 * @param state new state
	 */
	void (*show_desktop)(void *data,
			     struct treeland_window_management_v1 *treeland_window_management_v1,
			     uint32_t state);
};

/**
 * @ingroup iface_treeland_window_management_v1
 */
static inline int
treeland_window_management_v1_add_listener(struct treeland_window_management_v1 *treeland_window_management_v1,
					   const struct treeland_window_management_v1_listener *listener, void *data)
{
	return wl_proxy_add_listener((struct wl_proxy *) treeland_window_management_v1,
				     (void (**)(void)) listener, data);
}

#define TREELAND_WINDOW_MANAGEMENT_V1_SET_DESKTOP 0
#define TREELAND_WINDOW_MANAGEMENT_V1_DESTROY 1

/**
 * @ingroup iface_treeland_window_management_v1
 */
#define TREELAND_WINDOW_MANAGEMENT_V1_SHOW_DESKTOP_SINCE_VERSION 1

/**
 * @ingroup iface_treeland_window_management_v1
 */
#define TREELAND_WINDOW_MANAGEMENT_V1_SET_DESKTOP_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_window_management_v1
 */
#define TREELAND_WINDOW_MANAGEMENT_V1_DESTROY_SINCE_VERSION 1

/** @ingroup iface_treeland_window_management_v1 */
static inline void
treeland_window_management_v1_set_user_data(struct treeland_window_management_v1 *treeland_window_management_v1, void *user_data)
{
	wl_proxy_set_user_data((struct wl_proxy *) treeland_window_management_v1, user_data);
}

/** @ingroup iface_treeland_window_management_v1 */
static inline void *
treeland_window_management_v1_get_user_data(struct treeland_window_management_v1 *treeland_window_management_v1)
{
	return wl_proxy_get_user_data((struct wl_proxy *) treeland_window_management_v1);
}

static inline uint32_t
treeland_window_management_v1_get_version(struct treeland_window_management_v1 *treeland_window_management_v1)
{
	return wl_proxy_get_version((struct wl_proxy *) treeland_window_management_v1);
}

/**
 * @ingroup iface_treeland_window_management_v1
 *
 * Tell the compositor to show/hide the desktop.
 */
static inline void
treeland_window_management_v1_set_desktop(struct treeland_window_management_v1 *treeland_window_management_v1, uint32_t state)
{
	wl_proxy_marshal_flags((struct wl_proxy *) treeland_window_management_v1,
			 TREELAND_WINDOW_MANAGEMENT_V1_SET_DESKTOP, NULL, wl_proxy_get_version((struct wl_proxy *) treeland_window_management_v1), 0, state);
}

/**
 * @ingroup iface_treeland_window_management_v1
 */
static inline void
treeland_window_management_v1_destroy(struct treeland_window_management_v1 *treeland_window_management_v1)
{
	wl_proxy_marshal_flags((struct wl_proxy *) treeland_window_management_v1,
			 TREELAND_WINDOW_MANAGEMENT_V1_DESTROY, NULL, wl_proxy_get_version((struct wl_proxy *) treeland_window_management_v1), WL_MARSHAL_FLAG_DESTROY);
}

#ifdef  __cplusplus
}
#endif

#endif
