// This file was generated by qtwaylandscanner
// source file is /usr/share/deepin-wayland-protocols/dde-seat.xml

#ifndef QT_WAYLAND_SERVER_DDE_SEAT
#define QT_WAYLAND_SERVER_DDE_SEAT

#include "wayland-server-core.h"
#include "wayland-dde-seat-server-protocol.h"
#include <QByteArray>
#include <QMultiMap>
#include <QString>

#include <unistd.h>

#ifndef WAYLAND_VERSION_CHECK
#define WAYLAND_VERSION_CHECK(major, minor, micro) \
    ((WAYLAND_VERSION_MAJOR > (major)) || \
    (WAYLAND_VERSION_MAJOR == (major) && WAYLAND_VERSION_MINOR > (minor)) || \
    (WAYLAND_VERSION_MAJOR == (major) && WAYLAND_VERSION_MINOR == (minor) && WAYLAND_VERSION_MICRO >= (micro)))
#endif

QT_BEGIN_NAMESPACE
QT_WARNING_PUSH
QT_WARNING_DISABLE_GCC("-Wmissing-field-initializers")
QT_WARNING_DISABLE_CLANG("-Wmissing-field-initializers")

namespace QtWaylandServer {
    class  dde_seat
    {
    public:
        dde_seat(struct ::wl_client *client, int id, int version);
        dde_seat(struct ::wl_display *display, int version);
        dde_seat(struct ::wl_resource *resource);
        dde_seat();

        virtual ~dde_seat();

        class Resource
        {
        public:
            Resource() : dde_seat_object(nullptr), handle(nullptr) {}
            virtual ~Resource() {}

            dde_seat *dde_seat_object;
            dde_seat *object() { return dde_seat_object; } 
            struct ::wl_resource *handle;

            struct ::wl_client *client() const { return wl_resource_get_client(handle); }
            int version() const { return wl_resource_get_version(handle); }

            static Resource *fromResource(struct ::wl_resource *resource);
        };

        void init(struct ::wl_client *client, int id, int version);
        void init(struct ::wl_display *display, int version);
        void init(struct ::wl_resource *resource);

        Resource *add(struct ::wl_client *client, int version);
        Resource *add(struct ::wl_client *client, int id, int version);
        Resource *add(struct wl_list *resource_list, struct ::wl_client *client, int id, int version);

        Resource *resource() { return m_resource; }
        const Resource *resource() const { return m_resource; }

        QMultiMap<struct ::wl_client*, Resource*> resourceMap() { return m_resource_map; }
        const QMultiMap<struct ::wl_client*, Resource*> resourceMap() const { return m_resource_map; }

        bool isGlobalRemoved() const { return m_globalRemovedEvent; }
        void globalRemove();

        bool isGlobal() const { return m_global != nullptr; }
        bool isResource() const { return m_resource != nullptr; }

        static const struct ::wl_interface *interface();
        static QByteArray interfaceName() { return interface()->name; }
        static int interfaceVersion() { return interface()->version; }


    protected:
        virtual Resource *dde_seat_allocate();

        virtual void dde_seat_destroy_global();

        virtual void dde_seat_bind_resource(Resource *resource);
        virtual void dde_seat_destroy_resource(Resource *resource);

        virtual void dde_seat_get_dde_pointer(Resource *resource, uint32_t id);
        virtual void dde_seat_get_dde_keyboard(Resource *resource, uint32_t id);
        virtual void dde_seat_get_dde_touch(Resource *resource, uint32_t id);

    private:
        static void bind_func(struct ::wl_client *client, void *data, uint32_t version, uint32_t id);
        static void destroy_func(struct ::wl_resource *client_resource);
        static void display_destroy_func(struct ::wl_listener *listener, void *data);
        static int deferred_destroy_global_func(void *data);

        Resource *bind(struct ::wl_client *client, uint32_t id, int version);
        Resource *bind(struct ::wl_resource *handle);

        static const struct ::dde_seat_interface m_dde_seat_interface;

        static void handle_get_dde_pointer(
            ::wl_client *client,
            struct wl_resource *resource,
            uint32_t id);
        static void handle_get_dde_keyboard(
            ::wl_client *client,
            struct wl_resource *resource,
            uint32_t id);
        static void handle_get_dde_touch(
            ::wl_client *client,
            struct wl_resource *resource,
            uint32_t id);

        QMultiMap<struct ::wl_client*, Resource*> m_resource_map;
        Resource *m_resource;
        struct ::wl_global *m_global;
        struct ::wl_display *m_display;
        struct wl_event_source *m_globalRemovedEvent;
        struct DisplayDestroyedListener : ::wl_listener {
            dde_seat *parent;
        };
        DisplayDestroyedListener m_displayDestroyedListener;
    };

    class  dde_pointer
    {
    public:
        dde_pointer(struct ::wl_client *client, int id, int version);
        dde_pointer(struct ::wl_display *display, int version);
        dde_pointer(struct ::wl_resource *resource);
        dde_pointer();

        virtual ~dde_pointer();

        class Resource
        {
        public:
            Resource() : dde_pointer_object(nullptr), handle(nullptr) {}
            virtual ~Resource() {}

            dde_pointer *dde_pointer_object;
            dde_pointer *object() { return dde_pointer_object; } 
            struct ::wl_resource *handle;

            struct ::wl_client *client() const { return wl_resource_get_client(handle); }
            int version() const { return wl_resource_get_version(handle); }

            static Resource *fromResource(struct ::wl_resource *resource);
        };

        void init(struct ::wl_client *client, int id, int version);
        void init(struct ::wl_display *display, int version);
        void init(struct ::wl_resource *resource);

        Resource *add(struct ::wl_client *client, int version);
        Resource *add(struct ::wl_client *client, int id, int version);
        Resource *add(struct wl_list *resource_list, struct ::wl_client *client, int id, int version);

        Resource *resource() { return m_resource; }
        const Resource *resource() const { return m_resource; }

        QMultiMap<struct ::wl_client*, Resource*> resourceMap() { return m_resource_map; }
        const QMultiMap<struct ::wl_client*, Resource*> resourceMap() const { return m_resource_map; }

        bool isGlobalRemoved() const { return m_globalRemovedEvent; }
        void globalRemove();

        bool isGlobal() const { return m_global != nullptr; }
        bool isResource() const { return m_resource != nullptr; }

        static const struct ::wl_interface *interface();
        static QByteArray interfaceName() { return interface()->name; }
        static int interfaceVersion() { return interface()->version; }


        enum button_state {
            button_state_released = 0, // the button is not pressed
            button_state_pressed = 1, // the button is pressed
        };

        enum axis {
            axis_vertical_scroll = 0, // vertical axis
            axis_horizontal_scroll = 1, // horizontal axis
        };

        void send_motion(wl_fixed_t x, wl_fixed_t y);
        void send_motion(struct ::wl_resource *resource, wl_fixed_t x, wl_fixed_t y);
        void send_button(wl_fixed_t x, wl_fixed_t y, uint32_t button, uint32_t state);
        void send_button(struct ::wl_resource *resource, wl_fixed_t x, wl_fixed_t y, uint32_t button, uint32_t state);
        void send_axis(uint32_t time, uint32_t axis, wl_fixed_t value);
        void send_axis(struct ::wl_resource *resource, uint32_t time, uint32_t axis, wl_fixed_t value);

    protected:
        virtual Resource *dde_pointer_allocate();

        virtual void dde_pointer_destroy_global();

        virtual void dde_pointer_bind_resource(Resource *resource);
        virtual void dde_pointer_destroy_resource(Resource *resource);

        virtual void dde_pointer_get_motion(Resource *resource);

    private:
        static void bind_func(struct ::wl_client *client, void *data, uint32_t version, uint32_t id);
        static void destroy_func(struct ::wl_resource *client_resource);
        static void display_destroy_func(struct ::wl_listener *listener, void *data);
        static int deferred_destroy_global_func(void *data);

        Resource *bind(struct ::wl_client *client, uint32_t id, int version);
        Resource *bind(struct ::wl_resource *handle);

        static const struct ::dde_pointer_interface m_dde_pointer_interface;

        static void handle_get_motion(
            ::wl_client *client,
            struct wl_resource *resource);

        QMultiMap<struct ::wl_client*, Resource*> m_resource_map;
        Resource *m_resource;
        struct ::wl_global *m_global;
        struct ::wl_display *m_display;
        struct wl_event_source *m_globalRemovedEvent;
        struct DisplayDestroyedListener : ::wl_listener {
            dde_pointer *parent;
        };
        DisplayDestroyedListener m_displayDestroyedListener;
    };

    class  dde_keyboard
    {
    public:
        dde_keyboard(struct ::wl_client *client, int id, int version);
        dde_keyboard(struct ::wl_display *display, int version);
        dde_keyboard(struct ::wl_resource *resource);
        dde_keyboard();

        virtual ~dde_keyboard();

        class Resource
        {
        public:
            Resource() : dde_keyboard_object(nullptr), handle(nullptr) {}
            virtual ~Resource() {}

            dde_keyboard *dde_keyboard_object;
            dde_keyboard *object() { return dde_keyboard_object; } 
            struct ::wl_resource *handle;

            struct ::wl_client *client() const { return wl_resource_get_client(handle); }
            int version() const { return wl_resource_get_version(handle); }

            static Resource *fromResource(struct ::wl_resource *resource);
        };

        void init(struct ::wl_client *client, int id, int version);
        void init(struct ::wl_display *display, int version);
        void init(struct ::wl_resource *resource);

        Resource *add(struct ::wl_client *client, int version);
        Resource *add(struct ::wl_client *client, int id, int version);
        Resource *add(struct wl_list *resource_list, struct ::wl_client *client, int id, int version);

        Resource *resource() { return m_resource; }
        const Resource *resource() const { return m_resource; }

        QMultiMap<struct ::wl_client*, Resource*> resourceMap() { return m_resource_map; }
        const QMultiMap<struct ::wl_client*, Resource*> resourceMap() const { return m_resource_map; }

        bool isGlobalRemoved() const { return m_globalRemovedEvent; }
        void globalRemove();

        bool isGlobal() const { return m_global != nullptr; }
        bool isResource() const { return m_resource != nullptr; }

        static const struct ::wl_interface *interface();
        static QByteArray interfaceName() { return interface()->name; }
        static int interfaceVersion() { return interface()->version; }


        enum keymap_format {
            keymap_format_no_keymap = 0, // no keymap; client must understand how to interpret the raw keycode
            keymap_format_xkb_v1 = 1, // libxkbcommon compatible; to determine the xkb keycode, clients must add 8 to the key event keycode
        };

        enum key_state {
            key_state_released = 0, // key is not pressed
            key_state_pressed = 1, // key is pressed
        };

        void send_keymap(uint32_t format, int32_t fd, uint32_t size);
        void send_keymap(struct ::wl_resource *resource, uint32_t format, int32_t fd, uint32_t size);
        void send_enter(uint32_t serial, struct ::wl_resource *surface, const QByteArray &keys);
        void send_enter(struct ::wl_resource *resource, uint32_t serial, struct ::wl_resource *surface, const QByteArray &keys);
        void send_leave(uint32_t serial, struct ::wl_resource *surface);
        void send_leave(struct ::wl_resource *resource, uint32_t serial, struct ::wl_resource *surface);
        void send_key(uint32_t serial, uint32_t time, uint32_t key, uint32_t state);
        void send_key(struct ::wl_resource *resource, uint32_t serial, uint32_t time, uint32_t key, uint32_t state);
        void send_modifiers(uint32_t serial, uint32_t mods_depressed, uint32_t mods_latched, uint32_t mods_locked, uint32_t group);
        void send_modifiers(struct ::wl_resource *resource, uint32_t serial, uint32_t mods_depressed, uint32_t mods_latched, uint32_t mods_locked, uint32_t group);
        void send_repeat_info(int32_t rate, int32_t delay);
        void send_repeat_info(struct ::wl_resource *resource, int32_t rate, int32_t delay);

    protected:
        virtual Resource *dde_keyboard_allocate();

        virtual void dde_keyboard_destroy_global();

        virtual void dde_keyboard_bind_resource(Resource *resource);
        virtual void dde_keyboard_destroy_resource(Resource *resource);

        virtual void dde_keyboard_release(Resource *resource);

    private:
        static void bind_func(struct ::wl_client *client, void *data, uint32_t version, uint32_t id);
        static void destroy_func(struct ::wl_resource *client_resource);
        static void display_destroy_func(struct ::wl_listener *listener, void *data);
        static int deferred_destroy_global_func(void *data);

        Resource *bind(struct ::wl_client *client, uint32_t id, int version);
        Resource *bind(struct ::wl_resource *handle);

        static const struct ::dde_keyboard_interface m_dde_keyboard_interface;

        static void handle_release(
            ::wl_client *client,
            struct wl_resource *resource);

        QMultiMap<struct ::wl_client*, Resource*> m_resource_map;
        Resource *m_resource;
        struct ::wl_global *m_global;
        struct ::wl_display *m_display;
        struct wl_event_source *m_globalRemovedEvent;
        struct DisplayDestroyedListener : ::wl_listener {
            dde_keyboard *parent;
        };
        DisplayDestroyedListener m_displayDestroyedListener;
    };

    class  dde_touch
    {
    public:
        dde_touch(struct ::wl_client *client, int id, int version);
        dde_touch(struct ::wl_display *display, int version);
        dde_touch(struct ::wl_resource *resource);
        dde_touch();

        virtual ~dde_touch();

        class Resource
        {
        public:
            Resource() : dde_touch_object(nullptr), handle(nullptr) {}
            virtual ~Resource() {}

            dde_touch *dde_touch_object;
            dde_touch *object() { return dde_touch_object; } 
            struct ::wl_resource *handle;

            struct ::wl_client *client() const { return wl_resource_get_client(handle); }
            int version() const { return wl_resource_get_version(handle); }

            static Resource *fromResource(struct ::wl_resource *resource);
        };

        void init(struct ::wl_client *client, int id, int version);
        void init(struct ::wl_display *display, int version);
        void init(struct ::wl_resource *resource);

        Resource *add(struct ::wl_client *client, int version);
        Resource *add(struct ::wl_client *client, int id, int version);
        Resource *add(struct wl_list *resource_list, struct ::wl_client *client, int id, int version);

        Resource *resource() { return m_resource; }
        const Resource *resource() const { return m_resource; }

        QMultiMap<struct ::wl_client*, Resource*> resourceMap() { return m_resource_map; }
        const QMultiMap<struct ::wl_client*, Resource*> resourceMap() const { return m_resource_map; }

        bool isGlobalRemoved() const { return m_globalRemovedEvent; }
        void globalRemove();

        bool isGlobal() const { return m_global != nullptr; }
        bool isResource() const { return m_resource != nullptr; }

        static const struct ::wl_interface *interface();
        static QByteArray interfaceName() { return interface()->name; }
        static int interfaceVersion() { return interface()->version; }


        void send_down(int32_t id, uint32_t time, wl_fixed_t x, wl_fixed_t y);
        void send_down(struct ::wl_resource *resource, int32_t id, uint32_t time, wl_fixed_t x, wl_fixed_t y);
        void send_up(int32_t id, uint32_t time);
        void send_up(struct ::wl_resource *resource, int32_t id, uint32_t time);
        void send_motion(int32_t id, uint32_t time, wl_fixed_t x, wl_fixed_t y);
        void send_motion(struct ::wl_resource *resource, int32_t id, uint32_t time, wl_fixed_t x, wl_fixed_t y);

    protected:
        virtual Resource *dde_touch_allocate();

        virtual void dde_touch_destroy_global();

        virtual void dde_touch_bind_resource(Resource *resource);
        virtual void dde_touch_destroy_resource(Resource *resource);

        virtual void dde_touch_release(Resource *resource);

    private:
        static void bind_func(struct ::wl_client *client, void *data, uint32_t version, uint32_t id);
        static void destroy_func(struct ::wl_resource *client_resource);
        static void display_destroy_func(struct ::wl_listener *listener, void *data);
        static int deferred_destroy_global_func(void *data);

        Resource *bind(struct ::wl_client *client, uint32_t id, int version);
        Resource *bind(struct ::wl_resource *handle);

        static const struct ::dde_touch_interface m_dde_touch_interface;

        static void handle_release(
            ::wl_client *client,
            struct wl_resource *resource);

        QMultiMap<struct ::wl_client*, Resource*> m_resource_map;
        Resource *m_resource;
        struct ::wl_global *m_global;
        struct ::wl_display *m_display;
        struct wl_event_source *m_globalRemovedEvent;
        struct DisplayDestroyedListener : ::wl_listener {
            dde_touch *parent;
        };
        DisplayDestroyedListener m_displayDestroyedListener;
    };
}

QT_WARNING_POP
QT_END_NAMESPACE

#endif
