.\" Copyright (c) 1991, 1992 Free Software Foundation
.\" See section COPYING for conditions for redistribution
.\" $Id: info.man,v 1.1 1993/02/26 02:00:08 zoo Exp $
.TH info 1 "3mar1992" "GNU Tools" "GNU Tools"
.de BP
.sp
.ti \-.2i
\(**
..

.SH NAME
info \- the GNU information browser

.SH SYNOPSIS
.hy 0
.na
.TP
.B info
.RB "[\|" "\-d "\c
.I path\c
.RB " | " "+directory "\c
.I path\c
\&\|]
.br
.RB "[\|" "\-n "\c
.I nodename\c
.RB ".\|.\|. | " "+node "\c
.I nodename\c
\&.\|.\|.\|]
.br
.RB "[\|" "\-f "\c
.I name\c
.RB " | " "+file "\c
.I name\c
\&\|]
.br
.RB "[\|" "\-o "\c
.I outfile\c
.RB " | " "+output "\c
.I outfile\c
\&\|]
.br
.RB "[\|" \c
.I topic\c
\&\|]

.ad b
.hy 1
.SH DESCRIPTION
A program to browse through GNU manuals online.  Its first display is a directory showing all the manuals available.  If
you already know which of those manuals you want, you can give the
corresponding menu entry as an argument to \c
.B info\c
\&; for example,
`\|\c
.B info info\c
\&\|' requests the online manual for \c
.B info\c
\& itself.

The manuals are organized into \c
.I nodes\c
\&, which correspond to the
chapters and sections of a printed book.  You can follow them in
sequence, just like in the printed book; but there are
also menus, ``hot'' references, and search facilities.

The best way to get started with \c
.B info
is to run it with no arguments.  The first screen displayed is
a menu of the documentation available.  Typing the single letter \c
.B h\c
\& requests a
tutorial.

GNU Emacs has a built-in facility equivalent to \c
.B info\c
\&.  If you
already use Emacs, you may want to get into the documentation browsing
mode, instead, by typing \c
.B C-h i\c
\& inside Emacs.

You can get out of \c
.B info\c
\& at any time by typing the single letter
\c
.B q\c
\&.  

Here is a summary of all the \c
.B info\c
\& commands; \c
.B info\c
\& itself
can display a summary like this at any time, when you type the single
character \c
.B ?\c
\&.

.ta \w'SpaceMMM'u
.B h\c
\&	Invoke the Info tutorial.
.br
.B q\c
\&	Quit Info

.I Selecting other nodes:
.br
.B n\c
\&	Move to the ``next'' node of this node.
.br
.B p\c
\&	Move to the ``previous'' node of this node.
.br
.B u\c
\&	Move ``up'' from this node.
.br
.B m\c
\&	Pick menu item specified by name (or abbreviation).
.br
.B f\c
\&	Follow a cross reference.  Reads name of reference.
.br
.B l\c
\&	Move to the last node you were looking at.
.br
.B d\c
\&	Display directory node.

.I Moving within a node:
.br
Space\c
\&	scroll forward a page.\c
.br
DEL\c
\&	scroll backward a page.\c
.br
.B b\c
\&	Go to beginning of this node.\c

.I Advanced commands:
.br
.B 1\c
\&	Pick first item in node's menu.\c
.br
.B 2 \- 5\c
\&	Pick second ... fifth item in node's menu.\c
.br
.B g\c
\&	Move to \c
.I nodename\c
\& or \c
.B (\c
.I filename\c
.B \&)\c
.I nodename\c
\&.
.br
.B s\c
\&	Search for specified string.
.br
Ctl-p\c
\&	Print the contents of this node.

.SH OPTIONS

.BI "-d " "path"
.TP
.BI "+directory " "path"\c
\&
A colon-separated list of directories; where to look for info files
and their directory.  The first of these directories containing a file
`\|\c
.B dir\c
\&\|' governs the top-level directory displayed; but you can
explicitly visit info files by name, whether or not they're in that
directory, from any directory in \c
.I path\c
\&.
.PP        
.BI "-n " "nodename"\c
.TP
.BI "+node " "nodename"\c
Go directly to node \c
.I nodename\c
\& of the current file.  Since
directories don't have nodes, this option is most useful if you also
specify a particular \c
.I topic\c
\& or use the `\|\c
.B +file\c
\&\|' option.  You
may specify more than one `\|\c
.B +node \c
.I nodename\c
\&\c
\&\|'; the rightmost
will be displayed, but you can visit the others in reverse sequence
using the command \c
.B l\c
\&.
.PP        
.BI "-f " "name"\c
.TP
.BI "+file " "name"\c
\&
Go directly to info file \c
.I name\c
\&, bypassing the main directory
display.  \c
.I name\c
\& may be a fully specified path; if not, it will be
sought through the info path directories.
.PP        
.BI "-o " "outfile"\c
.TP
.BI "+output " "outfile"\c
\&
Copy a node to file \c
.I outfile\c
\& instead of running interactively.
        
.TP
.I "topic"\c
\&
Go directly to topic \c
.I topic\c
\& from the main info directory.
.PP

.SH ENVIRONMENT

.TP
.B INFOPATH
Overrides the default paths compiled into `\|\c
.B info\c
\&\|' to specify where
to look for info files.  The `\|\c
.B +directory\c
\&\|' option in turn
overrides this environment variable.

.TP
.B INFO_PRINT_COMMAND
Overrides the compiled-in default printing command (normally
`\|\c
.B lpr\c
\&\|') used to print nodes on request.
.PP

.SH FILES
.ta \w'\fIINFODIR\fR\fB/dir  'u
\fIINFODIR\fR\fB/dir	Top-level directory menu
.br
\fIname\fR
.br
\fIname\fR\fB-info
.br
\fIname\fR\fB.info	tried (in sequence) when file \fIname\fR 
requested. 

.SH "SEE ALSO"
`\|\c
.B Info\c
\&\|', `\|\c
.B Emacs\c
\&\|', and `\|\c
.B Texinfo\c
\&\|' entries in \c
.B info\c
\&.
.br
.I GNU Emacs\c
, Richard M. Stallman, February 1988.
.br
.I 
Texinfo: the GNU Documentation Format\c
, Robert J. Chassell and Richard M. Stallman, February 1991.
.br
.BR emacs ( 1 ),
.BR makeinfo ( 1 ).
.SH ACKNOWLEDGEMENT
Richard Stallman invented the Info concept many moons ago, even before
the advent of hypertext.  He also suggested that Brian Fox write this program.
.SH AUTHOR
Brian J. Fox (bfox@ai.mit.edu)
.SH COPYING
Copyright (c) 1991, 1992 Free Software Foundation, Inc.
.PP
Permission is granted to make and distribute verbatim copies of
this manual provided the copyright notice and this permission notice
are preserved on all copies.
.PP
Permission is granted to copy and distribute modified versions of this
manual under the conditions for verbatim copying, provided that the
entire resulting derived work is distributed under the terms of a
permission notice identical to this one.
.PP
Permission is granted to copy and distribute translations of this
manual into another language, under the above conditions for modified
versions, except that this permission notice may be included in
translations approved by the Free Software Foundation instead of in
the original English.
