#ifndef _G_curses_h


#ifdef __curses_h_recursive
#include_next <curses.h>
#else
#define __curses_h_recursive

extern "C" {
#include_next <curses.h>

WINDOW * (newwin)(int lines, int cols, int sy, int sx);
WINDOW * (subwin)(WINDOW *w, int lines, int cols, int sy, int sx);
WINDOW * (initscr)();
int      (box) (WINDOW*, char, char);
int      (delwin)(WINDOW*);
int      (getcurx)(WINDOW*);
int      (getcury)(WINDOW*);
int      (mvcur)(int, int, int, int);
int      (overlay)(WINDOW*, WINDOW*);
int      (overwrite)(WINDOW*, WINDOW*);
int      (scroll)(WINDOW*);
int      (touchwin)(WINDOW*);
int      (waddch)(WINDOW*, char);
int      (waddstr)(WINDOW*, const char*);
int      (wclear)(WINDOW*);
int      (wclrtobot)(WINDOW*);
int      (wclrtoeol)(WINDOW*);
int      (wdelch)(WINDOW*);
int      (wdeleteln)(WINDOW*);
int      (werase)(WINDOW*);
int      (wgetch)(WINDOW*);
int      (wgetstr)(WINDOW*, char*);
int      (winsch)(WINDOW*, char);
int      (winsertln)(WINDOW*);
int      (wmove)(WINDOW*, int, int);
int      (wrefresh)(WINDOW*);
int      (wstandend)(WINDOW*);
int      (wstandout)(WINDOW*);
int      (wprintw)(WINDOW*, const char * fmt, ...);
int      (mvwprintw)(WINDOW*, int y, int x, const char * fmt, ...);
int      (wscanw)(WINDOW*, const char *, ...);
int      (mvwscanw)(int, int, WINDOW*, const char*, ...);
int      (endwin)();

}
#define _G_curses_h
#endif
#endif /* _G_curses_h */
