// This may look like C code, but it is really -*- C++ -*-
/* 
Copyright (C) 1988 Free Software Foundation
    written by Doug Lea (dl@rocky.oswego.edu)

This file is part of GNU CC.

GNU CC is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY.  No author or distributor
accepts responsibility to anyone for the consequences of using it
or for whether it serves any particular purpose or works at all,
unless he says so in writing.  Refer to the GNU CC General Public
License for full details.

Everyone is granted permission to copy, modify and redistribute
GNU CC, but only under the conditions described in the
GNU CC General Public License.   A copy of this license is
supposed to have been given to you along with GNU CC so you
can know your rights and responsibilities.  It should be in a
file named COPYING.  Among other things, the copyright notice
and this notice must be preserved on all copies.  
*/

#include <builtin.h>
#include "<T>.Stack.h"

// error handling

void <T>Stack::error(char* msg)
{
  (*lib_error_handler)("Stack", msg);
}

// non-implemented virtuals
// these are defined to do nonsensical but type-legal things
// They need to be defined in order to fill the vtable

void <T>Stack::push(<T&>) { error("unimplemented"); }
<T> <T>Stack::pop() { error("unimplemented"); return *((<T>*)0); }
<T>& <T>Stack::top() { error("unimplemented"); return *((<T>*)0); }
void <T>Stack::del_top() { error("unimplemented"); }
int <T>Stack::empty() { error("unimplemented"); return 0; }
int <T>Stack::full() { error("unimplemented"); return 0; }
int <T>Stack::length() { error("unimplemented"); return 0; }
void <T>Stack::clear() { error("unimplemented"); }
int <T>Stack::OK() { error("unimplemented"); return 0; }
