/* 
 * predicate.h
 */

#include <stdio.h>

#define SPATIAL_PREDICATE   0
#define TEMPORAL_PREDICATE  1

#define LOWER_BOUND_IS_UNKNOWN  -1

/* a list for a single reference's predicates */

typedef struct predicate_def
{
  int type;
  tree variable;
  rtx arr_ref;
  /* these two fields delimit the insns which correspond to this array ref*/
  int offset;
  float coefficient;
  rtx start_insn;   
  rtx end_insn;
  rtx load_insn;
  int loop_init_value;
  int loop_depth;
  union
    {
      int stride; /* spatial */
      int init;   /* temporal */
    } info;
  struct predicate_def *next;
  /* The index number of the lower bound of the array to which this predicate
     corresponds.  If -1, then it's unknown */
  int lower_bound;
  rtx iterator_rtx;
  int iterator_reg;
} *predicate;

/* a list for a single loop's predicates.  Each element in the list
 corresponds to a different array reference. */

typedef struct loop_predicates_def
{
  predicate pred;
  struct loop_predicates_def *next_arr_ref;
} *loop_predicates;

/* List of all loop predicates in the function */

typedef struct pred_list_def
{
  loop_predicates loop_pred;
  rtx loop_end_note;
  struct pred_list_def *next_loop;
} *pred_list;

extern pred_list all_loop_predicates;
extern predicate curr_temporal_pred;
extern predicate curr_spatial_pred;

#ifdef USE_PROTOS
predicate predicate_create (int type, tree variable, tree arr_ref, int data, 
			    predicate old_pred, rtx start_insn,
			    rtx end_insn, rtx load_insn, 
			    tree loop_init_value, int loop_depth,
			    int lower_bound, float coefficient,
			    rtx iterator_rtx);
void predicate_delete (predicate p);
void predicate_set_end_insn (predicate curr_temporal_pred,
			     predicate curr_spatial_pred,
			     rtx end_insn);
predicate predicate_copy (predicate p, predicate new_next);

pred_list pred_list_create (loop_predicates p, rtx note, pred_list next);

loop_predicates get_loop_pred (pred_list pl, rtx loop_end_note);
void predicate_print (FILE *f, predicate p);
void pred_list_print (FILE *f, pred_list pl);
void debug_predicate (predicate p);
void debug_pred_list (pred_list pl);
void pred_list_delete (pred_list pl);

loop_predicates loop_predicates_create (predicate p, loop_predicates next);
void loop_predicates_print (FILE *f, loop_predicates pl);
void debug_loop_predicates (loop_predicates pl);
void loop_predicates_delete (loop_predicates pl);

void update_predicate_load_insns (pred_list pl);
#else
predicate predicate_create ();
void predicate_delete ();
void predicate_set_end_insn ();
predicate predicate_copy ();

pred_list pred_list_create ();

loop_predicates get_loop_pred ();
void predicate_print ();
void pred_list_print ();
void debug_predicate ();
void debug_pred_list ();
void pred_list_delete ();

loop_predicates loop_predicates_create ();
void loop_predicates_print ();
void debug_loop_predicates ();
void loop_predicates_delete ();

void update_predicate_load_insns ();
#endif
