/*
 * matrices.h
 */

typedef struct row_def
{
  int num_cols;
  float *elts;
} *row;

typedef struct matrix_def
{
  int num_rows;
  int num_cols;
  row *rows;
} *matrix;

matrix matrix_create ();
void matrix_delete ();
void matrix_print ();
int matrix_set_elt ();
int matrix_get_elt ();
void upper_triangular ();
matrix matrix_solve ();
matrix matrix_transpose ();
void matrix_clear_last_row ();
void matrix_remove_complex_rows ();
matrix matrix_copy ();
row row_create ();
void row_delete ();
int row_equal_zero (); 
int row_ok ();
int all_zeroes_below ();
float lcm ();
int row_copy ();
int row_scalar_mult ();
int row_scalar_div ();
int row_add ();
void row_print ();
void row_eliminate ();
int row_first_nonzero ();
matrix span_compress ();
matrix find_span ();
int matrix_is_zero ();
