//  This file is part of GNU c++-suite.
//  
//  GNU c++-suite is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 1, or (at your option)
//  any later version.
//  
//  GNU c++-suite is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//  
//  You should have received a copy of the GNU General Public License
//  along with GNU c++-suite; see the file COPYING.  If not, write to
//  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

// Check that incomplete types may not be used to declare
// objects.
//
// Cases:
//	formal parameter objects
//	global objects
//	local objects

enum E;
struct S;
union U;
class C;

void function_1 (enum E p) {		// ERROR
	p = p;
}

void function_2 (struct S p) {		// ERROR
	p = p;
}

void function_3 (union U p) {		// ERROR
	p = p;
}
}

void function_4 (class C p) {		// ERROR
	p = p;
}

enum E e;				// ERROR
struct S s;				// ERROR
union U u;				// ERROR
class C c;				// ERROR

int main ()
{
	enum E e;			// ERROR
	struct S s;			// ERROR
	union U u;			// ERROR
	class C c;			// ERROR

	function_1 (e);
	function_2 (s);
	function_3 (u);
	function_4 (c);
}

enum E { Evalue };
struct S { int Sfield; };
union U { int Ufield; };
class C { public: C() {} };
