//  This file is part of GNU c++-suite.
//  
//  GNU c++-suite is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 1, or (at your option)
//  any later version.
//  
//  GNU c++-suite is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//  
//  You should have received a copy of the GNU General Public License
//  along with GNU c++-suite; see the file COPYING.  If not, write to
//  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

// Check that if two overloaded functions are declared within
// the same scope, and if these two functions are essentially
// identical in their names and in their number, order, and
// type of parameters except that one of the two has more
// parameters than the other, but these additional parameters
// all have defaults, an error is issued for the (ambiguous)
// (re-)declaration.

overload function1;

void function1 (int arg1, int arg2);
void function1 (int arg1, int arg2, int arg3 = 88);	// ERROR

int test ()
{
	function1 (77, 88);			// possible error
	function1 (77, 88, 99);			// possible error
}
