//  This file is part of GNU c++-suite.
//  
//  GNU c++-suite is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 1, or (at your option)
//  any later version.
//  
//  GNU c++-suite is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//  
//  You should have received a copy of the GNU General Public License
//  along with GNU c++-suite; see the file COPYING.  If not, write to
//  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

// Options: -fall-virtual
//
// Check that the method call operator is *not* invoked when
// a caller is a member function and when the called function
// is also a member of the same class.

int errors = 0;
int event_counter = 0;

typedef int MP;

class base;

typedef void (base::*base_method_ptr) ();

class base {
	int member;
public:
	base () {}
	base operator ->() (MP method_id, int arg_bytes, ...)
	{
		base_method_ptr bmp = (base_method_ptr) method_id;

		//printf ("operator->()() called\n");
		if (event_counter != 0)
			errors++;
		event_counter++;
		(this->*(bmp)) ();
		return *this;
	}
};

class derived : public base {
	int member;
public:
	derived () {}
	void method_1 ()
	{
		//printf ("method_1() called\n");
		if (event_counter != 2)
			errors++;
		event_counter++;
	}
	void method_2 ()
	{
		//printf ("method_2() called\n");
		if (event_counter != 1)
			errors++;
		event_counter++;
		method_1 ();
	}
};

int main ()
{
	derived derived_object;

	derived_object.method_2 ();
	return errors;
}
