/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSCSSPrimitiveValue.h"

#include "CSSPrimitiveValue.h"
#include "Counter.h"
#include "ExceptionCode.h"
#include "JSCounter.h"
#include "JSDOMBinding.h"
#include "JSRGBColor.h"
#include "JSRect.h"
#include "KURL.h"
#include "RGBColor.h"
#include "Rect.h"
#include <runtime/Error.h>
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSCSSPrimitiveValueTableValues[] =
{
    { "primitiveType", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCSSPrimitiveValuePrimitiveType), (intptr_t)0, NoIntrinsic },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCSSPrimitiveValueConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSCSSPrimitiveValueTable = { 4, 3, JSCSSPrimitiveValueTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSCSSPrimitiveValueConstructorTableValues[] =
{
    { "CSS_UNKNOWN", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCSSPrimitiveValueCSS_UNKNOWN), (intptr_t)0, NoIntrinsic },
    { "CSS_NUMBER", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCSSPrimitiveValueCSS_NUMBER), (intptr_t)0, NoIntrinsic },
    { "CSS_PERCENTAGE", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCSSPrimitiveValueCSS_PERCENTAGE), (intptr_t)0, NoIntrinsic },
    { "CSS_EMS", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCSSPrimitiveValueCSS_EMS), (intptr_t)0, NoIntrinsic },
    { "CSS_EXS", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCSSPrimitiveValueCSS_EXS), (intptr_t)0, NoIntrinsic },
    { "CSS_PX", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCSSPrimitiveValueCSS_PX), (intptr_t)0, NoIntrinsic },
    { "CSS_CM", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCSSPrimitiveValueCSS_CM), (intptr_t)0, NoIntrinsic },
    { "CSS_MM", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCSSPrimitiveValueCSS_MM), (intptr_t)0, NoIntrinsic },
    { "CSS_IN", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCSSPrimitiveValueCSS_IN), (intptr_t)0, NoIntrinsic },
    { "CSS_PT", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCSSPrimitiveValueCSS_PT), (intptr_t)0, NoIntrinsic },
    { "CSS_PC", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCSSPrimitiveValueCSS_PC), (intptr_t)0, NoIntrinsic },
    { "CSS_DEG", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCSSPrimitiveValueCSS_DEG), (intptr_t)0, NoIntrinsic },
    { "CSS_RAD", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCSSPrimitiveValueCSS_RAD), (intptr_t)0, NoIntrinsic },
    { "CSS_GRAD", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCSSPrimitiveValueCSS_GRAD), (intptr_t)0, NoIntrinsic },
    { "CSS_MS", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCSSPrimitiveValueCSS_MS), (intptr_t)0, NoIntrinsic },
    { "CSS_S", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCSSPrimitiveValueCSS_S), (intptr_t)0, NoIntrinsic },
    { "CSS_HZ", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCSSPrimitiveValueCSS_HZ), (intptr_t)0, NoIntrinsic },
    { "CSS_KHZ", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCSSPrimitiveValueCSS_KHZ), (intptr_t)0, NoIntrinsic },
    { "CSS_DIMENSION", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCSSPrimitiveValueCSS_DIMENSION), (intptr_t)0, NoIntrinsic },
    { "CSS_STRING", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCSSPrimitiveValueCSS_STRING), (intptr_t)0, NoIntrinsic },
    { "CSS_URI", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCSSPrimitiveValueCSS_URI), (intptr_t)0, NoIntrinsic },
    { "CSS_IDENT", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCSSPrimitiveValueCSS_IDENT), (intptr_t)0, NoIntrinsic },
    { "CSS_ATTR", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCSSPrimitiveValueCSS_ATTR), (intptr_t)0, NoIntrinsic },
    { "CSS_COUNTER", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCSSPrimitiveValueCSS_COUNTER), (intptr_t)0, NoIntrinsic },
    { "CSS_RECT", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCSSPrimitiveValueCSS_RECT), (intptr_t)0, NoIntrinsic },
    { "CSS_RGBCOLOR", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCSSPrimitiveValueCSS_RGBCOLOR), (intptr_t)0, NoIntrinsic },
    { "CSS_VW", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCSSPrimitiveValueCSS_VW), (intptr_t)0, NoIntrinsic },
    { "CSS_VH", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCSSPrimitiveValueCSS_VH), (intptr_t)0, NoIntrinsic },
    { "CSS_VMIN", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCSSPrimitiveValueCSS_VMIN), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSCSSPrimitiveValueConstructorTable = { 71, 63, JSCSSPrimitiveValueConstructorTableValues, 0 };

COMPILE_ASSERT(0 == CSSPrimitiveValue::CSS_UNKNOWN, CSSPrimitiveValueEnumCSS_UNKNOWNIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(1 == CSSPrimitiveValue::CSS_NUMBER, CSSPrimitiveValueEnumCSS_NUMBERIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(2 == CSSPrimitiveValue::CSS_PERCENTAGE, CSSPrimitiveValueEnumCSS_PERCENTAGEIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(3 == CSSPrimitiveValue::CSS_EMS, CSSPrimitiveValueEnumCSS_EMSIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(4 == CSSPrimitiveValue::CSS_EXS, CSSPrimitiveValueEnumCSS_EXSIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(5 == CSSPrimitiveValue::CSS_PX, CSSPrimitiveValueEnumCSS_PXIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(6 == CSSPrimitiveValue::CSS_CM, CSSPrimitiveValueEnumCSS_CMIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(7 == CSSPrimitiveValue::CSS_MM, CSSPrimitiveValueEnumCSS_MMIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(8 == CSSPrimitiveValue::CSS_IN, CSSPrimitiveValueEnumCSS_INIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(9 == CSSPrimitiveValue::CSS_PT, CSSPrimitiveValueEnumCSS_PTIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(10 == CSSPrimitiveValue::CSS_PC, CSSPrimitiveValueEnumCSS_PCIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(11 == CSSPrimitiveValue::CSS_DEG, CSSPrimitiveValueEnumCSS_DEGIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(12 == CSSPrimitiveValue::CSS_RAD, CSSPrimitiveValueEnumCSS_RADIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(13 == CSSPrimitiveValue::CSS_GRAD, CSSPrimitiveValueEnumCSS_GRADIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(14 == CSSPrimitiveValue::CSS_MS, CSSPrimitiveValueEnumCSS_MSIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(15 == CSSPrimitiveValue::CSS_S, CSSPrimitiveValueEnumCSS_SIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(16 == CSSPrimitiveValue::CSS_HZ, CSSPrimitiveValueEnumCSS_HZIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(17 == CSSPrimitiveValue::CSS_KHZ, CSSPrimitiveValueEnumCSS_KHZIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(18 == CSSPrimitiveValue::CSS_DIMENSION, CSSPrimitiveValueEnumCSS_DIMENSIONIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(19 == CSSPrimitiveValue::CSS_STRING, CSSPrimitiveValueEnumCSS_STRINGIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(20 == CSSPrimitiveValue::CSS_URI, CSSPrimitiveValueEnumCSS_URIIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(21 == CSSPrimitiveValue::CSS_IDENT, CSSPrimitiveValueEnumCSS_IDENTIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(22 == CSSPrimitiveValue::CSS_ATTR, CSSPrimitiveValueEnumCSS_ATTRIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(23 == CSSPrimitiveValue::CSS_COUNTER, CSSPrimitiveValueEnumCSS_COUNTERIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(24 == CSSPrimitiveValue::CSS_RECT, CSSPrimitiveValueEnumCSS_RECTIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(25 == CSSPrimitiveValue::CSS_RGBCOLOR, CSSPrimitiveValueEnumCSS_RGBCOLORIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(26 == CSSPrimitiveValue::CSS_VW, CSSPrimitiveValueEnumCSS_VWIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(27 == CSSPrimitiveValue::CSS_VH, CSSPrimitiveValueEnumCSS_VHIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(28 == CSSPrimitiveValue::CSS_VMIN, CSSPrimitiveValueEnumCSS_VMINIsWrongUseDoNotCheckConstants);

const ClassInfo JSCSSPrimitiveValueConstructor::s_info = { "CSSPrimitiveValueConstructor", &Base::s_info, &JSCSSPrimitiveValueConstructorTable, 0, CREATE_METHOD_TABLE(JSCSSPrimitiveValueConstructor) };

JSCSSPrimitiveValueConstructor::JSCSSPrimitiveValueConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSCSSPrimitiveValueConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->globalData());
    ASSERT(inherits(&s_info));
    putDirect(exec->globalData(), exec->propertyNames().prototype, JSCSSPrimitiveValuePrototype::self(exec, globalObject), DontDelete | ReadOnly);
}

bool JSCSSPrimitiveValueConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSCSSPrimitiveValueConstructor, JSDOMWrapper>(exec, &JSCSSPrimitiveValueConstructorTable, jsCast<JSCSSPrimitiveValueConstructor*>(cell), propertyName, slot);
}

bool JSCSSPrimitiveValueConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSCSSPrimitiveValueConstructor, JSDOMWrapper>(exec, &JSCSSPrimitiveValueConstructorTable, jsCast<JSCSSPrimitiveValueConstructor*>(object), propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSCSSPrimitiveValuePrototypeTableValues[] =
{
    { "CSS_UNKNOWN", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCSSPrimitiveValueCSS_UNKNOWN), (intptr_t)0, NoIntrinsic },
    { "CSS_NUMBER", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCSSPrimitiveValueCSS_NUMBER), (intptr_t)0, NoIntrinsic },
    { "CSS_PERCENTAGE", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCSSPrimitiveValueCSS_PERCENTAGE), (intptr_t)0, NoIntrinsic },
    { "CSS_EMS", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCSSPrimitiveValueCSS_EMS), (intptr_t)0, NoIntrinsic },
    { "CSS_EXS", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCSSPrimitiveValueCSS_EXS), (intptr_t)0, NoIntrinsic },
    { "CSS_PX", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCSSPrimitiveValueCSS_PX), (intptr_t)0, NoIntrinsic },
    { "CSS_CM", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCSSPrimitiveValueCSS_CM), (intptr_t)0, NoIntrinsic },
    { "CSS_MM", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCSSPrimitiveValueCSS_MM), (intptr_t)0, NoIntrinsic },
    { "CSS_IN", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCSSPrimitiveValueCSS_IN), (intptr_t)0, NoIntrinsic },
    { "CSS_PT", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCSSPrimitiveValueCSS_PT), (intptr_t)0, NoIntrinsic },
    { "CSS_PC", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCSSPrimitiveValueCSS_PC), (intptr_t)0, NoIntrinsic },
    { "CSS_DEG", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCSSPrimitiveValueCSS_DEG), (intptr_t)0, NoIntrinsic },
    { "CSS_RAD", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCSSPrimitiveValueCSS_RAD), (intptr_t)0, NoIntrinsic },
    { "CSS_GRAD", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCSSPrimitiveValueCSS_GRAD), (intptr_t)0, NoIntrinsic },
    { "CSS_MS", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCSSPrimitiveValueCSS_MS), (intptr_t)0, NoIntrinsic },
    { "CSS_S", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCSSPrimitiveValueCSS_S), (intptr_t)0, NoIntrinsic },
    { "CSS_HZ", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCSSPrimitiveValueCSS_HZ), (intptr_t)0, NoIntrinsic },
    { "CSS_KHZ", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCSSPrimitiveValueCSS_KHZ), (intptr_t)0, NoIntrinsic },
    { "CSS_DIMENSION", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCSSPrimitiveValueCSS_DIMENSION), (intptr_t)0, NoIntrinsic },
    { "CSS_STRING", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCSSPrimitiveValueCSS_STRING), (intptr_t)0, NoIntrinsic },
    { "CSS_URI", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCSSPrimitiveValueCSS_URI), (intptr_t)0, NoIntrinsic },
    { "CSS_IDENT", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCSSPrimitiveValueCSS_IDENT), (intptr_t)0, NoIntrinsic },
    { "CSS_ATTR", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCSSPrimitiveValueCSS_ATTR), (intptr_t)0, NoIntrinsic },
    { "CSS_COUNTER", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCSSPrimitiveValueCSS_COUNTER), (intptr_t)0, NoIntrinsic },
    { "CSS_RECT", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCSSPrimitiveValueCSS_RECT), (intptr_t)0, NoIntrinsic },
    { "CSS_RGBCOLOR", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCSSPrimitiveValueCSS_RGBCOLOR), (intptr_t)0, NoIntrinsic },
    { "CSS_VW", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCSSPrimitiveValueCSS_VW), (intptr_t)0, NoIntrinsic },
    { "CSS_VH", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCSSPrimitiveValueCSS_VH), (intptr_t)0, NoIntrinsic },
    { "CSS_VMIN", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCSSPrimitiveValueCSS_VMIN), (intptr_t)0, NoIntrinsic },
    { "setFloatValue", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsCSSPrimitiveValuePrototypeFunctionSetFloatValue), (intptr_t)2, NoIntrinsic },
    { "getFloatValue", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsCSSPrimitiveValuePrototypeFunctionGetFloatValue), (intptr_t)1, NoIntrinsic },
    { "setStringValue", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsCSSPrimitiveValuePrototypeFunctionSetStringValue), (intptr_t)2, NoIntrinsic },
    { "getStringValue", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsCSSPrimitiveValuePrototypeFunctionGetStringValue), (intptr_t)0, NoIntrinsic },
    { "getCounterValue", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsCSSPrimitiveValuePrototypeFunctionGetCounterValue), (intptr_t)0, NoIntrinsic },
    { "getRectValue", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsCSSPrimitiveValuePrototypeFunctionGetRectValue), (intptr_t)0, NoIntrinsic },
    { "getRGBColorValue", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsCSSPrimitiveValuePrototypeFunctionGetRGBColorValue), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSCSSPrimitiveValuePrototypeTable = { 132, 127, JSCSSPrimitiveValuePrototypeTableValues, 0 };
const ClassInfo JSCSSPrimitiveValuePrototype::s_info = { "CSSPrimitiveValuePrototype", &Base::s_info, &JSCSSPrimitiveValuePrototypeTable, 0, CREATE_METHOD_TABLE(JSCSSPrimitiveValuePrototype) };

JSObject* JSCSSPrimitiveValuePrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSCSSPrimitiveValue>(exec, globalObject);
}

bool JSCSSPrimitiveValuePrototype::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSCSSPrimitiveValuePrototype* thisObject = jsCast<JSCSSPrimitiveValuePrototype*>(cell);
    return getStaticPropertySlot<JSCSSPrimitiveValuePrototype, JSObject>(exec, &JSCSSPrimitiveValuePrototypeTable, thisObject, propertyName, slot);
}

bool JSCSSPrimitiveValuePrototype::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSCSSPrimitiveValuePrototype* thisObject = jsCast<JSCSSPrimitiveValuePrototype*>(object);
    return getStaticPropertyDescriptor<JSCSSPrimitiveValuePrototype, JSObject>(exec, &JSCSSPrimitiveValuePrototypeTable, thisObject, propertyName, descriptor);
}

const ClassInfo JSCSSPrimitiveValue::s_info = { "CSSPrimitiveValue", &Base::s_info, &JSCSSPrimitiveValueTable, 0 , CREATE_METHOD_TABLE(JSCSSPrimitiveValue) };

JSCSSPrimitiveValue::JSCSSPrimitiveValue(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<CSSPrimitiveValue> impl)
    : JSCSSValue(structure, globalObject, impl)
{
}

void JSCSSPrimitiveValue::finishCreation(JSGlobalData& globalData)
{
    Base::finishCreation(globalData);
    ASSERT(inherits(&s_info));
}

JSObject* JSCSSPrimitiveValue::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSCSSPrimitiveValuePrototype::create(exec->globalData(), globalObject, JSCSSPrimitiveValuePrototype::createStructure(exec->globalData(), globalObject, JSCSSValuePrototype::self(exec, globalObject)));
}

bool JSCSSPrimitiveValue::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSCSSPrimitiveValue* thisObject = jsCast<JSCSSPrimitiveValue*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSCSSPrimitiveValue, Base>(exec, &JSCSSPrimitiveValueTable, thisObject, propertyName, slot);
}

bool JSCSSPrimitiveValue::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSCSSPrimitiveValue* thisObject = jsCast<JSCSSPrimitiveValue*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSCSSPrimitiveValue, Base>(exec, &JSCSSPrimitiveValueTable, thisObject, propertyName, descriptor);
}

JSValue jsCSSPrimitiveValuePrimitiveType(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSCSSPrimitiveValue* castedThis = jsCast<JSCSSPrimitiveValue*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    CSSPrimitiveValue* impl = static_cast<CSSPrimitiveValue*>(castedThis->impl());
    JSValue result = jsNumber(impl->primitiveType());
    return result;
}


JSValue jsCSSPrimitiveValueConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSCSSPrimitiveValue* domObject = jsCast<JSCSSPrimitiveValue*>(asObject(slotBase));
    return JSCSSPrimitiveValue::getConstructor(exec, domObject->globalObject());
}

JSValue JSCSSPrimitiveValue::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSCSSPrimitiveValueConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsCSSPrimitiveValuePrototypeFunctionSetFloatValue(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSCSSPrimitiveValue::s_info))
        return throwVMTypeError(exec);
    JSCSSPrimitiveValue* castedThis = jsCast<JSCSSPrimitiveValue*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSCSSPrimitiveValue::s_info);
    CSSPrimitiveValue* impl = static_cast<CSSPrimitiveValue*>(castedThis->impl());
    ExceptionCode ec = 0;
    unsigned short unitType(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).toUInt32(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float floatValue(MAYBE_MISSING_PARAMETER(exec, 1, DefaultIsUndefined).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setFloatValue(unitType, floatValue, ec);
    setDOMException(exec, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsCSSPrimitiveValuePrototypeFunctionGetFloatValue(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSCSSPrimitiveValue::s_info))
        return throwVMTypeError(exec);
    JSCSSPrimitiveValue* castedThis = jsCast<JSCSSPrimitiveValue*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSCSSPrimitiveValue::s_info);
    CSSPrimitiveValue* impl = static_cast<CSSPrimitiveValue*>(castedThis->impl());
    ExceptionCode ec = 0;
    unsigned short unitType(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).toUInt32(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = jsNumber(impl->getFloatValue(unitType, ec));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsCSSPrimitiveValuePrototypeFunctionSetStringValue(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSCSSPrimitiveValue::s_info))
        return throwVMTypeError(exec);
    JSCSSPrimitiveValue* castedThis = jsCast<JSCSSPrimitiveValue*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSCSSPrimitiveValue::s_info);
    CSSPrimitiveValue* impl = static_cast<CSSPrimitiveValue*>(castedThis->impl());
    ExceptionCode ec = 0;
    unsigned short stringType(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).toUInt32(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    const String& stringValue(MAYBE_MISSING_PARAMETER(exec, 1, DefaultIsUndefined).isEmpty() ? String() : MAYBE_MISSING_PARAMETER(exec, 1, DefaultIsUndefined).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setStringValue(stringType, stringValue, ec);
    setDOMException(exec, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsCSSPrimitiveValuePrototypeFunctionGetStringValue(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSCSSPrimitiveValue::s_info))
        return throwVMTypeError(exec);
    JSCSSPrimitiveValue* castedThis = jsCast<JSCSSPrimitiveValue*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSCSSPrimitiveValue::s_info);
    CSSPrimitiveValue* impl = static_cast<CSSPrimitiveValue*>(castedThis->impl());
    ExceptionCode ec = 0;

    JSC::JSValue result = jsStringWithCache(exec, impl->getStringValue(ec));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsCSSPrimitiveValuePrototypeFunctionGetCounterValue(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSCSSPrimitiveValue::s_info))
        return throwVMTypeError(exec);
    JSCSSPrimitiveValue* castedThis = jsCast<JSCSSPrimitiveValue*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSCSSPrimitiveValue::s_info);
    CSSPrimitiveValue* impl = static_cast<CSSPrimitiveValue*>(castedThis->impl());
    ExceptionCode ec = 0;

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->getCounterValue(ec)));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsCSSPrimitiveValuePrototypeFunctionGetRectValue(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSCSSPrimitiveValue::s_info))
        return throwVMTypeError(exec);
    JSCSSPrimitiveValue* castedThis = jsCast<JSCSSPrimitiveValue*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSCSSPrimitiveValue::s_info);
    CSSPrimitiveValue* impl = static_cast<CSSPrimitiveValue*>(castedThis->impl());
    ExceptionCode ec = 0;

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->getRectValue(ec)));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsCSSPrimitiveValuePrototypeFunctionGetRGBColorValue(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSCSSPrimitiveValue::s_info))
        return throwVMTypeError(exec);
    JSCSSPrimitiveValue* castedThis = jsCast<JSCSSPrimitiveValue*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSCSSPrimitiveValue::s_info);
    CSSPrimitiveValue* impl = static_cast<CSSPrimitiveValue*>(castedThis->impl());
    ExceptionCode ec = 0;

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->getRGBColorValue(ec)));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

// Constant getters

JSValue jsCSSPrimitiveValueCSS_UNKNOWN(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(0));
}

JSValue jsCSSPrimitiveValueCSS_NUMBER(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(1));
}

JSValue jsCSSPrimitiveValueCSS_PERCENTAGE(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(2));
}

JSValue jsCSSPrimitiveValueCSS_EMS(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(3));
}

JSValue jsCSSPrimitiveValueCSS_EXS(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(4));
}

JSValue jsCSSPrimitiveValueCSS_PX(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(5));
}

JSValue jsCSSPrimitiveValueCSS_CM(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(6));
}

JSValue jsCSSPrimitiveValueCSS_MM(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(7));
}

JSValue jsCSSPrimitiveValueCSS_IN(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(8));
}

JSValue jsCSSPrimitiveValueCSS_PT(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(9));
}

JSValue jsCSSPrimitiveValueCSS_PC(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(10));
}

JSValue jsCSSPrimitiveValueCSS_DEG(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(11));
}

JSValue jsCSSPrimitiveValueCSS_RAD(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(12));
}

JSValue jsCSSPrimitiveValueCSS_GRAD(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(13));
}

JSValue jsCSSPrimitiveValueCSS_MS(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(14));
}

JSValue jsCSSPrimitiveValueCSS_S(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(15));
}

JSValue jsCSSPrimitiveValueCSS_HZ(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(16));
}

JSValue jsCSSPrimitiveValueCSS_KHZ(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(17));
}

JSValue jsCSSPrimitiveValueCSS_DIMENSION(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(18));
}

JSValue jsCSSPrimitiveValueCSS_STRING(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(19));
}

JSValue jsCSSPrimitiveValueCSS_URI(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(20));
}

JSValue jsCSSPrimitiveValueCSS_IDENT(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(21));
}

JSValue jsCSSPrimitiveValueCSS_ATTR(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(22));
}

JSValue jsCSSPrimitiveValueCSS_COUNTER(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(23));
}

JSValue jsCSSPrimitiveValueCSS_RECT(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(24));
}

JSValue jsCSSPrimitiveValueCSS_RGBCOLOR(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(25));
}

JSValue jsCSSPrimitiveValueCSS_VW(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(26));
}

JSValue jsCSSPrimitiveValueCSS_VH(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(27));
}

JSValue jsCSSPrimitiveValueCSS_VMIN(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(28));
}


}
