# The PEP 484 type hints stub file for the Qt3DCore module.
#
# Generated by SIP 4.19.3
#
# Copyright (c) 2017 Riverbank Computing Limited <info@riverbankcomputing.com>
# 
# This file is part of PyQt3D.
# 
# This file may be used under the terms of the GNU General Public License
# version 3.0 as published by the Free Software Foundation and appearing in
# the file LICENSE included in the packaging of this file.  Please review the
# following information to ensure the GNU General Public License version 3.0
# requirements will be met: http://www.gnu.org/copyleft/gpl.html.
# 
# If you do not wish to use this file under the terms of the GPL version 3.0
# then you may purchase a commercial license.  For more information contact
# info@riverbankcomputing.com.
# 
# This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
# WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.


import typing
import sip

from PyQt5 import QtGui
from PyQt5 import QtCore

# Support for QDate, QDateTime and QTime.
import datetime

# Convenient type aliases.
PYQT_SIGNAL = typing.Union[QtCore.pyqtSignal, QtCore.pyqtBoundSignal]
PYQT_SLOT = typing.Union[typing.Callable[..., None], QtCore.pyqtBoundSignal]

# Convenient aliases for complicated OpenGL types.
PYQT_OPENGL_ARRAY = typing.Union[typing.Sequence[int], typing.Sequence[float],
        sip.Buffer, None]
PYQT_OPENGL_BOUND_ARRAY = typing.Union[typing.Sequence[int],
        typing.Sequence[float], sip.Buffer, int, None]


class Qt3DCore(sip.simplewrapper):

    class ChangeFlag(int): ...
    NodeCreated = ... # type: 'ChangeFlag'
    NodeDeleted = ... # type: 'ChangeFlag'
    PropertyUpdated = ... # type: 'ChangeFlag'
    PropertyValueAdded = ... # type: 'ChangeFlag'
    PropertyValueRemoved = ... # type: 'ChangeFlag'
    ComponentAdded = ... # type: 'ChangeFlag'
    ComponentRemoved = ... # type: 'ChangeFlag'
    AllChanges = ... # type: 'ChangeFlag'

    class QAbstractAspect(QtCore.QObject):

        def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None: ...

        def unregisterBackendType(self, a0: QtCore.QMetaObject) -> None: ...
        def registerBackendType(self, a0: QtCore.QMetaObject, functor: typing.Any) -> None: ...
        def rootEntityId(self) -> 'QNodeId': ...

    class QAspectEngine(QtCore.QObject):

        def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None: ...

        def executeCommand(self, command: str) -> typing.Any: ...
        def aspects(self) -> typing.Any: ...
        @typing.overload
        def unregisterAspect(self, aspect: 'QAbstractAspect') -> None: ...
        @typing.overload
        def unregisterAspect(self, name: str) -> None: ...
        @typing.overload
        def registerAspect(self, aspect: 'QAbstractAspect') -> None: ...
        @typing.overload
        def registerAspect(self, name: str) -> None: ...
        def rootEntity(self) -> typing.Any: ...
        def setRootEntity(self, root: typing.Any) -> None: ...

    class QBackendNodeMapper(sip.simplewrapper):

        @typing.overload
        def __init__(self) -> None: ...
        @typing.overload
        def __init__(self, a0: 'QBackendNodeMapper') -> None: ...

        def destroy(self, id: 'QNodeId') -> None: ...
        def get(self, id: 'QNodeId') -> 'QBackendNode': ...
        def create(self, change: typing.Any) -> 'QBackendNode': ...

    class QBackendNode(sip.simplewrapper):

        class Mode(int): ...
        ReadOnly = ... # type: 'QBackendNode.Mode'
        ReadWrite = ... # type: 'QBackendNode.Mode'

        def __init__(self, mode: 'QBackendNode.Mode' = ...) -> None: ...

        def sceneChangeEvent(self, e: typing.Any) -> None: ...
        def notifyObservers(self, e: typing.Any) -> None: ...
        def mode(self) -> 'QBackendNode.Mode': ...
        def isEnabled(self) -> bool: ...
        def setEnabled(self, enabled: bool) -> None: ...
        def peerId(self) -> 'QNodeId': ...

    class QNode(QtCore.QObject):

        class PropertyTrackingMode(int): ...
        TrackFinalValues = ... # type: 'QNode.PropertyTrackingMode'
        DontTrackValues = ... # type: 'QNode.PropertyTrackingMode'
        TrackAllValues = ... # type: 'QNode.PropertyTrackingMode'

        def __init__(self, parent: typing.Optional['QNode'] = ...) -> None: ...

        def defaultPropertyTrackingModeChanged(self, mode: 'QNode.PropertyTrackingMode') -> None: ...
        def setDefaultPropertyTrackingMode(self, mode: 'QNode.PropertyTrackingMode') -> None: ...
        def clearPropertyTrackings(self) -> None: ...
        def clearPropertyTracking(self, propertyName: str) -> None: ...
        def propertyTracking(self, propertyName: str) -> 'QNode.PropertyTrackingMode': ...
        def setPropertyTracking(self, propertyName: str, trackMode: 'QNode.PropertyTrackingMode') -> None: ...
        def defaultPropertyTrackingMode(self) -> 'QNode.PropertyTrackingMode': ...
        def sceneChangeEvent(self, change: typing.Any) -> None: ...
        def notifyObservers(self, change: typing.Any) -> None: ...
        def nodeDestroyed(self) -> None: ...
        def enabledChanged(self, enabled: bool) -> None: ...
        def parentChanged(self, parent: QtCore.QObject) -> None: ...
        def setEnabled(self, isEnabled: bool) -> None: ...
        def setParent(self, parent: 'QNode') -> None: ...
        def isEnabled(self) -> bool: ...
        def childNodes(self) -> typing.Any: ...
        def blockNotifications(self, block: bool) -> bool: ...
        def notificationsBlocked(self) -> bool: ...
        def parentNode(self) -> 'QNode': ...
        def id(self) -> 'QNodeId': ...

    class QComponent('QNode'):

        def __init__(self, parent: typing.Optional['QNode'] = ...) -> None: ...

        def removedFromEntity(self, entity: 'QEntity') -> None: ...
        def addedToEntity(self, entity: 'QEntity') -> None: ...
        def shareableChanged(self, isShareable: bool) -> None: ...
        def setShareable(self, isShareable: bool) -> None: ...
        def entities(self) -> typing.Any: ...
        def isShareable(self) -> bool: ...

    class QSceneChange(sip.simplewrapper):

        class DeliveryFlag(int): ...
        BackendNodes = ... # type: 'QSceneChange.DeliveryFlag'
        Nodes = ... # type: 'QSceneChange.DeliveryFlag'
        DeliverToAll = ... # type: 'QSceneChange.DeliveryFlag'

        class DeliveryFlags(sip.simplewrapper):

            @typing.overload
            def __init__(self) -> None: ...
            @typing.overload
            def __init__(self, f: typing.Union['QSceneChange.DeliveryFlags', 'QSceneChange.DeliveryFlag']) -> None: ...
            @typing.overload
            def __init__(self, a0: 'QSceneChange.DeliveryFlags') -> None: ...

            def __hash__(self) -> int: ...
            def __bool__(self) -> int: ...
            def __invert__(self) -> 'QSceneChange.DeliveryFlags': ...
            def __int__(self) -> int: ...

        def __init__(self, type: 'ChangeFlag', subjectId: 'QNodeId') -> None: ...

        def subjectId(self) -> 'QNodeId': ...
        def deliveryFlags(self) -> 'QSceneChange.DeliveryFlags': ...
        def setDeliveryFlags(self, flags: typing.Union['QSceneChange.DeliveryFlags', 'QSceneChange.DeliveryFlag']) -> None: ...
        def type(self) -> 'ChangeFlag': ...

    class QComponentAddedChange('QSceneChange'):

        def __init__(self, entity: 'QEntity', component: 'QComponent') -> None: ...

        def componentMetaObject(self) -> QtCore.QMetaObject: ...
        def componentId(self) -> 'QNodeId': ...
        def entityId(self) -> 'QNodeId': ...

    class QComponentRemovedChange('QSceneChange'):

        def __init__(self, entity: 'QEntity', component: 'QComponent') -> None: ...

        def componentMetaObject(self) -> QtCore.QMetaObject: ...
        def componentId(self) -> 'QNodeId': ...
        def entityId(self) -> 'QNodeId': ...

    class QPropertyUpdatedChangeBase('QSceneChange'):

        def __init__(self, subjectId: 'QNodeId') -> None: ...

    class QDynamicPropertyUpdatedChange('QPropertyUpdatedChangeBase'):

        def __init__(self, subjectId: 'QNodeId') -> None: ...

        def setValue(self, value: typing.Any) -> None: ...
        def value(self) -> typing.Any: ...
        def setPropertyName(self, name: typing.Union[QtCore.QByteArray, bytes, bytearray]) -> None: ...
        def propertyName(self) -> QtCore.QByteArray: ...

    class QEntity('QNode'):

        def __init__(self, parent: typing.Optional['QNode'] = ...) -> None: ...

        def parentEntity(self) -> 'QEntity': ...
        def removeComponent(self, comp: 'QComponent') -> None: ...
        def addComponent(self, comp: 'QComponent') -> None: ...
        def components(self) -> typing.Any: ...

    class QNodeIdTypePair(sip.simplewrapper):

        id = ... # type: 'QNodeId'
        type = ... # type: QtCore.QMetaObject

        @typing.overload
        def __init__(self) -> None: ...
        @typing.overload
        def __init__(self, _id: 'QNodeId', _type: QtCore.QMetaObject) -> None: ...
        @typing.overload
        def __init__(self, a0: 'QNodeIdTypePair') -> None: ...

    class QNodeCreatedChangeBase('QSceneChange'):

        def __init__(self, node: 'QNode') -> None: ...

        def isNodeEnabled(self) -> bool: ...
        def metaObject(self) -> QtCore.QMetaObject: ...
        def parentId(self) -> 'QNodeId': ...

    class QNodeDestroyedChange('QSceneChange'):

        def __init__(self, node: 'QNode', subtreeIdsAndTypes: typing.Any) -> None: ...

        def subtreeIdsAndTypes(self) -> typing.List['QNodeIdTypePair']: ...

    class QNodeId(sip.simplewrapper):

        @typing.overload
        def __init__(self) -> None: ...
        @typing.overload
        def __init__(self, a0: 'QNodeId') -> None: ...

        def __hash__(self) -> int: ...
        def __int__(self) -> bool: ...
        def id(self) -> int: ...
        def isNull(self) -> bool: ...
        @staticmethod
        def createId() -> 'QNodeId': ...

    class QPropertyValueAddedChangeBase('QSceneChange'):

        def __init__(self, subjectId: 'QNodeId') -> None: ...

    class QStaticPropertyValueAddedChangeBase('QPropertyValueAddedChangeBase'):

        def __init__(self, subjectId: 'QNodeId') -> None: ...

        def setPropertyName(self, name: str) -> None: ...
        def propertyName(self) -> str: ...

    class QPropertyNodeAddedChange('QStaticPropertyValueAddedChangeBase'):

        def __init__(self, subjectId: 'QNodeId', node: 'QNode') -> None: ...

        def metaObject(self) -> QtCore.QMetaObject: ...
        def addedNodeId(self) -> 'QNodeId': ...

    class QPropertyValueRemovedChangeBase('QSceneChange'):

        def __init__(self, subjectId: 'QNodeId') -> None: ...

    class QStaticPropertyValueRemovedChangeBase('QPropertyValueRemovedChangeBase'):

        def __init__(self, subjectId: 'QNodeId') -> None: ...

        def setPropertyName(self, name: str) -> None: ...
        def propertyName(self) -> str: ...

    class QPropertyNodeRemovedChange('QStaticPropertyValueRemovedChangeBase'):

        def __init__(self, subjectId: 'QNodeId', node: 'QNode') -> None: ...

        def metaObject(self) -> QtCore.QMetaObject: ...
        def removedNodeId(self) -> 'QNodeId': ...

    class QStaticPropertyUpdatedChangeBase('QPropertyUpdatedChangeBase'):

        def __init__(self, subjectId: 'QNodeId') -> None: ...

        def setPropertyName(self, name: str) -> None: ...
        def propertyName(self) -> str: ...

    class QPropertyUpdatedChange('QStaticPropertyUpdatedChangeBase'):

        def __init__(self, subjectId: 'QNodeId') -> None: ...

        def setValue(self, value: typing.Any) -> None: ...
        def value(self) -> typing.Any: ...

    class QPropertyValueAddedChange('QStaticPropertyValueAddedChangeBase'):

        def __init__(self, subjectId: 'QNodeId') -> None: ...

        def addedValue(self) -> typing.Any: ...
        def setAddedValue(self, value: typing.Any) -> None: ...

    class QPropertyValueRemovedChange('QStaticPropertyValueRemovedChangeBase'):

        def __init__(self, subjectId: 'QNodeId') -> None: ...

        def removedValue(self) -> typing.Any: ...
        def setRemovedValue(self, value: typing.Any) -> None: ...

    class ChangeFlags(sip.simplewrapper):

        @typing.overload
        def __init__(self) -> None: ...
        @typing.overload
        def __init__(self, f: typing.Union['ChangeFlags', 'ChangeFlag']) -> None: ...
        @typing.overload
        def __init__(self, a0: 'ChangeFlags') -> None: ...

        def __hash__(self) -> int: ...
        def __bool__(self) -> int: ...
        def __invert__(self) -> 'ChangeFlags': ...
        def __int__(self) -> int: ...

    class QTransform('QComponent'):

        def __init__(self, parent: typing.Optional['QNode'] = ...) -> None: ...

        def rotationZChanged(self, rotationZ: float) -> None: ...
        def rotationYChanged(self, rotationY: float) -> None: ...
        def rotationXChanged(self, rotationX: float) -> None: ...
        def matrixChanged(self) -> None: ...
        def translationChanged(self, translation: QtGui.QVector3D) -> None: ...
        def rotationChanged(self, rotation: QtGui.QQuaternion) -> None: ...
        def scale3DChanged(self, scale: QtGui.QVector3D) -> None: ...
        def scaleChanged(self, scale: float) -> None: ...
        def setRotationZ(self, rotationZ: float) -> None: ...
        def setRotationY(self, rotationY: float) -> None: ...
        def setRotationX(self, rotationX: float) -> None: ...
        def setMatrix(self, matrix: QtGui.QMatrix4x4) -> None: ...
        def setTranslation(self, translation: QtGui.QVector3D) -> None: ...
        def setRotation(self, rotation: QtGui.QQuaternion) -> None: ...
        def setScale3D(self, scale: QtGui.QVector3D) -> None: ...
        def setScale(self, scale: float) -> None: ...
        def rotationZ(self) -> float: ...
        def rotationY(self) -> float: ...
        def rotationX(self) -> float: ...
        def matrix(self) -> QtGui.QMatrix4x4: ...
        @staticmethod
        def rotateAround(point: QtGui.QVector3D, angle: float, axis: QtGui.QVector3D) -> QtGui.QMatrix4x4: ...
        @typing.overload
        @staticmethod
        def fromEulerAngles(eulerAngles: QtGui.QVector3D) -> QtGui.QQuaternion: ...
        @typing.overload
        @staticmethod
        def fromEulerAngles(pitch: float, yaw: float, roll: float) -> QtGui.QQuaternion: ...
        @typing.overload
        @staticmethod
        def fromAxesAndAngles(axis1: QtGui.QVector3D, angle1: float, axis2: QtGui.QVector3D, angle2: float) -> QtGui.QQuaternion: ...
        @typing.overload
        @staticmethod
        def fromAxesAndAngles(axis1: QtGui.QVector3D, angle1: float, axis2: QtGui.QVector3D, angle2: float, axis3: QtGui.QVector3D, angle3: float) -> QtGui.QQuaternion: ...
        @typing.overload
        @staticmethod
        def fromAxisAndAngle(axis: QtGui.QVector3D, angle: float) -> QtGui.QQuaternion: ...
        @typing.overload
        @staticmethod
        def fromAxisAndAngle(x: float, y: float, z: float, angle: float) -> QtGui.QQuaternion: ...
        def translation(self) -> QtGui.QVector3D: ...
        def rotation(self) -> QtGui.QQuaternion: ...
        def scale3D(self) -> QtGui.QVector3D: ...
        def scale(self) -> float: ...

    def qIdForNode(self, node: 'QNode') -> 'QNodeId': ...
