; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; RUN: llc -mtriple=amdgcn-amd-amdhsa -mcpu=tonga -verify-machineinstrs < %s | FileCheck -enable-var-scope -check-prefixes=GCN,UNPACKED %s
; RUN: llc -mtriple=amdgcn-amd-amdhsa -mcpu=gfx810 -verify-machineinstrs < %s | FileCheck -enable-var-scope -check-prefixes=GCN,PACKED %s
; RUN: llc -mtriple=amdgcn-amd-amdhsa -mcpu=gfx900 -verify-machineinstrs < %s | FileCheck -enable-var-scope -check-prefixes=GCN,PACKED %s

define amdgpu_kernel void @buffer_store_format_d16_x(<4 x i32> %rsrc, [8 x i32], half %data, [8 x i32], i32 %index) {
; GCN-LABEL: buffer_store_format_d16_x:
; GCN:       ; %bb.0: ; %main_body
; GCN-NEXT:    s_load_dword s4, s[8:9], 0x30
; GCN-NEXT:    s_load_dword s5, s[8:9], 0x54
; GCN-NEXT:    s_load_dwordx4 s[0:3], s[8:9], 0x0
; GCN-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-NEXT:    v_mov_b32_e32 v0, s4
; GCN-NEXT:    v_mov_b32_e32 v1, s5
; GCN-NEXT:    buffer_store_format_d16_x v0, v1, s[0:3], 0 idxen
; GCN-NEXT:    s_endpgm
main_body:
  call void @llvm.amdgcn.struct.buffer.store.format.f16(half %data, <4 x i32> %rsrc, i32 %index, i32 0, i32 0, i32 0)
  ret void
}

define amdgpu_kernel void @buffer_store_format_d16_xy(<4 x i32> %rsrc, <2 x half> %data, i32 %index) {
; UNPACKED-LABEL: buffer_store_format_d16_xy:
; UNPACKED:       ; %bb.0: ; %main_body
; UNPACKED-NEXT:    s_load_dwordx2 s[4:5], s[8:9], 0x10
; UNPACKED-NEXT:    s_load_dwordx4 s[0:3], s[8:9], 0x0
; UNPACKED-NEXT:    s_waitcnt lgkmcnt(0)
; UNPACKED-NEXT:    s_lshr_b32 s6, s4, 16
; UNPACKED-NEXT:    s_and_b32 s4, s4, 0xffff
; UNPACKED-NEXT:    v_mov_b32_e32 v0, s4
; UNPACKED-NEXT:    v_mov_b32_e32 v1, s6
; UNPACKED-NEXT:    v_mov_b32_e32 v2, s5
; UNPACKED-NEXT:    buffer_store_format_d16_xy v[0:1], v2, s[0:3], 0 idxen
; UNPACKED-NEXT:    s_endpgm
;
; PACKED-LABEL: buffer_store_format_d16_xy:
; PACKED:       ; %bb.0: ; %main_body
; PACKED-NEXT:    s_load_dwordx2 s[4:5], s[8:9], 0x10
; PACKED-NEXT:    s_load_dwordx4 s[0:3], s[8:9], 0x0
; PACKED-NEXT:    s_waitcnt lgkmcnt(0)
; PACKED-NEXT:    v_mov_b32_e32 v0, s4
; PACKED-NEXT:    v_mov_b32_e32 v1, s5
; PACKED-NEXT:    buffer_store_format_d16_xy v0, v1, s[0:3], 0 idxen
; PACKED-NEXT:    s_endpgm
main_body:
  call void @llvm.amdgcn.struct.buffer.store.format.v2f16(<2 x half> %data, <4 x i32> %rsrc, i32 %index, i32 0, i32 0, i32 0)
  ret void
}

define amdgpu_kernel void @buffer_store_format_d16_xyz(<4 x i32> %rsrc, <4 x half> %data, i32 %index) {
; UNPACKED-LABEL: buffer_store_format_d16_xyz:
; UNPACKED:       ; %bb.0: ; %main_body
; UNPACKED-NEXT:    s_load_dwordx2 s[4:5], s[8:9], 0x10
; UNPACKED-NEXT:    s_load_dwordx4 s[0:3], s[8:9], 0x0
; UNPACKED-NEXT:    s_load_dword s6, s[8:9], 0x18
; UNPACKED-NEXT:    s_waitcnt lgkmcnt(0)
; UNPACKED-NEXT:    s_and_b32 s5, s5, 0xffff
; UNPACKED-NEXT:    s_lshr_b32 s7, s4, 16
; UNPACKED-NEXT:    s_and_b32 s4, s4, 0xffff
; UNPACKED-NEXT:    v_mov_b32_e32 v0, s4
; UNPACKED-NEXT:    v_mov_b32_e32 v1, s7
; UNPACKED-NEXT:    v_mov_b32_e32 v2, s5
; UNPACKED-NEXT:    v_mov_b32_e32 v3, s6
; UNPACKED-NEXT:    buffer_store_format_d16_xyz v[0:2], v3, s[0:3], 0 idxen
; UNPACKED-NEXT:    s_endpgm
;
; PACKED-LABEL: buffer_store_format_d16_xyz:
; PACKED:       ; %bb.0: ; %main_body
; PACKED-NEXT:    s_load_dwordx2 s[4:5], s[8:9], 0x10
; PACKED-NEXT:    s_load_dword s6, s[8:9], 0x18
; PACKED-NEXT:    s_load_dwordx4 s[0:3], s[8:9], 0x0
; PACKED-NEXT:    s_waitcnt lgkmcnt(0)
; PACKED-NEXT:    s_and_b32 s5, s5, 0xffff
; PACKED-NEXT:    v_mov_b32_e32 v0, s4
; PACKED-NEXT:    v_mov_b32_e32 v1, s5
; PACKED-NEXT:    v_mov_b32_e32 v2, s6
; PACKED-NEXT:    buffer_store_format_d16_xyz v[0:1], v2, s[0:3], 0 idxen
; PACKED-NEXT:    s_endpgm
main_body:
  %data_subvec = shufflevector <4 x half> %data, <4 x half> poison, <3 x i32> <i32 0, i32 1, i32 2>
  call void @llvm.amdgcn.struct.buffer.store.format.v3f16(<3 x half> %data_subvec, <4 x i32> %rsrc, i32 %index, i32 0, i32 0, i32 0)
  ret void
}

define amdgpu_kernel void @buffer_store_format_d16_xyzw(<4 x i32> %rsrc, <4 x half> %data, i32 %index) {
; UNPACKED-LABEL: buffer_store_format_d16_xyzw:
; UNPACKED:       ; %bb.0: ; %main_body
; UNPACKED-NEXT:    s_load_dwordx2 s[4:5], s[8:9], 0x10
; UNPACKED-NEXT:    s_load_dwordx4 s[0:3], s[8:9], 0x0
; UNPACKED-NEXT:    s_load_dword s6, s[8:9], 0x18
; UNPACKED-NEXT:    s_waitcnt lgkmcnt(0)
; UNPACKED-NEXT:    s_lshr_b32 s7, s5, 16
; UNPACKED-NEXT:    s_and_b32 s5, s5, 0xffff
; UNPACKED-NEXT:    s_lshr_b32 s8, s4, 16
; UNPACKED-NEXT:    s_and_b32 s4, s4, 0xffff
; UNPACKED-NEXT:    v_mov_b32_e32 v0, s4
; UNPACKED-NEXT:    v_mov_b32_e32 v1, s8
; UNPACKED-NEXT:    v_mov_b32_e32 v2, s5
; UNPACKED-NEXT:    v_mov_b32_e32 v3, s7
; UNPACKED-NEXT:    v_mov_b32_e32 v4, s6
; UNPACKED-NEXT:    buffer_store_format_d16_xyzw v[0:3], v4, s[0:3], 0 idxen
; UNPACKED-NEXT:    s_endpgm
;
; PACKED-LABEL: buffer_store_format_d16_xyzw:
; PACKED:       ; %bb.0: ; %main_body
; PACKED-NEXT:    s_load_dwordx2 s[4:5], s[8:9], 0x10
; PACKED-NEXT:    s_load_dword s6, s[8:9], 0x18
; PACKED-NEXT:    s_load_dwordx4 s[0:3], s[8:9], 0x0
; PACKED-NEXT:    s_waitcnt lgkmcnt(0)
; PACKED-NEXT:    v_mov_b32_e32 v0, s4
; PACKED-NEXT:    v_mov_b32_e32 v1, s5
; PACKED-NEXT:    v_mov_b32_e32 v2, s6
; PACKED-NEXT:    buffer_store_format_d16_xyzw v[0:1], v2, s[0:3], 0 idxen
; PACKED-NEXT:    s_endpgm
main_body:
  call void @llvm.amdgcn.struct.buffer.store.format.v4f16(<4 x half> %data, <4 x i32> %rsrc, i32 %index, i32 0, i32 0, i32 0)
  ret void
}

define amdgpu_kernel void @buffer_store_format_i16_x(<4 x i32> %rsrc, [8 x i32], i16 %data, [8 x i32], i32 %index) {
; GCN-LABEL: buffer_store_format_i16_x:
; GCN:       ; %bb.0: ; %main_body
; GCN-NEXT:    s_load_dword s4, s[8:9], 0x30
; GCN-NEXT:    s_load_dword s5, s[8:9], 0x54
; GCN-NEXT:    s_load_dwordx4 s[0:3], s[8:9], 0x0
; GCN-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-NEXT:    v_mov_b32_e32 v0, s4
; GCN-NEXT:    v_mov_b32_e32 v1, s5
; GCN-NEXT:    buffer_store_format_d16_x v0, v1, s[0:3], 0 idxen
; GCN-NEXT:    s_endpgm
main_body:
  call void @llvm.amdgcn.struct.buffer.store.format.i16(i16 %data, <4 x i32> %rsrc, i32 %index, i32 0, i32 0, i32 0)
  ret void
}

declare void @llvm.amdgcn.struct.buffer.store.format.f16(half, <4 x i32>, i32, i32, i32, i32)
declare void @llvm.amdgcn.struct.buffer.store.format.v2f16(<2 x half>, <4 x i32>, i32, i32, i32, i32)
declare void @llvm.amdgcn.struct.buffer.store.format.v3f16(<3 x half>, <4 x i32>, i32, i32, i32, i32)
declare void @llvm.amdgcn.struct.buffer.store.format.v4f16(<4 x half>, <4 x i32>, i32, i32, i32, i32)
declare void @llvm.amdgcn.struct.buffer.store.format.i16(i16, <4 x i32>, i32, i32, i32, i32)
