; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; RUN: llc --force-dwarf-frame-section %s -o - | FileCheck %s
; RUN: llc --filetype=obj %s -o - | llvm-readelf -u - | FileCheck %s --check-prefix=UNWIND
target datalayout = "e-m:e-p:32:32-Fi8-i64:64-v128:64:128-a:0:32-n32-S64"
target triple = "thumbv8.1m.main-arm-unknown-eabi"

; Check the function starts with `pacbti` and correct unwind info is emitted
define hidden i32 @_Z1fi(i32 %x) "sign-return-address"="non-leaf" "sign-return-address-key"="a_key" "branch-target-enforcement" {
; CHECK-LABEL: _Z1fi:
; CHECK:         .cfi_sections .debug_frame
; CHECK-NEXT:    .cfi_startproc
; CHECK-NEXT:  @ %bb.0: @ %entry
; CHECK-NEXT:    pacbti r12, lr, sp
; CHECK-NEXT:    .save {r7, ra_auth_code, lr}
; CHECK-NEXT:    push.w {r7, r12, lr}
; CHECK-NEXT:    .cfi_def_cfa_offset 12
; CHECK-NEXT:    .cfi_offset lr, -4
; CHECK-NEXT:    .cfi_offset ra_auth_code, -8
; CHECK-NEXT:    .cfi_offset r7, -12
; CHECK-NEXT:    .pad #4
; CHECK-NEXT:    sub sp, #4
; CHECK-NEXT:    .cfi_def_cfa_offset 16
; CHECK-NEXT:    adds r0, #1
; CHECK-NEXT:    bl _Z1gi
; CHECK-NEXT:    subs r0, #1
; CHECK-NEXT:    add sp, #4
; CHECK-NEXT:    pop.w {r7, r12, lr}
; CHECK-NEXT:    aut r12, lr, sp
; CHECK-NEXT:    bx lr
entry:
  %add = add nsw i32 %x, 1
  %call = tail call i32 @_Z1gi(i32 %add)
  %sub = add nsw i32 %call, -1
  ret i32 %sub
}

declare dso_local i32 @_Z1gi(i32)

; UNWIND-LABEL: Opcodes [
; UNWIND-NEXT:  0x00      ; vsp = vsp + 4
; UNWIND-NEXT:  0x80 0x08 ; pop {r7}
; UNWIND-NEXT:  0xB4      ; pop ra_auth_code
; UNWIND-NEXT:  0x84 0x00 ; pop {lr}


