; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --version 5
; RUN: opt -passes=sandbox-vectorizer -mtriple=x86_64-- -mattr=+sse4.1 %s -S -sbvec-cost-threshold=0 | FileCheck %s --check-prefix=THRESHOLD_0
; RUN: opt -passes=sandbox-vectorizer -mtriple=x86_64-- -mattr=+sse4.1 %s -S -sbvec-cost-threshold=99 | FileCheck %s --check-prefix=THRESHOLD_99

define void @simple_cost_test(ptr %ptr) {
; THRESHOLD_0-LABEL: define void @simple_cost_test(
; THRESHOLD_0-SAME: ptr [[PTR:%.*]]) #[[ATTR0:[0-9]+]] {
; THRESHOLD_0-NEXT:    [[PTR0:%.*]] = getelementptr double, ptr [[PTR]], i32 0
; THRESHOLD_0-NEXT:    [[VECL:%.*]] = load <2 x double>, ptr [[PTR0]], align 8, !sandboxvec [[META0:![0-9]+]]
; THRESHOLD_0-NEXT:    store <2 x double> [[VECL]], ptr [[PTR0]], align 8, !sandboxvec [[META0]]
; THRESHOLD_0-NEXT:    ret void
;
; THRESHOLD_99-LABEL: define void @simple_cost_test(
; THRESHOLD_99-SAME: ptr [[PTR:%.*]]) #[[ATTR0:[0-9]+]] {
; THRESHOLD_99-NEXT:    [[PTR0:%.*]] = getelementptr double, ptr [[PTR]], i32 0
; THRESHOLD_99-NEXT:    [[PTR1:%.*]] = getelementptr double, ptr [[PTR]], i32 1, !sandboxvec [[META0:![0-9]+]]
; THRESHOLD_99-NEXT:    [[LD0:%.*]] = load double, ptr [[PTR0]], align 8, !sandboxvec [[META0]]
; THRESHOLD_99-NEXT:    [[LD1:%.*]] = load double, ptr [[PTR1]], align 8, !sandboxvec [[META0]]
; THRESHOLD_99-NEXT:    store double [[LD0]], ptr [[PTR0]], align 8, !sandboxvec [[META0]]
; THRESHOLD_99-NEXT:    store double [[LD1]], ptr [[PTR1]], align 8, !sandboxvec [[META0]]
; THRESHOLD_99-NEXT:    ret void
;
  %ptr0 = getelementptr double, ptr %ptr, i32 0
  %ptr1 = getelementptr double, ptr %ptr, i32 1
  %ld0 = load double, ptr %ptr0
  %ld1 = load double, ptr %ptr1
  store double %ld0, ptr %ptr0
  store double %ld1, ptr %ptr1
  ret void
}

define void @pack_cost_test_(ptr %ptr) {
; THRESHOLD_0-LABEL: define void @pack_cost_test_(
; THRESHOLD_0-SAME: ptr [[PTR:%.*]]) #[[ATTR0]] {
; THRESHOLD_0-NEXT:    [[PTR0:%.*]] = getelementptr float, ptr [[PTR]], i32 0
; THRESHOLD_0-NEXT:    [[PTR1:%.*]] = getelementptr float, ptr [[PTR]], i32 1
; THRESHOLD_0-NEXT:    [[LD0:%.*]] = load float, ptr [[PTR0]], align 4
; THRESHOLD_0-NEXT:    [[LD1:%.*]] = load float, ptr [[PTR1]], align 4
; THRESHOLD_0-NEXT:    [[PACK4:%.*]] = insertelement <4 x float> poison, float [[LD0]], i32 0, !sandboxvec [[META1:![0-9]+]]
; THRESHOLD_0-NEXT:    [[PACK5:%.*]] = insertelement <4 x float> [[PACK4]], float [[LD1]], i32 1, !sandboxvec [[META1]]
; THRESHOLD_0-NEXT:    [[PACK6:%.*]] = insertelement <4 x float> [[PACK5]], float [[LD0]], i32 2, !sandboxvec [[META1]]
; THRESHOLD_0-NEXT:    [[PACK7:%.*]] = insertelement <4 x float> [[PACK6]], float [[LD1]], i32 3, !sandboxvec [[META1]]
; THRESHOLD_0-NEXT:    [[PACK:%.*]] = insertelement <4 x float> poison, float [[LD0]], i32 0, !sandboxvec [[META1]]
; THRESHOLD_0-NEXT:    [[PACK1:%.*]] = insertelement <4 x float> [[PACK]], float [[LD1]], i32 1, !sandboxvec [[META1]]
; THRESHOLD_0-NEXT:    [[PACK2:%.*]] = insertelement <4 x float> [[PACK1]], float [[LD0]], i32 2, !sandboxvec [[META1]]
; THRESHOLD_0-NEXT:    [[PACK3:%.*]] = insertelement <4 x float> [[PACK2]], float [[LD1]], i32 3, !sandboxvec [[META1]]
; THRESHOLD_0-NEXT:    [[VEC:%.*]] = fmul <4 x float> [[PACK3]], [[PACK7]], !sandboxvec [[META1]]
; THRESHOLD_0-NEXT:    store <4 x float> [[VEC]], ptr [[PTR0]], align 4, !sandboxvec [[META1]]
; THRESHOLD_0-NEXT:    ret void
;
; THRESHOLD_99-LABEL: define void @pack_cost_test_(
; THRESHOLD_99-SAME: ptr [[PTR:%.*]]) #[[ATTR0]] {
; THRESHOLD_99-NEXT:    [[PTR0:%.*]] = getelementptr float, ptr [[PTR]], i32 0
; THRESHOLD_99-NEXT:    [[PTR1:%.*]] = getelementptr float, ptr [[PTR]], i32 1
; THRESHOLD_99-NEXT:    [[PTR2:%.*]] = getelementptr float, ptr [[PTR]], i32 2, !sandboxvec [[META1:![0-9]+]]
; THRESHOLD_99-NEXT:    [[PTR3:%.*]] = getelementptr float, ptr [[PTR]], i32 3, !sandboxvec [[META1]]
; THRESHOLD_99-NEXT:    [[LD0:%.*]] = load float, ptr [[PTR0]], align 4
; THRESHOLD_99-NEXT:    [[LD1:%.*]] = load float, ptr [[PTR1]], align 4
; THRESHOLD_99-NEXT:    [[MUL0:%.*]] = fmul float [[LD0]], [[LD0]], !sandboxvec [[META1]]
; THRESHOLD_99-NEXT:    [[MUL1:%.*]] = fmul float [[LD1]], [[LD1]], !sandboxvec [[META1]]
; THRESHOLD_99-NEXT:    [[MUL2:%.*]] = fmul float [[LD0]], [[LD0]], !sandboxvec [[META1]]
; THRESHOLD_99-NEXT:    [[MUL3:%.*]] = fmul float [[LD1]], [[LD1]], !sandboxvec [[META1]]
; THRESHOLD_99-NEXT:    store float [[MUL0]], ptr [[PTR0]], align 4, !sandboxvec [[META1]]
; THRESHOLD_99-NEXT:    store float [[MUL1]], ptr [[PTR1]], align 4, !sandboxvec [[META1]]
; THRESHOLD_99-NEXT:    store float [[MUL2]], ptr [[PTR2]], align 4, !sandboxvec [[META1]]
; THRESHOLD_99-NEXT:    store float [[MUL3]], ptr [[PTR3]], align 4, !sandboxvec [[META1]]
; THRESHOLD_99-NEXT:    ret void
;
  %ptr0 = getelementptr float, ptr %ptr, i32 0
  %ptr1 = getelementptr float, ptr %ptr, i32 1
  %ptr2 = getelementptr float, ptr %ptr, i32 2
  %ptr3 = getelementptr float, ptr %ptr, i32 3
  %ld0 = load float, ptr %ptr0
  %ld1 = load float, ptr %ptr1
  %mul0 = fmul float %ld0, %ld0
  %mul1 = fmul float %ld1, %ld1
  %mul2 = fmul float %ld0, %ld0
  %mul3 = fmul float %ld1, %ld1
  store float %mul0, ptr %ptr0
  store float %mul1, ptr %ptr1
  store float %mul2, ptr %ptr2
  store float %mul3, ptr %ptr3
  ret void
}
;.
; THRESHOLD_0: [[META0]] = distinct !{!"sandboxregion"}
; THRESHOLD_0: [[META1]] = distinct !{!"sandboxregion"}
;.
; THRESHOLD_99: [[META0]] = distinct !{!"sandboxregion"}
; THRESHOLD_99: [[META1]] = distinct !{!"sandboxregion"}
;.
