; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --version 5
; RUN: opt < %s -passes=loop-interchange -S -verify-dom-info -verify-loop-info 2>&1 | FileCheck %s

target datalayout = "e-m:e-i64:64-f80:128-n8:16:32:64-S128"

@A = common global [100 x [100 x i32]] zeroinitializer

declare void @foo(i64 %a)
declare void @bar(i64 %a) readnone

;;--------------------------------------Test case 02------------------------------------
;; Safe to interchange, because the called function `bar` is marked as readnone,
;; so it cannot introduce dependences.
;;
;;  for(int i=0;i<100;i++) {
;;    for(int j=1;j<100;j++) {
;;      bar(i);
;;      A[j][i] = A[j][i]+k;
;;    }
;; }
;
define void @interchange_02(i32 %k) {
; CHECK-LABEL: define void @interchange_02(
; CHECK-SAME: i32 [[K:%.*]]) {
; CHECK-NEXT:  [[ENTRY:.*:]]
; CHECK-NEXT:    br label %[[FOR2_PREHEADER:.*]]
; CHECK:       [[FOR1_HEADER_PREHEADER:.*]]:
; CHECK-NEXT:    br label %[[FOR1_HEADER:.*]]
; CHECK:       [[FOR1_HEADER]]:
; CHECK-NEXT:    [[INDVARS_IV23:%.*]] = phi i64 [ [[INDVARS_IV_NEXT24:%.*]], %[[FOR1_INC10:.*]] ], [ 0, %[[FOR1_HEADER_PREHEADER]] ]
; CHECK-NEXT:    br label %[[FOR2_SPLIT1:.*]]
; CHECK:       [[FOR2_PREHEADER]]:
; CHECK-NEXT:    br label %[[FOR2:.*]]
; CHECK:       [[FOR2]]:
; CHECK-NEXT:    [[INDVARS_IV:%.*]] = phi i64 [ [[TMP0:%.*]], %[[FOR2_SPLIT:.*]] ], [ 1, %[[FOR2_PREHEADER]] ]
; CHECK-NEXT:    br label %[[FOR1_HEADER_PREHEADER]]
; CHECK:       [[FOR2_SPLIT1]]:
; CHECK-NEXT:    call void @bar(i64 [[INDVARS_IV23]])
; CHECK-NEXT:    [[ARRAYIDX5:%.*]] = getelementptr inbounds [100 x [100 x i32]], ptr @A, i64 0, i64 [[INDVARS_IV]], i64 [[INDVARS_IV23]]
; CHECK-NEXT:    [[LV:%.*]] = load i32, ptr [[ARRAYIDX5]], align 4
; CHECK-NEXT:    [[ADD:%.*]] = add nsw i32 [[LV]], [[K]]
; CHECK-NEXT:    store i32 [[ADD]], ptr [[ARRAYIDX5]], align 4
; CHECK-NEXT:    [[INDVARS_IV_NEXT:%.*]] = add nuw nsw i64 [[INDVARS_IV]], 1
; CHECK-NEXT:    [[EXITCOND:%.*]] = icmp eq i64 [[INDVARS_IV]], 99
; CHECK-NEXT:    br label %[[FOR2_LOOPEXIT:.*]]
; CHECK:       [[FOR2_SPLIT]]:
; CHECK-NEXT:    [[TMP0]] = add nuw nsw i64 [[INDVARS_IV]], 1
; CHECK-NEXT:    [[TMP1:%.*]] = icmp eq i64 [[INDVARS_IV]], 99
; CHECK-NEXT:    br i1 [[TMP1]], label %[[FOR1_LOOPEXIT:.*]], label %[[FOR2]]
; CHECK:       [[FOR2_LOOPEXIT]]:
; CHECK-NEXT:    br label %[[FOR1_INC10]]
; CHECK:       [[FOR1_INC10]]:
; CHECK-NEXT:    [[INDVARS_IV_NEXT24]] = add nuw nsw i64 [[INDVARS_IV23]], 1
; CHECK-NEXT:    [[EXITCOND26:%.*]] = icmp eq i64 [[INDVARS_IV23]], 99
; CHECK-NEXT:    br i1 [[EXITCOND26]], label %[[FOR2_SPLIT]], label %[[FOR1_HEADER]]
; CHECK:       [[FOR1_LOOPEXIT]]:
; CHECK-NEXT:    br label %[[EXIT:.*]]
; CHECK:       [[EXIT]]:
; CHECK-NEXT:    ret void
;
entry:
  br label %for1.header

for1.header:
  %indvars.iv23 = phi i64 [ 0, %entry ], [ %indvars.iv.next24, %for1.inc10 ]
  br label %for2

for2:
  %indvars.iv = phi i64 [ %indvars.iv.next, %for2 ], [ 1, %for1.header ]
  call void @bar(i64 %indvars.iv23)
  %arrayidx5 = getelementptr inbounds [100 x [100 x i32]], ptr @A, i64 0, i64 %indvars.iv, i64 %indvars.iv23
  %lv = load i32, ptr %arrayidx5
  %add = add nsw i32 %lv, %k
  store i32 %add, ptr %arrayidx5
  %indvars.iv.next = add nuw nsw i64 %indvars.iv, 1
  %exitcond = icmp eq i64 %indvars.iv, 99
  br i1 %exitcond, label %for2.loopexit , label %for2

for2.loopexit:
  br label %for1.inc10

for1.inc10:
  %indvars.iv.next24 = add nuw nsw i64 %indvars.iv23, 1
  %exitcond26 = icmp eq i64 %indvars.iv23, 99
  br i1 %exitcond26, label %for1.loopexit, label %for1.header

for1.loopexit:
  br label %exit

exit:
  ret void
}
